#
# BZ::Client::Exception.pm - Exception class thrown by BZ::Client
#                            in case of errors.
#

use strict;
use warnings "all";

package BZ::Client::Exception;
$BZ::Client::Exception::VERSION = '1.062_1';
sub throw {
    my $class = shift;
    die $class->new(@_);
}

sub new {
    my $class = shift;
    my $self = { @_ };
    bless($self, ref($class) || $class);
    return $self;
}

sub message {
    my $self = shift;
    return $self->{"message"};
}

sub xmlrpc_code {
    my $self = shift;
    return $self->{"xmlrpc_code"};
}

sub http_code {
    my $self = shift;
    return $self->{"http_code"};
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

BZ::Client::Exception

=head1 VERSION

version 1.062_1

=head1 SYNOPSIS

  my $exception = BZ::Client::Exception->new(message => $message,
                                             http_code => $httpCode,
                                             xmlrpc_code => $xmlrpcCode);

  BZ::Client::Exception->throw(message => $message,
                               http_code => $httpCode,
                               xmlrpc_code => $xmlrpcCode);

=head1 NAME

  BZ::Client::Exception - Exception class, which is thrown by
      BZ::Client in case of errors.

=head1 VERSION

version 1.062_1

BZ::Client does not return error codes or do similar stuff.
Instead, it throws instances of BZ::Client::Exception.

=head1 SEE ALSO

  L<BZ::Client>

=head1 AUTHOR

Dean Hamstead <dean@bytefoundry.com.au>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Dean Hamstad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
