package Unicode::Number::System;
$Unicode::Number::System::VERSION = '0.006';
use strict;
use warnings;

use overload '""' => \&_stringify, fallback => 1;

use constant NS_UNKNOWN => -1;
use constant NS_ALLZERO => -2;
use constant ALLZERO => (
	bless { _name => "All_Zero", _id => NS_ALLZERO, _both_dir => 0 }, __PACKAGE__
);

# generated by tool/unicode-script-dump.pl
our %NS_STR_TO_ISO_15924 = (
	Aegean                             => 'Zyyy', # Common
	Arabic_Alphabetic                  => 'Arab', # Arabic
	Arabic_Persian                     => 'Arab', # Arabic
	Arabic_Western                     => 'Arab', # Arabic
	Armenian                           => 'Armn', # Armenian
	Balinese                           => 'Bali', # Balinese
	Bengali                            => 'Beng', # Bengali
	Burmese                            => 'Mymr', # Myanmar
	Chinese_Counting_Rod_Early         => 'Zyyy', # Common # TODO
	Chinese_Counting_Rod_Late          => 'Zyyy', # Common # TODO
	Chinese_Counting_Rod_Early_No_Zero => 'Zyyy', # Common # TODO
	Chinese_Counting_Rod_Late_No_Zero  => 'Zyyy', # Common # TODO
	Chinese_Legal_Simplified           => 'Hani', # Han # TODO
	Chinese_Legal_Traditional          => 'Hani', # Han # TODO
	Chinese_Regular_Simplified         => 'Hani', # Han # TODO
	Chinese_Regular_Traditional        => 'Hani', # Han # TODO
	Chinese_Regular_Place              => 'Hani', # Han # TODO
	Common_Braille                     => 'Brai', # Braille
	Cyrillic                           => 'Cyrl', # Cyrillic
	Devanagari                         => 'Deva', # Devanagari
	Egyptian                           => 'Egyp', # Egyptian_Hieroglyphs
	Ethiopic                           => 'Ethi', # Ethiopic
	Ewellic_Decimal                    => 'Zzzz', # Unknown
	Ewellic_Hexadecimal                => 'Zzzz', # Unknown
	French_Braille                     => 'Brai', # Braille
	Glagolitic                         => 'Glag', # Glagolitic
	Greek_Lower                        => 'Grek', # Greek
	Greek_Upper                        => 'Grek', # Greek
	Gujarati                           => 'Gujr', # Gujarati
	Gurmukhi                           => 'Guru', # Gurmukhi
	Hebrew_Early                       => 'Hebr', # Hebrew
	Hebrew_Late                        => 'Hebr', # Hebrew
	Hexadecimal_Lower                  => 'Zyyy', # Common
	Hexadecimal_Upper                  => 'Zyyy', # Common
	Japanese_Regular_Simplified        => 'Hani', # Han # TODO
	Japanese_Regular_Traditional       => 'Hani', # Han # TODO
	Japanese_Legal_Simplified          => 'Hani', # Han # TODO
	Japanese_Legal_Traditional         => 'Hani', # Han # TODO
	Japanese_Western_Mixed             => 'Hani', # Han # TODO
	Kannada                            => 'Knda', # Kannada
	Kayah_Li                           => 'Kali', # Kayah_Li
	Kharoshthi                         => 'Khar', # Kharoshthi
	Khmer                              => 'Khmr', # Khmer
	Klingon                            => 'Zzzz', # Unknown
	Lao                                => 'Laoo', # Lao
	Lepcha                             => 'Lepc', # Lepcha
	Limbu                              => 'Limb', # Limbu
	Malayalam                          => 'Mlym', # Malayalam
	Mandarin_Legal_Simplified          => 'Hani', # Han # TODO
	Mandarin_Legal_Traditional         => 'Hani', # Han # TODO
	Mandarin_Regular_Simplified        => 'Hani', # Han # TODO
	Mandarin_Regular_Traditional       => 'Hani', # Han # TODO
	Mongolian                          => 'Mong', # Mongolian
	Mxedruli                           => 'Geor', # Georgian
	New_Tai_Lue                        => 'Talu', # New_Tai_Lue
	Nko                                => 'Nkoo', # Nko
	Ol_Chiki                           => 'Olck', # Ol_Chiki
	Old_Italic                         => 'Ital', # Old_Italic
	Old_Persian                        => 'Xpeo', # Old_Persian
	Oriya                              => 'Orya', # Oriya
	Osmanya                            => 'Osma', # Osmanya
	Phoenician                         => 'Phnx', # Phoenician
	Roman_Lower                        => 'Latn', # Latin
	Roman_Upper                        => 'Latn', # Latin
	Russian_Braille                    => 'Brai', # Braille
	Saurashtra                         => 'Saur', # Saurashtra
	Shan                               => 'Mymr', # Myanmar
	Sinhala                            => 'Sinh', # Sinhala
	Sundanese                          => 'Sund', # Sundanese
	Suzhou                             => 'Hani', # Han # TODO
	Tamil_Place                        => 'Taml', # Tamil
	Tamil_Traditional                  => 'Taml', # Tamil
	Telugu                             => 'Telu', # Telugu
	Tengwar_Decimal                    => 'Zzzz', # Unknown
	Tengwar_Duodecimal                 => 'Zzzz', # Unknown
	Thai                               => 'Thai', # Thai
	Tibetan                            => 'Tibt', # Tibetan
	Vai                                => 'Vaii', # Vai
	Verdurian                          => 'Zzzz', # Unknown
	Western_Lower                      => 'Zyyy', # Common
	Western_Upper                      => 'Zyyy', # Common
	Xucuri_Lower                       => 'Geor', # Georgian
	Xucuri_Upper                       => 'Geor', # Georgian
	Chinese                            => 'Hani', # Han # TODO
	Counting_Rod                       => 'Zyyy', # Common
	Greek                              => 'Grek', # Greek
	Hebrew                             => 'Hebr', # Hebrew
	Hexadecimal                        => 'Zyyy', # Common
	Roman                              => 'Latn', # Latin
	Tamil                              => 'Taml', # Tamil
	Western                            => 'Zyyy', # Common
);

sub _stringify { $_[0]->name; }

sub iso15924_code {
	my ($self) = @_;
	return $NS_STR_TO_ISO_15924{$self->name};
}




sub maximum_value {
	my ($self) = @_;
	my $str = $self->_MaximumValue();
	if( $str eq 'unlimited' ) {
		return Unicode::Number::Result->_new('inf');
	}
	Unicode::Number::Result->_new($str);
}


1;

# ABSTRACT: representation of a number system

__END__

=pod

=encoding UTF-8

=head1 NAME

Unicode::Number::System - representation of a number system

=head1 VERSION

version 0.006

=head1 SYNOPSIS

  use Unicode::Number;

  my $u = Unicode::Number->new;
  # print out all the number systems
  say join "\n", map { $_->name } @{ $u->number_systems };

=head1 DESCRIPTION

This class is the representation of a number system that can be used for
conversion by L<Unicode::Number>. The list of number systems supported is given
by the C<L<number_systems|Unicode::Number/number_systems>> of
L<Unicode::Number>.

=head1 ATTRIBUTES

=head2 iso15924_code

Returns the L<ISO 15924 code|http://www.unicode.org/iso15924/codelists.html>
for the number system's script.

=head2 name

Returns a string for the C<libuninum> name of the number system.

=head2 convertible_in_both_directions

Returns a boolean.

If C<true>, then the number system can be used to convert from strings to
numbers and from numbers to strings (in C<libuninum> terminology: "specific
number systems").

If C<false>, then the number system can only be used to convert strings to
numbers. (in C<libuninum> terminology: "cover terms").

=head2 maximum_value

Returns a L<Unicode::Number::Result> with the largest representable value. This
value may be unlimited and in that case we return a L<Unicode::Number::Result>
with a value of infinity (C<inf>).

=head1 AUTHOR

Zakariyya Mughal <zmughal@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Zakariyya Mughal.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
