use 5.014;
no if $] >= 5.018, warnings => "experimental::smartmatch";
use strict;
use Test::More tests => 24;

use Var::Pairs;

my %data1 = ( 1 => 'a', 2 => 'b' );
my %data2 = ( 1 => 'aa', 2 => 'bb' );

my @expected_key   = qw< 1 1  2 2  >;
my @expected_value = qw< a aa b bb >;

my $next_ref = \%data1;

my $next_expected = 0;
while (my ($key, $value) = each_kv %{$next_ref}) {
    is $key  , $expected_key[$next_expected]   => 'correct key';
    is $value, $expected_value[$next_expected] => 'correct value';

    $next_ref = $next_ref == \%data1 ? \%data2 : \%data1;
    $next_expected++;
}


$next_ref = \%data1;

my $next_expected = 0;
while (my $pair = each_pair %{$next_ref}) {
    is $pair->key  , $expected_key[$next_expected]   => 'correct key';
    is $pair->value, $expected_value[$next_expected] => 'correct value';

    $next_ref = $next_ref == \%data1 ? \%data2 : \%data1;
    $next_expected++;
}



@expected_key   = qw< 1 2 1  2  >;
@expected_value = qw< a b aa bb >;

for my $next_ref (\%data1, \%data2) {
    for my $pair (pairs %{$next_ref}) {
        is $pair->key  , shift @expected_key   => 'correct key';
        is $pair->value, shift @expected_value => 'correct value';
    }
}




