//
//      srecord - manipulate eprom load files
//      Copyright (C) 2003, 2004, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_FILE_OUTPUT_BUFFER_H
#define COMMON_FILE_OUTPUT_BUFFER_H

#include <libtardy/file/output.h>

/**
  * The file_output_buffer class is used to represent a buffered output
  * stream.  The data is passed through unchanged, however it is
  * buffered before delivery to the deeper output stream.
  */
class file_output_buffer:
    public file_output
{
public:
    /**
      * The destructor.
      */
    virtual ~file_output_buffer();

    /**
      * The constructor.
      *
      * \param deeper
      *     This argument is used to specify the output stream to write
      *     the data to once it has been buffered.
      * \param blocksize
      *     This argument my be used to specify the block size, in bytes.
      *     It defaults to 512 bytes if zero or negative.
      */
    file_output_buffer(file_output *deeper, int blocksize = 0);

    // See base class for documentation.
    const char *filename() const;

    // See base class for documentation.
    void write(const void *data, int nbytes);

private:
    /**
      * The deeper instance variable is used to remember the output file
      * to write the output to, once it has been buffered.
      */
    file_output *deeper;

    /**
      * The blocksize instance variable is used to remember the size of
      * blocks to be wrutten to the deeper output.
      */
    int blocksize;

    /**
      * The buffer instance variable is used to remember whe the buffer
      * of blocksize byte has been allocated in the heap.
      */
    char *buffer;

    /**
      * The pos instance variable is used to remember how many bytes
      * have been buffered into `buffer'.
      *
      * Invariant: assert(pos >= 0 && pos < blocksize);
      */
    int pos;

    /**
      * The default constructor.  Do not use.
      */
    file_output_buffer();

    /**
      * The copy constructor.  Do not use.
      */
    file_output_buffer(const file_output_buffer &);

    /**
      * The assignment operator.  Do not use.
      */
    file_output_buffer &operator=(const file_output_buffer &);
};

#endif // COMMON_FILE_OUTPUT_BUFFER_H
