//
//      srecord - manipulate eprom load files
//      Copyright (C) 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_FILTER_EXCLUDE_H
#define COMMON_TAR_INPUT_FILTER_EXCLUDE_H

#include <libtardy/tar/input/filter.h>

/**
  * The tar_input_filter_exclude class is used to represent a filter
  * that removes file that match a glob pattern from the archive.
  */
class tar_input_filter_exclude:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_exclude();

    /**
      * The constructor.
      *
      * @param deeper
      *     The input source to be filtered.
      * @param glob
      *     The file name pattern to be matched.
      */
    tar_input_filter_exclude(tar_input *deeper, const rcstring &glob);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The glob instance variable is used to remember the file name
      * pattern for the excluded files.
      */
    rcstring glob;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_exclude();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_exclude(const tar_input_filter_exclude &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_exclude &operator=(const tar_input_filter_exclude &);
};

#endif // COMMON_TAR_INPUT_FILTER_EXCLUDE_H
