//
// tardy - a tar post-processor
// Copyright (C) 1998, 1999, 2002, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/stdio.h>

#include <libtardy/tar/output/list.h>


tar_output_list::~tar_output_list()
{
    delete fp;
}


tar_output_list::tar_output_list(tar_output *arg) :
    fp(arg)
{
}


void
tar_output_list::write_data(const void *buffer, int buflen)
{
    fp->write_data(buffer, buflen);
}

void
tar_output_list::write_data_padding()
{
    fp->write_data_padding();
}


void
tar_output_list::write_header(const tar_header &h)
{
    rcstring name = h.name;
    if (h.type == tar_header::type_directory)
        name += "/";
    fprintf
    (
        stderr,
        "%04lo %3ld %3ld %5ld %s\n",
        h.mode,
        h.user_id,
        h.group_id,
        h.size,
        name.to_c_string()
    );
    fp->write_header(h);
}


void
tar_output_list::write_header_padding()
{
    fp->write_header_padding();
}


const char *
tar_output_list::filename()
    const
{
    return fp->filename();
}


tar_output_list::tar_output_list()
{
    fatal("bug %s %d", __FILE__, __LINE__);
}


tar_output_list::tar_output_list(const tar_output_list &rhs) :
    tar_output(rhs)
{
    fatal("bug %s %d", __FILE__, __LINE__);
}


tar_output_list &
tar_output_list::operator = (const tar_output_list &)
{
    fatal("bug %s %d", __FILE__, __LINE__);
    return *this;
}
