##
##  teem.py: automatically-generated ctypes python wrappers for Teem
##  Copyright (C) 2012, 2011, 2010, 2009  University of Chicago
##
##  Permission is hereby granted, free of charge, to any person obtaining
##  a copy of this software and associated documentation files (the
##  "Software"), to deal in the Software without restriction, including
##  without limitation the rights to use, copy, modify, merge, publish,
##  distribute, sublicense, and/or sell copies of the Software, and to
##  permit persons to whom the Software is furnished to do so, subject to
##  the following conditions:
##
##  The above copyright notice and this permission notice shall be
##  included in all copies or substantial portions of the Software.
##
##  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
##  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
##  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
##  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
##  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
##  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
##  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
##
##############################################################
##############################################################
#### NOTE: This teem.py file is automatically produced by
#### teem/python/ctypes/teem-gen.py.  Necessary changes to 
#### teem.py should be made in teem-gen.py, not here.
##############################################################
##############################################################

from ctypes import *
import ctypes.util
import sys, os

def load_library(libname, loader_path=""):
    ext = os.path.splitext(libname)[1]
    if not ext:
        # Try to load library with platform-specific name
        if sys.platform == 'win32':
            libname_ext = '%s.dll' % libname
        elif sys.platform == 'darwin':
            libname_ext = '%s.dylib' % libname
        elif sys.platform == 'linux2':
            libname_ext = '%s.so' % libname
    else:        libname_ext = libname

    if (loader_path != ""):
        loader_path = os.path.abspath(loader_path)
        if not os.path.isdir(loader_path):
            libdir = os.path.dirname(loader_path)
        else:
            libdir = loader_path
    else:
        libdir = loader_path

    try:
        libpath = os.path.join(libdir, libname_ext)
        return CDLL(libpath)
    except OSError, e:
        raise e
try:
    libteem = load_library('libteem')
except OSError:
    print "**"
    print "**  teem.py couldn't find and load the \"libteem\" shared library."
    print "**"
    print "**  try setting optional loader_path argument in the load_library() call above to '<teem-install-dir>/lib/'"
    print "**"
    raise ImportError

# =============================================================
# Utility types and classes to help teem.py be platform-independent.

STRING = c_char_p

class FILE(Structure):
    pass

# oddly, size_t is in ctypes, but not ptrdiff_t
# which is probably a bug
if sizeof(c_void_p) == 4:
    ptrdiff_t = c_int32
elif sizeof(c_void_p) == 8:
    ptrdiff_t = c_int64

# =============================================================
# What follows are all the functions, struct definitions, globals, 
# enum values, and typedefs in Teem. This is generated by ctypeslib:
#   http://svn.python.org/projects/ctypes/branches/ctypeslib-gccxml-0.9
# followed by further post-processing and filtering.
# See end of this file for definitions of stderr, stdin, stdout

gagePvlFlagVolume = 1
tenDwiGageTensorLLS = 6
pullPropStepConstr = 5
tenGageClpmin2 = 80
gagePvlFlagUnknown = 0
tenGageDelNormK2 = 23
tenGageOmegaHessianContrTenEvec2 = 147
hooverErrLast = 11
gageKernel00 = 1
hooverErrThreadJoin = 9
hooverErrSample = 6
tenGageEvec1 = 21
hooverErrThreadCreate = 3
hooverErrRayBegin = 5
echoTypeInstance = 11
hooverErrNone = 0
nrrdUnaryOpLog10 = 12
echoMatterGlassFuzzy = 3
tenGageTheta = 12
echoMatterGlassKa = 1
nrrdField_kinds = 16
echoMatterPhongSp = 3
echoMatterPhongKd = 1
echoMatterPhongKa = 0
tenGageEval2 = 18
echoJitterRandom = 3
echoJitterJitter = 2
echoJitterNone = 0
tenGageOmegaHessianContrTenEvec1 = 146
echoJitterUnknown = -1
pullIterParmCallback = 7
pullIterParmPopCntlPeriod = 5
pullIterParmConstraintMax = 4
nrrdUnaryOpLog2 = 11
pullIterParmMax = 2
pullIterParmUnknown = 0
tenGageMode = 11
tenGageCp2 = 78
dyeSpaceLUV = 6
tenDwiGageLast = 36
dyeSpaceLAB = 5
tenDwiGage2TensorPeledAndError = 34
nrrdTypeLast = 12
nrrdTypeBlock = 11
tenGageR = 10
nrrdTypeDouble = 10
nrrdTypeFloat = 9
seekTypeValleySurface = 3
nrrdTypeLLong = 7
tenDwiGage2TensorPeledError = 33
nrrdTypeUInt = 6
gageParmRenormalize = 2
nrrdTypeInt = 5
nrrdTypeUShort = 4
alanParmReact = 13
nrrdTypeShort = 3
nrrdTypeUChar = 2
limnEdgeTypeLone = 7
limnEdgeTypeBorder = 6
hooverErrThreadEnd = 8
tenGageOmega2ndDD = 144
limnEdgeTypeBackCrease = 2
gageCtxFlagShape = 6
limnEdgeTypeUnknown = 0
nrrdZlibStrategyLast = 4
hooverErrRayEnd = 7
nrrdZlibStrategyHuffman = 2
nrrdZlibStrategyDefault = 1
nrrdZlibStrategyUnknown = 0
pullCountTestStep = 2
echoTypeList = 10
baneMeasrTotalCurv = 7
pushEnergyTypeZero = 5
baneIncAbsolute = 1
pullSysParmFracNeighNixedMax = 19
pushEnergyTypeCotan = 4
pushEnergyTypeCoulomb = 3
pushEnergyTypeGauss = 2
tenDwiGageTensorNLS = 14
echoTypeAABBox = 8
tenGageOmegaLaplacian = 143
pullSysParmConstraintStepMin = 17
limnPolyDataInfoTex2 = 3
limnPolyDataInfoNorm = 2
limnPolyDataInfoUnknown = 0
gageSclHessMode = 35
echoTypeTriMesh = 6
limnSpaceScreen = 3
gageSclMedian = 32
pullEnergyTypeQuartic = 7
gageSclCurvDir2 = 30
tenAniso_eval0 = 27
pullStatusUnknown = 0
gageSclGaussCurv = 28
pullSysParmEnergyIncreasePermit = 15
gageSclMeanCurv = 27
gageSclShapeIndex = 26
tenGageQ = 8
gageSclK2 = 23
echoTypeTriangle = 4
gageSclGeomTensTen = 21
baneMeasr2ndDD = 6
tenGageCa1 = 75
gageSclHessEvec2 = 18
tenDwiGageTensorWLSLikelihood = 13
tenGageOmegaHessianEvec2 = 142
gageSclHessEval2 = 14
airMopAlways = 3
pullSysParmOpporStepScale = 12
alanTextureTypeLast = 3
alanTextureTypeGrayScott = 2
airMopOnError = 1
miteShadeMethodUnknown = 0
limnPrimitiveLines = 7
pullSysParmProbeProb = 11
limnPrimitiveQuads = 5
limnPrimitiveTriangleFan = 4
limnPrimitiveTriangleStrip = 3
pullCountUnknown = 0
echoTypeSphere = 0
tenGageS = 7
miteValRi = 8
baneIncUnknown = 0
unrrduScaleSubtract = 5
baneMeasrLaplacian = 5
unrrduScaleDivide = 3
tenGageCp1 = 74
tenDwiGageTensorWLSErrorLog = 12
echoMatterGlassIndex = 0
gageParmVerbose = 1
tenAniso_R = 19
baneMeasrGradMag = 4
baneMeasrValueZeroCentered = 2
baneMeasrValuePositive = 1
baneMeasrUnknown = 0
nrrdUnaryOpExists = 25
pullSysParmStepInitial = 6
nrrdResampleNonExistentRenormalize = 2
miteRangeSP = 8
echoMatterPhongKs = 2
miteRangeEmissivity = 4
miteValRw = 7
tenAniso_VF = 16
miteRangeAlpha = 0
tenGageCl1 = 73
nrrdUnaryOpRoundDown = 22
pullSysParmGamma = 3
tenGageOmegaHessianEvec0 = 140
nrrdUnaryOpRoundUp = 21
pullSysParmBeta = 2
nrrdResampleNonExistentNoop = 1
miteValNdotV = 13
pullSysParmUnknown = 0
echoJitterGrid = 1
tenGageCp1HessianEvec = 192
nrrdUnaryOpErf = 17
pullPropNeighCovar = 11
seekTypeRidgeSurfaceT = 9
nrrdResampleNonExistentWeight = 3
nrrdResampleNonExistentUnknown = 0
nrrdFFTWPlanRigorExhaustive = 4
nrrdFFTWPlanRigorPatient = 3
tenGageFA = 9
nrrdFFTWPlanRigorMeasure = 2
nrrdFFTWPlanRigorUnknown = 0
pullProcessModeUnknown = 0
pullCondEnergyBad = 6
pullPropForce = 8
pullCondConstraintFail = 5
pullCondEnergyTry = 4
echoMatterLightUnit = 1
nrrdTernaryOpMaxSmooth = 6
nrrdTernaryOpMax = 5
gageKernelStack = 7
tenAniso_Clpmin1 = 5
gageCtxFlagUnknown = 0
nrrdTernaryOpUnknown = 0
nrrdBinaryOpLT = 13
pullIterParmLast = 10
nrrdBinaryOpMin = 11
gageKernel22 = 6
nrrdBinaryOpAtan2 = 10
nrrdBinaryOpFmod = 9
gageItemPackPartHessEval0 = 6
tenAniso_Ca1 = 4
nrrdBinaryOpMod = 8
nrrdBinaryOpFlippedSgnPow = 7
nrrdBinaryOpMultiply = 3
nrrdUnaryOpLog = 10
nrrdBinaryOpUnknown = 0
pullInterTypeUnivariate = 2
pullInterTypeJustR = 1
nrrdUnaryOpExp = 9
nrrdTypeDefault = 0
echoMatterLightPower = 0
nrrdUnaryOpAtan = 8
pullIterParmAddDescent = 6
hooverErrRenderBegin = 2
airNoDio_ptr = 8
nrrdUnaryOpAsin = 6
pullStatusLast = 5
pullPropUnknown = 0
pullStatusEdge = 4
pullStatusNixMe = 3
pullStatusNewbie = 2
pullStatusStuck = 1
nrrdUnaryOpTan = 5
pullIterParmStuckMax = 3
tenGageConfidence = 2
miteValYw = 3
nrrdUnaryOpCos = 4
nrrdAxisInfoUnits = 10
pullInfoLast = 24
pullInfoQuality = 23
tenGageInvarRGradMags = 69
tenGageFADiffusionFraction = 153
pullInfoIsovalueGradient = 20
pullInfoIsovalue = 19
pullInfoNegativeTangent1 = 17
pullInfoTangent2 = 16
pullInfoTangent1 = 15
nrrdUnaryOpReciprocal = 2
gageErrStackUnused = 6
pullInfoLiveThresh3 = 14
pullInfoLiveThresh = 12
pullInfoSeedThresh = 11
gageCtxFlagKernel = 4
pullInfoSeedPreThresh = 10
nrrdUnaryOpNegative = 1
pullInfoHeightGradient = 7
pullInfoHeight = 6
gageCtxFlagNeedK = 3
pullInfoHessian = 3
nrrdUnaryOpUnknown = 0
pullInfoTensorInverse = 2
pullInfoTensor = 1
pullInfoUnknown = 0
miteValXi = 2
airNoDio_okay = 0
limnPolyDataInfoTang = 4
tenGageCp1HessianEval = 188
nrrdBinaryOpLast = 24
nrrdUnaryOpLast = 31
nrrdUnaryOpOne = 30
nrrdUnaryOpZero = 29
nrrdUnaryOpNormalRand = 27
nrrdUnaryOpRand = 26
nrrdUnaryOpSgn = 24
nrrdUnaryOpAbs = 23
gageErrLast = 7
nrrdUnaryOpFloor = 20
nrrdUnaryOpNerf = 18
nrrdUnaryOpCbrt = 16
nrrdUnaryOpSqrt = 15
nrrdUnaryOpExpm1 = 14
nrrdUnaryOpLog1p = 13
airNoDio_disable = 12
airNoDio_test = 11
airNoDio_setfl = 10
airNoDio_fpos = 9
nrrdUnaryOpAcos = 7
airNoDio_size = 7
airNoDio_small = 6
tenGageTraceHessianEvec1 = 89
tenGageInvarKGradMags = 67
airNoDio_dioinfo = 5
nrrdUnaryOpSin = 3
airNoDio_std = 3
airNoDio_format = 2
tenTripleTypeWheelParm = 9
miteShadeMethodLitTen = 3
tenTripleTypeR = 8
tenTripleTypeK = 7
tenTripleTypeJ = 6
tenTripleTypeEigenvalue = 1
tenTripleTypeRThetaPhi = 5
tenTripleTypeRThetaZ = 4
tenTripleTypeXYZ = 3
tenTripleTypeMoment = 2
echoMatterLast = 5
tenTripleTypeUnknown = 0
echoMatterLight = 4
airFP_Last = 11
airFP_NEG_ZERO = 10
pullFlagScaleIsTau = 12
airFP_NEG_DENORM = 8
airFP_POS_DENORM = 7
pullFlagPopCntlEnoughTest = 9
tenInterpTypeRThetaPhiLinear = 11
airFP_NEG_INF = 4
airFP_POS_INF = 3
airFP_QNAN = 2
tenGageInvarKGrads = 66
tenInterpTypeLoxK = 7
tenDwiGageAll = 1
tenInterpTypeGeoLoxR = 6
tenInterpTypeGeoLoxK = 5
pullFlagPermuteOnRebin = 1
dyeSpaceLast = 7
echoMatterPhong = 1
tenInterpTypeLinear = 1
tenInterpTypeUnknown = 0
dyeSpaceXYZ = 4
dyeSpaceRGB = 3
dyeSpaceHSL = 2
dyeSpaceUnknown = 0
miteValTi = 10
pushEnergyTypeSpring = 1
pushEnergyTypeUnknown = 0
limnPolyDataInfoRGBA = 1
seekTypeValleySurfaceOP = 10
tenGageOmegaNormal = 65
pullFlagStartSkipsPoints = 13
pullFlagAllowCodimension3Constraints = 11
gageVecLast = 32
gageVecMGEvec = 31
gageVecMultiGrad = 28
pullFlagBinSingle = 10
gageVecGradient2 = 27
gageVecGradient0 = 25
gageVecProjHelGradient = 24
gageVecDirHelDeriv = 23
pullCondNew = 7
gageVecNCurlNormGrad = 21
gageVecCurlNormGrad = 20
gageVecCurlGradient = 19
gageVecDivGradient = 18
gageSclFlowlineCurv = 31
gageVecHessian = 17
nrrdTernaryOpLast = 17
gageVecImaginaryPart = 16
gageVecLambda2 = 15
gageVecSOmega = 14
gageVecNormHelicity = 13
gageVecHelicity = 12
gageParmGradMagCurvMin = 5
gageVecCurlNorm = 11
gageVecCurl = 10
gageVecDivergence = 9
gageVecStrain = 8
gageVecJacobian = 7
gageVecNormalized = 6
gageParmK3Pack = 4
gageVecLength = 5
tijk_class_last = 4
gageVecVector1 = 3
gageVecVector0 = 2
gageVecVector = 1
gageVecUnknown = 0
gageItemPackPartNormal = 4
pullFlagEnergyFromStrength = 5
pullFlagRestrictiveAddToBins = 4
nrrdAxisInfoLast = 11
limnSpaceLast = 5
miteRangeUnknown = -1
seekTypeRidgeSurfaceOP = 8
tenGageOmegaGradVec = 63
tenEstimate2MethodLast = 3
nrrdBinaryOpRicianRand = 23
nrrdTernaryOpRician = 16
tenEstimate2MethodPeled = 2
nrrdBasicInfoContent = 5
pullFlagUseBetaForGammaLearn = 3
tenEstimate2MethodQSegLLS = 1
nrrdHasNonExistUnknown = 3
nrrdTypeULLong = 8
gageItemPackPartGradMag = 3
gageKernelUnknown = 0
pullFlagUnknown = 0
pullIterParmEnergyIncreasePermitHalfLife = 9
tenInterpTypeLogLinear = 2
limnSpaceDevice = 4
nrrdTernaryOpGaussian = 15
nrrdMeasureHistoMedian = 23
tenDwiGageUnknown = 0
baneClipTopN = 4
airTypeChar = 9
airEndianLast = 4322
airMopOnOkay = 2
nrrdBinaryOpNormalRandScaleAdd = 22
nrrdMeasureLast = 30
nrrdTypeChar = 1
gageSclLast = 36
tenGageOmegaDiffusionAlign = 155
dyeSpaceHSV = 1
limnEdgeTypeLast = 8
nrrdTypeUnknown = 0
nrrdBinaryOpIf = 21
nrrdTernaryOpInOpen = 13
limnEdgeTypeContour = 3
nrrdBoundaryMirror = 5
nrrdResampleNonExistentLast = 4
nrrdBoundaryWeight = 4
tenGageLast = 208
alanParmLast = 22
tenGageAniso = 207
tenGageFiberDispersion = 206
tenGageCa1HessianEvec2 = 204
nrrdBoundaryWrap = 3
tenGageCa1HessianEvec0 = 202
nrrdBinaryOpExists = 20
tenGageCa1HessianEval1 = 199
tenGageCa1HessianEval = 197
tenGageCa1Hessian = 196
tenGageCp1HessianEvec2 = 195
nrrdKind3DMatrix = 30
limnSpaceWorld = 1
coilMethodTypeLast = 9
seekTypeRidgeLine = 4
tenGageCp1HessianEval2 = 191
nrrdBoundaryPad = 1
tenGageCp1HessianEval1 = 190
gageSclHessValleyness = 33
tenGageCp1HessianEval0 = 189
nrrdZlibStrategyFiltered = 3
airTypeSize_t = 6
pullInitMethodLast = 5
nrrdBasicInfoKeyValuePairs = 15
pullTraceStopLast = 6
gageParmOrientationFromSpacing = 13
pullTraceStopConstrFail = 2
pullTraceStopSpeeding = 1
alanParmWrapAround = 21
pullSourceLast = 3
pullSourceProp = 2
pullSourceGage = 1
pullSourceUnknown = 0
nrrdBinaryOpNotEqual = 19
pullEnergyTypeButterworthParabola = 13
pullEnergyTypeBetterCubicWell = 9
pullEnergyTypeCotan = 5
pullEnergyTypeBspln = 3
pullEnergyTypeGauss = 2
pullInitMethodGivenPos = 4
gageParmStackNormalizeRecon = 12
echoJitterLast = 4
alanParmConstantFilename = 20
gagePvlFlagNeedD = 3
gagePvlFlagQuery = 2
nrrdBinaryOpEqual = 18
tenDwiGage2TensorPeledLevmarInfo = 35
hooverErrThreadBegin = 4
tenGageModeGradVec = 57
hooverErrRenderEnd = 10
tenDwiGage2TensorPeled = 32
tenDwiGage2TensorQSegAndError = 31
tenDwiGage2TensorQSegError = 30
tenDwiGage2TensorQSeg = 29
pullInitMethodPointPerVoxel = 3
tenDwiGageTensorAllDWIError = 28
nrrdBasicInfoOldMax = 13
gageSclHessEvec0 = 16
seekTypeMinimalSurface = 6
gageSclHessEvec = 15
gageSclHessEval1 = 13
gageSclHessEval0 = 12
gageSclHessEval = 11
gageSclHessFrob = 10
gageSclLaplacian = 9
gageSclHessianTen = 8
nrrdBinaryOpCompare = 17
gageSclHessian = 7
gageSclNPerp = 6
gageSclNProj = 5
gageSclNormal = 4
echoJittableNormalA = 3
coilKindTypeLast = 4
gageSclGradMag = 3
gageSclGradVec = 2
gageSclUnknown = 0
tenGageCa1HessianEvec = 201
gageKernelLast = 8
gageKernel21 = 5
gageKernel20 = 4
gageKernel11 = 3
gageKernel10 = 2
pushEnergyTypeLast = 6
gageCtxFlagRadius = 5
gageCtxFlagLast = 7
alanParmAlpha = 18
gageCtxFlagK3Pack = 2
gageCtxFlagNeedD = 1
nrrdBinaryOpGTE = 16
gageErrStackSearch = 5
tenAnisoLast = 30
gageErrStackIntegral = 4
gageErrBoundsStack = 3
gageErrBoundsSpace = 2
gageErrNone = 1
gageErrUnknown = 0
gageParmLast = 15
gageParmGenerateErrStr = 14
miteStageOpMax = 2
nrrdTernaryOpGTSmooth = 8
gageParmStackNormalizeDerivBias = 11
gageParmStackNormalizeDeriv = 10
gageParmStackUse = 9
gageParmDefaultCenter = 8
gageParmKernelIntegralNearZero = 7
gageParmCurvNormalSide = 6
gageParmCheckIntegrals = 3
alanParmMaxPixelChange = 17
tenGageCp1Hessian = 187
airEndianBig = 4321
nrrdBinaryOpGT = 15
airEndianLittle = 1234
airEndianUnknown = 0
tenGageCl1HessianEvec2 = 186
nrrdBoundaryLast = 6
nrrdBoundaryBleed = 2
tenFiberStopMinNumSteps = 10
nrrdBoundaryUnknown = 0
gageVecMGEval = 30
echoJittableLast = 7
echoJittableMotionB = 6
gageVecMGFrob = 29
echoJittableMotionA = 5
echoJittableNormalB = 4
echoJittableLens = 2
echoJittableLight = 1
tenGageModeNormal = 59
echoJittablePixel = 0
nrrdBinaryOpLTE = 14
echoJittableUnknown = -1
limnSplineInfoNormal = 4
pullProcessModeLast = 5
limnPolyDataInfoLast = 5
tenAniso_eval1 = 28
pullProcessModeNixing = 4
pullProcessModeAdding = 3
pullProcessModeNeighLearn = 2
pullProcessModeDescent = 1
nrrdMeasureHistoSD = 29
nrrdMeasureHistoVariance = 28
nrrdMeasureHistoL2 = 27
gageVecGradient1 = 26
nrrdMeasureHistoSum = 26
nrrdMeasureHistoProduct = 25
nrrdMeasureHistoMode = 24
nrrdMeasureHistoMean = 22
nrrdMeasureHistoMax = 21
nrrdMeasureHistoMin = 20
nrrdMeasureLineError = 19
nrrdMeasureLineIntercept = 18
nrrdMeasureSkew = 16
tenGageEvalHessian = 177
airTypeLast = 13
airTypeOther = 12
nrrdMeasureRootMeanSquare = 11
nrrdMeasureNormalizedL2 = 10
nrrdMeasureL2 = 9
limnSplineInfo3Vector = 3
airTypeDouble = 8
tenGageTensorGradRotE = 176
airTypeFloat = 7
nrrdMeasureProduct = 6
coilKindTypeUnknown = 0
nrrdMeasureMode = 5
nrrdMeasureMedian = 4
gageVecHelGradient = 22
nrrdMeasureMean = 3
airTypeInt = 2
tenGageCa1Normal = 175
nrrdMeasureMin = 1
nrrdMeasureUnknown = 0
nrrdOriginStatusLast = 5
nrrdOriginStatusOkay = 4
nrrdOriginStatusNoMaxOrSpacing = 3
nrrdOriginStatusNoMin = 2
nrrdOriginStatusDirection = 1
nrrdOriginStatusUnknown = 0
tenGageFAGaussCurv = 119
limnSpaceView = 2
miteRangeGreen = 2
nrrdField_last = 33
nrrdField_data_file = 32
nrrdSpace3DLeftHanded = 10
seekTypeValleyLine = 5
alanParmF = 15
airMopNever = 0
nrrdField_sample_units = 28
nrrdField_keyvalue = 27
nrrdField_byte_skip = 26
limnEdgeTypeFrontCrease = 4
pullSysParmTheta = 5
pullFlagLast = 14
nrrdField_old_max = 22
nrrdField_old_min = 21
tenGageCp1GradMag = 171
nrrdField_max = 20
nrrdMeasureLineSlope = 17
nrrdField_units = 18
nrrdField_labels = 17
tenGageTraceHessianEval1 = 85
nrrdField_centers = 15
limnSpaceUnknown = 0
nrrdField_space_directions = 14
gageSclHessRidgeness = 34
nrrdField_axis_mins = 12
nrrdField_thicknesses = 11
nrrdTernaryOpMinSmooth = 4
nrrdField_sizes = 9
gageSclCurvDir1 = 29
nrrdField_space_dimension = 8
nrrdField_space = 7
nrrdMeasureCoV = 15
nrrdField_dimension = 6
nrrdField_type = 4
echoMatterMetalR0 = 0
tenFiberParmUnknown = 0
nrrdField_content = 2
nrrdField_comment = 1
nrrdMeasureSD = 14
nrrdField_unknown = 0
alanParmK = 14
nrrdKind3DSymMatrix = 28
tenGageTensorRThetaPhiLinear = 166
nrrdKind2DMaskedSymMatrix = 25
nrrdMeasureVariance = 13
nrrdKind4Vector = 22
nrrdKind3Normal = 21
nrrdKind3Gradient = 20
gageSclShapeTrace = 25
nrrdKind3Vector = 19
nrrdKindRGBAColor = 18
nrrdMeasureLinf = 12
nrrdKind4Color = 17
miteStageOpMin = 1
nrrdKindXYZColor = 16
nrrdKindHSVColor = 15
nrrdKindRGBColor = 14
gageSclTotalCurv = 24
nrrdKind3Color = 13
airTypeEnum = 11
nrrdKindComplex = 11
nrrdKindScalar = 10
nrrdKindStub = 9
tenGageTensorLogEuclidean = 163
airInsane_QNaNHiBit = 6
nrrdKindCovariantVector = 7
nrrdKindVector = 6
airTypeString = 10
nrrdKindPoint = 5
nrrdKindList = 4
nrrdKindTime = 3
nrrdKindSpace = 2
nrrdKindDomain = 1
alanStopNonExist = 3
tenGageCovarianceRGRT = 161
nrrdMeasureL1 = 8
gageSclGeomTens = 20
nrrdMeasureSum = 7
nrrdTernaryOpMultiply = 2
gageScl2ndDD = 19
pullConstraintFailIterMaxed = 3
airTypeULongInt = 5
gageVecVector2 = 4
airTypeLongInt = 4
tenGageModeGradMag = 58
airTypeUInt = 3
tijk_class_esh = 2
limnSplineInfoLast = 7
limnSplineInfoQuaternion = 6
limnPrimitiveTriangles = 2
limnSplineInfo4Vector = 5
nrrdMeasureMax = 2
mossFlagImage = 0
mossFlagUnknown = -1
gageSclK1 = 22
tijk_class_tensor = 1
limnSplineInfo2Vector = 2
limnSplineInfoScalar = 1
limnSplineInfoUnknown = 0
airTypeBool = 1
tenDwiGageTensorWLSError = 11
tijk_class_unknown = 0
nrrdIoStateBzip2BlockSize = 9
airTypeUnknown = 0
nrrdIoStateZlibStrategy = 8
nrrdIoStateZlibLevel = 7
nrrdIoStateKeepNrrdDataFileOpen = 6
nrrdIoStateSkipData = 5
nrrdIoStateValsPerLine = 4
nrrdIoStateCharsPerLine = 3
nrrdIoStateBareText = 2
nrrdIoStateDetachedHeader = 1
nrrdIoStateUnknown = 0
pullIterParmMin = 1
miteShadeMethodLast = 4
tenFiberTypeEvec2 = 3
nrrdBasicInfoBlocksize = 3
limnSplineTypeLast = 6
nrrdFormatTypeEPS = 6
miteShadeMethodPhong = 2
nrrdFormatTypeVTK = 4
nrrdCenterNode = 1
nrrdFormatTypePNM = 2
tenAniso_S = 20
nrrdFormatTypeNRRD = 1
nrrdFormatTypeUnknown = 0
miteShadeMethodNone = 1
nrrdBinaryOpSgnPow = 6
nrrdSpacingStatusLast = 5
limnSplineTypeHermite = 3
tenGageSGradMag = 46
tenGageTensorQuatGeoLoxK = 164
seekTypeLast = 12
seekTypeValleySurfaceT = 11
nrrdTernaryOpExists = 12
nrrdBasicInfoType = 2
seekTypeMaximalSurface = 7
limnPrimitiveLineStrip = 6
seekTypeRidgeSurface = 2
seekTypeIsocontour = 1
seekTypeUnknown = 0
echoTypeSplit = 9
pullSysParmWall = 18
pullFlagNoAdd = 8
pullEnergyTypeSpring = 1
echoTypeIsosurface = 7
pullPropIdCC = 2
echoTypeRectangle = 5
pullSysParmEnergyDecreasePopCntlMin = 14
tenGageRotTanMags = 71
echoTypeCube = 3
echoTypeSuperquad = 2
echoTypeCylinder = 1
pullSysParmNeighborTrueProb = 10
echoTypeUnknown = -1
pullSysParmRadiusScale = 8
pullSysParmRadiusSpace = 7
miteStageOpUnknown = 0
pullSysParmSeparableGammaLearnRescale = 4
pullPropStability = 17
miteRangeLast = 9
pullPropNeighCovarDet = 16
hooverErrInit = 1
nrrdField_space_units = 29
pullSysParmAlpha = 1
tenGageFA2ndDD = 112
airNoDio_fd = 4
pullPropNeighInterNum = 14
nrrdBasicInfoData = 1
pullPropNeighTanCovar = 13
pullPropNeighCovar7Ten = 12
limnPrimitiveNoop = 1
pullPropScale = 10
pullPropNeighDistMean = 9
alanParmRandRange = 8
miteRangeRed = 1
pullPropStuck = 6
limnPrimitiveUnknown = 0
pullPropEnergy = 3
pullFlagConstraintBeforeSeedThresh = 7
pullPropIdtag = 1
pullCondConstraintSatB = 3
unrrduScaleLast = 8
nrrdField_line_skip = 25
airInsane_NaNExists = 4
nrrdField_encoding = 24
tenGageFARidgeSurfaceAlignment = 111
alanStopLast = 6
unrrduScaleAspectRatio = 6
tijk_class_efs = 3
nrrdField_endian = 23
alanParmMaxIteration = 7
nrrdBinaryOpDivide = 4
pullFlagNixAtVolumeEdgeSpace = 6
airInsane_nInfExists = 3
unrrduScaleMultiply = 2
pullTraceStopStub = 5
nrrdField_min = 19
alanStopDiverged = 5
unrrduScaleNothing = 1
limnDeviceLast = 3
unrrduScaleUnknown = 0
pullSysParmLast = 20
echoTypeLast = 12
tenInterpTypeQuatGeoLoxR = 10
alanTextureTypeTuring = 1
echoMatterGlassKd = 2
tenGageFAHessianEvalMode = 109
tenDwiGageFA = 27
baneIncLast = 5
tenGageCl1HessianEvec = 183
tenGageCl1HessianEval2 = 182
nrrdField_axis_maxs = 13
tenGageCl1HessianEval1 = 181
alanParmHomogAniso = 5
tenGageCl1HessianEval = 179
tenGageCl1Hessian = 178
tenDwiGageConfidence = 26
tenGageCa1GradMag = 174
nrrdBinaryOpSubtract = 2
tenGageCa1GradVec = 173
gageParmUnknown = 0
tenGageCp1GradVec = 170
tenInterpTypeQuatGeoLoxK = 9
tenGageCl1Normal = 169
nrrdBinaryOpPow = 5
tenGageCl1GradVec = 167
baneMeasrValueAnywhere = 3
tenGageTensorQuatGeoLoxR = 165
nrrdField_spacings = 10
tenGageCovarianceKGRT = 162
nrrdSpaceLeftPosteriorSuperior = 3
nrrdTernaryOpLerp = 11
tenDwiGageTensor = 22
baneIncStdv = 4
nrrdCenterCell = 2
tenFiberParmLast = 5
nrrdCenterUnknown = 0
gageSclHessEvec1 = 17
limnSplineTypeBC = 5
limnSplineTypeCubicBezier = 4
nrrdBinaryOpAdd = 1
limnSplineTypeLinear = 1
limnSplineTypeUnknown = 0
tenInterpTypeLast = 12
tenInterpTypeLoxR = 8
tenDwiGageTensorMLEError = 19
nrrdField_block_size = 5
nrrdSpaceLeftAnteriorSuperior = 2
tenGageFALaplacian = 108
alanStopMaxIteration = 2
tenDwiGageTensorNLSLikelihood = 17
nrrdField_number = 3
tenDwiGageTensorLikelihood = 25
tenDwiGageTensorError = 23
tenDwiGageTensorMLEErrorLog = 20
pullFlagNoPopCntlWithZeroAlpha = 2
tenDwiGageTensorNLSErrorLog = 16
tenDwiGageTensorNLSError = 15
tenGageConfDiffusionFraction = 159
tenGageConfDiffusionAlign = 158
tenGageConfGradVecDotEvec0 = 157
pullCondConstraintSatA = 2
tenGageOmegaGradVecDotEvec0 = 154
tenDwiGageTensorLLSErrorLog = 8
tenGageFAGradVecDotEvec0 = 151
tenGageTraceDiffusionFraction = 150
tenDwiGageMeanDWIValue = 5
nrrdSpaceRightAnteriorSuperior = 1
tenDwiGageADC = 4
miteRangeKs = 7
tenDwiGageJustDWI = 3
coilMethodTypePeronaMalik = 3
tenGageFAValleySurfaceStrength = 107
miteRangeKd = 6
tenGageOmegaHessianEvec1 = 141
nrrdKindLast = 32
alanParmTextureType = 2
tenGageOmegaHessianEval2 = 138
tenGageOmegaHessianEval1 = 137
tenGageOmegaHessianEval0 = 136
tenGageOmegaHessianEval = 135
tenGageOmegaHessian = 134
nrrdKind3DMaskedMatrix = 31
tenGageModeHessianFrob = 133
pullSysParmEnergyDecreaseMin = 16
tenGageModeHessianEvec1 = 131
tenGageModeHessianEvec0 = 130
tenDwiGageTensorWLS = 10
tenGageModeHessianEvec = 129
tenGageModeHessianEval2 = 128
tenGageModeHessianEval = 125
tenGageModeHessian = 124
tenGageRHessian = 123
nrrdKind3DMaskedSymMatrix = 29
tenGageFACurvDir2 = 121
tenGageFACurvDir1 = 120
airNoDio_arch = 1
nrrdSpaceUnknown = 0
tenGageFAShapeIndex = 117
pullTraceStopUnknown = 0
tenGageFATotalCurv = 116
tenGageFARidgeSurfaceStrength = 106
tenDwiGageTensorLLSLikelihood = 9
tenGageFAGeomTens = 113
alanParmBeta = 19
tenGageFARidgeLineAlignment = 110
pullInfoStrength = 22
nrrdSpaceRightAnteriorSuperiorTime = 4
nrrdKind2DMaskedMatrix = 27
limnQN9octa = 14
alanParmDeltaX = 10
tenGageFAHessianEvec = 101
tenGageFAHessianEval1 = 99
nrrdKind2DMatrix = 26
alanParmSaveInterval = 6
limnQN10octa = 13
nrrdBasicInfoLast = 16
alanParmNumThreads = 3
pullInterTypeLast = 5
nrrdBasicInfoComments = 14
alanParmVerbose = 1
alanParmUnknown = 0
tenGageNormNormal = 38
nrrdBasicInfoMeasurementFrame = 11
nrrdBasicInfoSpaceOrigin = 10
nrrdBasicInfoSpaceUnits = 9
nrrdBasicInfoSpaceDimension = 8
tenGageTraceHessianEvec = 87
nrrdKind2DSymMatrix = 24
nrrdBasicInfoSampleUnits = 6
nrrdHasNonExistTrue = 1
tenGageTraceHessianEval = 83
tenDwiGageB0 = 2
tenGageHessian = 81
nrrdKindQuaternion = 23
nrrdBasicInfoUnknown = 0
tenGageCa2 = 79
tenGageCl2 = 77
tenGageOmegaHessianContrTenEvec0 = 145
tenGageClpmin1 = 76
limnEdgeTypeBackFacet = 1
pullInitMethodHalton = 2
tenGageEvalGrads = 72
coilMethodTypeHomogeneous = 2
tenAniso_Clpmin2 = 11
tenInterpTypeWang = 4
limnQN13octa = 8
coilMethodTypeTesting = 1
tenGageThetaNormal = 62
tenGageThetaGradVec = 60
coilMethodTypeUnknown = 0
tenGageFAHessianEvec2 = 104
tenGageRGradMag = 55
limnQN14checker = 6
tenGageRGradVec = 54
tenGageFAGradMag = 52
tenGageFAGradVec = 51
tenGageQNormal = 50
tenGageQGradMag = 49
limnQN15octa = 5
tenGageQGradVec = 48
tenGageSNormal = 47
nrrdAxisInfoSpacing = 2
tenGageDetNormal = 44
pullSysParmBackStepScale = 13
limnQN16octa = 4
tenGageDetGradMag = 43
tenGageOmegaHessianEvec = 139
tenGageBGradMag = 40
tenInterpTypeAffineInvariant = 3
tenGageBGradVec = 39
tenGageNormGradMag = 37
tenGageNormGradVec = 36
pullInterTypeSeparable = 3
tenGageTraceNormal = 35
nrrdAxisInfoLabel = 9
tenGageTraceGradVec = 33
tenGageTensorGradMag = 31
nrrdAxisInfoMax = 5
nrrdAxisInfoMin = 4
nrrdAxisInfoThickness = 3
tenGageFAHessianEvec1 = 103
tenGageDelNormR2 = 26
tenGageDelNormPhi3 = 29
tenGageDelNormR1 = 25
tenGageDelNormK3 = 24
tenGageEvec2 = 22
tenGageEvec0 = 20
limnQNUnknown = 0
tenGageEvec = 19
tenGageEval1 = 17
tenGageEval0 = 16
nrrdKind2Vector = 12
pullCondLast = 8
tenGageOmega = 14
tenGageDet = 6
tenGageB = 5
tenGageNorm = 4
tenGageTrace = 3
tenAniso_eval2 = 29
tenGageTensor = 1
tenGageUnknown = 0
tenGageModeHessianEvec2 = 132
tenAniso_Tr = 26
tenAniso_Det = 25
tenAniso_Omega = 24
tenGageFAHessianEvec0 = 102
tenAniso_Th = 23
limnEdgeTypeFrontFacet = 5
tenAniso_Mode = 22
tenAniso_Skew = 21
nrrdKindNormal = 8
tenAniso_Q = 18
tenAniso_FA = 15
tenAniso_RA = 14
tenAniso_Ct2 = 13
tenAniso_Cs2 = 12
tenAniso_Ca2 = 10
tenAniso_Cp2 = 9
tenAniso_Cl2 = 8
tenAniso_Ct1 = 7
tenAniso_Cs1 = 6
alanTextureTypeUnknown = 0
nrrdAxisInfoCenter = 7
tenAniso_Cp1 = 3
tenAniso_Cl1 = 2
tenAniso_Conf = 1
tenGageModeHessianEval1 = 127
tenGageModeHessianEval0 = 126
nrrdBlind8BitRangeLast = 4
nrrdBlind8BitRangeState = 3
nrrdBlind8BitRangeFalse = 2
nrrdBlind8BitRangeTrue = 1
nrrdBlind8BitRangeUnknown = 0
tenGageFAFlowlineCurv = 122
tenFiberParmVerbose = 4
airInsane_pInfExists = 2
coilKindType7Tensor = 3
coilKindType3Color = 2
coilKindTypeScalar = 1
pullSysParmBinWidthSpace = 9
miteValNdotL = 14
limnDeviceGL = 2
tenAniso_B = 17
unrrduScaleExact = 7
pullIterParmSnap = 8
miteValLast = 20
tenGageFAKappa2 = 115
tenFiberStopLast = 11
tenFiberStopMinLength = 9
tenGageFAKappa1 = 114
tenFiberStopStub = 8
tenFiberStopFraction = 7
tenFiberStopBounds = 6
tenFiberStopRadius = 5
baneClipPercentile = 3
tenFiberStopConfidence = 4
tenFiberStopNumSteps = 3
tenFiberStopLength = 2
tenFiberStopAniso = 1
pullConstraintFailUnknown = 0
tenFiberStopUnknown = 0
tenFiberIntgLast = 4
tenFiberIntgRK4 = 3
tenFiberIntgMidpoint = 2
tenFiberIntgEuler = 1
tenFiberIntgUnknown = 0
tenGageFAHessianEval0 = 98
tenGageDelNormPhi2 = 28
miteValGTdotV = 16
nrrdBasicInfoOldMin = 12
baneClipUnknown = 0
tenGageCl1HessianEvec1 = 185
nrrdCenterLast = 3
tenDwiFiberTypeLast = 4
pullCondUnknown = 0
tenDwiFiberType12BlendEvec0 = 3
nrrdSpacingStatusUnknown = 0
tenDwiFiberType2Evec0 = 2
tenDwiFiberType1Evec0 = 1
tenDwiFiberTypeUnknown = 0
ell_cubic_root_unknown = 0
tenGageTensorGrad = 30
miteValNormal = 12
pullEnergyTypeZero = 12
tenGageFAHessianEval = 97
miteValView = 11
pullInfoLiveThresh2 = 13
pullConstraintFailTravel = 4
tenGageCl1HessianEvec0 = 184
baneRangeUnknown = 0
tenGageFAHessianFrob = 105
nrrdEncodingTypeLast = 6
nrrdUnaryOpIf = 28
nrrdKindUnknown = 0
alanParmDiffB = 12
pullConstraintFailProjGradZeroB = 2
alanParmDiffA = 11
pullConstraintFailProjGradZeroA = 1
tenGageFAHessian = 96
tenDwiGageTensorLLSError = 7
miteValZi = 6
limnQNLast = 17
limnQN8octa = 16
limnQN8checker = 15
unrrduScaleAdd = 4
miteValZw = 5
echoMatterMetal = 3
tenGageCl1GradMag = 168
limnQN10checker = 12
alanParmDeltaT = 9
limnQN11octa = 11
limnQN12octa = 10
limnQN12checker = 9
pullCondOld = 1
tenGlyphTypePolarPlot = 6
miteValYi = 4
limnQN14octa = 7
tenGageFAHessianEval2 = 100
tenFiberParmWPunct = 3
limnQN16checker = 3
limnQN16border1 = 2
limnQN16simple = 1
pullEnergyTypeHepticWell = 11
nrrdAxisInfoSize = 1
tenGageQHessian = 95
miteValXw = 1
nrrdFFTWPlanRigorLast = 5
miteValUnknown = 0
alanParmFrameInterval = 4
miteValWdotD = 19
miteValVdefTdotV = 18
miteValVdefT = 17
nrrdSpacingStatusScalarWithSpace = 3
miteRangeBlue = 3
nrrdSpacingStatusScalarNoSpace = 2
nrrdEncodingTypeGzip = 4
baneRangeLast = 5
baneRangeAnywhere = 4
gageItemPackPartHessEvec0 = 9
nrrdTernaryOpInClosed = 14
miteValTw = 9
tenGageTraceGradVecDotEvec0 = 148
tenGageDelNormPhi1 = 27
gageItemPackPartHessEval2 = 8
nrrdField_measurement_frame = 31
nrrdFFTWPlanRigorEstimate = 1
gageItemPackPartLast = 12
tenGageSHessian = 94
gageItemPackPartHessEvec2 = 11
gageItemPackPartHessEvec1 = 10
gageItemPackPartHessEval1 = 7
gageItemPackPartHessian = 5
nrrdAxisInfoUnknown = 0
tenGageTraceHessianFrob = 91
gageItemPackPartScalar = 1
gageItemPackPartUnknown = 0
nrrdTernaryOpIfElse = 10
nrrdEncodingTypeHex = 3
miteStageOpLast = 5
nrrdTernaryOpClamp = 9
nrrdField_space_origin = 30
tenGageTraceHessianEvec0 = 88
miteRangeKa = 5
tenGageDetHessian = 93
gageItemPackPartGradVec = 2
nrrdBasicInfoSpace = 7
tenGageCovariance = 160
pullInfoHeightLaplacian = 9
echoMatterUnknown = 0
gageSclValue = 1
tenFiberParmStepSize = 1
nrrdEncodingTypeBzip2 = 5
tenGageCl1HessianEval0 = 180
nrrdHasNonExistOnly = 2
pullCountLast = 15
tenAnisoUnknown = 0
nrrdEncodingTypeUnknown = 0
pullPropLast = 18
pullCountCC = 13
pullCountPointsStuck = 11
nrrdBasicInfoDimension = 4
pullCountAdding = 9
pullCountConstraintSatisfy = 8
pullCountProbe = 7
pullCountForceFromPoints = 6
pullCountEnergyFromPoints = 5
pullCountForceFromImage = 4
nrrdTernaryOpMin = 3
pullCountEnergyFromImage = 3
alanParmMinAverageChange = 16
mossFlagLast = 2
pullCountDescent = 1
airFP_POS_ZERO = 9
mossFlagKernel = 1
pullInfoHeightHessian = 8
nrrdTernaryOpAdd = 1
tenGageFANormal = 53
coilMethodTypeModifiedCurvature = 4
nrrdEncodingTypeRaw = 1
miteStageOpMultiply = 4
pullConstraintFailLast = 5
alanStopNot = 1
miteStageOpAdd = 3
tenGageModeWarp = 13
nrrdBinaryOpMax = 12
echoMatterMetalFuzzy = 3
echoMatterMetalKd = 2
echoMatterMetalKa = 1
baneMeasrLast = 9
baneMeasrFlowlineCurv = 8
limnDevicePS = 1
limnDeviceUnknown = 0
tenGageCa1HessianEval0 = 198
pullPropStepEnergy = 4
tenGageCa1HessianEval2 = 200
tenFiberParmUseIndexSpace = 2
baneClipLast = 5
pullEnergyTypeQuarticWell = 10
pullInitMethodRandom = 1
tenGageCp1HessianEvec1 = 194
pullInitMethodUnknown = 0
baneRangeNegative = 2
tenGageTraceHessianEvec2 = 90
tenGageCp1HessianEvec0 = 193
nrrdIoStateLast = 10
tenGageBHessian = 92
tenGageRotTans = 70
pullPropNeighCovarTrace = 15
nrrdSpacingStatusDirection = 4
echoMatterGlass = 2
nrrdHasNonExistLast = 4
tenGageInvarRGrads = 68
nrrdTernaryOpLTSmooth = 7
airFP_NEG_NORM = 6
pullInterTypeAdditive = 4
tenGageOmegaDiffusionFraction = 156
pullInfoInsideGradient = 5
limnSplineTypeTimeWarp = 2
pullCountIteration = 14
tenGageOmegaGradMag = 64
pullInterTypeUnknown = 0
airFP_POS_NORM = 5
miteValVrefN = 15
pullInfoInside = 4
tenGageThetaGradMag = 61
pullTraceStopLength = 4
tenTripleTypeLast = 10
baneClipPeakRatio = 2
pullTraceStopBounds = 3
nrrdUnaryOpCeil = 19
nrrdSpaceLast = 13
nrrdSpace3DLeftHandedTime = 12
nrrdSpace3DRightHandedTime = 11
nrrdSpace3DRightHanded = 9
nrrdSpaceScannerXYZTime = 8
tenGageRNormal = 56
nrrdSpaceScannerXYZ = 7
nrrdSpaceLeftPosteriorSuperiorTime = 6
nrrdSpaceLeftAnteriorSuperiorTime = 5
baneClipAbsolute = 1
tenFiberTypeLast = 7
tenFiberTypeZhukov = 6
tenFiberTypePureLine = 5
baneIncPercentile = 3
tenFiberTypeTensorLine = 4
tenGageTraceHessianEval2 = 86
nrrdEncodingTypeAscii = 2
tenFiberTypeEvec1 = 2
tenFiberTypeEvec0 = 1
tenFiberTypeUnknown = 0
tenDwiGageTensorErrorLog = 24
tenEstimate1MethodLast = 5
tenEstimate1MethodMLE = 4
tenEstimate1MethodNLS = 3
tenEstimate1MethodWLS = 2
tenEstimate1MethodLLS = 1
tenEstimate1MethodUnknown = 0
tenGlyphTypeLast = 7
tenGlyphTypeBetterquad = 5
tenGlyphTypeSuperquad = 4
tenGlyphTypeCylinder = 3
tenGlyphTypeSphere = 2
pullEnergyTypeLast = 14
tenGlyphTypeBox = 1
tenGlyphTypeUnknown = 0
pullCountPoints = 12
nrrdHasNonExistFalse = 0
tenEstimate2MethodUnknown = 0
tenGageFiberCurving = 205
gagePvlFlagLast = 4
tenGageFADiffusionAlign = 152
pullCountNixing = 10
limnCameraPathTrackLast = 4
tenGageCp1Normal = 172
tenGageSGradVec = 45
limnPrimitiveLast = 8
tenGageTraceHessianEval0 = 84
airFP_SNAN = 1
airInsane_DLSize = 11
coilMethodTypeFinish = 8
airInsane_FISize = 10
pullEnergyTypeCubic = 6
airInsane_UCSize = 9
airInsane_dio = 8
tenGageDetGradVec = 42
airInsane_AIR_NAN = 7
airInsane_FltDblFPClass = 5
tenGageBNormal = 41
airInsane_endian = 1
airInsane_not = 0
pullEnergyTypeButterworth = 4
ell_cubic_root_last = 5
ell_cubic_root_three = 4
ell_cubic_root_single_double = 3
ell_cubic_root_triple = 2
ell_cubic_root_single = 1
nrrdFormatTypeLast = 7
tenGageCa1HessianEvec1 = 203
airFP_Unknown = 0
tenDwiGageTensorMLELikelihood = 21
coilMethodTypeSelf = 7
tenDwiGageTensorMLE = 18
nrrdFormatTypeText = 5
pullEnergyTypeUnknown = 0
baneRangeZeroCentered = 3
nrrdSpacingStatusNone = 1
nrrdFormatTypePNG = 3
tenGageEval = 15
tenGageTraceGradMag = 34
tenGageTraceHessian = 82
nrrdAxisInfoKind = 8
coilMethodTypeCurvatureFlow = 6
tenGageTraceDiffusionAlign = 149
tenGageTensorGradMagMag = 32
nrrdAxisInfoSpaceDirection = 6
pullPropPosition = 7
alanStopConverged = 4
baneIncRangeRatio = 2
pullInfoIsovalueHessian = 21
limnCameraPathTrackBoth = 3
limnCameraPathTrackAt = 2
limnCameraPathTrackFrom = 1
coilMethodTypeModifiedCurvatureRings = 5
limnCameraPathTrackUnknown = 0
tenGageFAMeanCurv = 118
alanStopUnknown = 0
baneRangePositive = 1
pullEnergyTypeCubicWell = 8
pullInfoNegativeTangent2 = 18
airLLong = c_longlong
airULLong = c_ulonglong
class airPtrPtrUnion(Union):
    pass
airPtrPtrUnion._fields_ = [
    ('uc', POINTER(POINTER(c_ubyte))),
    ('sc', POINTER(POINTER(c_byte))),
    ('c', POINTER(STRING)),
    ('cp', POINTER(POINTER(STRING))),
    ('us', POINTER(POINTER(c_ushort))),
    ('s', POINTER(POINTER(c_short))),
    ('ui', POINTER(POINTER(c_uint))),
    ('i', POINTER(POINTER(c_int))),
    ('f', POINTER(POINTER(c_float))),
    ('d', POINTER(POINTER(c_double))),
    ('v', POINTER(c_void_p)),
]
class airEnum(Structure):
    pass
airEnum._fields_ = [
    ('name', STRING),
    ('M', c_uint),
    ('str', POINTER(STRING)),
    ('val', POINTER(c_int)),
    ('desc', POINTER(STRING)),
    ('strEqv', POINTER(STRING)),
    ('valEqv', POINTER(c_int)),
    ('sense', c_int),
]
airEnumUnknown = libteem.airEnumUnknown
airEnumUnknown.restype = c_int
airEnumUnknown.argtypes = [POINTER(airEnum)]
airEnumValCheck = libteem.airEnumValCheck
airEnumValCheck.restype = c_int
airEnumValCheck.argtypes = [POINTER(airEnum), c_int]
airEnumStr = libteem.airEnumStr
airEnumStr.restype = STRING
airEnumStr.argtypes = [POINTER(airEnum), c_int]
airEnumDesc = libteem.airEnumDesc
airEnumDesc.restype = STRING
airEnumDesc.argtypes = [POINTER(airEnum), c_int]
airEnumVal = libteem.airEnumVal
airEnumVal.restype = c_int
airEnumVal.argtypes = [POINTER(airEnum), STRING]
airEnumFmtDesc = libteem.airEnumFmtDesc
airEnumFmtDesc.restype = STRING
airEnumFmtDesc.argtypes = [POINTER(airEnum), c_int, c_int, STRING]
airEnumPrint = libteem.airEnumPrint
airEnumPrint.restype = None
airEnumPrint.argtypes = [POINTER(FILE), POINTER(airEnum)]
airEnumCheck = libteem.airEnumCheck
airEnumCheck.restype = c_int
airEnumCheck.argtypes = [STRING, POINTER(airEnum)]
airEndian = (POINTER(airEnum)).in_dll(libteem, 'airEndian')
airMyEndian = libteem.airMyEndian
airMyEndian.restype = c_int
airMyEndian.argtypes = []
class airArray(Structure):
    pass
airArray._fields_ = [
    ('data', c_void_p),
    ('dataP', POINTER(c_void_p)),
    ('len', c_uint),
    ('lenP', POINTER(c_uint)),
    ('incr', c_uint),
    ('size', c_uint),
    ('unit', c_size_t),
    ('noReallocWhenSmaller', c_int),
    ('allocCB', CFUNCTYPE(c_void_p)),
    ('freeCB', CFUNCTYPE(c_void_p, c_void_p)),
    ('initCB', CFUNCTYPE(None, c_void_p)),
    ('doneCB', CFUNCTYPE(None, c_void_p)),
]
airArrayNew = libteem.airArrayNew
airArrayNew.restype = POINTER(airArray)
airArrayNew.argtypes = [POINTER(c_void_p), POINTER(c_uint), c_size_t, c_uint]
airArrayStructCB = libteem.airArrayStructCB
airArrayStructCB.restype = None
airArrayStructCB.argtypes = [POINTER(airArray), CFUNCTYPE(None, c_void_p), CFUNCTYPE(None, c_void_p)]
airArrayPointerCB = libteem.airArrayPointerCB
airArrayPointerCB.restype = None
airArrayPointerCB.argtypes = [POINTER(airArray), CFUNCTYPE(c_void_p), CFUNCTYPE(c_void_p, c_void_p)]
airArrayLenSet = libteem.airArrayLenSet
airArrayLenSet.restype = None
airArrayLenSet.argtypes = [POINTER(airArray), c_uint]
airArrayLenPreSet = libteem.airArrayLenPreSet
airArrayLenPreSet.restype = None
airArrayLenPreSet.argtypes = [POINTER(airArray), c_uint]
airArrayLenIncr = libteem.airArrayLenIncr
airArrayLenIncr.restype = c_uint
airArrayLenIncr.argtypes = [POINTER(airArray), c_int]
airArrayNix = libteem.airArrayNix
airArrayNix.restype = POINTER(airArray)
airArrayNix.argtypes = [POINTER(airArray)]
airArrayNuke = libteem.airArrayNuke
airArrayNuke.restype = POINTER(airArray)
airArrayNuke.argtypes = [POINTER(airArray)]
class airHeap(Structure):
    pass
airHeap._fields_ = [
    ('key_a', POINTER(airArray)),
    ('data_a', POINTER(airArray)),
    ('idx_a', POINTER(airArray)),
    ('invidx_a', POINTER(airArray)),
    ('key', POINTER(c_double)),
    ('data', c_void_p),
    ('idx', POINTER(c_uint)),
    ('invidx', POINTER(c_uint)),
]
airHeapNew = libteem.airHeapNew
airHeapNew.restype = POINTER(airHeap)
airHeapNew.argtypes = [c_size_t, c_uint]
airHeapFromArray = libteem.airHeapFromArray
airHeapFromArray.restype = POINTER(airHeap)
airHeapFromArray.argtypes = [POINTER(airArray), POINTER(airArray)]
airHeapNix = libteem.airHeapNix
airHeapNix.restype = POINTER(airHeap)
airHeapNix.argtypes = [POINTER(airHeap)]
airHeapLength = libteem.airHeapLength
airHeapLength.restype = c_uint
airHeapLength.argtypes = [POINTER(airHeap)]
airHeapInsert = libteem.airHeapInsert
airHeapInsert.restype = c_uint
airHeapInsert.argtypes = [POINTER(airHeap), c_double, c_void_p]
airHeapMerge = libteem.airHeapMerge
airHeapMerge.restype = c_uint
airHeapMerge.argtypes = [POINTER(airHeap), POINTER(airHeap)]
airHeapFrontPeek = libteem.airHeapFrontPeek
airHeapFrontPeek.restype = c_double
airHeapFrontPeek.argtypes = [POINTER(airHeap), c_void_p]
airHeapFrontPop = libteem.airHeapFrontPop
airHeapFrontPop.restype = c_double
airHeapFrontPop.argtypes = [POINTER(airHeap), c_void_p]
airHeapFrontUpdate = libteem.airHeapFrontUpdate
airHeapFrontUpdate.restype = c_int
airHeapFrontUpdate.argtypes = [POINTER(airHeap), c_double, c_void_p]
airHeapFind = libteem.airHeapFind
airHeapFind.restype = c_int
airHeapFind.argtypes = [POINTER(airHeap), POINTER(c_uint), c_void_p]
airHeapRemove = libteem.airHeapRemove
airHeapRemove.restype = c_int
airHeapRemove.argtypes = [POINTER(airHeap), c_uint]
airHeapUpdate = libteem.airHeapUpdate
airHeapUpdate.restype = c_int
airHeapUpdate.argtypes = [POINTER(airHeap), c_uint, c_double, c_void_p]
airThreadCapable = (c_int).in_dll(libteem, 'airThreadCapable')
airThreadNoopWarning = (c_int).in_dll(libteem, 'airThreadNoopWarning')
class _airThread(Structure):
    pass
airThread = _airThread
class _airThreadMutex(Structure):
    pass
airThreadMutex = _airThreadMutex
class _airThreadCond(Structure):
    pass
airThreadCond = _airThreadCond
class airThreadBarrier(Structure):
    pass
airThreadBarrier._fields_ = [
    ('numUsers', c_uint),
    ('numDone', c_uint),
    ('doneMutex', POINTER(airThreadMutex)),
    ('doneCond', POINTER(airThreadCond)),
]
airThreadNew = libteem.airThreadNew
airThreadNew.restype = POINTER(airThread)
airThreadNew.argtypes = []
airThreadStart = libteem.airThreadStart
airThreadStart.restype = c_int
airThreadStart.argtypes = [POINTER(airThread), CFUNCTYPE(c_void_p, c_void_p), c_void_p]
airThreadJoin = libteem.airThreadJoin
airThreadJoin.restype = c_int
airThreadJoin.argtypes = [POINTER(airThread), POINTER(c_void_p)]
airThreadNix = libteem.airThreadNix
airThreadNix.restype = POINTER(airThread)
airThreadNix.argtypes = [POINTER(airThread)]
airThreadMutexNew = libteem.airThreadMutexNew
airThreadMutexNew.restype = POINTER(airThreadMutex)
airThreadMutexNew.argtypes = []
airThreadMutexLock = libteem.airThreadMutexLock
airThreadMutexLock.restype = c_int
airThreadMutexLock.argtypes = [POINTER(airThreadMutex)]
airThreadMutexUnlock = libteem.airThreadMutexUnlock
airThreadMutexUnlock.restype = c_int
airThreadMutexUnlock.argtypes = [POINTER(airThreadMutex)]
airThreadMutexNix = libteem.airThreadMutexNix
airThreadMutexNix.restype = POINTER(airThreadMutex)
airThreadMutexNix.argtypes = [POINTER(airThreadMutex)]
airThreadCondNew = libteem.airThreadCondNew
airThreadCondNew.restype = POINTER(airThreadCond)
airThreadCondNew.argtypes = []
airThreadCondWait = libteem.airThreadCondWait
airThreadCondWait.restype = c_int
airThreadCondWait.argtypes = [POINTER(airThreadCond), POINTER(airThreadMutex)]
airThreadCondSignal = libteem.airThreadCondSignal
airThreadCondSignal.restype = c_int
airThreadCondSignal.argtypes = [POINTER(airThreadCond)]
airThreadCondBroadcast = libteem.airThreadCondBroadcast
airThreadCondBroadcast.restype = c_int
airThreadCondBroadcast.argtypes = [POINTER(airThreadCond)]
airThreadCondNix = libteem.airThreadCondNix
airThreadCondNix.restype = POINTER(airThreadCond)
airThreadCondNix.argtypes = [POINTER(airThreadCond)]
airThreadBarrierNew = libteem.airThreadBarrierNew
airThreadBarrierNew.restype = POINTER(airThreadBarrier)
airThreadBarrierNew.argtypes = [c_uint]
airThreadBarrierWait = libteem.airThreadBarrierWait
airThreadBarrierWait.restype = c_int
airThreadBarrierWait.argtypes = [POINTER(airThreadBarrier)]
airThreadBarrierNix = libteem.airThreadBarrierNix
airThreadBarrierNix.restype = POINTER(airThreadBarrier)
airThreadBarrierNix.argtypes = [POINTER(airThreadBarrier)]
class airFloat(Union):
    pass
airFloat._fields_ = [
    ('i', c_uint),
    ('f', c_float),
]
class airDouble(Union):
    pass
airDouble._pack_ = 4
airDouble._fields_ = [
    ('i', airULLong),
    ('d', c_double),
]
airMyQNaNHiBit = (c_int).in_dll(libteem, 'airMyQNaNHiBit')
airFPPartsToVal_f = libteem.airFPPartsToVal_f
airFPPartsToVal_f.restype = c_float
airFPPartsToVal_f.argtypes = [c_uint, c_uint, c_uint]
airFPValToParts_f = libteem.airFPValToParts_f
airFPValToParts_f.restype = None
airFPValToParts_f.argtypes = [POINTER(c_uint), POINTER(c_uint), POINTER(c_uint), c_float]
airFPPartsToVal_d = libteem.airFPPartsToVal_d
airFPPartsToVal_d.restype = c_double
airFPPartsToVal_d.argtypes = [c_uint, c_uint, c_uint, c_uint]
airFPValToParts_d = libteem.airFPValToParts_d
airFPValToParts_d.restype = None
airFPValToParts_d.argtypes = [POINTER(c_uint), POINTER(c_uint), POINTER(c_uint), POINTER(c_uint), c_double]
airFPGen_f = libteem.airFPGen_f
airFPGen_f.restype = c_float
airFPGen_f.argtypes = [c_int]
airFPGen_d = libteem.airFPGen_d
airFPGen_d.restype = c_double
airFPGen_d.argtypes = [c_int]
airFPClass_f = libteem.airFPClass_f
airFPClass_f.restype = c_int
airFPClass_f.argtypes = [c_float]
airFPClass_d = libteem.airFPClass_d
airFPClass_d.restype = c_int
airFPClass_d.argtypes = [c_double]
airFPFprintf_f = libteem.airFPFprintf_f
airFPFprintf_f.restype = None
airFPFprintf_f.argtypes = [POINTER(FILE), c_float]
airFPFprintf_d = libteem.airFPFprintf_d
airFPFprintf_d.restype = None
airFPFprintf_d.argtypes = [POINTER(FILE), c_double]
airFloatQNaN = (airFloat).in_dll(libteem, 'airFloatQNaN')
airFloatSNaN = (airFloat).in_dll(libteem, 'airFloatSNaN')
airFloatPosInf = (airFloat).in_dll(libteem, 'airFloatPosInf')
airFloatNegInf = (airFloat).in_dll(libteem, 'airFloatNegInf')
airNaN = libteem.airNaN
airNaN.restype = c_float
airNaN.argtypes = []
airIsNaN = libteem.airIsNaN
airIsNaN.restype = c_int
airIsNaN.argtypes = [c_double]
airIsInf_f = libteem.airIsInf_f
airIsInf_f.restype = c_int
airIsInf_f.argtypes = [c_float]
airIsInf_d = libteem.airIsInf_d
airIsInf_d.restype = c_int
airIsInf_d.argtypes = [c_double]
airExists = libteem.airExists
airExists.restype = c_int
airExists.argtypes = [c_double]
class airRandMTState(Structure):
    pass
airRandMTState._fields_ = [
    ('state', c_uint * 624),
    ('pNext', POINTER(c_uint)),
    ('left', c_uint),
]
airRandMTStateGlobal = (POINTER(airRandMTState)).in_dll(libteem, 'airRandMTStateGlobal')
airRandMTStateGlobalInit = libteem.airRandMTStateGlobalInit
airRandMTStateGlobalInit.restype = None
airRandMTStateGlobalInit.argtypes = []
airRandMTStateNew = libteem.airRandMTStateNew
airRandMTStateNew.restype = POINTER(airRandMTState)
airRandMTStateNew.argtypes = [c_uint]
airRandMTStateNix = libteem.airRandMTStateNix
airRandMTStateNix.restype = POINTER(airRandMTState)
airRandMTStateNix.argtypes = [POINTER(airRandMTState)]
airSrandMT_r = libteem.airSrandMT_r
airSrandMT_r.restype = None
airSrandMT_r.argtypes = [POINTER(airRandMTState), c_uint]
airDrandMT_r = libteem.airDrandMT_r
airDrandMT_r.restype = c_double
airDrandMT_r.argtypes = [POINTER(airRandMTState)]
airUIrandMT_r = libteem.airUIrandMT_r
airUIrandMT_r.restype = c_uint
airUIrandMT_r.argtypes = [POINTER(airRandMTState)]
airDrandMT53_r = libteem.airDrandMT53_r
airDrandMT53_r.restype = c_double
airDrandMT53_r.argtypes = [POINTER(airRandMTState)]
airRandInt = libteem.airRandInt
airRandInt.restype = c_uint
airRandInt.argtypes = [c_uint]
airRandInt_r = libteem.airRandInt_r
airRandInt_r.restype = c_uint
airRandInt_r.argtypes = [POINTER(airRandMTState), c_uint]
airSrandMT = libteem.airSrandMT
airSrandMT.restype = None
airSrandMT.argtypes = [c_uint]
airDrandMT = libteem.airDrandMT
airDrandMT.restype = c_double
airDrandMT.argtypes = []
airRandMTSanity = libteem.airRandMTSanity
airRandMTSanity.restype = c_int
airRandMTSanity.argtypes = []
airAtod = libteem.airAtod
airAtod.restype = c_double
airAtod.argtypes = [STRING]
airSingleSscanf = libteem.airSingleSscanf
airSingleSscanf.restype = c_int
airSingleSscanf.argtypes = [STRING, STRING, c_void_p]
airBool = (POINTER(airEnum)).in_dll(libteem, 'airBool')
airParseStrB = libteem.airParseStrB
airParseStrB.restype = c_uint
airParseStrB.argtypes = [POINTER(c_int), STRING, STRING, c_uint]
airParseStrI = libteem.airParseStrI
airParseStrI.restype = c_uint
airParseStrI.argtypes = [POINTER(c_int), STRING, STRING, c_uint]
airParseStrUI = libteem.airParseStrUI
airParseStrUI.restype = c_uint
airParseStrUI.argtypes = [POINTER(c_uint), STRING, STRING, c_uint]
airParseStrZ = libteem.airParseStrZ
airParseStrZ.restype = c_uint
airParseStrZ.argtypes = [POINTER(c_size_t), STRING, STRING, c_uint]
airParseStrF = libteem.airParseStrF
airParseStrF.restype = c_uint
airParseStrF.argtypes = [POINTER(c_float), STRING, STRING, c_uint]
airParseStrD = libteem.airParseStrD
airParseStrD.restype = c_uint
airParseStrD.argtypes = [POINTER(c_double), STRING, STRING, c_uint]
airParseStrC = libteem.airParseStrC
airParseStrC.restype = c_uint
airParseStrC.argtypes = [STRING, STRING, STRING, c_uint]
airParseStrS = libteem.airParseStrS
airParseStrS.restype = c_uint
airParseStrS.argtypes = [POINTER(STRING), STRING, STRING, c_uint]
airParseStrE = libteem.airParseStrE
airParseStrE.restype = c_uint
airParseStrE.argtypes = [POINTER(c_int), STRING, STRING, c_uint]
airParseStr = (CFUNCTYPE(c_uint, c_void_p, STRING, STRING, c_uint) * 13).in_dll(libteem, 'airParseStr')
airStrdup = libteem.airStrdup
airStrdup.restype = STRING
airStrdup.argtypes = [STRING]
airStrlen = libteem.airStrlen
airStrlen.restype = c_size_t
airStrlen.argtypes = [STRING]
airStrcmp = libteem.airStrcmp
airStrcmp.restype = c_int
airStrcmp.argtypes = [STRING, STRING]
airStrtokQuoting = (c_int).in_dll(libteem, 'airStrtokQuoting')
airStrtok = libteem.airStrtok
airStrtok.restype = STRING
airStrtok.argtypes = [STRING, STRING, POINTER(STRING)]
airStrntok = libteem.airStrntok
airStrntok.restype = c_uint
airStrntok.argtypes = [STRING, STRING]
airStrtrans = libteem.airStrtrans
airStrtrans.restype = STRING
airStrtrans.argtypes = [STRING, c_char, c_char]
airStrcpy = libteem.airStrcpy
airStrcpy.restype = STRING
airStrcpy.argtypes = [STRING, c_size_t, STRING]
airEndsWith = libteem.airEndsWith
airEndsWith.restype = c_int
airEndsWith.argtypes = [STRING, STRING]
airUnescape = libteem.airUnescape
airUnescape.restype = STRING
airUnescape.argtypes = [STRING]
airOneLinify = libteem.airOneLinify
airOneLinify.restype = STRING
airOneLinify.argtypes = [STRING]
airToLower = libteem.airToLower
airToLower.restype = STRING
airToLower.argtypes = [STRING]
airToUpper = libteem.airToUpper
airToUpper.restype = STRING
airToUpper.argtypes = [STRING]
airOneLine = libteem.airOneLine
airOneLine.restype = c_uint
airOneLine.argtypes = [POINTER(FILE), STRING, c_uint]
airInsaneErr = libteem.airInsaneErr
airInsaneErr.restype = STRING
airInsaneErr.argtypes = [c_int]
airSanity = libteem.airSanity
airSanity.restype = c_int
airSanity.argtypes = []
airTeemVersion = (STRING).in_dll(libteem, 'airTeemVersion')
airTeemReleaseDate = (STRING).in_dll(libteem, 'airTeemReleaseDate')
airNull = libteem.airNull
airNull.restype = c_void_p
airNull.argtypes = []
airSetNull = libteem.airSetNull
airSetNull.restype = c_void_p
airSetNull.argtypes = [POINTER(c_void_p)]
airFree = libteem.airFree
airFree.restype = c_void_p
airFree.argtypes = [c_void_p]
airFopen = libteem.airFopen
airFopen.restype = POINTER(FILE)
airFopen.argtypes = [STRING, POINTER(FILE), STRING]
airFclose = libteem.airFclose
airFclose.restype = POINTER(FILE)
airFclose.argtypes = [POINTER(FILE)]
airSinglePrintf = libteem.airSinglePrintf
airSinglePrintf.restype = c_int
airSinglePrintf.argtypes = [POINTER(FILE), STRING, STRING]
airSprintSize_t = libteem.airSprintSize_t
airSprintSize_t.restype = STRING
airSprintSize_t.argtypes = [STRING, c_size_t]
airSprintVecSize_t = libteem.airSprintVecSize_t
airSprintVecSize_t.restype = STRING
airSprintVecSize_t.argtypes = [STRING, POINTER(c_size_t), c_uint]
airPrettySprintSize_t = libteem.airPrettySprintSize_t
airPrettySprintSize_t.restype = STRING
airPrettySprintSize_t.argtypes = [STRING, c_size_t]
airSprintPtrdiff_t = libteem.airSprintPtrdiff_t
airSprintPtrdiff_t.restype = STRING
airSprintPtrdiff_t.argtypes = [STRING, ptrdiff_t]
airPresent = (c_int).in_dll(libteem, 'airPresent')
airStderr = libteem.airStderr
airStderr.restype = POINTER(FILE)
airStderr.argtypes = []
airStdout = libteem.airStdout
airStdout.restype = POINTER(FILE)
airStdout.argtypes = []
airStdin = libteem.airStdin
airStdin.restype = POINTER(FILE)
airStdin.argtypes = []
airIndex = libteem.airIndex
airIndex.restype = c_uint
airIndex.argtypes = [c_double, c_double, c_double, c_uint]
airIndexClamp = libteem.airIndexClamp
airIndexClamp.restype = c_uint
airIndexClamp.argtypes = [c_double, c_double, c_double, c_uint]
airIndexULL = libteem.airIndexULL
airIndexULL.restype = airULLong
airIndexULL.argtypes = [c_double, c_double, c_double, airULLong]
airIndexClampULL = libteem.airIndexClampULL
airIndexClampULL.restype = airULLong
airIndexClampULL.argtypes = [c_double, c_double, c_double, airULLong]
airDoneStr = libteem.airDoneStr
airDoneStr.restype = STRING
airDoneStr.argtypes = [c_double, c_double, c_double, STRING]
airTime = libteem.airTime
airTime.restype = c_double
airTime.argtypes = []
airTypeStr = (c_char * 129 * 13).in_dll(libteem, 'airTypeStr')
airTypeSize = (c_size_t * 13).in_dll(libteem, 'airTypeSize')
airEqvAdd = libteem.airEqvAdd
airEqvAdd.restype = None
airEqvAdd.argtypes = [POINTER(airArray), c_uint, c_uint]
airEqvMap = libteem.airEqvMap
airEqvMap.restype = c_uint
airEqvMap.argtypes = [POINTER(airArray), POINTER(c_uint), c_uint]
airEqvSettle = libteem.airEqvSettle
airEqvSettle.restype = c_uint
airEqvSettle.argtypes = [POINTER(c_uint), c_uint]
airFastExp = libteem.airFastExp
airFastExp.restype = c_double
airFastExp.argtypes = [c_double]
airExp = libteem.airExp
airExp.restype = c_double
airExp.argtypes = [c_double]
airNormalRand = libteem.airNormalRand
airNormalRand.restype = None
airNormalRand.argtypes = [POINTER(c_double), POINTER(c_double)]
airNormalRand_r = libteem.airNormalRand_r
airNormalRand_r.restype = None
airNormalRand_r.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(airRandMTState)]
airShuffle = libteem.airShuffle
airShuffle.restype = None
airShuffle.argtypes = [POINTER(c_uint), c_uint, c_int]
airShuffle_r = libteem.airShuffle_r
airShuffle_r.restype = None
airShuffle_r.argtypes = [POINTER(airRandMTState), POINTER(c_uint), c_uint, c_int]
airCbrt = libteem.airCbrt
airCbrt.restype = c_double
airCbrt.argtypes = [c_double]
airMode3 = libteem.airMode3
airMode3.restype = c_double
airMode3.argtypes = [c_double, c_double, c_double]
airMode3_d = libteem.airMode3_d
airMode3_d.restype = c_double
airMode3_d.argtypes = [POINTER(c_double)]
airSgnPow = libteem.airSgnPow
airSgnPow.restype = c_double
airSgnPow.argtypes = [c_double, c_double]
airFlippedSgnPow = libteem.airFlippedSgnPow
airFlippedSgnPow.restype = c_double
airFlippedSgnPow.argtypes = [c_double, c_double]
airIntPow = libteem.airIntPow
airIntPow.restype = c_double
airIntPow.argtypes = [c_double, c_int]
airSgn = libteem.airSgn
airSgn.restype = c_int
airSgn.argtypes = [c_double]
airLog2 = libteem.airLog2
airLog2.restype = c_int
airLog2.argtypes = [c_size_t]
airErfc = libteem.airErfc
airErfc.restype = c_double
airErfc.argtypes = [c_double]
airErf = libteem.airErf
airErf.restype = c_double
airErf.argtypes = [c_double]
airGaussian = libteem.airGaussian
airGaussian.restype = c_double
airGaussian.argtypes = [c_double, c_double, c_double]
airBesselI0 = libteem.airBesselI0
airBesselI0.restype = c_double
airBesselI0.argtypes = [c_double]
airBesselI1 = libteem.airBesselI1
airBesselI1.restype = c_double
airBesselI1.argtypes = [c_double]
airBesselI0ExpScaled = libteem.airBesselI0ExpScaled
airBesselI0ExpScaled.restype = c_double
airBesselI0ExpScaled.argtypes = [c_double]
airBesselI1ExpScaled = libteem.airBesselI1ExpScaled
airBesselI1ExpScaled.restype = c_double
airBesselI1ExpScaled.argtypes = [c_double]
airLogBesselI0 = libteem.airLogBesselI0
airLogBesselI0.restype = c_double
airLogBesselI0.argtypes = [c_double]
airLogRician = libteem.airLogRician
airLogRician.restype = c_double
airLogRician.argtypes = [c_double, c_double, c_double]
airRician = libteem.airRician
airRician.restype = c_double
airRician.argtypes = [c_double, c_double, c_double]
airBesselI1By0 = libteem.airBesselI1By0
airBesselI1By0.restype = c_double
airBesselI1By0.argtypes = [c_double]
airBesselIn = libteem.airBesselIn
airBesselIn.restype = c_double
airBesselIn.argtypes = [c_int, c_double]
airBesselInExpScaled = libteem.airBesselInExpScaled
airBesselInExpScaled.restype = c_double
airBesselInExpScaled.argtypes = [c_int, c_double]
airVanDerCorput = libteem.airVanDerCorput
airVanDerCorput.restype = c_double
airVanDerCorput.argtypes = [c_uint, c_uint]
airHalton = libteem.airHalton
airHalton.restype = None
airHalton.argtypes = [POINTER(c_double), c_uint, POINTER(c_uint), c_uint]
airPrimeList = (c_uint * 1000).in_dll(libteem, 'airPrimeList')
airCRC32 = libteem.airCRC32
airCRC32.restype = c_uint
airCRC32.argtypes = [POINTER(c_ubyte), c_size_t, c_size_t, c_int]
airNoDioErr = libteem.airNoDioErr
airNoDioErr.restype = STRING
airNoDioErr.argtypes = [c_int]
airMyDio = (c_int).in_dll(libteem, 'airMyDio')
airDisableDio = (c_int).in_dll(libteem, 'airDisableDio')
airDioInfo = libteem.airDioInfo
airDioInfo.restype = None
airDioInfo.argtypes = [POINTER(c_int), POINTER(c_int), POINTER(c_int), c_int]
airDioTest = libteem.airDioTest
airDioTest.restype = c_int
airDioTest.argtypes = [c_int, c_void_p, c_size_t]
airDioMalloc = libteem.airDioMalloc
airDioMalloc.restype = c_void_p
airDioMalloc.argtypes = [c_size_t, c_int]
airDioRead = libteem.airDioRead
airDioRead.restype = c_size_t
airDioRead.argtypes = [c_int, c_void_p, c_size_t]
airDioWrite = libteem.airDioWrite
airDioWrite.restype = c_size_t
airDioWrite.argtypes = [c_int, c_void_p, c_size_t]
airMopper = CFUNCTYPE(c_void_p, c_void_p)
class airMop(Structure):
    pass
airMop._fields_ = [
    ('ptr', c_void_p),
    ('mop', airMopper),
    ('when', c_int),
]
airMopNew = libteem.airMopNew
airMopNew.restype = POINTER(airArray)
airMopNew.argtypes = []
airMopAdd = libteem.airMopAdd
airMopAdd.restype = c_int
airMopAdd.argtypes = [POINTER(airArray), c_void_p, airMopper, c_int]
airMopSub = libteem.airMopSub
airMopSub.restype = None
airMopSub.argtypes = [POINTER(airArray), c_void_p, airMopper]
airMopMem = libteem.airMopMem
airMopMem.restype = None
airMopMem.argtypes = [POINTER(airArray), c_void_p, c_int]
airMopUnMem = libteem.airMopUnMem
airMopUnMem.restype = None
airMopUnMem.argtypes = [POINTER(airArray), c_void_p]
airMopPrint = libteem.airMopPrint
airMopPrint.restype = None
airMopPrint.argtypes = [POINTER(airArray), c_void_p, c_int]
airMopDone = libteem.airMopDone
airMopDone.restype = None
airMopDone.argtypes = [POINTER(airArray), c_int]
airMopError = libteem.airMopError
airMopError.restype = None
airMopError.argtypes = [POINTER(airArray)]
airMopOkay = libteem.airMopOkay
airMopOkay.restype = None
airMopOkay.argtypes = [POINTER(airArray)]
airMopDebug = libteem.airMopDebug
airMopDebug.restype = None
airMopDebug.argtypes = [POINTER(airArray)]
airMopSingleDone = libteem.airMopSingleDone
airMopSingleDone.restype = None
airMopSingleDone.argtypes = [POINTER(airArray), c_void_p, c_int]
airMopSingleError = libteem.airMopSingleError
airMopSingleError.restype = None
airMopSingleError.argtypes = [POINTER(airArray), c_void_p]
airMopSingleOkay = libteem.airMopSingleOkay
airMopSingleOkay.restype = None
airMopSingleOkay.argtypes = [POINTER(airArray), c_void_p]
alan_t = c_float
class alanContext_t(Structure):
    pass
class Nrrd(Structure):
    pass
alanContext_t._fields_ = [
    ('dim', c_uint),
    ('size', c_uint * 3),
    ('verbose', c_int),
    ('wrap', c_int),
    ('textureType', c_int),
    ('oversample', c_int),
    ('homogAniso', c_int),
    ('numThreads', c_int),
    ('frameInterval', c_int),
    ('saveInterval', c_int),
    ('maxIteration', c_int),
    ('constFilename', c_int),
    ('K', alan_t),
    ('F', alan_t),
    ('deltaX', alan_t),
    ('minAverageChange', alan_t),
    ('maxPixelChange', alan_t),
    ('alpha', alan_t),
    ('beta', alan_t),
    ('react', alan_t),
    ('deltaT', alan_t),
    ('initA', alan_t),
    ('initB', alan_t),
    ('diffA', alan_t),
    ('diffB', alan_t),
    ('randRange', alan_t),
    ('nten', POINTER(Nrrd)),
    ('perIteration', CFUNCTYPE(c_int, POINTER(alanContext_t), c_int)),
    ('iter', c_int),
    ('_nlev', POINTER(Nrrd) * 2),
    ('nlev', POINTER(Nrrd)),
    ('nparm', POINTER(Nrrd)),
    ('averageChange', alan_t),
    ('changeCount', c_int),
    ('changeMutex', POINTER(airThreadMutex)),
    ('iterBarrier', POINTER(airThreadBarrier)),
    ('stop', c_int),
]
alanContext = alanContext_t
alanPresent = (c_int).in_dll(libteem, 'alanPresent')
alanBiffKey = (STRING).in_dll(libteem, 'alanBiffKey')
alanContextNew = libteem.alanContextNew
alanContextNew.restype = POINTER(alanContext)
alanContextNew.argtypes = []
alanContextNix = libteem.alanContextNix
alanContextNix.restype = POINTER(alanContext)
alanContextNix.argtypes = [POINTER(alanContext)]
alanDimensionSet = libteem.alanDimensionSet
alanDimensionSet.restype = c_int
alanDimensionSet.argtypes = [POINTER(alanContext), c_int]
alan2DSizeSet = libteem.alan2DSizeSet
alan2DSizeSet.restype = c_int
alan2DSizeSet.argtypes = [POINTER(alanContext), c_int, c_int]
alan3DSizeSet = libteem.alan3DSizeSet
alan3DSizeSet.restype = c_int
alan3DSizeSet.argtypes = [POINTER(alanContext), c_int, c_int, c_int]
alanTensorSet = libteem.alanTensorSet
alanTensorSet.restype = c_int
alanTensorSet.argtypes = [POINTER(alanContext), POINTER(Nrrd), c_int]
alanParmSet = libteem.alanParmSet
alanParmSet.restype = c_int
alanParmSet.argtypes = [POINTER(alanContext), c_int, c_double]
alanStop = (POINTER(airEnum)).in_dll(libteem, 'alanStop')
alanUpdate = libteem.alanUpdate
alanUpdate.restype = c_int
alanUpdate.argtypes = [POINTER(alanContext)]
class NrrdAxisInfo(Structure):
    pass
NrrdAxisInfo._pack_ = 4
NrrdAxisInfo._fields_ = [
    ('size', c_size_t),
    ('spacing', c_double),
    ('thickness', c_double),
    ('min', c_double),
    ('max', c_double),
    ('spaceDirection', c_double * 8),
    ('center', c_int),
    ('kind', c_int),
    ('label', STRING),
    ('units', STRING),
]
Nrrd._pack_ = 4
Nrrd._fields_ = [
    ('data', c_void_p),
    ('type', c_int),
    ('dim', c_uint),
    ('axis', NrrdAxisInfo * 16),
    ('content', STRING),
    ('sampleUnits', STRING),
    ('space', c_int),
    ('spaceDim', c_uint),
    ('spaceUnits', STRING * 8),
    ('spaceOrigin', c_double * 8),
    ('measurementFrame', c_double * 8 * 8),
    ('blockSize', c_size_t),
    ('oldMin', c_double),
    ('oldMax', c_double),
    ('ptr', c_void_p),
    ('cmt', POINTER(STRING)),
    ('cmtArr', POINTER(airArray)),
    ('kvp', POINTER(STRING)),
    ('kvpArr', POINTER(airArray)),
]
alanInit = libteem.alanInit
alanInit.restype = c_int
alanInit.argtypes = [POINTER(alanContext), POINTER(Nrrd), POINTER(Nrrd)]
alanRun = libteem.alanRun
alanRun.restype = c_int
alanRun.argtypes = [POINTER(alanContext)]
class baneRange(Structure):
    pass
baneRange._pack_ = 4
baneRange._fields_ = [
    ('name', c_char * 129),
    ('type', c_int),
    ('center', c_double),
    ('answer', CFUNCTYPE(c_int, POINTER(c_double), POINTER(c_double), c_double, c_double)),
]
class baneInc_t(Structure):
    pass
baneInc_t._pack_ = 4
baneInc_t._fields_ = [
    ('name', c_char * 129),
    ('type', c_int),
    ('S', c_double),
    ('SS', c_double),
    ('num', c_int),
    ('nhist', POINTER(Nrrd)),
    ('range', POINTER(baneRange)),
    ('parm', c_double * 5),
    ('process', CFUNCTYPE(None, POINTER(baneInc_t), c_double) * 2),
    ('answer', CFUNCTYPE(c_int, POINTER(c_double), POINTER(c_double), POINTER(Nrrd), POINTER(c_double), POINTER(baneRange))),
]
baneInc = baneInc_t
class baneClip(Structure):
    pass
baneClip._pack_ = 4
baneClip._fields_ = [
    ('name', c_char * 129),
    ('type', c_int),
    ('parm', c_double * 5),
    ('answer', CFUNCTYPE(c_int, POINTER(c_int), POINTER(Nrrd), POINTER(c_double))),
]
class baneMeasr_t(Structure):
    pass
gageQuery = c_ubyte * 32
baneMeasr_t._pack_ = 4
baneMeasr_t._fields_ = [
    ('name', c_char * 129),
    ('type', c_int),
    ('parm', c_double * 5),
    ('query', gageQuery),
    ('range', POINTER(baneRange)),
    ('offset0', c_int),
    ('answer', CFUNCTYPE(c_double, POINTER(baneMeasr_t), POINTER(c_double), POINTER(c_double))),
]
baneMeasr = baneMeasr_t
class baneAxis(Structure):
    pass
baneAxis._fields_ = [
    ('res', c_uint),
    ('measr', POINTER(baneMeasr)),
    ('inc', POINTER(baneInc)),
]
class baneHVolParm(Structure):
    pass
class NrrdKernel(Structure):
    pass
NrrdKernel._fields_ = [
    ('name', c_char * 129),
    ('numParm', c_uint),
    ('support', CFUNCTYPE(c_double, POINTER(c_double))),
    ('integral', CFUNCTYPE(c_double, POINTER(c_double))),
    ('eval1_f', CFUNCTYPE(c_float, c_float, POINTER(c_double))),
    ('evalN_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), c_size_t, POINTER(c_double))),
    ('eval1_d', CFUNCTYPE(c_double, c_double, POINTER(c_double))),
    ('evalN_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), c_size_t, POINTER(c_double))),
]
baneHVolParm._pack_ = 4
baneHVolParm._fields_ = [
    ('verbose', c_int),
    ('makeMeasrVol', c_int),
    ('renormalize', c_int),
    ('k3pack', c_int),
    ('k', POINTER(NrrdKernel) * 8),
    ('kparm', c_double * 8 * 8),
    ('clip', POINTER(baneClip)),
    ('incLimit', c_double),
    ('axis', baneAxis * 3),
    ('measrVol', POINTER(Nrrd)),
    ('measrVolDone', c_int),
]
baneBiffKey = (STRING).in_dll(libteem, 'baneBiffKey')
baneDefVerbose = (c_int).in_dll(libteem, 'baneDefVerbose')
baneDefMakeMeasrVol = (c_int).in_dll(libteem, 'baneDefMakeMeasrVol')
baneDefIncLimit = (c_double).in_dll(libteem, 'baneDefIncLimit')
baneDefRenormalize = (c_int).in_dll(libteem, 'baneDefRenormalize')
baneDefPercHistBins = (c_int).in_dll(libteem, 'baneDefPercHistBins')
baneStateHistEqBins = (c_int).in_dll(libteem, 'baneStateHistEqBins')
baneStateHistEqSmart = (c_int).in_dll(libteem, 'baneStateHistEqSmart')
baneHack = (c_int).in_dll(libteem, 'baneHack')
baneRangeNew = libteem.baneRangeNew
baneRangeNew.restype = POINTER(baneRange)
baneRangeNew.argtypes = [c_int]
baneRangeCopy = libteem.baneRangeCopy
baneRangeCopy.restype = POINTER(baneRange)
baneRangeCopy.argtypes = [POINTER(baneRange)]
baneRangeAnswer = libteem.baneRangeAnswer
baneRangeAnswer.restype = c_int
baneRangeAnswer.argtypes = [POINTER(baneRange), POINTER(c_double), POINTER(c_double), c_double, c_double]
baneRangeNix = libteem.baneRangeNix
baneRangeNix.restype = POINTER(baneRange)
baneRangeNix.argtypes = [POINTER(baneRange)]
baneIncNew = libteem.baneIncNew
baneIncNew.restype = POINTER(baneInc)
baneIncNew.argtypes = [c_int, POINTER(baneRange), POINTER(c_double)]
baneIncProcess = libteem.baneIncProcess
baneIncProcess.restype = None
baneIncProcess.argtypes = [POINTER(baneInc), c_int, c_double]
baneIncAnswer = libteem.baneIncAnswer
baneIncAnswer.restype = c_int
baneIncAnswer.argtypes = [POINTER(baneInc), POINTER(c_double), POINTER(c_double)]
baneIncCopy = libteem.baneIncCopy
baneIncCopy.restype = POINTER(baneInc)
baneIncCopy.argtypes = [POINTER(baneInc)]
baneIncNix = libteem.baneIncNix
baneIncNix.restype = POINTER(baneInc)
baneIncNix.argtypes = [POINTER(baneInc)]
baneClipNew = libteem.baneClipNew
baneClipNew.restype = POINTER(baneClip)
baneClipNew.argtypes = [c_int, POINTER(c_double)]
baneClipAnswer = libteem.baneClipAnswer
baneClipAnswer.restype = c_int
baneClipAnswer.argtypes = [POINTER(c_int), POINTER(baneClip), POINTER(Nrrd)]
baneClipCopy = libteem.baneClipCopy
baneClipCopy.restype = POINTER(baneClip)
baneClipCopy.argtypes = [POINTER(baneClip)]
baneClipNix = libteem.baneClipNix
baneClipNix.restype = POINTER(baneClip)
baneClipNix.argtypes = [POINTER(baneClip)]
baneMeasrNew = libteem.baneMeasrNew
baneMeasrNew.restype = POINTER(baneMeasr)
baneMeasrNew.argtypes = [c_int, POINTER(c_double)]
class gageContext_t(Structure):
    pass
gageContext = gageContext_t
baneMeasrAnswer = libteem.baneMeasrAnswer
baneMeasrAnswer.restype = c_double
baneMeasrAnswer.argtypes = [POINTER(baneMeasr), POINTER(gageContext)]
baneMeasrCopy = libteem.baneMeasrCopy
baneMeasrCopy.restype = POINTER(baneMeasr)
baneMeasrCopy.argtypes = [POINTER(baneMeasr)]
baneMeasrNix = libteem.baneMeasrNix
baneMeasrNix.restype = POINTER(baneMeasr)
baneMeasrNix.argtypes = [POINTER(baneMeasr)]
banePresent = (c_int).in_dll(libteem, 'banePresent')
baneHVolParmNew = libteem.baneHVolParmNew
baneHVolParmNew.restype = POINTER(baneHVolParm)
baneHVolParmNew.argtypes = []
baneHVolParmGKMSInit = libteem.baneHVolParmGKMSInit
baneHVolParmGKMSInit.restype = None
baneHVolParmGKMSInit.argtypes = [POINTER(baneHVolParm)]
baneHVolParmAxisSet = libteem.baneHVolParmAxisSet
baneHVolParmAxisSet.restype = None
baneHVolParmAxisSet.argtypes = [POINTER(baneHVolParm), c_uint, c_uint, POINTER(baneMeasr), POINTER(baneInc)]
baneHVolParmClipSet = libteem.baneHVolParmClipSet
baneHVolParmClipSet.restype = None
baneHVolParmClipSet.argtypes = [POINTER(baneHVolParm), POINTER(baneClip)]
baneHVolParmNix = libteem.baneHVolParmNix
baneHVolParmNix.restype = POINTER(baneHVolParm)
baneHVolParmNix.argtypes = [POINTER(baneHVolParm)]
baneInputCheck = libteem.baneInputCheck
baneInputCheck.restype = c_int
baneInputCheck.argtypes = [POINTER(Nrrd), POINTER(baneHVolParm)]
baneHVolCheck = libteem.baneHVolCheck
baneHVolCheck.restype = c_int
baneHVolCheck.argtypes = [POINTER(Nrrd)]
baneInfoCheck = libteem.baneInfoCheck
baneInfoCheck.restype = c_int
baneInfoCheck.argtypes = [POINTER(Nrrd), c_int]
banePosCheck = libteem.banePosCheck
banePosCheck.restype = c_int
banePosCheck.argtypes = [POINTER(Nrrd), c_int]
baneBcptsCheck = libteem.baneBcptsCheck
baneBcptsCheck.restype = c_int
baneBcptsCheck.argtypes = [POINTER(Nrrd)]
baneProbe = libteem.baneProbe
baneProbe.restype = None
baneProbe.argtypes = [POINTER(c_double), POINTER(Nrrd), POINTER(baneHVolParm), POINTER(gageContext), c_uint, c_uint, c_uint]
baneFindInclusion = libteem.baneFindInclusion
baneFindInclusion.restype = c_int
baneFindInclusion.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(Nrrd), POINTER(baneHVolParm), POINTER(gageContext)]
baneMakeHVol = libteem.baneMakeHVol
baneMakeHVol.restype = c_int
baneMakeHVol.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(baneHVolParm)]
baneGKMSHVol = libteem.baneGKMSHVol
baneGKMSHVol.restype = POINTER(Nrrd)
baneGKMSHVol.argtypes = [POINTER(Nrrd), c_float, c_float]
baneOpacInfo = libteem.baneOpacInfo
baneOpacInfo.restype = c_int
baneOpacInfo.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_int]
bane1DOpacInfoFrom2D = libteem.bane1DOpacInfoFrom2D
bane1DOpacInfoFrom2D.restype = c_int
bane1DOpacInfoFrom2D.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
baneSigmaCalc = libteem.baneSigmaCalc
baneSigmaCalc.restype = c_int
baneSigmaCalc.argtypes = [POINTER(c_float), POINTER(Nrrd)]
banePosCalc = libteem.banePosCalc
banePosCalc.restype = c_int
banePosCalc.argtypes = [POINTER(Nrrd), c_float, c_float, POINTER(Nrrd)]
baneOpacCalc = libteem.baneOpacCalc
baneOpacCalc.restype = c_int
baneOpacCalc.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
baneRawScatterplots = libteem.baneRawScatterplots
baneRawScatterplots.restype = c_int
baneRawScatterplots.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_int]
class unrrduCmd(Structure):
    pass
class hestParm(Structure):
    pass
unrrduCmd._fields_ = [
    ('name', STRING),
    ('info', STRING),
    ('main', CFUNCTYPE(c_int, c_int, POINTER(STRING), STRING, POINTER(hestParm))),
    ('hidden', c_int),
]
baneGkms_hvolCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_hvolCmd')
baneGkms_infoCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_infoCmd')
baneGkms_opacCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_opacCmd')
baneGkms_miteCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_miteCmd')
baneGkms_pvgCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_pvgCmd')
baneGkms_scatCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_scatCmd')
baneGkms_txfCmd = (unrrduCmd).in_dll(libteem, 'baneGkms_txfCmd')
baneGkmsMeasr = (POINTER(airEnum)).in_dll(libteem, 'baneGkmsMeasr')
baneGkmsCmdList = (POINTER(unrrduCmd) * 0).in_dll(libteem, 'baneGkmsCmdList')
baneGkmsUsage = libteem.baneGkmsUsage
baneGkmsUsage.restype = None
baneGkmsUsage.argtypes = [STRING, POINTER(hestParm)]
class hestCB(Structure):
    pass
baneGkmsHestIncStrategy = (POINTER(hestCB)).in_dll(libteem, 'baneGkmsHestIncStrategy')
baneGkmsHestBEF = (POINTER(hestCB)).in_dll(libteem, 'baneGkmsHestBEF')
baneGkmsHestGthresh = (POINTER(hestCB)).in_dll(libteem, 'baneGkmsHestGthresh')
class biffMsg(Structure):
    pass
biffMsg._fields_ = [
    ('key', STRING),
    ('err', POINTER(STRING)),
    ('errNum', c_uint),
    ('errArr', POINTER(airArray)),
]
biffPresent = (c_int).in_dll(libteem, 'biffPresent')
biffMsgNew = libteem.biffMsgNew
biffMsgNew.restype = POINTER(biffMsg)
biffMsgNew.argtypes = [STRING]
biffMsgNix = libteem.biffMsgNix
biffMsgNix.restype = POINTER(biffMsg)
biffMsgNix.argtypes = [POINTER(biffMsg)]
biffMsgAdd = libteem.biffMsgAdd
biffMsgAdd.restype = None
biffMsgAdd.argtypes = [POINTER(biffMsg), STRING]
biffMsgClear = libteem.biffMsgClear
biffMsgClear.restype = None
biffMsgClear.argtypes = [POINTER(biffMsg)]
biffMsgLineLenMax = libteem.biffMsgLineLenMax
biffMsgLineLenMax.restype = c_uint
biffMsgLineLenMax.argtypes = [POINTER(biffMsg)]
biffMsgMove = libteem.biffMsgMove
biffMsgMove.restype = None
biffMsgMove.argtypes = [POINTER(biffMsg), POINTER(biffMsg), STRING]
biffMsgAddf = libteem.biffMsgAddf
biffMsgAddf.restype = None
biffMsgAddf.argtypes = [POINTER(biffMsg), STRING]
biffMsgMovef = libteem.biffMsgMovef
biffMsgMovef.restype = None
biffMsgMovef.argtypes = [POINTER(biffMsg), POINTER(biffMsg), STRING]
biffMsgErrNum = libteem.biffMsgErrNum
biffMsgErrNum.restype = c_uint
biffMsgErrNum.argtypes = [POINTER(biffMsg)]
biffMsgStrlen = libteem.biffMsgStrlen
biffMsgStrlen.restype = c_uint
biffMsgStrlen.argtypes = [POINTER(biffMsg)]
biffMsgStrSet = libteem.biffMsgStrSet
biffMsgStrSet.restype = None
biffMsgStrSet.argtypes = [STRING, POINTER(biffMsg)]
biffMsgStrAlloc = libteem.biffMsgStrAlloc
biffMsgStrAlloc.restype = STRING
biffMsgStrAlloc.argtypes = [POINTER(biffMsg)]
biffMsgStrGet = libteem.biffMsgStrGet
biffMsgStrGet.restype = STRING
biffMsgStrGet.argtypes = [POINTER(biffMsg)]
biffMsgNoop = (POINTER(biffMsg)).in_dll(libteem, 'biffMsgNoop')
biffAdd = libteem.biffAdd
biffAdd.restype = None
biffAdd.argtypes = [STRING, STRING]
biffAddf = libteem.biffAddf
biffAddf.restype = None
biffAddf.argtypes = [STRING, STRING]
biffMaybeAdd = libteem.biffMaybeAdd
biffMaybeAdd.restype = None
biffMaybeAdd.argtypes = [STRING, STRING, c_int]
biffMaybeAddf = libteem.biffMaybeAddf
biffMaybeAddf.restype = None
biffMaybeAddf.argtypes = [c_int, STRING, STRING]
biffGet = libteem.biffGet
biffGet.restype = STRING
biffGet.argtypes = [STRING]
biffGetStrlen = libteem.biffGetStrlen
biffGetStrlen.restype = c_uint
biffGetStrlen.argtypes = [STRING]
biffSetStr = libteem.biffSetStr
biffSetStr.restype = None
biffSetStr.argtypes = [STRING, STRING]
biffCheck = libteem.biffCheck
biffCheck.restype = c_uint
biffCheck.argtypes = [STRING]
biffMove = libteem.biffMove
biffMove.restype = None
biffMove.argtypes = [STRING, STRING, STRING]
biffMovef = libteem.biffMovef
biffMovef.restype = None
biffMovef.argtypes = [STRING, STRING, STRING]
biffSetStrDone = libteem.biffSetStrDone
biffSetStrDone.restype = None
biffSetStrDone.argtypes = [STRING, STRING]
biffDone = libteem.biffDone
biffDone.restype = None
biffDone.argtypes = [STRING]
biffGetDone = libteem.biffGetDone
biffGetDone.restype = STRING
biffGetDone.argtypes = [STRING]
coil_t = c_float
class coilMethod(Structure):
    pass
coilMethod._fields_ = [
    ('name', c_char * 129),
    ('type', c_int),
    ('numParm', c_int),
]
class coilKind(Structure):
    pass
coilKind._fields_ = [
    ('name', c_char * 129),
    ('valLen', c_uint),
    ('filter', CFUNCTYPE(None, POINTER(coil_t), c_int, c_int, c_int, POINTER(POINTER(coil_t)), POINTER(c_double), POINTER(c_double)) * 9),
    ('update', CFUNCTYPE(None, POINTER(coil_t), POINTER(coil_t))),
]
class coilTask(Structure):
    pass
class coilContext_t(Structure):
    pass
coilTask._fields_ = [
    ('cctx', POINTER(coilContext_t)),
    ('thread', POINTER(airThread)),
    ('threadIdx', c_uint),
    ('_iv3', POINTER(coil_t)),
    ('iv3', POINTER(POINTER(coil_t))),
    ('iv3Fill', CFUNCTYPE(None, POINTER(POINTER(coil_t)), POINTER(coil_t), c_uint, c_int, c_int, c_int, c_int, c_int, c_int, c_int)),
    ('returnPtr', c_void_p),
]
coilContext_t._pack_ = 4
coilContext_t._fields_ = [
    ('nin', POINTER(Nrrd)),
    ('kind', POINTER(coilKind)),
    ('method', POINTER(coilMethod)),
    ('radius', c_uint),
    ('numThreads', c_uint),
    ('verbose', c_int),
    ('parm', c_double * 6),
    ('iter', c_uint),
    ('size', c_size_t * 3),
    ('nextSlice', c_size_t),
    ('spacing', c_double * 3),
    ('nvol', POINTER(Nrrd)),
    ('finished', c_int),
    ('todoFilter', c_int),
    ('todoUpdate', c_int),
    ('nextSliceMutex', POINTER(airThreadMutex)),
    ('task', POINTER(POINTER(coilTask))),
    ('filterBarrier', POINTER(airThreadBarrier)),
    ('updateBarrier', POINTER(airThreadBarrier)),
]
coilContext = coilContext_t
coilPresent = (c_int).in_dll(libteem, 'coilPresent')
coilBiffKey = (STRING).in_dll(libteem, 'coilBiffKey')
coilDefaultRadius = (c_int).in_dll(libteem, 'coilDefaultRadius')
coilVerbose = (c_int).in_dll(libteem, 'coilVerbose')
coilMethodType = (POINTER(airEnum)).in_dll(libteem, 'coilMethodType')
coilKindType = (POINTER(airEnum)).in_dll(libteem, 'coilKindType')
coilKindScalar = (POINTER(coilKind)).in_dll(libteem, 'coilKindScalar')
coilKindArray = (POINTER(coilKind) * 4).in_dll(libteem, 'coilKindArray')
coilKind7Tensor = (POINTER(coilKind)).in_dll(libteem, 'coilKind7Tensor')
coilMethodTesting = (POINTER(coilMethod)).in_dll(libteem, 'coilMethodTesting')
coilMethodArray = (POINTER(coilMethod) * 9).in_dll(libteem, 'coilMethodArray')
coilContextNew = libteem.coilContextNew
coilContextNew.restype = POINTER(coilContext)
coilContextNew.argtypes = []
coilVolumeCheck = libteem.coilVolumeCheck
coilVolumeCheck.restype = c_int
coilVolumeCheck.argtypes = [POINTER(Nrrd), POINTER(coilKind)]
coilContextAllSet = libteem.coilContextAllSet
coilContextAllSet.restype = c_int
coilContextAllSet.argtypes = [POINTER(coilContext), POINTER(Nrrd), POINTER(coilKind), POINTER(coilMethod), c_uint, c_uint, c_int, POINTER(c_double)]
coilOutputGet = libteem.coilOutputGet
coilOutputGet.restype = c_int
coilOutputGet.argtypes = [POINTER(Nrrd), POINTER(coilContext)]
coilContextNix = libteem.coilContextNix
coilContextNix.restype = POINTER(coilContext)
coilContextNix.argtypes = [POINTER(coilContext)]
coilStart = libteem.coilStart
coilStart.restype = c_int
coilStart.argtypes = [POINTER(coilContext)]
coilIterate = libteem.coilIterate
coilIterate.restype = c_int
coilIterate.argtypes = [POINTER(coilContext), c_int]
coilFinish = libteem.coilFinish
coilFinish.restype = c_int
coilFinish.argtypes = [POINTER(coilContext)]
class dyeColor(Structure):
    pass
dyeColor._fields_ = [
    ('val', c_float * 3 * 2),
    ('xWhite', c_float),
    ('yWhite', c_float),
    ('spc', c_byte * 2),
    ('ii', c_byte),
]
dyePresent = (c_int).in_dll(libteem, 'dyePresent')
dyeBiffKey = (STRING).in_dll(libteem, 'dyeBiffKey')
dyeSpaceToStr = (c_char * 129 * 0).in_dll(libteem, 'dyeSpaceToStr')
dyeStrToSpace = libteem.dyeStrToSpace
dyeStrToSpace.restype = c_int
dyeStrToSpace.argtypes = [STRING]
dyeColorInit = libteem.dyeColorInit
dyeColorInit.restype = POINTER(dyeColor)
dyeColorInit.argtypes = [POINTER(dyeColor)]
dyeColorSet = libteem.dyeColorSet
dyeColorSet.restype = POINTER(dyeColor)
dyeColorSet.argtypes = [POINTER(dyeColor), c_int, c_float, c_float, c_float]
dyeColorGet = libteem.dyeColorGet
dyeColorGet.restype = c_int
dyeColorGet.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(dyeColor)]
dyeColorGetAs = libteem.dyeColorGetAs
dyeColorGetAs.restype = c_int
dyeColorGetAs.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(dyeColor), c_int]
dyeColorNew = libteem.dyeColorNew
dyeColorNew.restype = POINTER(dyeColor)
dyeColorNew.argtypes = []
dyeColorCopy = libteem.dyeColorCopy
dyeColorCopy.restype = POINTER(dyeColor)
dyeColorCopy.argtypes = [POINTER(dyeColor), POINTER(dyeColor)]
dyeColorNix = libteem.dyeColorNix
dyeColorNix.restype = POINTER(dyeColor)
dyeColorNix.argtypes = [POINTER(dyeColor)]
dyeColorParse = libteem.dyeColorParse
dyeColorParse.restype = c_int
dyeColorParse.argtypes = [POINTER(dyeColor), STRING]
dyeColorSprintf = libteem.dyeColorSprintf
dyeColorSprintf.restype = STRING
dyeColorSprintf.argtypes = [STRING, POINTER(dyeColor)]
dyeConverter = CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float)
dyeRGBtoHSV = libteem.dyeRGBtoHSV
dyeRGBtoHSV.restype = None
dyeRGBtoHSV.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeHSVtoRGB = libteem.dyeHSVtoRGB
dyeHSVtoRGB.restype = None
dyeHSVtoRGB.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeRGBtoHSL = libteem.dyeRGBtoHSL
dyeRGBtoHSL.restype = None
dyeRGBtoHSL.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeHSLtoRGB = libteem.dyeHSLtoRGB
dyeHSLtoRGB.restype = None
dyeHSLtoRGB.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeRGBtoXYZ = libteem.dyeRGBtoXYZ
dyeRGBtoXYZ.restype = None
dyeRGBtoXYZ.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeXYZtoRGB = libteem.dyeXYZtoRGB
dyeXYZtoRGB.restype = None
dyeXYZtoRGB.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeXYZtoLAB = libteem.dyeXYZtoLAB
dyeXYZtoLAB.restype = None
dyeXYZtoLAB.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeXYZtoLUV = libteem.dyeXYZtoLUV
dyeXYZtoLUV.restype = None
dyeXYZtoLUV.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeLABtoXYZ = libteem.dyeLABtoXYZ
dyeLABtoXYZ.restype = None
dyeLABtoXYZ.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeLUVtoXYZ = libteem.dyeLUVtoXYZ
dyeLUVtoXYZ.restype = None
dyeLUVtoXYZ.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, c_float, c_float]
dyeSimpleConvert = (dyeConverter * 7 * 7).in_dll(libteem, 'dyeSimpleConvert')
dyeConvert = libteem.dyeConvert
dyeConvert.restype = c_int
dyeConvert.argtypes = [POINTER(dyeColor), c_int]
echoPos_t = c_double
echoCol_t = c_float
class echoRTParm(Structure):
    pass
echoRTParm._pack_ = 4
echoRTParm._fields_ = [
    ('jitterType', c_int),
    ('reuseJitter', c_int),
    ('permuteJitter', c_int),
    ('textureNN', c_int),
    ('numSamples', c_int),
    ('imgResU', c_int),
    ('imgResV', c_int),
    ('maxRecDepth', c_int),
    ('renderLights', c_int),
    ('renderBoxes', c_int),
    ('seedRand', c_int),
    ('sqNRI', c_int),
    ('numThreads', c_int),
    ('sqTol', echoPos_t),
    ('shadow', echoCol_t),
    ('glassC', echoCol_t),
    ('aperture', c_float),
    ('timeGamma', c_float),
    ('boxOpac', c_float),
    ('maxRecCol', echoCol_t * 3),
]
class echoGlobalState(Structure):
    pass
class limnCamera_t(Structure):
    pass
limnCamera = limnCamera_t
class echoScene_t(Structure):
    pass
echoGlobalState._pack_ = 4
echoGlobalState._fields_ = [
    ('verbose', c_int),
    ('time', c_double),
    ('nraw', POINTER(Nrrd)),
    ('cam', POINTER(limnCamera)),
    ('scene', POINTER(echoScene_t)),
    ('parm', POINTER(echoRTParm)),
    ('workIdx', c_int),
    ('workMutex', POINTER(airThreadMutex)),
]
class echoThreadState(Structure):
    pass
echoThreadState._fields_ = [
    ('thread', POINTER(airThread)),
    ('gstate', POINTER(echoGlobalState)),
    ('verbose', c_int),
    ('threadIdx', c_int),
    ('depth', c_int),
    ('nperm', POINTER(Nrrd)),
    ('njitt', POINTER(Nrrd)),
    ('permBuff', POINTER(c_uint)),
    ('jitt', POINTER(echoPos_t)),
    ('chanBuff', POINTER(echoCol_t)),
    ('rst', POINTER(airRandMTState)),
    ('returnPtr', c_void_p),
]
class echoObject(Structure):
    pass
echoObject._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
]
class echoSphere(Structure):
    pass
echoSphere._pack_ = 4
echoSphere._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('pos', echoPos_t * 3),
    ('rad', echoPos_t),
]
class echoCylinder(Structure):
    pass
echoCylinder._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('axis', c_int),
]
class echoSuperquad(Structure):
    pass
echoSuperquad._pack_ = 4
echoSuperquad._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('axis', c_int),
    ('A', echoPos_t),
    ('B', echoPos_t),
]
class echoCube(Structure):
    pass
echoCube._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
]
class echoTriangle(Structure):
    pass
echoTriangle._pack_ = 4
echoTriangle._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('vert', echoPos_t * 3 * 3),
]
class echoRectangle(Structure):
    pass
echoRectangle._pack_ = 4
echoRectangle._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('origin', echoPos_t * 3),
    ('edge0', echoPos_t * 3),
    ('edge1', echoPos_t * 3),
]
class echoTriMesh(Structure):
    pass
echoTriMesh._pack_ = 4
echoTriMesh._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('meanvert', echoPos_t * 3),
    ('min', echoPos_t * 3),
    ('max', echoPos_t * 3),
    ('numV', c_int),
    ('numF', c_int),
    ('pos', POINTER(echoPos_t)),
    ('vert', POINTER(c_int)),
]
class echoIsosurface(Structure):
    pass
echoIsosurface._fields_ = [
    ('type', c_byte),
    ('matter', c_ubyte),
    ('rgba', echoCol_t * 4),
    ('mat', echoCol_t * 4),
    ('ntext', POINTER(Nrrd)),
    ('volume', POINTER(Nrrd)),
    ('value', c_float),
]
class echoAABBox(Structure):
    pass
echoAABBox._pack_ = 4
echoAABBox._fields_ = [
    ('type', c_byte),
    ('obj', POINTER(echoObject)),
    ('min', echoPos_t * 3),
    ('max', echoPos_t * 3),
]
class echoSplit(Structure):
    pass
echoSplit._pack_ = 4
echoSplit._fields_ = [
    ('type', c_byte),
    ('axis', c_int),
    ('min0', echoPos_t * 3),
    ('max0', echoPos_t * 3),
    ('min1', echoPos_t * 3),
    ('max1', echoPos_t * 3),
    ('obj0', POINTER(echoObject)),
    ('obj1', POINTER(echoObject)),
]
class echoList(Structure):
    pass
echoList._fields_ = [
    ('type', c_byte),
    ('obj', POINTER(POINTER(echoObject))),
    ('objArr', POINTER(airArray)),
]
class echoInstance(Structure):
    pass
echoInstance._pack_ = 4
echoInstance._fields_ = [
    ('type', c_byte),
    ('Mi', echoPos_t * 16),
    ('M', echoPos_t * 16),
    ('obj', POINTER(echoObject)),
]
echoScene_t._fields_ = [
    ('cat', POINTER(POINTER(echoObject))),
    ('catArr', POINTER(airArray)),
    ('rend', POINTER(POINTER(echoObject))),
    ('rendArr', POINTER(airArray)),
    ('light', POINTER(POINTER(echoObject))),
    ('lightArr', POINTER(airArray)),
    ('nrrd', POINTER(POINTER(Nrrd))),
    ('nrrdArr', POINTER(airArray)),
    ('envmap', POINTER(Nrrd)),
    ('ambi', echoCol_t * 3),
    ('bkgr', echoCol_t * 3),
]
echoScene = echoScene_t
class echoRay(Structure):
    pass
echoRay._pack_ = 4
echoRay._fields_ = [
    ('from', echoPos_t * 3),
    ('dir', echoPos_t * 3),
    ('neer', echoPos_t),
    ('faar', echoPos_t),
    ('shadow', c_int),
    ('transp', echoCol_t),
]
class echoIntx(Structure):
    pass
echoIntx._pack_ = 4
echoIntx._fields_ = [
    ('obj', POINTER(echoObject)),
    ('t', echoPos_t),
    ('u', echoPos_t),
    ('v', echoPos_t),
    ('norm', echoPos_t * 3),
    ('view', echoPos_t * 3),
    ('refl', echoPos_t * 3),
    ('pos', echoPos_t * 3),
    ('face', c_int),
    ('boxhits', c_int),
]
class echoPtrPtrUnion(Union):
    pass
echoPtrPtrUnion._fields_ = [
    ('obj', POINTER(POINTER(POINTER(echoObject)))),
    ('nrd', POINTER(POINTER(POINTER(Nrrd)))),
    ('v', POINTER(c_void_p)),
]
echoJitter = (POINTER(airEnum)).in_dll(libteem, 'echoJitter')
echoType = (POINTER(airEnum)).in_dll(libteem, 'echoType')
echoMatter = (POINTER(airEnum)).in_dll(libteem, 'echoMatter')
echoPresent = (c_int).in_dll(libteem, 'echoPresent')
echoBiffKey = (STRING).in_dll(libteem, 'echoBiffKey')
echoRTParmNew = libteem.echoRTParmNew
echoRTParmNew.restype = POINTER(echoRTParm)
echoRTParmNew.argtypes = []
echoRTParmNix = libteem.echoRTParmNix
echoRTParmNix.restype = POINTER(echoRTParm)
echoRTParmNix.argtypes = [POINTER(echoRTParm)]
echoGlobalStateNew = libteem.echoGlobalStateNew
echoGlobalStateNew.restype = POINTER(echoGlobalState)
echoGlobalStateNew.argtypes = []
echoGlobalStateNix = libteem.echoGlobalStateNix
echoGlobalStateNix.restype = POINTER(echoGlobalState)
echoGlobalStateNix.argtypes = [POINTER(echoGlobalState)]
echoThreadStateNew = libteem.echoThreadStateNew
echoThreadStateNew.restype = POINTER(echoThreadState)
echoThreadStateNew.argtypes = []
echoThreadStateNix = libteem.echoThreadStateNix
echoThreadStateNix.restype = POINTER(echoThreadState)
echoThreadStateNix.argtypes = [POINTER(echoThreadState)]
echoSceneNew = libteem.echoSceneNew
echoSceneNew.restype = POINTER(echoScene)
echoSceneNew.argtypes = []
echoSceneNix = libteem.echoSceneNix
echoSceneNix.restype = POINTER(echoScene)
echoSceneNix.argtypes = [POINTER(echoScene)]
echoObjectNew = libteem.echoObjectNew
echoObjectNew.restype = POINTER(echoObject)
echoObjectNew.argtypes = [POINTER(echoScene), c_byte]
echoObjectAdd = libteem.echoObjectAdd
echoObjectAdd.restype = c_int
echoObjectAdd.argtypes = [POINTER(echoScene), POINTER(echoObject)]
echoObjectNix = libteem.echoObjectNix
echoObjectNix.restype = POINTER(echoObject)
echoObjectNix.argtypes = [POINTER(echoObject)]
echoRoughSphereNew = libteem.echoRoughSphereNew
echoRoughSphereNew.restype = POINTER(echoObject)
echoRoughSphereNew.argtypes = [POINTER(echoScene), c_int, c_int, POINTER(echoPos_t)]
echoBoundsGet = libteem.echoBoundsGet
echoBoundsGet.restype = None
echoBoundsGet.argtypes = [POINTER(echoPos_t), POINTER(echoPos_t), POINTER(echoObject)]
echoListAdd = libteem.echoListAdd
echoListAdd.restype = None
echoListAdd.argtypes = [POINTER(echoObject), POINTER(echoObject)]
echoListSplit = libteem.echoListSplit
echoListSplit.restype = POINTER(echoObject)
echoListSplit.argtypes = [POINTER(echoScene), POINTER(echoObject), c_int]
echoListSplit3 = libteem.echoListSplit3
echoListSplit3.restype = POINTER(echoObject)
echoListSplit3.argtypes = [POINTER(echoScene), POINTER(echoObject), c_int]
echoSphereSet = libteem.echoSphereSet
echoSphereSet.restype = None
echoSphereSet.argtypes = [POINTER(echoObject), echoPos_t, echoPos_t, echoPos_t, echoPos_t]
echoCylinderSet = libteem.echoCylinderSet
echoCylinderSet.restype = None
echoCylinderSet.argtypes = [POINTER(echoObject), c_int]
echoSuperquadSet = libteem.echoSuperquadSet
echoSuperquadSet.restype = None
echoSuperquadSet.argtypes = [POINTER(echoObject), c_int, echoPos_t, echoPos_t]
echoRectangleSet = libteem.echoRectangleSet
echoRectangleSet.restype = None
echoRectangleSet.argtypes = [POINTER(echoObject), echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t]
echoTriangleSet = libteem.echoTriangleSet
echoTriangleSet.restype = None
echoTriangleSet.argtypes = [POINTER(echoObject), echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t, echoPos_t]
echoTriMeshSet = libteem.echoTriMeshSet
echoTriMeshSet.restype = None
echoTriMeshSet.argtypes = [POINTER(echoObject), c_int, POINTER(echoPos_t), c_int, POINTER(c_int)]
echoInstanceSet = libteem.echoInstanceSet
echoInstanceSet.restype = None
echoInstanceSet.argtypes = [POINTER(echoObject), POINTER(echoPos_t), POINTER(echoObject)]
echoObjectHasMatter = (c_int * 12).in_dll(libteem, 'echoObjectHasMatter')
echoColorSet = libteem.echoColorSet
echoColorSet.restype = None
echoColorSet.argtypes = [POINTER(echoObject), echoCol_t, echoCol_t, echoCol_t, echoCol_t]
echoMatterPhongSet = libteem.echoMatterPhongSet
echoMatterPhongSet.restype = None
echoMatterPhongSet.argtypes = [POINTER(echoScene), POINTER(echoObject), echoCol_t, echoCol_t, echoCol_t, echoCol_t]
echoMatterGlassSet = libteem.echoMatterGlassSet
echoMatterGlassSet.restype = None
echoMatterGlassSet.argtypes = [POINTER(echoScene), POINTER(echoObject), echoCol_t, echoCol_t, echoCol_t, echoCol_t]
echoMatterMetalSet = libteem.echoMatterMetalSet
echoMatterMetalSet.restype = None
echoMatterMetalSet.argtypes = [POINTER(echoScene), POINTER(echoObject), echoCol_t, echoCol_t, echoCol_t, echoCol_t]
echoMatterLightSet = libteem.echoMatterLightSet
echoMatterLightSet.restype = None
echoMatterLightSet.argtypes = [POINTER(echoScene), POINTER(echoObject), echoCol_t, echoCol_t]
echoMatterTextureSet = libteem.echoMatterTextureSet
echoMatterTextureSet.restype = None
echoMatterTextureSet.argtypes = [POINTER(echoScene), POINTER(echoObject), POINTER(Nrrd)]
echoLightPosition = libteem.echoLightPosition
echoLightPosition.restype = None
echoLightPosition.argtypes = [POINTER(echoPos_t), POINTER(echoObject), POINTER(echoThreadState)]
echoLightColor = libteem.echoLightColor
echoLightColor.restype = None
echoLightColor.argtypes = [POINTER(echoCol_t), echoPos_t, POINTER(echoObject), POINTER(echoRTParm), POINTER(echoThreadState)]
echoEnvmapLookup = libteem.echoEnvmapLookup
echoEnvmapLookup.restype = None
echoEnvmapLookup.argtypes = [POINTER(echoCol_t), POINTER(echoPos_t), POINTER(Nrrd)]
echoTextureLookup = libteem.echoTextureLookup
echoTextureLookup.restype = None
echoTextureLookup.argtypes = [POINTER(echoCol_t), POINTER(Nrrd), echoPos_t, echoPos_t, POINTER(echoRTParm)]
echoIntxMaterialColor = libteem.echoIntxMaterialColor
echoIntxMaterialColor.restype = None
echoIntxMaterialColor.argtypes = [POINTER(echoCol_t), POINTER(echoIntx), POINTER(echoRTParm)]
echoIntxLightColor = libteem.echoIntxLightColor
echoIntxLightColor.restype = None
echoIntxLightColor.argtypes = [POINTER(echoCol_t), POINTER(echoCol_t), POINTER(echoCol_t), echoCol_t, POINTER(echoIntx), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoThreadState)]
echoIntxFuzzify = libteem.echoIntxFuzzify
echoIntxFuzzify.restype = None
echoIntxFuzzify.argtypes = [POINTER(echoIntx), echoCol_t, POINTER(echoThreadState)]
echoRayIntx = libteem.echoRayIntx
echoRayIntx.restype = c_int
echoRayIntx.argtypes = [POINTER(echoIntx), POINTER(echoRay), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoThreadState)]
echoIntxColor = libteem.echoIntxColor
echoIntxColor.restype = None
echoIntxColor.argtypes = [POINTER(echoCol_t), POINTER(echoIntx), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoThreadState)]
echoThreadStateInit = libteem.echoThreadStateInit
echoThreadStateInit.restype = c_int
echoThreadStateInit.argtypes = [c_int, POINTER(echoThreadState), POINTER(echoRTParm), POINTER(echoGlobalState)]
echoJitterCompute = libteem.echoJitterCompute
echoJitterCompute.restype = None
echoJitterCompute.argtypes = [POINTER(echoRTParm), POINTER(echoThreadState)]
echoRayColor = libteem.echoRayColor
echoRayColor.restype = None
echoRayColor.argtypes = [POINTER(echoCol_t), POINTER(echoRay), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoThreadState)]
echoChannelAverage = libteem.echoChannelAverage
echoChannelAverage.restype = None
echoChannelAverage.argtypes = [POINTER(echoCol_t), POINTER(echoRTParm), POINTER(echoThreadState)]
echoRTRenderCheck = libteem.echoRTRenderCheck
echoRTRenderCheck.restype = c_int
echoRTRenderCheck.argtypes = [POINTER(Nrrd), POINTER(limnCamera), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoGlobalState)]
echoRTRender = libteem.echoRTRender
echoRTRender.restype = c_int
echoRTRender.argtypes = [POINTER(Nrrd), POINTER(limnCamera), POINTER(echoScene), POINTER(echoRTParm), POINTER(echoGlobalState)]
elfPresent = (c_int).in_dll(libteem, 'elfPresent')
class limnPolyData(Structure):
    pass
class tijk_type_t(Structure):
    pass
tijk_type = tijk_type_t
elfGlyphHOME = libteem.elfGlyphHOME
elfGlyphHOME.restype = c_float
elfGlyphHOME.argtypes = [POINTER(limnPolyData), c_char, POINTER(c_float), POINTER(tijk_type), STRING, c_char]
elfGlyphPolar = libteem.elfGlyphPolar
elfGlyphPolar.restype = c_float
elfGlyphPolar.argtypes = [POINTER(limnPolyData), c_char, POINTER(c_float), POINTER(tijk_type), STRING, c_char, c_char, POINTER(c_ubyte), POINTER(c_ubyte)]
elfColorGlyphMaxima = libteem.elfColorGlyphMaxima
elfColorGlyphMaxima.restype = c_int
elfColorGlyphMaxima.argtypes = [POINTER(limnPolyData), c_char, POINTER(c_int), c_uint, POINTER(c_float), POINTER(tijk_type), c_char, c_float]
class elfMaximaContext(Structure):
    pass
class tijk_refine_rank1_parm_t(Structure):
    pass
tijk_refine_rank1_parm = tijk_refine_rank1_parm_t
elfMaximaContext._fields_ = [
    ('num', c_uint),
    ('type', POINTER(tijk_type)),
    ('parm', POINTER(tijk_refine_rank1_parm)),
    ('refine', c_int),
    ('neighbors', POINTER(c_int)),
    ('nbstride', c_uint),
    ('vertices_f', POINTER(c_float)),
    ('vertices_d', POINTER(c_double)),
]
elfMaximaContextNew = libteem.elfMaximaContextNew
elfMaximaContextNew.restype = POINTER(elfMaximaContext)
elfMaximaContextNew.argtypes = [POINTER(tijk_type), c_uint]
elfMaximaContextNix = libteem.elfMaximaContextNix
elfMaximaContextNix.restype = POINTER(elfMaximaContext)
elfMaximaContextNix.argtypes = [POINTER(elfMaximaContext)]
elfMaximaParmSet = libteem.elfMaximaParmSet
elfMaximaParmSet.restype = None
elfMaximaParmSet.argtypes = [POINTER(elfMaximaContext), POINTER(tijk_refine_rank1_parm)]
elfMaximaRefineSet = libteem.elfMaximaRefineSet
elfMaximaRefineSet.restype = None
elfMaximaRefineSet.argtypes = [POINTER(elfMaximaContext), c_int]
elfMaximaFind_d = libteem.elfMaximaFind_d
elfMaximaFind_d.restype = c_int
elfMaximaFind_d.argtypes = [POINTER(POINTER(c_double)), POINTER(POINTER(c_double)), POINTER(c_double), POINTER(elfMaximaContext)]
elfMaximaFind_f = libteem.elfMaximaFind_f
elfMaximaFind_f.restype = c_int
elfMaximaFind_f.argtypes = [POINTER(POINTER(c_float)), POINTER(POINTER(c_float)), POINTER(c_float), POINTER(elfMaximaContext)]
elfCart2Thetaphi_f = libteem.elfCart2Thetaphi_f
elfCart2Thetaphi_f.restype = None
elfCart2Thetaphi_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
elfESHEstimMatrix_f = libteem.elfESHEstimMatrix_f
elfESHEstimMatrix_f.restype = c_int
elfESHEstimMatrix_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint, POINTER(c_float), c_uint, c_float, POINTER(c_float)]
class elfSingleShellDWI(Structure):
    pass
elfSingleShellDWI._fields_ = [
    ('b0', c_float),
    ('b', c_float),
    ('dwis', POINTER(c_float)),
    ('grads', POINTER(c_float)),
    ('dwino', c_uint),
]
elfKernelStick_f = libteem.elfKernelStick_f
elfKernelStick_f.restype = c_int
elfKernelStick_f.argtypes = [POINTER(c_float), c_uint, c_float, c_float, c_int]
elfBallStickODF_f = libteem.elfBallStickODF_f
elfBallStickODF_f.restype = c_int
elfBallStickODF_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(elfSingleShellDWI), POINTER(c_float), c_uint, c_int]
class elfBallStickParms(Structure):
    pass
elfBallStickParms._pack_ = 4
elfBallStickParms._fields_ = [
    ('d', c_float),
    ('fiberct', c_uint),
    ('fs', c_float * 4),
    ('vs', c_float * 9),
    ('stopreason', c_int),
    ('sqrerr', c_double),
    ('itr', c_double),
]
elfBallStickPredict_f = libteem.elfBallStickPredict_f
elfBallStickPredict_f.restype = c_int
elfBallStickPredict_f.argtypes = [POINTER(elfBallStickParms), POINTER(c_float), POINTER(tijk_type), c_uint, c_float, c_float]
elfBallStickOptimize_f = libteem.elfBallStickOptimize_f
elfBallStickOptimize_f.restype = c_int
elfBallStickOptimize_f.argtypes = [POINTER(elfBallStickParms), POINTER(elfSingleShellDWI)]
ellPresent = (c_int).in_dll(libteem, 'ellPresent')
ell_biff_key = (STRING).in_dll(libteem, 'ell_biff_key')
ell_cubic_root = (POINTER(airEnum)).in_dll(libteem, 'ell_cubic_root')
ell_debug = (c_int).in_dll(libteem, 'ell_debug')
ell_3m_print_f = libteem.ell_3m_print_f
ell_3m_print_f.restype = None
ell_3m_print_f.argtypes = [POINTER(FILE), POINTER(c_float)]
ell_3v_print_f = libteem.ell_3v_print_f
ell_3v_print_f.restype = None
ell_3v_print_f.argtypes = [POINTER(FILE), POINTER(c_float)]
ell_3m_print_d = libteem.ell_3m_print_d
ell_3m_print_d.restype = None
ell_3m_print_d.argtypes = [POINTER(FILE), POINTER(c_double)]
ell_3v_print_d = libteem.ell_3v_print_d
ell_3v_print_d.restype = None
ell_3v_print_d.argtypes = [POINTER(FILE), POINTER(c_double)]
ell_4m_print_f = libteem.ell_4m_print_f
ell_4m_print_f.restype = None
ell_4m_print_f.argtypes = [POINTER(FILE), POINTER(c_float)]
ell_4v_print_f = libteem.ell_4v_print_f
ell_4v_print_f.restype = None
ell_4v_print_f.argtypes = [POINTER(FILE), POINTER(c_float)]
ell_4m_print_d = libteem.ell_4m_print_d
ell_4m_print_d.restype = None
ell_4m_print_d.argtypes = [POINTER(FILE), POINTER(c_double)]
ell_4v_print_d = libteem.ell_4v_print_d
ell_4v_print_d.restype = None
ell_4v_print_d.argtypes = [POINTER(FILE), POINTER(c_double)]
ell_4v_norm_f = libteem.ell_4v_norm_f
ell_4v_norm_f.restype = None
ell_4v_norm_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3v_perp_f = libteem.ell_3v_perp_f
ell_3v_perp_f.restype = None
ell_3v_perp_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3v_perp_d = libteem.ell_3v_perp_d
ell_3v_perp_d.restype = None
ell_3v_perp_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_3mv_mul_f = libteem.ell_3mv_mul_f
ell_3mv_mul_f.restype = None
ell_3mv_mul_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_3mv_mul_d = libteem.ell_3mv_mul_d
ell_3mv_mul_d.restype = None
ell_3mv_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_4mv_mul_f = libteem.ell_4mv_mul_f
ell_4mv_mul_f.restype = None
ell_4mv_mul_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_4mv_mul_d = libteem.ell_4mv_mul_d
ell_4mv_mul_d.restype = None
ell_4mv_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3v_angle_f = libteem.ell_3v_angle_f
ell_3v_angle_f.restype = c_float
ell_3v_angle_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3v_angle_d = libteem.ell_3v_angle_d
ell_3v_angle_d.restype = c_double
ell_3v_angle_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_3v_area_spherical_d = libteem.ell_3v_area_spherical_d
ell_3v_area_spherical_d.restype = c_double
ell_3v_area_spherical_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3v_barycentric_spherical_d = libteem.ell_3v_barycentric_spherical_d
ell_3v_barycentric_spherical_d.restype = None
ell_3v_barycentric_spherical_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3m_mul_f = libteem.ell_3m_mul_f
ell_3m_mul_f.restype = None
ell_3m_mul_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_3m_mul_d = libteem.ell_3m_mul_d
ell_3m_mul_d.restype = None
ell_3m_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3m_pre_mul_f = libteem.ell_3m_pre_mul_f
ell_3m_pre_mul_f.restype = None
ell_3m_pre_mul_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3m_pre_mul_d = libteem.ell_3m_pre_mul_d
ell_3m_pre_mul_d.restype = None
ell_3m_pre_mul_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_3m_post_mul_f = libteem.ell_3m_post_mul_f
ell_3m_post_mul_f.restype = None
ell_3m_post_mul_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3m_post_mul_d = libteem.ell_3m_post_mul_d
ell_3m_post_mul_d.restype = None
ell_3m_post_mul_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_3m_det_f = libteem.ell_3m_det_f
ell_3m_det_f.restype = c_float
ell_3m_det_f.argtypes = [POINTER(c_float)]
ell_3m_det_d = libteem.ell_3m_det_d
ell_3m_det_d.restype = c_double
ell_3m_det_d.argtypes = [POINTER(c_double)]
ell_3m_inv_f = libteem.ell_3m_inv_f
ell_3m_inv_f.restype = None
ell_3m_inv_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3m_inv_d = libteem.ell_3m_inv_d
ell_3m_inv_d.restype = None
ell_3m_inv_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_4m_mul_f = libteem.ell_4m_mul_f
ell_4m_mul_f.restype = None
ell_4m_mul_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_4m_mul_d = libteem.ell_4m_mul_d
ell_4m_mul_d.restype = None
ell_4m_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_4m_pre_mul_f = libteem.ell_4m_pre_mul_f
ell_4m_pre_mul_f.restype = None
ell_4m_pre_mul_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_4m_post_mul_f = libteem.ell_4m_post_mul_f
ell_4m_post_mul_f.restype = None
ell_4m_post_mul_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_4m_post_mul_d = libteem.ell_4m_post_mul_d
ell_4m_post_mul_d.restype = None
ell_4m_post_mul_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_4m_det_f = libteem.ell_4m_det_f
ell_4m_det_f.restype = c_float
ell_4m_det_f.argtypes = [POINTER(c_float)]
ell_4m_det_d = libteem.ell_4m_det_d
ell_4m_det_d.restype = c_double
ell_4m_det_d.argtypes = [POINTER(c_double)]
ell_4m_inv_f = libteem.ell_4m_inv_f
ell_4m_inv_f.restype = None
ell_4m_inv_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_4m_inv_d = libteem.ell_4m_inv_d
ell_4m_inv_d.restype = None
ell_4m_inv_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_6m_mul_d = libteem.ell_6m_mul_d
ell_6m_mul_d.restype = None
ell_6m_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3m_rotate_between_d = libteem.ell_3m_rotate_between_d
ell_3m_rotate_between_d.restype = None
ell_3m_rotate_between_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3m_to_q_f = libteem.ell_3m_to_q_f
ell_3m_to_q_f.restype = None
ell_3m_to_q_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3m_to_q_d = libteem.ell_3m_to_q_d
ell_3m_to_q_d.restype = None
ell_3m_to_q_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_4m_to_q_f = libteem.ell_4m_to_q_f
ell_4m_to_q_f.restype = None
ell_4m_to_q_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_4m_to_q_d = libteem.ell_4m_to_q_d
ell_4m_to_q_d.restype = None
ell_4m_to_q_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_to_3m_f = libteem.ell_q_to_3m_f
ell_q_to_3m_f.restype = None
ell_q_to_3m_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_to_3m_d = libteem.ell_q_to_3m_d
ell_q_to_3m_d.restype = None
ell_q_to_3m_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_to_4m_f = libteem.ell_q_to_4m_f
ell_q_to_4m_f.restype = None
ell_q_to_4m_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_to_4m_d = libteem.ell_q_to_4m_d
ell_q_to_4m_d.restype = None
ell_q_to_4m_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_to_aa_f = libteem.ell_q_to_aa_f
ell_q_to_aa_f.restype = c_float
ell_q_to_aa_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_to_aa_d = libteem.ell_q_to_aa_d
ell_q_to_aa_d.restype = c_double
ell_q_to_aa_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_aa_to_q_f = libteem.ell_aa_to_q_f
ell_aa_to_q_f.restype = None
ell_aa_to_q_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float)]
ell_aa_to_q_d = libteem.ell_aa_to_q_d
ell_aa_to_q_d.restype = None
ell_aa_to_q_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double)]
ell_aa_to_3m_f = libteem.ell_aa_to_3m_f
ell_aa_to_3m_f.restype = None
ell_aa_to_3m_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float)]
ell_aa_to_3m_d = libteem.ell_aa_to_3m_d
ell_aa_to_3m_d.restype = None
ell_aa_to_3m_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double)]
ell_aa_to_4m_f = libteem.ell_aa_to_4m_f
ell_aa_to_4m_f.restype = None
ell_aa_to_4m_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float)]
ell_aa_to_4m_d = libteem.ell_aa_to_4m_d
ell_aa_to_4m_d.restype = None
ell_aa_to_4m_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double)]
ell_3m_to_aa_f = libteem.ell_3m_to_aa_f
ell_3m_to_aa_f.restype = c_float
ell_3m_to_aa_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_3m_to_aa_d = libteem.ell_3m_to_aa_d
ell_3m_to_aa_d.restype = c_double
ell_3m_to_aa_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_4m_to_aa_f = libteem.ell_4m_to_aa_f
ell_4m_to_aa_f.restype = c_float
ell_4m_to_aa_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_4m_to_aa_d = libteem.ell_4m_to_aa_d
ell_4m_to_aa_d.restype = c_double
ell_4m_to_aa_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_mul_f = libteem.ell_q_mul_f
ell_q_mul_f.restype = None
ell_q_mul_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_q_mul_d = libteem.ell_q_mul_d
ell_q_mul_d.restype = None
ell_q_mul_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_q_inv_f = libteem.ell_q_inv_f
ell_q_inv_f.restype = None
ell_q_inv_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_inv_d = libteem.ell_q_inv_d
ell_q_inv_d.restype = None
ell_q_inv_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_pow_f = libteem.ell_q_pow_f
ell_q_pow_f.restype = None
ell_q_pow_f.argtypes = [POINTER(c_float), POINTER(c_float), c_float]
ell_q_pow_d = libteem.ell_q_pow_d
ell_q_pow_d.restype = None
ell_q_pow_d.argtypes = [POINTER(c_double), POINTER(c_double), c_double]
ell_q_div_f = libteem.ell_q_div_f
ell_q_div_f.restype = None
ell_q_div_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_q_div_d = libteem.ell_q_div_d
ell_q_div_d.restype = None
ell_q_div_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_q_exp_f = libteem.ell_q_exp_f
ell_q_exp_f.restype = None
ell_q_exp_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_exp_d = libteem.ell_q_exp_d
ell_q_exp_d.restype = None
ell_q_exp_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_log_f = libteem.ell_q_log_f
ell_q_log_f.restype = None
ell_q_log_f.argtypes = [POINTER(c_float), POINTER(c_float)]
ell_q_log_d = libteem.ell_q_log_d
ell_q_log_d.restype = None
ell_q_log_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_q_3v_rotate_f = libteem.ell_q_3v_rotate_f
ell_q_3v_rotate_f.restype = None
ell_q_3v_rotate_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_q_3v_rotate_d = libteem.ell_q_3v_rotate_d
ell_q_3v_rotate_d.restype = None
ell_q_3v_rotate_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_q_4v_rotate_f = libteem.ell_q_4v_rotate_f
ell_q_4v_rotate_f.restype = None
ell_q_4v_rotate_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
ell_q_4v_rotate_d = libteem.ell_q_4v_rotate_d
ell_q_4v_rotate_d.restype = None
ell_q_4v_rotate_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_q_avg4_d = libteem.ell_q_avg4_d
ell_q_avg4_d.restype = c_int
ell_q_avg4_d.argtypes = [POINTER(c_double), POINTER(c_uint), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double, c_uint]
ell_q_avgN_d = libteem.ell_q_avgN_d
ell_q_avgN_d.restype = c_int
ell_q_avgN_d.argtypes = [POINTER(c_double), POINTER(c_uint), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_uint, c_double, c_uint]
ell_Nm_check = libteem.ell_Nm_check
ell_Nm_check.restype = c_int
ell_Nm_check.argtypes = [POINTER(Nrrd), c_int]
ell_Nm_tran = libteem.ell_Nm_tran
ell_Nm_tran.restype = c_int
ell_Nm_tran.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
ell_Nm_mul = libteem.ell_Nm_mul
ell_Nm_mul.restype = c_int
ell_Nm_mul.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
ell_Nm_inv = libteem.ell_Nm_inv
ell_Nm_inv.restype = c_int
ell_Nm_inv.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
ell_Nm_pseudo_inv = libteem.ell_Nm_pseudo_inv
ell_Nm_pseudo_inv.restype = c_int
ell_Nm_pseudo_inv.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
ell_Nm_wght_pseudo_inv = libteem.ell_Nm_wght_pseudo_inv
ell_Nm_wght_pseudo_inv.restype = c_int
ell_Nm_wght_pseudo_inv.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
ell_cubic = libteem.ell_cubic
ell_cubic.restype = c_int
ell_cubic.argtypes = [POINTER(c_double), c_double, c_double, c_double, c_int]
ell_3m_1d_nullspace_d = libteem.ell_3m_1d_nullspace_d
ell_3m_1d_nullspace_d.restype = None
ell_3m_1d_nullspace_d.argtypes = [POINTER(c_double), POINTER(c_double)]
ell_3m_2d_nullspace_d = libteem.ell_3m_2d_nullspace_d
ell_3m_2d_nullspace_d.restype = None
ell_3m_2d_nullspace_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
ell_3m_eigenvalues_d = libteem.ell_3m_eigenvalues_d
ell_3m_eigenvalues_d.restype = c_int
ell_3m_eigenvalues_d.argtypes = [POINTER(c_double), POINTER(c_double), c_int]
ell_3m_eigensolve_d = libteem.ell_3m_eigensolve_d
ell_3m_eigensolve_d.restype = c_int
ell_3m_eigensolve_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int]
ell_3m_svd_d = libteem.ell_3m_svd_d
ell_3m_svd_d.restype = c_int
ell_3m_svd_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int]
ell_6ms_eigensolve_d = libteem.ell_6ms_eigensolve_d
ell_6ms_eigensolve_d.restype = c_int
ell_6ms_eigensolve_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double]
class gageItemEntry(Structure):
    pass
gageItemEntry._fields_ = [
    ('enumVal', c_int),
    ('answerLength', c_uint),
    ('needDeriv', c_int),
    ('prereq', c_int * 8),
    ('parentItem', c_int),
    ('parentIndex', c_int),
    ('needData', c_int),
]
class gageShape_t(Structure):
    pass
gageShape_t._pack_ = 4
gageShape_t._fields_ = [
    ('defaultCenter', c_int),
    ('orientationFromSpacing', c_int),
    ('center', c_int),
    ('fromOrientation', c_int),
    ('size', c_uint * 3),
    ('spacing', c_double * 3),
    ('ItoW', c_double * 16),
    ('WtoI', c_double * 16),
    ('ItoWSubInvTransp', c_double * 9),
    ('ItoWSubInv', c_double * 9),
]
gageShape = gageShape_t
class gageParm_t(Structure):
    pass
gageParm_t._pack_ = 4
gageParm_t._fields_ = [
    ('renormalize', c_int),
    ('checkIntegrals', c_int),
    ('k3pack', c_int),
    ('gradMagCurvMin', c_double),
    ('kernelIntegralNearZero', c_double),
    ('stackNormalizeDerivBias', c_double),
    ('curvNormalSide', c_int),
    ('defaultCenter', c_int),
    ('stackUse', c_int),
    ('stackNormalizeRecon', c_int),
    ('stackNormalizeDeriv', c_int),
    ('orientationFromSpacing', c_int),
    ('generateErrStr', c_int),
]
gageParm = gageParm_t
class gagePoint_t(Structure):
    pass
gagePoint_t._pack_ = 4
gagePoint_t._fields_ = [
    ('frac', c_double * 4),
    ('idx', c_uint * 4),
    ('stackFwNonZeroNum', c_uint),
]
gagePoint = gagePoint_t
class NrrdKernelSpec(Structure):
    pass
class gagePerVolume_t(Structure):
    pass
gageContext_t._pack_ = 4
gageContext_t._fields_ = [
    ('verbose', c_int),
    ('parm', gageParm),
    ('ksp', POINTER(NrrdKernelSpec) * 8),
    ('pvl', POINTER(POINTER(gagePerVolume_t))),
    ('pvlNum', c_uint),
    ('pvlArr', POINTER(airArray)),
    ('shape', POINTER(gageShape)),
    ('stackPos', POINTER(c_double)),
    ('stackFsl', POINTER(c_double)),
    ('stackFw', POINTER(c_double)),
    ('flag', c_int * 7),
    ('needD', c_int * 3),
    ('needK', c_int * 8),
    ('radius', c_uint),
    ('fsl', POINTER(c_double)),
    ('fw', POINTER(c_double)),
    ('off', POINTER(c_uint)),
    ('point', gagePoint),
    ('errStr', c_char * 513),
    ('errNum', c_int),
    ('edgeFrac', c_double),
]
class gageKind_t(Structure):
    pass
gagePerVolume = gagePerVolume_t
gageKind_t._fields_ = [
    ('dynamicAlloc', c_int),
    ('name', c_char * 129),
    ('enm', POINTER(airEnum)),
    ('baseDim', c_uint),
    ('valLen', c_uint),
    ('itemMax', c_int),
    ('table', POINTER(gageItemEntry)),
    ('iv3Print', CFUNCTYPE(None, POINTER(FILE), POINTER(gageContext), POINTER(gagePerVolume))),
    ('filter', CFUNCTYPE(None, POINTER(gageContext), POINTER(gagePerVolume))),
    ('answer', CFUNCTYPE(None, POINTER(gageContext), POINTER(gagePerVolume))),
    ('pvlDataNew', CFUNCTYPE(c_void_p, POINTER(gageKind_t))),
    ('pvlDataCopy', CFUNCTYPE(c_void_p, POINTER(gageKind_t), c_void_p)),
    ('pvlDataNix', CFUNCTYPE(c_void_p, POINTER(gageKind_t), c_void_p)),
    ('pvlDataUpdate', CFUNCTYPE(c_int, POINTER(gageKind_t), POINTER(gageContext), POINTER(gagePerVolume), c_void_p)),
    ('data', c_void_p),
]
gagePerVolume_t._fields_ = [
    ('verbose', c_int),
    ('kind', POINTER(gageKind_t)),
    ('query', gageQuery),
    ('needD', c_int * 3),
    ('nin', POINTER(Nrrd)),
    ('flag', c_int * 4),
    ('iv3', POINTER(c_double)),
    ('iv2', POINTER(c_double)),
    ('iv1', POINTER(c_double)),
    ('lup', CFUNCTYPE(c_double, c_void_p, c_size_t)),
    ('answer', POINTER(c_double)),
    ('directAnswer', POINTER(POINTER(c_double))),
    ('data', c_void_p),
]
gageKind = gageKind_t
class gageItemSpec(Structure):
    pass
gageItemSpec._fields_ = [
    ('kind', POINTER(gageKind)),
    ('item', c_int),
]
class gageItemPack(Structure):
    pass
gageItemPack._fields_ = [
    ('kind', POINTER(gageKind)),
    ('item', c_int * 12),
]
class gageStackBlurParm(Structure):
    pass
gageStackBlurParm._pack_ = 4
gageStackBlurParm._fields_ = [
    ('num', c_uint),
    ('scale', POINTER(c_double)),
    ('sigmaMax', c_double),
    ('padValue', c_double),
    ('kspec', POINTER(NrrdKernelSpec)),
    ('dataCheck', c_int),
    ('boundary', c_int),
    ('renormalize', c_int),
    ('verbose', c_int),
]
class gageOptimSigParm(Structure):
    pass
gageOptimSigParm._pack_ = 4
gageOptimSigParm._fields_ = [
    ('dim', c_uint),
    ('sigmaMax', c_double),
    ('cutoff', c_double),
    ('measrSampleNum', c_uint),
    ('sampleNum', c_uint),
    ('volMeasr', c_int),
    ('lineMeasr', c_int),
    ('plotting', c_int),
    ('tentRecon', c_int),
    ('maxIter', c_uint),
    ('convEps', c_double),
    ('sx', c_uint),
    ('sy', c_uint),
    ('sz', c_uint),
    ('sigmatru', POINTER(c_double)),
    ('truth', POINTER(c_double)),
    ('ntruth', POINTER(Nrrd)),
    ('nerr', POINTER(Nrrd)),
    ('ntruline', POINTER(Nrrd)),
    ('ninterp', POINTER(Nrrd)),
    ('ndiff', POINTER(Nrrd)),
    ('sampleNumMax', c_uint),
    ('scalePos', POINTER(c_double)),
    ('step', POINTER(c_double)),
    ('nsampvol', POINTER(POINTER(Nrrd))),
    ('pvl', POINTER(gagePerVolume)),
    ('pvlSS', POINTER(POINTER(gagePerVolume))),
    ('gctx', POINTER(gageContext)),
    ('finalErr', c_double),
]
gageBiffKey = (STRING).in_dll(libteem, 'gageBiffKey')
gageDefVerbose = (c_int).in_dll(libteem, 'gageDefVerbose')
gageDefGradMagCurvMin = (c_double).in_dll(libteem, 'gageDefGradMagCurvMin')
gageDefRenormalize = (c_int).in_dll(libteem, 'gageDefRenormalize')
gageDefCheckIntegrals = (c_int).in_dll(libteem, 'gageDefCheckIntegrals')
gageDefK3Pack = (c_int).in_dll(libteem, 'gageDefK3Pack')
gageDefCurvNormalSide = (c_int).in_dll(libteem, 'gageDefCurvNormalSide')
gageDefKernelIntegralNearZero = (c_double).in_dll(libteem, 'gageDefKernelIntegralNearZero')
gageDefDefaultCenter = (c_int).in_dll(libteem, 'gageDefDefaultCenter')
gageDefStackUse = (c_int).in_dll(libteem, 'gageDefStackUse')
gageDefStackNormalizeRecon = (c_int).in_dll(libteem, 'gageDefStackNormalizeRecon')
gageDefStackNormalizeDeriv = (c_int).in_dll(libteem, 'gageDefStackNormalizeDeriv')
gageDefStackNormalizeDerivBias = (c_double).in_dll(libteem, 'gageDefStackNormalizeDerivBias')
gageDefStackBlurSigmaMax = (c_double).in_dll(libteem, 'gageDefStackBlurSigmaMax')
gageDefOrientationFromSpacing = (c_int).in_dll(libteem, 'gageDefOrientationFromSpacing')
gageDefGenerateErrStr = (c_int).in_dll(libteem, 'gageDefGenerateErrStr')
gagePresent = (c_int).in_dll(libteem, 'gagePresent')
gageZeroNormal = (c_double * 3).in_dll(libteem, 'gageZeroNormal')
gageErr = (POINTER(airEnum)).in_dll(libteem, 'gageErr')
gageKernel = (POINTER(airEnum)).in_dll(libteem, 'gageKernel')
gageItemPackPart = (POINTER(airEnum)).in_dll(libteem, 'gageItemPackPart')
gageParmReset = libteem.gageParmReset
gageParmReset.restype = None
gageParmReset.argtypes = [POINTER(gageParm)]
gagePointReset = libteem.gagePointReset
gagePointReset.restype = None
gagePointReset.argtypes = [POINTER(gagePoint)]
gageItemSpecNew = libteem.gageItemSpecNew
gageItemSpecNew.restype = POINTER(gageItemSpec)
gageItemSpecNew.argtypes = []
gageItemSpecInit = libteem.gageItemSpecInit
gageItemSpecInit.restype = None
gageItemSpecInit.argtypes = [POINTER(gageItemSpec)]
gageItemSpecNix = libteem.gageItemSpecNix
gageItemSpecNix.restype = POINTER(gageItemSpec)
gageItemSpecNix.argtypes = [POINTER(gageItemSpec)]
gageKindCheck = libteem.gageKindCheck
gageKindCheck.restype = c_int
gageKindCheck.argtypes = [POINTER(gageKind)]
gageKindTotalAnswerLength = libteem.gageKindTotalAnswerLength
gageKindTotalAnswerLength.restype = c_uint
gageKindTotalAnswerLength.argtypes = [POINTER(gageKind)]
gageKindAnswerLength = libteem.gageKindAnswerLength
gageKindAnswerLength.restype = c_uint
gageKindAnswerLength.argtypes = [POINTER(gageKind), c_int]
gageKindAnswerOffset = libteem.gageKindAnswerOffset
gageKindAnswerOffset.restype = c_int
gageKindAnswerOffset.argtypes = [POINTER(gageKind), c_int]
gageKindVolumeCheck = libteem.gageKindVolumeCheck
gageKindVolumeCheck.restype = c_int
gageKindVolumeCheck.argtypes = [POINTER(gageKind), POINTER(Nrrd)]
gageQueryPrint = libteem.gageQueryPrint
gageQueryPrint.restype = None
gageQueryPrint.argtypes = [POINTER(FILE), POINTER(gageKind), POINTER(c_ubyte)]
gageScl3PFilter_t = CFUNCTYPE(None, POINTER(gageShape), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int))
gageScl3PFilter2 = libteem.gageScl3PFilter2
gageScl3PFilter2.restype = None
gageScl3PFilter2.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int)]
gageScl3PFilter4 = libteem.gageScl3PFilter4
gageScl3PFilter4.restype = None
gageScl3PFilter4.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int)]
gageScl3PFilter6 = libteem.gageScl3PFilter6
gageScl3PFilter6.restype = None
gageScl3PFilter6.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int)]
gageScl3PFilter8 = libteem.gageScl3PFilter8
gageScl3PFilter8.restype = None
gageScl3PFilter8.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int)]
gageScl3PFilterN = libteem.gageScl3PFilterN
gageScl3PFilterN.restype = None
gageScl3PFilterN.argtypes = [POINTER(gageShape), c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_int)]
gageScl = (POINTER(airEnum)).in_dll(libteem, 'gageScl')
gageKindScl = (POINTER(gageKind)).in_dll(libteem, 'gageKindScl')
gageItemPackSclValue = (POINTER(gageItemPack)).in_dll(libteem, 'gageItemPackSclValue')
gageVec = (POINTER(airEnum)).in_dll(libteem, 'gageVec')
gageKindVec = (POINTER(gageKind)).in_dll(libteem, 'gageKindVec')
gageShapeReset = libteem.gageShapeReset
gageShapeReset.restype = None
gageShapeReset.argtypes = [POINTER(gageShape)]
gageShapeNew = libteem.gageShapeNew
gageShapeNew.restype = POINTER(gageShape)
gageShapeNew.argtypes = []
gageShapeCopy = libteem.gageShapeCopy
gageShapeCopy.restype = POINTER(gageShape)
gageShapeCopy.argtypes = [POINTER(gageShape)]
gageShapeNix = libteem.gageShapeNix
gageShapeNix.restype = POINTER(gageShape)
gageShapeNix.argtypes = [POINTER(gageShape)]
gageShapeSet = libteem.gageShapeSet
gageShapeSet.restype = c_int
gageShapeSet.argtypes = [POINTER(gageShape), POINTER(Nrrd), c_int]
gageShapeWtoI = libteem.gageShapeWtoI
gageShapeWtoI.restype = None
gageShapeWtoI.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double)]
gageShapeItoW = libteem.gageShapeItoW
gageShapeItoW.restype = None
gageShapeItoW.argtypes = [POINTER(gageShape), POINTER(c_double), POINTER(c_double)]
gageShapeEqual = libteem.gageShapeEqual
gageShapeEqual.restype = c_int
gageShapeEqual.argtypes = [POINTER(gageShape), STRING, POINTER(gageShape), STRING]
gageShapeBoundingBox = libteem.gageShapeBoundingBox
gageShapeBoundingBox.restype = None
gageShapeBoundingBox.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(gageShape)]
gageVolumeCheck = libteem.gageVolumeCheck
gageVolumeCheck.restype = c_int
gageVolumeCheck.argtypes = [POINTER(gageContext), POINTER(Nrrd), POINTER(gageKind)]
gagePerVolumeNew = libteem.gagePerVolumeNew
gagePerVolumeNew.restype = POINTER(gagePerVolume)
gagePerVolumeNew.argtypes = [POINTER(gageContext), POINTER(Nrrd), POINTER(gageKind)]
gagePerVolumeNix = libteem.gagePerVolumeNix
gagePerVolumeNix.restype = POINTER(gagePerVolume)
gagePerVolumeNix.argtypes = [POINTER(gagePerVolume)]
gageAnswerPointer = libteem.gageAnswerPointer
gageAnswerPointer.restype = POINTER(c_double)
gageAnswerPointer.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), c_int]
gageAnswerLength = libteem.gageAnswerLength
gageAnswerLength.restype = c_uint
gageAnswerLength.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), c_int]
gageQueryReset = libteem.gageQueryReset
gageQueryReset.restype = c_int
gageQueryReset.argtypes = [POINTER(gageContext), POINTER(gagePerVolume)]
gageQuerySet = libteem.gageQuerySet
gageQuerySet.restype = c_int
gageQuerySet.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), POINTER(c_ubyte)]
gageQueryAdd = libteem.gageQueryAdd
gageQueryAdd.restype = c_int
gageQueryAdd.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), POINTER(c_ubyte)]
gageQueryItemOn = libteem.gageQueryItemOn
gageQueryItemOn.restype = c_int
gageQueryItemOn.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), c_int]
gageOptimSigSet = libteem.gageOptimSigSet
gageOptimSigSet.restype = c_int
gageOptimSigSet.argtypes = [POINTER(c_double), c_uint, c_uint]
gageOptimSigParmNew = libteem.gageOptimSigParmNew
gageOptimSigParmNew.restype = POINTER(gageOptimSigParm)
gageOptimSigParmNew.argtypes = [c_uint]
gageOptimSigParmNix = libteem.gageOptimSigParmNix
gageOptimSigParmNix.restype = POINTER(gageOptimSigParm)
gageOptimSigParmNix.argtypes = [POINTER(gageOptimSigParm)]
gageOptimSigTruthSet = libteem.gageOptimSigTruthSet
gageOptimSigTruthSet.restype = c_int
gageOptimSigTruthSet.argtypes = [POINTER(gageOptimSigParm), c_uint, c_double, c_double, c_uint]
gageOptimSigCalculate = libteem.gageOptimSigCalculate
gageOptimSigCalculate.restype = c_int
gageOptimSigCalculate.argtypes = [POINTER(gageOptimSigParm), POINTER(c_double), c_uint, c_int, c_int, c_double, c_uint]
gageOptimSigPlot = libteem.gageOptimSigPlot
gageOptimSigPlot.restype = c_int
gageOptimSigPlot.argtypes = [POINTER(gageOptimSigParm), POINTER(Nrrd), POINTER(c_double), c_uint, c_int, c_int]
gageTauOfTee = libteem.gageTauOfTee
gageTauOfTee.restype = c_double
gageTauOfTee.argtypes = [c_double]
gageTeeOfTau = libteem.gageTeeOfTau
gageTeeOfTau.restype = c_double
gageTeeOfTau.argtypes = [c_double]
gageSigOfTau = libteem.gageSigOfTau
gageSigOfTau.restype = c_double
gageSigOfTau.argtypes = [c_double]
gageTauOfSig = libteem.gageTauOfSig
gageTauOfSig.restype = c_double
gageTauOfSig.argtypes = [c_double]
gageStackWtoI = libteem.gageStackWtoI
gageStackWtoI.restype = c_double
gageStackWtoI.argtypes = [POINTER(gageContext), c_double, POINTER(c_int)]
gageStackItoW = libteem.gageStackItoW
gageStackItoW.restype = c_double
gageStackItoW.argtypes = [POINTER(gageContext), c_double, POINTER(c_int)]
gageStackPerVolumeNew = libteem.gageStackPerVolumeNew
gageStackPerVolumeNew.restype = c_int
gageStackPerVolumeNew.argtypes = [POINTER(gageContext), POINTER(POINTER(gagePerVolume)), POINTER(POINTER(Nrrd)), c_uint, POINTER(gageKind)]
gageStackPerVolumeAttach = libteem.gageStackPerVolumeAttach
gageStackPerVolumeAttach.restype = c_int
gageStackPerVolumeAttach.argtypes = [POINTER(gageContext), POINTER(gagePerVolume), POINTER(POINTER(gagePerVolume)), POINTER(c_double), c_uint]
gageStackProbe = libteem.gageStackProbe
gageStackProbe.restype = c_int
gageStackProbe.argtypes = [POINTER(gageContext), c_double, c_double, c_double, c_double]
gageStackProbeSpace = libteem.gageStackProbeSpace
gageStackProbeSpace.restype = c_int
gageStackProbeSpace.argtypes = [POINTER(gageContext), c_double, c_double, c_double, c_double, c_int, c_int]
gageStackBlurParmNew = libteem.gageStackBlurParmNew
gageStackBlurParmNew.restype = POINTER(gageStackBlurParm)
gageStackBlurParmNew.argtypes = []
gageStackBlurParmNix = libteem.gageStackBlurParmNix
gageStackBlurParmNix.restype = POINTER(gageStackBlurParm)
gageStackBlurParmNix.argtypes = [POINTER(gageStackBlurParm)]
gageStackBlurParmScaleSet = libteem.gageStackBlurParmScaleSet
gageStackBlurParmScaleSet.restype = c_int
gageStackBlurParmScaleSet.argtypes = [POINTER(gageStackBlurParm), c_uint, c_double, c_double, c_int, c_int]
NrrdKernelSpec._pack_ = 4
NrrdKernelSpec._fields_ = [
    ('kernel', POINTER(NrrdKernel)),
    ('parm', c_double * 8),
]
gageStackBlurParmKernelSet = libteem.gageStackBlurParmKernelSet
gageStackBlurParmKernelSet.restype = c_int
gageStackBlurParmKernelSet.argtypes = [POINTER(gageStackBlurParm), POINTER(NrrdKernelSpec), c_int]
gageStackBlurParmBoundarySet = libteem.gageStackBlurParmBoundarySet
gageStackBlurParmBoundarySet.restype = c_int
gageStackBlurParmBoundarySet.argtypes = [POINTER(gageStackBlurParm), c_int, c_double]
gageStackBlurParmVerboseSet = libteem.gageStackBlurParmVerboseSet
gageStackBlurParmVerboseSet.restype = c_int
gageStackBlurParmVerboseSet.argtypes = [POINTER(gageStackBlurParm), c_int]
gageStackBlurParmCheck = libteem.gageStackBlurParmCheck
gageStackBlurParmCheck.restype = c_int
gageStackBlurParmCheck.argtypes = [POINTER(gageStackBlurParm)]
gageStackBlur = libteem.gageStackBlur
gageStackBlur.restype = c_int
gageStackBlur.argtypes = [POINTER(POINTER(Nrrd)), POINTER(gageStackBlurParm), POINTER(Nrrd), POINTER(gageKind)]
gageStackBlurCheck = libteem.gageStackBlurCheck
gageStackBlurCheck.restype = c_int
gageStackBlurCheck.argtypes = [POINTER(POINTER(Nrrd)), POINTER(gageStackBlurParm), POINTER(Nrrd), POINTER(gageKind)]
gageStackBlurGet = libteem.gageStackBlurGet
gageStackBlurGet.restype = c_int
gageStackBlurGet.argtypes = [POINTER(POINTER(Nrrd)), POINTER(c_int), POINTER(gageStackBlurParm), STRING, POINTER(Nrrd), POINTER(gageKind)]
class NrrdEncoding_t(Structure):
    pass
NrrdEncoding = NrrdEncoding_t
gageStackBlurManage = libteem.gageStackBlurManage
gageStackBlurManage.restype = c_int
gageStackBlurManage.argtypes = [POINTER(POINTER(POINTER(Nrrd))), POINTER(c_int), POINTER(gageStackBlurParm), STRING, c_int, POINTER(NrrdEncoding), POINTER(Nrrd), POINTER(gageKind)]
gageContextNew = libteem.gageContextNew
gageContextNew.restype = POINTER(gageContext)
gageContextNew.argtypes = []
gageContextCopy = libteem.gageContextCopy
gageContextCopy.restype = POINTER(gageContext)
gageContextCopy.argtypes = [POINTER(gageContext)]
gageContextNix = libteem.gageContextNix
gageContextNix.restype = POINTER(gageContext)
gageContextNix.argtypes = [POINTER(gageContext)]
gageParmSet = libteem.gageParmSet
gageParmSet.restype = None
gageParmSet.argtypes = [POINTER(gageContext), c_int, c_double]
gagePerVolumeIsAttached = libteem.gagePerVolumeIsAttached
gagePerVolumeIsAttached.restype = c_int
gagePerVolumeIsAttached.argtypes = [POINTER(gageContext), POINTER(gagePerVolume)]
gagePerVolumeAttach = libteem.gagePerVolumeAttach
gagePerVolumeAttach.restype = c_int
gagePerVolumeAttach.argtypes = [POINTER(gageContext), POINTER(gagePerVolume)]
gagePerVolumeDetach = libteem.gagePerVolumeDetach
gagePerVolumeDetach.restype = c_int
gagePerVolumeDetach.argtypes = [POINTER(gageContext), POINTER(gagePerVolume)]
gageKernelSet = libteem.gageKernelSet
gageKernelSet.restype = c_int
gageKernelSet.argtypes = [POINTER(gageContext), c_int, POINTER(NrrdKernel), POINTER(c_double)]
gageKernelReset = libteem.gageKernelReset
gageKernelReset.restype = None
gageKernelReset.argtypes = [POINTER(gageContext)]
gageProbe = libteem.gageProbe
gageProbe.restype = c_int
gageProbe.argtypes = [POINTER(gageContext), c_double, c_double, c_double]
gageProbeSpace = libteem.gageProbeSpace
gageProbeSpace.restype = c_int
gageProbeSpace.argtypes = [POINTER(gageContext), c_double, c_double, c_double, c_int, c_int]
gageUpdate = libteem.gageUpdate
gageUpdate.restype = c_int
gageUpdate.argtypes = [POINTER(gageContext)]
gageStructureTensor = libteem.gageStructureTensor
gageStructureTensor.restype = c_int
gageStructureTensor.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_int, c_int]
gageDeconvolve = libteem.gageDeconvolve
gageDeconvolve.restype = c_int
gageDeconvolve.argtypes = [POINTER(Nrrd), POINTER(c_double), POINTER(Nrrd), POINTER(gageKind), POINTER(NrrdKernelSpec), c_int, c_uint, c_int, c_double, c_double, c_int]
gageDeconvolveSeparableKnown = libteem.gageDeconvolveSeparableKnown
gageDeconvolveSeparableKnown.restype = c_int
gageDeconvolveSeparableKnown.argtypes = [POINTER(NrrdKernelSpec)]
gageDeconvolveSeparable = libteem.gageDeconvolveSeparable
gageDeconvolveSeparable.restype = c_int
gageDeconvolveSeparable.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(gageKind), POINTER(NrrdKernelSpec), c_int]
hestCB._fields_ = [
    ('size', c_size_t),
    ('type', STRING),
    ('parse', CFUNCTYPE(c_int, c_void_p, STRING, STRING)),
    ('destroy', CFUNCTYPE(c_void_p, c_void_p)),
]
class hestOpt(Structure):
    pass
hestOpt._fields_ = [
    ('flag', STRING),
    ('name', STRING),
    ('type', c_int),
    ('min', c_uint),
    ('max', c_int),
    ('valueP', c_void_p),
    ('dflt', STRING),
    ('info', STRING),
    ('sawP', POINTER(c_uint)),
    ('enm', POINTER(airEnum)),
    ('CB', POINTER(hestCB)),
    ('kind', c_int),
    ('alloc', c_int),
]
hestParm._fields_ = [
    ('verbosity', c_int),
    ('respFileEnable', c_int),
    ('elideSingleEnumType', c_int),
    ('elideSingleOtherType', c_int),
    ('elideSingleOtherDefault', c_int),
    ('elideSingleNonExistFloatDefault', c_int),
    ('elideMultipleNonExistFloatDefault', c_int),
    ('elideSingleEmptyStringDefault', c_int),
    ('elideMultipleEmptyStringDefault', c_int),
    ('noArgsIsNoProblem', c_int),
    ('greedySingleString', c_int),
    ('cleverPluralizeOtherY', c_int),
    ('columns', c_uint),
    ('respFileFlag', c_char),
    ('respFileComment', c_char),
    ('varParamStopFlag', c_char),
    ('multiFlagSep', c_char),
]
hestVerbosity = (c_int).in_dll(libteem, 'hestVerbosity')
hestRespFileEnable = (c_int).in_dll(libteem, 'hestRespFileEnable')
hestElideSingleEnumType = (c_int).in_dll(libteem, 'hestElideSingleEnumType')
hestElideSingleOtherType = (c_int).in_dll(libteem, 'hestElideSingleOtherType')
hestElideSingleOtherDefault = (c_int).in_dll(libteem, 'hestElideSingleOtherDefault')
hestElideSingleNonExistFloatDefault = (c_int).in_dll(libteem, 'hestElideSingleNonExistFloatDefault')
hestElideMultipleNonExistFloatDefault = (c_int).in_dll(libteem, 'hestElideMultipleNonExistFloatDefault')
hestElideSingleEmptyStringDefault = (c_int).in_dll(libteem, 'hestElideSingleEmptyStringDefault')
hestElideMultipleEmptyStringDefault = (c_int).in_dll(libteem, 'hestElideMultipleEmptyStringDefault')
hestNoArgsIsNoProblem = (c_int).in_dll(libteem, 'hestNoArgsIsNoProblem')
hestGreedySingleString = (c_int).in_dll(libteem, 'hestGreedySingleString')
hestCleverPluralizeOtherY = (c_int).in_dll(libteem, 'hestCleverPluralizeOtherY')
hestColumns = (c_uint).in_dll(libteem, 'hestColumns')
hestRespFileFlag = (c_char).in_dll(libteem, 'hestRespFileFlag')
hestRespFileComment = (c_char).in_dll(libteem, 'hestRespFileComment')
hestVarParamStopFlag = (c_char).in_dll(libteem, 'hestVarParamStopFlag')
hestMultiFlagSep = (c_char).in_dll(libteem, 'hestMultiFlagSep')
hestPresent = (c_int).in_dll(libteem, 'hestPresent')
hestParmNew = libteem.hestParmNew
hestParmNew.restype = POINTER(hestParm)
hestParmNew.argtypes = []
hestParmFree = libteem.hestParmFree
hestParmFree.restype = POINTER(hestParm)
hestParmFree.argtypes = [POINTER(hestParm)]
hestOptAdd = libteem.hestOptAdd
hestOptAdd.restype = None
hestOptAdd.argtypes = [POINTER(POINTER(hestOpt)), STRING, STRING, c_int, c_int, c_int, c_void_p, STRING, STRING]
hestOptFree = libteem.hestOptFree
hestOptFree.restype = POINTER(hestOpt)
hestOptFree.argtypes = [POINTER(hestOpt)]
hestOptCheck = libteem.hestOptCheck
hestOptCheck.restype = c_int
hestOptCheck.argtypes = [POINTER(hestOpt), POINTER(STRING)]
hestParse = libteem.hestParse
hestParse.restype = c_int
hestParse.argtypes = [POINTER(hestOpt), c_int, POINTER(STRING), POINTER(STRING), POINTER(hestParm)]
hestParseFree = libteem.hestParseFree
hestParseFree.restype = c_void_p
hestParseFree.argtypes = [POINTER(hestOpt)]
hestParseOrDie = libteem.hestParseOrDie
hestParseOrDie.restype = None
hestParseOrDie.argtypes = [POINTER(hestOpt), c_int, POINTER(STRING), POINTER(hestParm), STRING, STRING, c_int, c_int, c_int]
hestMinNumArgs = libteem.hestMinNumArgs
hestMinNumArgs.restype = c_int
hestMinNumArgs.argtypes = [POINTER(hestOpt)]
hestUsage = libteem.hestUsage
hestUsage.restype = None
hestUsage.argtypes = [POINTER(FILE), POINTER(hestOpt), STRING, POINTER(hestParm)]
hestGlossary = libteem.hestGlossary
hestGlossary.restype = None
hestGlossary.argtypes = [POINTER(FILE), POINTER(hestOpt), POINTER(hestParm)]
hestInfo = libteem.hestInfo
hestInfo.restype = None
hestInfo.argtypes = [POINTER(FILE), STRING, STRING, POINTER(hestParm)]
hooverRenderBegin_t = CFUNCTYPE(c_int, POINTER(c_void_p), c_void_p)
hooverThreadBegin_t = CFUNCTYPE(c_int, POINTER(c_void_p), c_void_p, c_void_p, c_int)
hooverRayBegin_t = CFUNCTYPE(c_int, c_void_p, c_void_p, c_void_p, c_int, c_int, c_double, POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double))
hooverSample_t = CFUNCTYPE(c_double, c_void_p, c_void_p, c_void_p, c_int, c_double, c_int, POINTER(c_double), POINTER(c_double))
hooverRayEnd_t = CFUNCTYPE(c_int, c_void_p, c_void_p, c_void_p)
hooverThreadEnd_t = CFUNCTYPE(c_int, c_void_p, c_void_p, c_void_p)
hooverRenderEnd_t = CFUNCTYPE(c_int, c_void_p, c_void_p)
class hooverContext(Structure):
    pass
hooverContext._pack_ = 4
hooverContext._fields_ = [
    ('cam', POINTER(limnCamera)),
    ('volSize', c_int * 3),
    ('volSpacing', c_double * 3),
    ('volCentering', c_int),
    ('shape', POINTER(gageShape)),
    ('imgSize', c_int * 2),
    ('imgCentering', c_int),
    ('user', c_void_p),
    ('numThreads', c_uint),
    ('workIdx', c_int),
    ('workMutex', POINTER(airThreadMutex)),
    ('renderBegin', POINTER(hooverRenderBegin_t)),
    ('threadBegin', POINTER(hooverThreadBegin_t)),
    ('rayBegin', POINTER(hooverRayBegin_t)),
    ('sample', POINTER(hooverSample_t)),
    ('rayEnd', POINTER(hooverRayEnd_t)),
    ('threadEnd', POINTER(hooverThreadEnd_t)),
    ('renderEnd', POINTER(hooverRenderEnd_t)),
]
hooverPresent = (c_int).in_dll(libteem, 'hooverPresent')
hooverBiffKey = (STRING).in_dll(libteem, 'hooverBiffKey')
hooverDefVolCentering = (c_int).in_dll(libteem, 'hooverDefVolCentering')
hooverDefImgCentering = (c_int).in_dll(libteem, 'hooverDefImgCentering')
hooverErr = (POINTER(airEnum)).in_dll(libteem, 'hooverErr')
hooverContextNew = libteem.hooverContextNew
hooverContextNew.restype = POINTER(hooverContext)
hooverContextNew.argtypes = []
hooverContextCheck = libteem.hooverContextCheck
hooverContextCheck.restype = c_int
hooverContextCheck.argtypes = [POINTER(hooverContext)]
hooverContextNix = libteem.hooverContextNix
hooverContextNix.restype = None
hooverContextNix.argtypes = [POINTER(hooverContext)]
hooverRender = libteem.hooverRender
hooverRender.restype = c_int
hooverRender.argtypes = [POINTER(hooverContext), POINTER(c_int), POINTER(c_int)]
hooverStubRenderBegin = libteem.hooverStubRenderBegin
hooverStubRenderBegin.restype = c_int
hooverStubRenderBegin.argtypes = [POINTER(c_void_p), c_void_p]
hooverStubThreadBegin = libteem.hooverStubThreadBegin
hooverStubThreadBegin.restype = c_int
hooverStubThreadBegin.argtypes = [POINTER(c_void_p), c_void_p, c_void_p, c_int]
hooverStubRayBegin = libteem.hooverStubRayBegin
hooverStubRayBegin.restype = c_int
hooverStubRayBegin.argtypes = [c_void_p, c_void_p, c_void_p, c_int, c_int, c_double, POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double)]
hooverStubSample = libteem.hooverStubSample
hooverStubSample.restype = c_double
hooverStubSample.argtypes = [c_void_p, c_void_p, c_void_p, c_int, c_double, c_int, POINTER(c_double), POINTER(c_double)]
hooverStubRayEnd = libteem.hooverStubRayEnd
hooverStubRayEnd.restype = c_int
hooverStubRayEnd.argtypes = [c_void_p, c_void_p, c_void_p]
hooverStubThreadEnd = libteem.hooverStubThreadEnd
hooverStubThreadEnd.restype = c_int
hooverStubThreadEnd.argtypes = [c_void_p, c_void_p, c_void_p]
hooverStubRenderEnd = libteem.hooverStubRenderEnd
hooverStubRenderEnd.restype = c_int
hooverStubRenderEnd.argtypes = [c_void_p, c_void_p]
limnCamera_t._pack_ = 4
limnCamera_t._fields_ = [
    ('from', c_double * 3),
    ('at', c_double * 3),
    ('up', c_double * 3),
    ('uRange', c_double * 2),
    ('vRange', c_double * 2),
    ('fov', c_double),
    ('aspect', c_double),
    ('neer', c_double),
    ('faar', c_double),
    ('dist', c_double),
    ('atRelative', c_int),
    ('orthographic', c_int),
    ('rightHanded', c_int),
    ('W2V', c_double * 16),
    ('V2W', c_double * 16),
    ('U', c_double * 4),
    ('V', c_double * 4),
    ('N', c_double * 4),
    ('vspNeer', c_double),
    ('vspFaar', c_double),
    ('vspDist', c_double),
]
class limnLight(Structure):
    pass
limnLight._fields_ = [
    ('amb', c_float * 4),
    ('_dir', c_float * 4 * 8),
    ('dir', c_float * 4 * 8),
    ('col', c_float * 4 * 8),
    ('on', c_int * 8),
    ('vsp', c_int * 8),
]
class limnOptsPS(Structure):
    pass
limnOptsPS._fields_ = [
    ('lineWidth', c_float * 8),
    ('creaseAngle', c_float),
    ('bg', c_float * 3),
    ('edgeColor', c_float * 3),
    ('showpage', c_int),
    ('wireFrame', c_int),
    ('noBackground', c_int),
]
class limnWindow(Structure):
    pass
limnWindow._fields_ = [
    ('ps', limnOptsPS),
    ('device', c_int),
    ('scale', c_float),
    ('bbox', c_float * 4),
    ('yFlip', c_int),
    ('file', POINTER(FILE)),
]
class limnLook(Structure):
    pass
limnLook._fields_ = [
    ('rgba', c_float * 4),
    ('kads', c_float * 3),
    ('spow', c_float),
]
class limnVertex(Structure):
    pass
limnVertex._fields_ = [
    ('world', c_float * 4),
    ('rgba', c_float * 4),
    ('coord', c_float * 4),
    ('worldNormal', c_float * 3),
]
class limnEdge_t(Structure):
    pass
limnEdge_t._fields_ = [
    ('vertIdx', c_uint * 2),
    ('lookIdx', c_uint),
    ('partIdx', c_uint),
    ('type', c_int),
    ('faceIdx', c_int * 2),
    ('once', c_int),
]
limnEdge = limnEdge_t
class limnFace_t(Structure):
    pass
limnFace_t._fields_ = [
    ('worldNormal', c_float * 3),
    ('screenNormal', c_float * 3),
    ('vertIdx', POINTER(c_uint)),
    ('edgeIdx', POINTER(c_uint)),
    ('sideNum', c_uint),
    ('lookIdx', c_uint),
    ('partIdx', c_uint),
    ('visible', c_int),
    ('depth', c_float),
]
limnFace = limnFace_t
class limnPart_t(Structure):
    pass
limnPart_t._fields_ = [
    ('vertIdx', POINTER(c_uint)),
    ('vertIdxNum', c_uint),
    ('vertIdxArr', POINTER(airArray)),
    ('edgeIdx', POINTER(c_uint)),
    ('edgeIdxNum', c_uint),
    ('edgeIdxArr', POINTER(airArray)),
    ('faceIdx', POINTER(c_uint)),
    ('faceIdxNum', c_uint),
    ('faceIdxArr', POINTER(airArray)),
    ('lookIdx', c_int),
    ('depth', c_float),
]
limnPart = limnPart_t
class limnObject(Structure):
    pass
limnObject._fields_ = [
    ('vert', POINTER(limnVertex)),
    ('vertNum', c_uint),
    ('vertArr', POINTER(airArray)),
    ('edge', POINTER(limnEdge)),
    ('edgeNum', c_uint),
    ('edgeArr', POINTER(airArray)),
    ('face', POINTER(limnFace)),
    ('faceNum', c_uint),
    ('faceArr', POINTER(airArray)),
    ('faceSort', POINTER(POINTER(limnFace))),
    ('part', POINTER(POINTER(limnPart))),
    ('partNum', c_uint),
    ('partArr', POINTER(airArray)),
    ('partPool', POINTER(POINTER(limnPart))),
    ('partPoolNum', c_uint),
    ('partPoolArr', POINTER(airArray)),
    ('look', POINTER(limnLook)),
    ('lookNum', c_uint),
    ('lookArr', POINTER(airArray)),
    ('vertSpace', c_int),
    ('setVertexRGBAFromLook', c_int),
    ('doEdges', c_int),
    ('incr', c_uint),
]
limnPolyData._fields_ = [
    ('xyzw', POINTER(c_float)),
    ('xyzwNum', c_uint),
    ('rgba', POINTER(c_ubyte)),
    ('rgbaNum', c_uint),
    ('norm', POINTER(c_float)),
    ('normNum', c_uint),
    ('tex2', POINTER(c_float)),
    ('tex2Num', c_uint),
    ('tang', POINTER(c_float)),
    ('tangNum', c_uint),
    ('indxNum', c_uint),
    ('indx', POINTER(c_uint)),
    ('primNum', c_uint),
    ('type', POINTER(c_ubyte)),
    ('icnt', POINTER(c_uint)),
]
class limnSpline_t(Structure):
    pass
limnSpline_t._pack_ = 4
limnSpline_t._fields_ = [
    ('type', c_int),
    ('info', c_int),
    ('loop', c_int),
    ('B', c_double),
    ('C', c_double),
    ('ncpt', POINTER(Nrrd)),
    ('time', POINTER(c_double)),
]
limnSpline = limnSpline_t
class limnSplineTypeSpec_t(Structure):
    pass
limnSplineTypeSpec_t._pack_ = 4
limnSplineTypeSpec_t._fields_ = [
    ('type', c_int),
    ('B', c_double),
    ('C', c_double),
]
limnSplineTypeSpec = limnSplineTypeSpec_t
limnPresent = (c_int).in_dll(libteem, 'limnPresent')
limnBiffKey = (STRING).in_dll(libteem, 'limnBiffKey')
limnDefCameraAtRelative = (c_int).in_dll(libteem, 'limnDefCameraAtRelative')
limnDefCameraOrthographic = (c_int).in_dll(libteem, 'limnDefCameraOrthographic')
limnDefCameraRightHanded = (c_int).in_dll(libteem, 'limnDefCameraRightHanded')
limnSpace = (POINTER(airEnum)).in_dll(libteem, 'limnSpace')
limnPolyDataInfo = (POINTER(airEnum)).in_dll(libteem, 'limnPolyDataInfo')
limnCameraPathTrack = (POINTER(airEnum)).in_dll(libteem, 'limnCameraPathTrack')
limnPrimitive = (POINTER(airEnum)).in_dll(libteem, 'limnPrimitive')
limnQNBins = (c_uint * 17).in_dll(libteem, 'limnQNBins')
limnQNtoV_f = (CFUNCTYPE(None, POINTER(c_float), c_uint) * 17).in_dll(libteem, 'limnQNtoV_f')
limnQNtoV_d = (CFUNCTYPE(None, POINTER(c_double), c_uint) * 17).in_dll(libteem, 'limnQNtoV_d')
limnVtoQN_f = (CFUNCTYPE(c_uint, POINTER(c_float)) * 17).in_dll(libteem, 'limnVtoQN_f')
limnVtoQN_d = (CFUNCTYPE(c_uint, POINTER(c_double)) * 17).in_dll(libteem, 'limnVtoQN_d')
limnQNDemo = libteem.limnQNDemo
limnQNDemo.restype = c_int
limnQNDemo.argtypes = [POINTER(Nrrd), c_uint, c_int]
limnLightSet = libteem.limnLightSet
limnLightSet.restype = None
limnLightSet.argtypes = [POINTER(limnLight), c_int, c_int, c_float, c_float, c_float, c_float, c_float, c_float]
limnLightAmbientSet = libteem.limnLightAmbientSet
limnLightAmbientSet.restype = None
limnLightAmbientSet.argtypes = [POINTER(limnLight), c_float, c_float, c_float]
limnLightSwitch = libteem.limnLightSwitch
limnLightSwitch.restype = None
limnLightSwitch.argtypes = [POINTER(limnLight), c_int, c_int]
limnLightReset = libteem.limnLightReset
limnLightReset.restype = None
limnLightReset.argtypes = [POINTER(limnLight)]
limnLightUpdate = libteem.limnLightUpdate
limnLightUpdate.restype = c_int
limnLightUpdate.argtypes = [POINTER(limnLight), POINTER(limnCamera)]
limnEnvMapCB = CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), c_void_p)
limnEnvMapFill = libteem.limnEnvMapFill
limnEnvMapFill.restype = c_int
limnEnvMapFill.argtypes = [POINTER(Nrrd), limnEnvMapCB, c_int, c_void_p]
limnLightDiffuseCB = libteem.limnLightDiffuseCB
limnLightDiffuseCB.restype = None
limnLightDiffuseCB.argtypes = [POINTER(c_float), POINTER(c_float), c_void_p]
limnEnvMapCheck = libteem.limnEnvMapCheck
limnEnvMapCheck.restype = c_int
limnEnvMapCheck.argtypes = [POINTER(Nrrd)]
limnLightNew = libteem.limnLightNew
limnLightNew.restype = POINTER(limnLight)
limnLightNew.argtypes = []
limnCameraInit = libteem.limnCameraInit
limnCameraInit.restype = None
limnCameraInit.argtypes = [POINTER(limnCamera)]
limnLightNix = libteem.limnLightNix
limnLightNix.restype = POINTER(limnLight)
limnLightNix.argtypes = [POINTER(limnLight)]
limnCameraNew = libteem.limnCameraNew
limnCameraNew.restype = POINTER(limnCamera)
limnCameraNew.argtypes = []
limnCameraNix = libteem.limnCameraNix
limnCameraNix.restype = POINTER(limnCamera)
limnCameraNix.argtypes = [POINTER(limnCamera)]
limnWindowNew = libteem.limnWindowNew
limnWindowNew.restype = POINTER(limnWindow)
limnWindowNew.argtypes = [c_int]
limnWindowNix = libteem.limnWindowNix
limnWindowNix.restype = POINTER(limnWindow)
limnWindowNix.argtypes = [POINTER(limnWindow)]
limnHestCameraOptAdd = libteem.limnHestCameraOptAdd
limnHestCameraOptAdd.restype = None
limnHestCameraOptAdd.argtypes = [POINTER(POINTER(hestOpt)), POINTER(limnCamera), STRING, STRING, STRING, STRING, STRING, STRING, STRING, STRING, STRING]
limnCameraAspectSet = libteem.limnCameraAspectSet
limnCameraAspectSet.restype = c_int
limnCameraAspectSet.argtypes = [POINTER(limnCamera), c_uint, c_uint, c_int]
limnCameraUpdate = libteem.limnCameraUpdate
limnCameraUpdate.restype = c_int
limnCameraUpdate.argtypes = [POINTER(limnCamera)]
limnCameraPathMake = libteem.limnCameraPathMake
limnCameraPathMake.restype = c_int
limnCameraPathMake.argtypes = [POINTER(limnCamera), c_int, POINTER(limnCamera), POINTER(c_double), c_int, c_int, POINTER(limnSplineTypeSpec), POINTER(limnSplineTypeSpec), POINTER(limnSplineTypeSpec), POINTER(limnSplineTypeSpec)]
limnObjectLookAdd = libteem.limnObjectLookAdd
limnObjectLookAdd.restype = c_int
limnObjectLookAdd.argtypes = [POINTER(limnObject)]
limnObjectNew = libteem.limnObjectNew
limnObjectNew.restype = POINTER(limnObject)
limnObjectNew.argtypes = [c_int, c_int]
limnObjectNix = libteem.limnObjectNix
limnObjectNix.restype = POINTER(limnObject)
limnObjectNix.argtypes = [POINTER(limnObject)]
limnObjectEmpty = libteem.limnObjectEmpty
limnObjectEmpty.restype = None
limnObjectEmpty.argtypes = [POINTER(limnObject)]
limnObjectPreSet = libteem.limnObjectPreSet
limnObjectPreSet.restype = c_int
limnObjectPreSet.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint, c_uint, c_uint]
limnObjectPartAdd = libteem.limnObjectPartAdd
limnObjectPartAdd.restype = c_int
limnObjectPartAdd.argtypes = [POINTER(limnObject)]
limnObjectVertexNumPreSet = libteem.limnObjectVertexNumPreSet
limnObjectVertexNumPreSet.restype = c_int
limnObjectVertexNumPreSet.argtypes = [POINTER(limnObject), c_uint, c_uint]
limnObjectVertexAdd = libteem.limnObjectVertexAdd
limnObjectVertexAdd.restype = c_int
limnObjectVertexAdd.argtypes = [POINTER(limnObject), c_uint, c_float, c_float, c_float]
limnObjectEdgeAdd = libteem.limnObjectEdgeAdd
limnObjectEdgeAdd.restype = c_int
limnObjectEdgeAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint, c_uint, c_uint]
limnObjectFaceNumPreSet = libteem.limnObjectFaceNumPreSet
limnObjectFaceNumPreSet.restype = c_int
limnObjectFaceNumPreSet.argtypes = [POINTER(limnObject), c_uint, c_uint]
limnObjectFaceAdd = libteem.limnObjectFaceAdd
limnObjectFaceAdd.restype = c_int
limnObjectFaceAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint, POINTER(c_uint)]
limnPolyDataNew = libteem.limnPolyDataNew
limnPolyDataNew.restype = POINTER(limnPolyData)
limnPolyDataNew.argtypes = []
limnPolyDataNix = libteem.limnPolyDataNix
limnPolyDataNix.restype = POINTER(limnPolyData)
limnPolyDataNix.argtypes = [POINTER(limnPolyData)]
limnPolyDataInfoBitFlag = libteem.limnPolyDataInfoBitFlag
limnPolyDataInfoBitFlag.restype = c_uint
limnPolyDataInfoBitFlag.argtypes = [POINTER(limnPolyData)]
limnPolyDataAlloc = libteem.limnPolyDataAlloc
limnPolyDataAlloc.restype = c_int
limnPolyDataAlloc.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_uint, c_uint]
limnPolyDataSize = libteem.limnPolyDataSize
limnPolyDataSize.restype = c_size_t
limnPolyDataSize.argtypes = [POINTER(limnPolyData)]
limnPolyDataCopy = libteem.limnPolyDataCopy
limnPolyDataCopy.restype = c_int
limnPolyDataCopy.argtypes = [POINTER(limnPolyData), POINTER(limnPolyData)]
limnPolyDataCopyN = libteem.limnPolyDataCopyN
limnPolyDataCopyN.restype = c_int
limnPolyDataCopyN.argtypes = [POINTER(limnPolyData), POINTER(limnPolyData), c_uint]
limnPolyDataTransform_f = libteem.limnPolyDataTransform_f
limnPolyDataTransform_f.restype = None
limnPolyDataTransform_f.argtypes = [POINTER(limnPolyData), POINTER(c_float)]
limnPolyDataTransform_d = libteem.limnPolyDataTransform_d
limnPolyDataTransform_d.restype = None
limnPolyDataTransform_d.argtypes = [POINTER(limnPolyData), POINTER(c_double)]
limnPolyDataPolygonNumber = libteem.limnPolyDataPolygonNumber
limnPolyDataPolygonNumber.restype = c_uint
limnPolyDataPolygonNumber.argtypes = [POINTER(limnPolyData)]
limnPolyDataVertexNormals = libteem.limnPolyDataVertexNormals
limnPolyDataVertexNormals.restype = c_int
limnPolyDataVertexNormals.argtypes = [POINTER(limnPolyData)]
limnPolyDataVertexNormalsNO = libteem.limnPolyDataVertexNormalsNO
limnPolyDataVertexNormalsNO.restype = c_int
limnPolyDataVertexNormalsNO.argtypes = [POINTER(limnPolyData)]
limnPolyDataPrimitiveTypes = libteem.limnPolyDataPrimitiveTypes
limnPolyDataPrimitiveTypes.restype = c_uint
limnPolyDataPrimitiveTypes.argtypes = [POINTER(limnPolyData)]
limnPolyDataPrimitiveVertexNumber = libteem.limnPolyDataPrimitiveVertexNumber
limnPolyDataPrimitiveVertexNumber.restype = c_int
limnPolyDataPrimitiveVertexNumber.argtypes = [POINTER(Nrrd), POINTER(limnPolyData)]
limnPolyDataPrimitiveArea = libteem.limnPolyDataPrimitiveArea
limnPolyDataPrimitiveArea.restype = c_int
limnPolyDataPrimitiveArea.argtypes = [POINTER(Nrrd), POINTER(limnPolyData)]
limnPolyDataRasterize = libteem.limnPolyDataRasterize
limnPolyDataRasterize.restype = c_int
limnPolyDataRasterize.argtypes = [POINTER(Nrrd), POINTER(limnPolyData), POINTER(c_double), POINTER(c_double), POINTER(c_size_t), c_int]
limnPolyDataColorSet = libteem.limnPolyDataColorSet
limnPolyDataColorSet.restype = None
limnPolyDataColorSet.argtypes = [POINTER(limnPolyData), c_ubyte, c_ubyte, c_ubyte, c_ubyte]
limnPolyDataCube = libteem.limnPolyDataCube
limnPolyDataCube.restype = c_int
limnPolyDataCube.argtypes = [POINTER(limnPolyData), c_uint, c_int]
limnPolyDataCubeTriangles = libteem.limnPolyDataCubeTriangles
limnPolyDataCubeTriangles.restype = c_int
limnPolyDataCubeTriangles.argtypes = [POINTER(limnPolyData), c_uint, c_int]
limnPolyDataOctahedron = libteem.limnPolyDataOctahedron
limnPolyDataOctahedron.restype = c_int
limnPolyDataOctahedron.argtypes = [POINTER(limnPolyData), c_uint, c_int]
limnPolyDataCone = libteem.limnPolyDataCone
limnPolyDataCone.restype = c_int
limnPolyDataCone.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_int]
limnPolyDataCylinder = libteem.limnPolyDataCylinder
limnPolyDataCylinder.restype = c_int
limnPolyDataCylinder.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_int]
limnPolyDataSuperquadric = libteem.limnPolyDataSuperquadric
limnPolyDataSuperquadric.restype = c_int
limnPolyDataSuperquadric.argtypes = [POINTER(limnPolyData), c_uint, c_float, c_float, c_uint, c_uint]
limnPolyDataSpiralBetterquadric = libteem.limnPolyDataSpiralBetterquadric
limnPolyDataSpiralBetterquadric.restype = c_int
limnPolyDataSpiralBetterquadric.argtypes = [POINTER(limnPolyData), c_uint, c_float, c_float, c_float, c_float, c_uint, c_uint]
limnPolyDataSpiralSuperquadric = libteem.limnPolyDataSpiralSuperquadric
limnPolyDataSpiralSuperquadric.restype = c_int
limnPolyDataSpiralSuperquadric.argtypes = [POINTER(limnPolyData), c_uint, c_float, c_float, c_uint, c_uint]
limnPolyDataPolarSphere = libteem.limnPolyDataPolarSphere
limnPolyDataPolarSphere.restype = c_int
limnPolyDataPolarSphere.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_uint]
limnPolyDataSpiralSphere = libteem.limnPolyDataSpiralSphere
limnPolyDataSpiralSphere.restype = c_int
limnPolyDataSpiralSphere.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_uint]
limnPolyDataIcoSphere = libteem.limnPolyDataIcoSphere
limnPolyDataIcoSphere.restype = c_int
limnPolyDataIcoSphere.argtypes = [POINTER(limnPolyData), c_uint, c_uint]
limnPolyDataPlane = libteem.limnPolyDataPlane
limnPolyDataPlane.restype = c_int
limnPolyDataPlane.argtypes = [POINTER(limnPolyData), c_uint, c_uint, c_uint]
limnPolyDataSquare = libteem.limnPolyDataSquare
limnPolyDataSquare.restype = c_int
limnPolyDataSquare.argtypes = [POINTER(limnPolyData), c_uint]
limnPolyDataEdgeHalve = libteem.limnPolyDataEdgeHalve
limnPolyDataEdgeHalve.restype = c_int
limnPolyDataEdgeHalve.argtypes = [POINTER(limnPolyData), POINTER(limnPolyData)]
limnPolyDataVertexWindingFix = libteem.limnPolyDataVertexWindingFix
limnPolyDataVertexWindingFix.restype = c_int
limnPolyDataVertexWindingFix.argtypes = [POINTER(limnPolyData), c_int]
limnPolyDataClip = libteem.limnPolyDataClip
limnPolyDataClip.restype = c_int
limnPolyDataClip.argtypes = [POINTER(limnPolyData), POINTER(Nrrd), c_double]
limnPolyDataClipMulti = libteem.limnPolyDataClipMulti
limnPolyDataClipMulti.restype = c_int
limnPolyDataClipMulti.argtypes = [POINTER(limnPolyData), POINTER(Nrrd), POINTER(c_double)]
limnPolyDataCompress = libteem.limnPolyDataCompress
limnPolyDataCompress.restype = POINTER(limnPolyData)
limnPolyDataCompress.argtypes = [POINTER(limnPolyData)]
limnPolyDataJoin = libteem.limnPolyDataJoin
limnPolyDataJoin.restype = POINTER(limnPolyData)
limnPolyDataJoin.argtypes = [POINTER(POINTER(limnPolyData)), c_uint]
limnPolyDataVertexWindingFlip = libteem.limnPolyDataVertexWindingFlip
limnPolyDataVertexWindingFlip.restype = c_int
limnPolyDataVertexWindingFlip.argtypes = [POINTER(limnPolyData)]
limnPolyDataCCFind = libteem.limnPolyDataCCFind
limnPolyDataCCFind.restype = c_int
limnPolyDataCCFind.argtypes = [POINTER(limnPolyData)]
limnPolyDataPrimitiveSort = libteem.limnPolyDataPrimitiveSort
limnPolyDataPrimitiveSort.restype = c_int
limnPolyDataPrimitiveSort.argtypes = [POINTER(limnPolyData), POINTER(Nrrd)]
limnPolyDataPrimitiveSelect = libteem.limnPolyDataPrimitiveSelect
limnPolyDataPrimitiveSelect.restype = c_int
limnPolyDataPrimitiveSelect.argtypes = [POINTER(limnPolyData), POINTER(limnPolyData), POINTER(Nrrd)]
limnPolyDataNeighborList = libteem.limnPolyDataNeighborList
limnPolyDataNeighborList.restype = c_int
limnPolyDataNeighborList.argtypes = [POINTER(POINTER(c_uint)), POINTER(c_size_t), POINTER(c_uint), POINTER(limnPolyData)]
limnPolyDataNeighborArray = libteem.limnPolyDataNeighborArray
limnPolyDataNeighborArray.restype = c_int
limnPolyDataNeighborArray.argtypes = [POINTER(POINTER(c_int)), POINTER(c_uint), POINTER(limnPolyData)]
limnPolyDataNeighborArrayComp = libteem.limnPolyDataNeighborArrayComp
limnPolyDataNeighborArrayComp.restype = c_int
limnPolyDataNeighborArrayComp.argtypes = [POINTER(POINTER(c_int)), POINTER(POINTER(c_int)), POINTER(limnPolyData)]
limnPolyDataSpiralTubeWrap = libteem.limnPolyDataSpiralTubeWrap
limnPolyDataSpiralTubeWrap.restype = c_int
limnPolyDataSpiralTubeWrap.argtypes = [POINTER(limnPolyData), POINTER(limnPolyData), c_uint, POINTER(Nrrd), c_uint, c_uint, c_double]
limnPolyDataSmoothHC = libteem.limnPolyDataSmoothHC
limnPolyDataSmoothHC.restype = c_int
limnPolyDataSmoothHC.argtypes = [POINTER(limnPolyData), POINTER(c_int), POINTER(c_int), c_double, c_double, c_int]
limnObjectDescribe = libteem.limnObjectDescribe
limnObjectDescribe.restype = c_int
limnObjectDescribe.argtypes = [POINTER(FILE), POINTER(limnObject)]
limnObjectReadOFF = libteem.limnObjectReadOFF
limnObjectReadOFF.restype = c_int
limnObjectReadOFF.argtypes = [POINTER(limnObject), POINTER(FILE)]
limnObjectWriteOFF = libteem.limnObjectWriteOFF
limnObjectWriteOFF.restype = c_int
limnObjectWriteOFF.argtypes = [POINTER(FILE), POINTER(limnObject)]
limnPolyDataWriteIV = libteem.limnPolyDataWriteIV
limnPolyDataWriteIV.restype = c_int
limnPolyDataWriteIV.argtypes = [POINTER(FILE), POINTER(limnPolyData)]
limnPolyDataWriteLMPD = libteem.limnPolyDataWriteLMPD
limnPolyDataWriteLMPD.restype = c_int
limnPolyDataWriteLMPD.argtypes = [POINTER(FILE), POINTER(limnPolyData)]
limnPolyDataReadLMPD = libteem.limnPolyDataReadLMPD
limnPolyDataReadLMPD.restype = c_int
limnPolyDataReadLMPD.argtypes = [POINTER(limnPolyData), POINTER(FILE)]
limnPolyDataWriteVTK = libteem.limnPolyDataWriteVTK
limnPolyDataWriteVTK.restype = c_int
limnPolyDataWriteVTK.argtypes = [POINTER(FILE), POINTER(limnPolyData)]
limnPolyDataReadOFF = libteem.limnPolyDataReadOFF
limnPolyDataReadOFF.restype = c_int
limnPolyDataReadOFF.argtypes = [POINTER(limnPolyData), POINTER(FILE)]
limnPolyDataSave = libteem.limnPolyDataSave
limnPolyDataSave.restype = c_int
limnPolyDataSave.argtypes = [STRING, POINTER(limnPolyData)]
limnHestPolyDataLMPD = (POINTER(hestCB)).in_dll(libteem, 'limnHestPolyDataLMPD')
limnHestPolyDataOFF = (POINTER(hestCB)).in_dll(libteem, 'limnHestPolyDataOFF')
limnObjectCubeAdd = libteem.limnObjectCubeAdd
limnObjectCubeAdd.restype = c_int
limnObjectCubeAdd.argtypes = [POINTER(limnObject), c_uint]
limnObjectSquareAdd = libteem.limnObjectSquareAdd
limnObjectSquareAdd.restype = c_int
limnObjectSquareAdd.argtypes = [POINTER(limnObject), c_uint]
limnObjectCylinderAdd = libteem.limnObjectCylinderAdd
limnObjectCylinderAdd.restype = c_int
limnObjectCylinderAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint]
limnObjectPolarSphereAdd = libteem.limnObjectPolarSphereAdd
limnObjectPolarSphereAdd.restype = c_int
limnObjectPolarSphereAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint, c_uint]
limnObjectConeAdd = libteem.limnObjectConeAdd
limnObjectConeAdd.restype = c_int
limnObjectConeAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_uint]
limnObjectPolarSuperquadAdd = libteem.limnObjectPolarSuperquadAdd
limnObjectPolarSuperquadAdd.restype = c_int
limnObjectPolarSuperquadAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_float, c_float, c_uint, c_uint]
limnObjectPolarSuperquadFancyAdd = libteem.limnObjectPolarSuperquadFancyAdd
limnObjectPolarSuperquadFancyAdd.restype = c_int
limnObjectPolarSuperquadFancyAdd.argtypes = [POINTER(limnObject), c_uint, c_uint, c_float, c_float, c_float, c_float, c_uint, c_uint]
limnObjectWorldHomog = libteem.limnObjectWorldHomog
limnObjectWorldHomog.restype = c_int
limnObjectWorldHomog.argtypes = [POINTER(limnObject)]
limnObjectFaceNormals = libteem.limnObjectFaceNormals
limnObjectFaceNormals.restype = c_int
limnObjectFaceNormals.argtypes = [POINTER(limnObject), c_int]
limnObjectVertexNormals = libteem.limnObjectVertexNormals
limnObjectVertexNormals.restype = c_int
limnObjectVertexNormals.argtypes = [POINTER(limnObject)]
limnObjectSpaceTransform = libteem.limnObjectSpaceTransform
limnObjectSpaceTransform.restype = c_int
limnObjectSpaceTransform.argtypes = [POINTER(limnObject), POINTER(limnCamera), POINTER(limnWindow), c_int]
limnObjectPartTransform = libteem.limnObjectPartTransform
limnObjectPartTransform.restype = c_int
limnObjectPartTransform.argtypes = [POINTER(limnObject), c_uint, POINTER(c_float)]
limnObjectDepthSortParts = libteem.limnObjectDepthSortParts
limnObjectDepthSortParts.restype = c_int
limnObjectDepthSortParts.argtypes = [POINTER(limnObject)]
limnObjectDepthSortFaces = libteem.limnObjectDepthSortFaces
limnObjectDepthSortFaces.restype = c_int
limnObjectDepthSortFaces.argtypes = [POINTER(limnObject)]
limnObjectFaceReverse = libteem.limnObjectFaceReverse
limnObjectFaceReverse.restype = c_int
limnObjectFaceReverse.argtypes = [POINTER(limnObject)]
limnObjectRender = libteem.limnObjectRender
limnObjectRender.restype = c_int
limnObjectRender.argtypes = [POINTER(limnObject), POINTER(limnCamera), POINTER(limnWindow)]
limnObjectPSDraw = libteem.limnObjectPSDraw
limnObjectPSDraw.restype = c_int
limnObjectPSDraw.argtypes = [POINTER(limnObject), POINTER(limnCamera), POINTER(Nrrd), POINTER(limnWindow)]
limnObjectPSDrawConcave = libteem.limnObjectPSDrawConcave
limnObjectPSDrawConcave.restype = c_int
limnObjectPSDrawConcave.argtypes = [POINTER(limnObject), POINTER(limnCamera), POINTER(Nrrd), POINTER(limnWindow)]
limnSplineTypeSpecNew = libteem.limnSplineTypeSpecNew
limnSplineTypeSpecNew.restype = POINTER(limnSplineTypeSpec)
limnSplineTypeSpecNew.argtypes = [c_int]
limnSplineTypeSpecNix = libteem.limnSplineTypeSpecNix
limnSplineTypeSpecNix.restype = POINTER(limnSplineTypeSpec)
limnSplineTypeSpecNix.argtypes = [POINTER(limnSplineTypeSpec)]
limnSplineNew = libteem.limnSplineNew
limnSplineNew.restype = POINTER(limnSpline)
limnSplineNew.argtypes = [POINTER(Nrrd), c_int, POINTER(limnSplineTypeSpec)]
limnSplineNix = libteem.limnSplineNix
limnSplineNix.restype = POINTER(limnSpline)
limnSplineNix.argtypes = [POINTER(limnSpline)]
limnSplineNrrdCleverFix = libteem.limnSplineNrrdCleverFix
limnSplineNrrdCleverFix.restype = c_int
limnSplineNrrdCleverFix.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_int]
limnSplineCleverNew = libteem.limnSplineCleverNew
limnSplineCleverNew.restype = POINTER(limnSpline)
limnSplineCleverNew.argtypes = [POINTER(Nrrd), c_int, POINTER(limnSplineTypeSpec)]
limnSplineUpdate = libteem.limnSplineUpdate
limnSplineUpdate.restype = c_int
limnSplineUpdate.argtypes = [POINTER(limnSpline), POINTER(Nrrd)]
limnSplineType = (POINTER(airEnum)).in_dll(libteem, 'limnSplineType')
limnSplineInfo = (POINTER(airEnum)).in_dll(libteem, 'limnSplineInfo')
limnSplineParse = libteem.limnSplineParse
limnSplineParse.restype = POINTER(limnSpline)
limnSplineParse.argtypes = [STRING]
limnSplineTypeSpecParse = libteem.limnSplineTypeSpecParse
limnSplineTypeSpecParse.restype = POINTER(limnSplineTypeSpec)
limnSplineTypeSpecParse.argtypes = [STRING]
limnHestSpline = (POINTER(hestCB)).in_dll(libteem, 'limnHestSpline')
limnHestSplineTypeSpec = (POINTER(hestCB)).in_dll(libteem, 'limnHestSplineTypeSpec')
limnSplineInfoSize = (c_uint * 7).in_dll(libteem, 'limnSplineInfoSize')
limnSplineTypeHasImplicitTangents = (c_int * 6).in_dll(libteem, 'limnSplineTypeHasImplicitTangents')
limnSplineNumPoints = libteem.limnSplineNumPoints
limnSplineNumPoints.restype = c_int
limnSplineNumPoints.argtypes = [POINTER(limnSpline)]
limnSplineMinT = libteem.limnSplineMinT
limnSplineMinT.restype = c_double
limnSplineMinT.argtypes = [POINTER(limnSpline)]
limnSplineMaxT = libteem.limnSplineMaxT
limnSplineMaxT.restype = c_double
limnSplineMaxT.argtypes = [POINTER(limnSpline)]
limnSplineBCSet = libteem.limnSplineBCSet
limnSplineBCSet.restype = None
limnSplineBCSet.argtypes = [POINTER(limnSpline), c_double, c_double]
limnSplineEvaluate = libteem.limnSplineEvaluate
limnSplineEvaluate.restype = None
limnSplineEvaluate.argtypes = [POINTER(c_double), POINTER(limnSpline), c_double]
limnSplineNrrdEvaluate = libteem.limnSplineNrrdEvaluate
limnSplineNrrdEvaluate.restype = c_int
limnSplineNrrdEvaluate.argtypes = [POINTER(Nrrd), POINTER(limnSpline), POINTER(Nrrd)]
limnSplineSample = libteem.limnSplineSample
limnSplineSample.restype = c_int
limnSplineSample.argtypes = [POINTER(Nrrd), POINTER(limnSpline), c_double, c_size_t, c_double]
meetPresent = (c_int).in_dll(libteem, 'meetPresent')
meetBiffKey = (STRING).in_dll(libteem, 'meetBiffKey')
meetAirEnumAll = libteem.meetAirEnumAll
meetAirEnumAll.restype = POINTER(POINTER(airEnum))
meetAirEnumAll.argtypes = []
meetAirEnumAllPrint = libteem.meetAirEnumAllPrint
meetAirEnumAllPrint.restype = None
meetAirEnumAllPrint.argtypes = [POINTER(FILE)]
meetAirEnumAllCheck = libteem.meetAirEnumAllCheck
meetAirEnumAllCheck.restype = c_int
meetAirEnumAllCheck.argtypes = []
meetTeemLibs = (STRING * 0).in_dll(libteem, 'meetTeemLibs')
meetNrrdKernelAll = libteem.meetNrrdKernelAll
meetNrrdKernelAll.restype = POINTER(POINTER(NrrdKernel))
meetNrrdKernelAll.argtypes = []
meetNrrdKernelAllCheck = libteem.meetNrrdKernelAllCheck
meetNrrdKernelAllCheck.restype = c_int
meetNrrdKernelAllCheck.argtypes = []
meetGageKindParse = libteem.meetGageKindParse
meetGageKindParse.restype = POINTER(gageKind)
meetGageKindParse.argtypes = [STRING]
meetConstGageKindParse = libteem.meetConstGageKindParse
meetConstGageKindParse.restype = POINTER(gageKind)
meetConstGageKindParse.argtypes = [STRING]
meetHestGageKind = (POINTER(hestCB)).in_dll(libteem, 'meetHestGageKind')
meetHestConstGageKind = (POINTER(hestCB)).in_dll(libteem, 'meetHestConstGageKind')
class meetPullVol(Structure):
    pass
meetPullVol._pack_ = 4
meetPullVol._fields_ = [
    ('kind', POINTER(gageKind)),
    ('fileName', STRING),
    ('volName', STRING),
    ('derivNormSS', c_int),
    ('uniformSS', c_int),
    ('optimSS', c_int),
    ('leeching', c_int),
    ('recomputedSS', c_int),
    ('numSS', c_uint),
    ('rangeSS', c_double * 2),
    ('derivNormBiasSS', c_double),
    ('posSS', POINTER(c_double)),
    ('nin', POINTER(Nrrd)),
    ('ninSS', POINTER(POINTER(Nrrd))),
]
class meetPullInfo(Structure):
    pass
meetPullInfo._pack_ = 4
meetPullInfo._fields_ = [
    ('info', c_int),
    ('source', c_int),
    ('prop', c_int),
    ('constraint', c_int),
    ('volName', STRING),
    ('itemStr', STRING),
    ('zero', c_double),
    ('scale', c_double),
]
meetPullVolNew = libteem.meetPullVolNew
meetPullVolNew.restype = POINTER(meetPullVol)
meetPullVolNew.argtypes = []
meetPullVolParse = libteem.meetPullVolParse
meetPullVolParse.restype = c_int
meetPullVolParse.argtypes = [POINTER(meetPullVol), STRING]
meetPullVolLeechable = libteem.meetPullVolLeechable
meetPullVolLeechable.restype = c_int
meetPullVolLeechable.argtypes = [POINTER(meetPullVol), POINTER(meetPullVol)]
meetPullVolNix = libteem.meetPullVolNix
meetPullVolNix.restype = POINTER(meetPullVol)
meetPullVolNix.argtypes = [POINTER(meetPullVol)]
meetHestPullVol = (POINTER(hestCB)).in_dll(libteem, 'meetHestPullVol')
meetPullVolLoadMulti = libteem.meetPullVolLoadMulti
meetPullVolLoadMulti.restype = c_int
meetPullVolLoadMulti.argtypes = [POINTER(POINTER(meetPullVol)), c_uint, STRING, POINTER(NrrdKernelSpec), c_int, c_double, c_int]
class pullContext_t(Structure):
    pass
pullContext = pullContext_t
meetPullVolAddMulti = libteem.meetPullVolAddMulti
meetPullVolAddMulti.restype = c_int
meetPullVolAddMulti.argtypes = [POINTER(pullContext), POINTER(POINTER(meetPullVol)), c_uint, POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec)]
meetPullInfoNew = libteem.meetPullInfoNew
meetPullInfoNew.restype = POINTER(meetPullInfo)
meetPullInfoNew.argtypes = []
meetPullInfoNix = libteem.meetPullInfoNix
meetPullInfoNix.restype = POINTER(meetPullInfo)
meetPullInfoNix.argtypes = [POINTER(meetPullInfo)]
meetPullInfoParse = libteem.meetPullInfoParse
meetPullInfoParse.restype = c_int
meetPullInfoParse.argtypes = [POINTER(meetPullInfo), STRING]
meetHestPullInfo = (POINTER(hestCB)).in_dll(libteem, 'meetHestPullInfo')
meetPullInfoAddMulti = libteem.meetPullInfoAddMulti
meetPullInfoAddMulti.restype = c_int
meetPullInfoAddMulti.argtypes = [POINTER(pullContext), POINTER(POINTER(meetPullInfo)), c_uint]
mite_t = c_double
class miteUser(Structure):
    pass
miteUser._pack_ = 4
miteUser._fields_ = [
    ('nsin', POINTER(Nrrd)),
    ('nvin', POINTER(Nrrd)),
    ('ntin', POINTER(Nrrd)),
    ('ntxf', POINTER(POINTER(Nrrd))),
    ('nout', POINTER(Nrrd)),
    ('debug', POINTER(c_double)),
    ('debugArr', POINTER(airArray)),
    ('ndebug', POINTER(Nrrd)),
    ('debugIdx', c_int),
    ('ntxfNum', c_int),
    ('shadeStr', c_char * 257),
    ('normalStr', c_char * 257),
    ('rangeInit', mite_t * 9),
    ('refStep', c_double),
    ('rayStep', c_double),
    ('opacMatters', c_double),
    ('opacNear1', c_double),
    ('hctx', POINTER(hooverContext)),
    ('fakeFrom', c_double * 3),
    ('vectorD', c_double * 3),
    ('ksp', POINTER(NrrdKernelSpec) * 8),
    ('shape', POINTER(gageShape)),
    ('gctx0', POINTER(gageContext)),
    ('lit', POINTER(limnLight)),
    ('normalSide', c_int),
    ('verbUi', c_int),
    ('verbVi', c_int),
    ('umop', POINTER(airArray)),
    ('rendTime', c_double),
    ('sampRate', c_double),
]
class miteShadeSpec(Structure):
    pass
miteShadeSpec._fields_ = [
    ('method', c_int),
    ('vec0', POINTER(gageItemSpec)),
    ('vec1', POINTER(gageItemSpec)),
    ('scl0', POINTER(gageItemSpec)),
    ('scl1', POINTER(gageItemSpec)),
]
class miteRender(Structure):
    pass
class miteThread_t(Structure):
    pass
miteRender._pack_ = 4
miteRender._fields_ = [
    ('ntxf', POINTER(POINTER(Nrrd))),
    ('ntxfNum', c_int),
    ('sclPvlIdx', c_int),
    ('vecPvlIdx', c_int),
    ('tenPvlIdx', c_int),
    ('shadeSpec', POINTER(miteShadeSpec)),
    ('normalSpec', POINTER(gageItemSpec)),
    ('time0', c_double),
    ('queryMite', gageQuery),
    ('queryMiteNonzero', c_int),
    ('tt', POINTER(miteThread_t) * 512),
    ('rmop', POINTER(airArray)),
]
class miteStage(Structure):
    pass
miteStage._pack_ = 4
miteStage._fields_ = [
    ('val', POINTER(c_double)),
    ('size', c_int),
    ('op', c_int),
    ('qn', CFUNCTYPE(c_uint, POINTER(c_double))),
    ('min', c_double),
    ('max', c_double),
    ('data', POINTER(mite_t)),
    ('rangeIdx', c_int * 9),
    ('rangeNum', c_int),
    ('label', STRING),
]
miteThread_t._pack_ = 4
miteThread_t._fields_ = [
    ('gctx', POINTER(gageContext)),
    ('ansScl', POINTER(c_double)),
    ('nPerp', POINTER(c_double)),
    ('geomTens', POINTER(c_double)),
    ('ansVec', POINTER(c_double)),
    ('ansTen', POINTER(c_double)),
    ('ansMiteVal', POINTER(c_double)),
    ('directAnsMiteVal', POINTER(POINTER(c_double))),
    ('_normal', POINTER(c_double)),
    ('shadeVec0', POINTER(c_double)),
    ('shadeVec1', POINTER(c_double)),
    ('shadeScl0', POINTER(c_double)),
    ('shadeScl1', POINTER(c_double)),
    ('verbose', c_int),
    ('skip', c_int),
    ('thrid', c_int),
    ('ui', c_int),
    ('vi', c_int),
    ('raySample', c_int),
    ('samples', c_int),
    ('stage', POINTER(miteStage)),
    ('stageNum', c_int),
    ('range', mite_t * 9),
    ('rayStep', mite_t),
    ('V', mite_t * 3),
    ('RR', mite_t),
    ('GG', mite_t),
    ('BB', mite_t),
    ('TT', mite_t),
    ('ZZ', mite_t),
    ('rmop', POINTER(airArray)),
]
miteThread = miteThread_t
mitePresent = (c_int).in_dll(libteem, 'mitePresent')
miteBiffKey = (STRING).in_dll(libteem, 'miteBiffKey')
miteDefRefStep = (c_double).in_dll(libteem, 'miteDefRefStep')
miteDefRenorm = (c_int).in_dll(libteem, 'miteDefRenorm')
miteDefNormalSide = (c_int).in_dll(libteem, 'miteDefNormalSide')
miteDefOpacNear1 = (c_double).in_dll(libteem, 'miteDefOpacNear1')
miteDefOpacMatters = (c_double).in_dll(libteem, 'miteDefOpacMatters')
miteVal = (POINTER(airEnum)).in_dll(libteem, 'miteVal')
miteValGageKind = (POINTER(gageKind)).in_dll(libteem, 'miteValGageKind')
miteStageOp = (POINTER(airEnum)).in_dll(libteem, 'miteStageOp')
miteRangeChar = (c_char * 10).in_dll(libteem, 'miteRangeChar')
miteVariableParse = libteem.miteVariableParse
miteVariableParse.restype = c_int
miteVariableParse.argtypes = [POINTER(gageItemSpec), STRING]
miteVariablePrint = libteem.miteVariablePrint
miteVariablePrint.restype = None
miteVariablePrint.argtypes = [STRING, POINTER(gageItemSpec)]
miteNtxfCheck = libteem.miteNtxfCheck
miteNtxfCheck.restype = c_int
miteNtxfCheck.argtypes = [POINTER(Nrrd)]
miteQueryAdd = libteem.miteQueryAdd
miteQueryAdd.restype = None
miteQueryAdd.argtypes = [POINTER(c_ubyte), POINTER(c_ubyte), POINTER(c_ubyte), POINTER(c_ubyte), POINTER(gageItemSpec)]
miteUserNew = libteem.miteUserNew
miteUserNew.restype = POINTER(miteUser)
miteUserNew.argtypes = []
miteUserNix = libteem.miteUserNix
miteUserNix.restype = POINTER(miteUser)
miteUserNix.argtypes = [POINTER(miteUser)]
miteShadeSpecNew = libteem.miteShadeSpecNew
miteShadeSpecNew.restype = POINTER(miteShadeSpec)
miteShadeSpecNew.argtypes = []
miteShadeSpecNix = libteem.miteShadeSpecNix
miteShadeSpecNix.restype = POINTER(miteShadeSpec)
miteShadeSpecNix.argtypes = [POINTER(miteShadeSpec)]
miteShadeSpecParse = libteem.miteShadeSpecParse
miteShadeSpecParse.restype = c_int
miteShadeSpecParse.argtypes = [POINTER(miteShadeSpec), STRING]
miteShadeSpecPrint = libteem.miteShadeSpecPrint
miteShadeSpecPrint.restype = None
miteShadeSpecPrint.argtypes = [STRING, POINTER(miteShadeSpec)]
miteShadeSpecQueryAdd = libteem.miteShadeSpecQueryAdd
miteShadeSpecQueryAdd.restype = None
miteShadeSpecQueryAdd.argtypes = [POINTER(c_ubyte), POINTER(c_ubyte), POINTER(c_ubyte), POINTER(c_ubyte), POINTER(miteShadeSpec)]
miteRenderBegin = libteem.miteRenderBegin
miteRenderBegin.restype = c_int
miteRenderBegin.argtypes = [POINTER(POINTER(miteRender)), POINTER(miteUser)]
miteRenderEnd = libteem.miteRenderEnd
miteRenderEnd.restype = c_int
miteRenderEnd.argtypes = [POINTER(miteRender), POINTER(miteUser)]
miteThreadNew = libteem.miteThreadNew
miteThreadNew.restype = POINTER(miteThread)
miteThreadNew.argtypes = []
miteThreadNix = libteem.miteThreadNix
miteThreadNix.restype = POINTER(miteThread)
miteThreadNix.argtypes = [POINTER(miteThread)]
miteThreadBegin = libteem.miteThreadBegin
miteThreadBegin.restype = c_int
miteThreadBegin.argtypes = [POINTER(POINTER(miteThread)), POINTER(miteRender), POINTER(miteUser), c_int]
miteThreadEnd = libteem.miteThreadEnd
miteThreadEnd.restype = c_int
miteThreadEnd.argtypes = [POINTER(miteThread), POINTER(miteRender), POINTER(miteUser)]
miteRayBegin = libteem.miteRayBegin
miteRayBegin.restype = c_int
miteRayBegin.argtypes = [POINTER(miteThread), POINTER(miteRender), POINTER(miteUser), c_int, c_int, c_double, POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double)]
miteSample = libteem.miteSample
miteSample.restype = c_double
miteSample.argtypes = [POINTER(miteThread), POINTER(miteRender), POINTER(miteUser), c_int, c_double, c_int, POINTER(c_double), POINTER(c_double)]
miteRayEnd = libteem.miteRayEnd
miteRayEnd.restype = c_int
miteRayEnd.argtypes = [POINTER(miteThread), POINTER(miteRender), POINTER(miteUser)]
class mossSampler(Structure):
    pass
mossSampler._pack_ = 4
mossSampler._fields_ = [
    ('image', POINTER(Nrrd)),
    ('kernel', POINTER(NrrdKernel)),
    ('kparm', c_double * 8),
    ('ivc', POINTER(c_float)),
    ('xFslw', POINTER(c_double)),
    ('yFslw', POINTER(c_double)),
    ('fdiam', c_int),
    ('ncol', c_int),
    ('xIdx', POINTER(c_int)),
    ('yIdx', POINTER(c_int)),
    ('bg', POINTER(c_float)),
    ('boundary', c_int),
    ('flag', c_int * 2),
]
mossBiffKey = (STRING).in_dll(libteem, 'mossBiffKey')
mossDefBoundary = (c_int).in_dll(libteem, 'mossDefBoundary')
mossDefCenter = (c_int).in_dll(libteem, 'mossDefCenter')
mossVerbose = (c_int).in_dll(libteem, 'mossVerbose')
mossPresent = (c_int).in_dll(libteem, 'mossPresent')
mossSamplerNew = libteem.mossSamplerNew
mossSamplerNew.restype = POINTER(mossSampler)
mossSamplerNew.argtypes = []
mossSamplerFill = libteem.mossSamplerFill
mossSamplerFill.restype = c_int
mossSamplerFill.argtypes = [POINTER(mossSampler), c_int, c_int]
mossSamplerEmpty = libteem.mossSamplerEmpty
mossSamplerEmpty.restype = None
mossSamplerEmpty.argtypes = [POINTER(mossSampler)]
mossSamplerNix = libteem.mossSamplerNix
mossSamplerNix.restype = POINTER(mossSampler)
mossSamplerNix.argtypes = [POINTER(mossSampler)]
mossImageCheck = libteem.mossImageCheck
mossImageCheck.restype = c_int
mossImageCheck.argtypes = [POINTER(Nrrd)]
mossImageAlloc = libteem.mossImageAlloc
mossImageAlloc.restype = c_int
mossImageAlloc.argtypes = [POINTER(Nrrd), c_int, c_int, c_int, c_int]
mossSamplerImageSet = libteem.mossSamplerImageSet
mossSamplerImageSet.restype = c_int
mossSamplerImageSet.argtypes = [POINTER(mossSampler), POINTER(Nrrd), POINTER(c_float)]
mossSamplerKernelSet = libteem.mossSamplerKernelSet
mossSamplerKernelSet.restype = c_int
mossSamplerKernelSet.argtypes = [POINTER(mossSampler), POINTER(NrrdKernel), POINTER(c_double)]
mossSamplerUpdate = libteem.mossSamplerUpdate
mossSamplerUpdate.restype = c_int
mossSamplerUpdate.argtypes = [POINTER(mossSampler)]
mossSamplerSample = libteem.mossSamplerSample
mossSamplerSample.restype = c_int
mossSamplerSample.argtypes = [POINTER(c_float), POINTER(mossSampler), c_double, c_double]
mossHestTransform = (POINTER(hestCB)).in_dll(libteem, 'mossHestTransform')
mossHestOrigin = (POINTER(hestCB)).in_dll(libteem, 'mossHestOrigin')
mossMatPrint = libteem.mossMatPrint
mossMatPrint.restype = None
mossMatPrint.argtypes = [POINTER(FILE), POINTER(c_double)]
mossMatRightMultiply = libteem.mossMatRightMultiply
mossMatRightMultiply.restype = POINTER(c_double)
mossMatRightMultiply.argtypes = [POINTER(c_double), POINTER(c_double)]
mossMatLeftMultiply = libteem.mossMatLeftMultiply
mossMatLeftMultiply.restype = POINTER(c_double)
mossMatLeftMultiply.argtypes = [POINTER(c_double), POINTER(c_double)]
mossMatInvert = libteem.mossMatInvert
mossMatInvert.restype = POINTER(c_double)
mossMatInvert.argtypes = [POINTER(c_double), POINTER(c_double)]
mossMatIdentitySet = libteem.mossMatIdentitySet
mossMatIdentitySet.restype = POINTER(c_double)
mossMatIdentitySet.argtypes = [POINTER(c_double)]
mossMatTranslateSet = libteem.mossMatTranslateSet
mossMatTranslateSet.restype = POINTER(c_double)
mossMatTranslateSet.argtypes = [POINTER(c_double), c_double, c_double]
mossMatRotateSet = libteem.mossMatRotateSet
mossMatRotateSet.restype = POINTER(c_double)
mossMatRotateSet.argtypes = [POINTER(c_double), c_double]
mossMatFlipSet = libteem.mossMatFlipSet
mossMatFlipSet.restype = POINTER(c_double)
mossMatFlipSet.argtypes = [POINTER(c_double), c_double]
mossMatShearSet = libteem.mossMatShearSet
mossMatShearSet.restype = POINTER(c_double)
mossMatShearSet.argtypes = [POINTER(c_double), c_double, c_double]
mossMatScaleSet = libteem.mossMatScaleSet
mossMatScaleSet.restype = POINTER(c_double)
mossMatScaleSet.argtypes = [POINTER(c_double), c_double, c_double]
mossMatApply = libteem.mossMatApply
mossMatApply.restype = None
mossMatApply.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double, c_double]
mossLinearTransform = libteem.mossLinearTransform
mossLinearTransform.restype = c_int
mossLinearTransform.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_float), POINTER(c_double), POINTER(mossSampler), c_double, c_double, c_double, c_double, c_int, c_int]
nrrdDefaultWriteEncodingType = (c_int).in_dll(libteem, 'nrrdDefaultWriteEncodingType')
nrrdDefaultWriteBareText = (c_int).in_dll(libteem, 'nrrdDefaultWriteBareText')
nrrdDefaultWriteCharsPerLine = (c_uint).in_dll(libteem, 'nrrdDefaultWriteCharsPerLine')
nrrdDefaultWriteValsPerLine = (c_uint).in_dll(libteem, 'nrrdDefaultWriteValsPerLine')
nrrdDefaultResampleBoundary = (c_int).in_dll(libteem, 'nrrdDefaultResampleBoundary')
nrrdDefaultResampleType = (c_int).in_dll(libteem, 'nrrdDefaultResampleType')
nrrdDefaultResampleRenormalize = (c_int).in_dll(libteem, 'nrrdDefaultResampleRenormalize')
nrrdDefaultResampleRound = (c_int).in_dll(libteem, 'nrrdDefaultResampleRound')
nrrdDefaultResampleClamp = (c_int).in_dll(libteem, 'nrrdDefaultResampleClamp')
nrrdDefaultResampleCheap = (c_int).in_dll(libteem, 'nrrdDefaultResampleCheap')
nrrdDefaultResamplePadValue = (c_double).in_dll(libteem, 'nrrdDefaultResamplePadValue')
nrrdDefaultResampleNonExistent = (c_int).in_dll(libteem, 'nrrdDefaultResampleNonExistent')
nrrdDefaultKernelParm0 = (c_double).in_dll(libteem, 'nrrdDefaultKernelParm0')
nrrdDefaultCenter = (c_int).in_dll(libteem, 'nrrdDefaultCenter')
nrrdDefaultSpacing = (c_double).in_dll(libteem, 'nrrdDefaultSpacing')
nrrdStateVerboseIO = (c_int).in_dll(libteem, 'nrrdStateVerboseIO')
nrrdStateKeyValuePairsPropagate = (c_int).in_dll(libteem, 'nrrdStateKeyValuePairsPropagate')
nrrdStateBlind8BitRange = (c_int).in_dll(libteem, 'nrrdStateBlind8BitRange')
nrrdStateMeasureType = (c_int).in_dll(libteem, 'nrrdStateMeasureType')
nrrdStateMeasureModeBins = (c_int).in_dll(libteem, 'nrrdStateMeasureModeBins')
nrrdStateMeasureHistoType = (c_int).in_dll(libteem, 'nrrdStateMeasureHistoType')
nrrdStateDisallowIntegerNonExist = (c_int).in_dll(libteem, 'nrrdStateDisallowIntegerNonExist')
nrrdStateAlwaysSetContent = (c_int).in_dll(libteem, 'nrrdStateAlwaysSetContent')
nrrdStateDisableContent = (c_int).in_dll(libteem, 'nrrdStateDisableContent')
nrrdStateUnknownContent = (STRING).in_dll(libteem, 'nrrdStateUnknownContent')
nrrdStateGrayscaleImage3D = (c_int).in_dll(libteem, 'nrrdStateGrayscaleImage3D')
nrrdStateKeyValueReturnInternalPointers = (c_int).in_dll(libteem, 'nrrdStateKeyValueReturnInternalPointers')
nrrdStateKindNoop = (c_int).in_dll(libteem, 'nrrdStateKindNoop')
nrrdEnvVarDefaultWriteEncodingType = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultWriteEncodingType')
nrrdEnvVarDefaultWriteBareText = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultWriteBareText')
nrrdEnvVarDefaultWriteBareTextOld = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultWriteBareTextOld')
nrrdEnvVarDefaultCenter = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultCenter')
nrrdEnvVarDefaultCenterOld = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultCenterOld')
nrrdEnvVarDefaultWriteCharsPerLine = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultWriteCharsPerLine')
nrrdEnvVarDefaultWriteValsPerLine = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultWriteValsPerLine')
nrrdEnvVarDefaultKernelParm0 = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultKernelParm0')
nrrdEnvVarDefaultSpacing = (STRING).in_dll(libteem, 'nrrdEnvVarDefaultSpacing')
nrrdEnvVarStateKindNoop = (STRING).in_dll(libteem, 'nrrdEnvVarStateKindNoop')
nrrdEnvVarStateVerboseIO = (STRING).in_dll(libteem, 'nrrdEnvVarStateVerboseIO')
nrrdEnvVarStateKeyValuePairsPropagate = (STRING).in_dll(libteem, 'nrrdEnvVarStateKeyValuePairsPropagate')
nrrdEnvVarStateBlind8BitRange = (STRING).in_dll(libteem, 'nrrdEnvVarStateBlind8BitRange')
nrrdEnvVarStateAlwaysSetContent = (STRING).in_dll(libteem, 'nrrdEnvVarStateAlwaysSetContent')
nrrdEnvVarStateDisableContent = (STRING).in_dll(libteem, 'nrrdEnvVarStateDisableContent')
nrrdEnvVarStateMeasureType = (STRING).in_dll(libteem, 'nrrdEnvVarStateMeasureType')
nrrdEnvVarStateMeasureModeBins = (STRING).in_dll(libteem, 'nrrdEnvVarStateMeasureModeBins')
nrrdEnvVarStateMeasureHistoType = (STRING).in_dll(libteem, 'nrrdEnvVarStateMeasureHistoType')
nrrdEnvVarStateGrayscaleImage3D = (STRING).in_dll(libteem, 'nrrdEnvVarStateGrayscaleImage3D')
nrrdGetenvBool = libteem.nrrdGetenvBool
nrrdGetenvBool.restype = c_int
nrrdGetenvBool.argtypes = [POINTER(c_int), POINTER(STRING), STRING]
nrrdGetenvEnum = libteem.nrrdGetenvEnum
nrrdGetenvEnum.restype = c_int
nrrdGetenvEnum.argtypes = [POINTER(c_int), POINTER(STRING), POINTER(airEnum), STRING]
nrrdGetenvInt = libteem.nrrdGetenvInt
nrrdGetenvInt.restype = c_int
nrrdGetenvInt.argtypes = [POINTER(c_int), POINTER(STRING), STRING]
nrrdGetenvUInt = libteem.nrrdGetenvUInt
nrrdGetenvUInt.restype = c_int
nrrdGetenvUInt.argtypes = [POINTER(c_uint), POINTER(STRING), STRING]
nrrdGetenvDouble = libteem.nrrdGetenvDouble
nrrdGetenvDouble.restype = c_int
nrrdGetenvDouble.argtypes = [POINTER(c_double), POINTER(STRING), STRING]
nrrdDefaultGetenv = libteem.nrrdDefaultGetenv
nrrdDefaultGetenv.restype = None
nrrdDefaultGetenv.argtypes = []
nrrdStateGetenv = libteem.nrrdStateGetenv
nrrdStateGetenv.restype = None
nrrdStateGetenv.argtypes = []
nrrdFormatType = (POINTER(airEnum)).in_dll(libteem, 'nrrdFormatType')
nrrdType = (POINTER(airEnum)).in_dll(libteem, 'nrrdType')
nrrdEncodingType = (POINTER(airEnum)).in_dll(libteem, 'nrrdEncodingType')
nrrdCenter = (POINTER(airEnum)).in_dll(libteem, 'nrrdCenter')
nrrdKind = (POINTER(airEnum)).in_dll(libteem, 'nrrdKind')
nrrdField = (POINTER(airEnum)).in_dll(libteem, 'nrrdField')
nrrdSpace = (POINTER(airEnum)).in_dll(libteem, 'nrrdSpace')
nrrdSpacingStatus = (POINTER(airEnum)).in_dll(libteem, 'nrrdSpacingStatus')
nrrdBoundary = (POINTER(airEnum)).in_dll(libteem, 'nrrdBoundary')
nrrdMeasure = (POINTER(airEnum)).in_dll(libteem, 'nrrdMeasure')
nrrdUnaryOp = (POINTER(airEnum)).in_dll(libteem, 'nrrdUnaryOp')
nrrdBinaryOp = (POINTER(airEnum)).in_dll(libteem, 'nrrdBinaryOp')
nrrdTernaryOp = (POINTER(airEnum)).in_dll(libteem, 'nrrdTernaryOp')
nrrdFFTWPlanRigor = (POINTER(airEnum)).in_dll(libteem, 'nrrdFFTWPlanRigor')
nrrdResampleNonExistent = (POINTER(airEnum)).in_dll(libteem, 'nrrdResampleNonExistent')
nrrdTypePrintfStr = (c_char * 129 * 12).in_dll(libteem, 'nrrdTypePrintfStr')
nrrdTypeSize = (c_size_t * 12).in_dll(libteem, 'nrrdTypeSize')
nrrdTypeMin = (c_double * 12).in_dll(libteem, 'nrrdTypeMin')
nrrdTypeMax = (c_double * 12).in_dll(libteem, 'nrrdTypeMax')
nrrdTypeIsIntegral = (c_int * 12).in_dll(libteem, 'nrrdTypeIsIntegral')
nrrdTypeIsUnsigned = (c_int * 12).in_dll(libteem, 'nrrdTypeIsUnsigned')
nrrdPresent = (c_int).in_dll(libteem, 'nrrdPresent')
class NrrdIoState_t(Structure):
    pass
NrrdIoState = NrrdIoState_t
nrrdIoStateNew = libteem.nrrdIoStateNew
nrrdIoStateNew.restype = POINTER(NrrdIoState)
nrrdIoStateNew.argtypes = []
nrrdIoStateInit = libteem.nrrdIoStateInit
nrrdIoStateInit.restype = None
nrrdIoStateInit.argtypes = [POINTER(NrrdIoState)]
nrrdIoStateNix = libteem.nrrdIoStateNix
nrrdIoStateNix.restype = POINTER(NrrdIoState)
nrrdIoStateNix.argtypes = [POINTER(NrrdIoState)]
class NrrdResampleInfo(Structure):
    pass
nrrdResampleInfoNew = libteem.nrrdResampleInfoNew
nrrdResampleInfoNew.restype = POINTER(NrrdResampleInfo)
nrrdResampleInfoNew.argtypes = []
nrrdResampleInfoNix = libteem.nrrdResampleInfoNix
nrrdResampleInfoNix.restype = POINTER(NrrdResampleInfo)
nrrdResampleInfoNix.argtypes = [POINTER(NrrdResampleInfo)]
nrrdKernelSpecNew = libteem.nrrdKernelSpecNew
nrrdKernelSpecNew.restype = POINTER(NrrdKernelSpec)
nrrdKernelSpecNew.argtypes = []
nrrdKernelSpecCopy = libteem.nrrdKernelSpecCopy
nrrdKernelSpecCopy.restype = POINTER(NrrdKernelSpec)
nrrdKernelSpecCopy.argtypes = [POINTER(NrrdKernelSpec)]
nrrdKernelSpecSet = libteem.nrrdKernelSpecSet
nrrdKernelSpecSet.restype = None
nrrdKernelSpecSet.argtypes = [POINTER(NrrdKernelSpec), POINTER(NrrdKernel), POINTER(c_double)]
nrrdKernelParmSet = libteem.nrrdKernelParmSet
nrrdKernelParmSet.restype = None
nrrdKernelParmSet.argtypes = [POINTER(POINTER(NrrdKernel)), POINTER(c_double), POINTER(NrrdKernelSpec)]
nrrdKernelSpecNix = libteem.nrrdKernelSpecNix
nrrdKernelSpecNix.restype = POINTER(NrrdKernelSpec)
nrrdKernelSpecNix.argtypes = [POINTER(NrrdKernelSpec)]
nrrdInit = libteem.nrrdInit
nrrdInit.restype = None
nrrdInit.argtypes = [POINTER(Nrrd)]
nrrdNew = libteem.nrrdNew
nrrdNew.restype = POINTER(Nrrd)
nrrdNew.argtypes = []
nrrdNix = libteem.nrrdNix
nrrdNix.restype = POINTER(Nrrd)
nrrdNix.argtypes = [POINTER(Nrrd)]
nrrdEmpty = libteem.nrrdEmpty
nrrdEmpty.restype = POINTER(Nrrd)
nrrdEmpty.argtypes = [POINTER(Nrrd)]
nrrdNuke = libteem.nrrdNuke
nrrdNuke.restype = POINTER(Nrrd)
nrrdNuke.argtypes = [POINTER(Nrrd)]
nrrdWrap_nva = libteem.nrrdWrap_nva
nrrdWrap_nva.restype = c_int
nrrdWrap_nva.argtypes = [POINTER(Nrrd), c_void_p, c_int, c_uint, POINTER(c_size_t)]
nrrdWrap_va = libteem.nrrdWrap_va
nrrdWrap_va.restype = c_int
nrrdWrap_va.argtypes = [POINTER(Nrrd), c_void_p, c_int, c_uint]
nrrdBasicInfoInit = libteem.nrrdBasicInfoInit
nrrdBasicInfoInit.restype = None
nrrdBasicInfoInit.argtypes = [POINTER(Nrrd), c_int]
nrrdBasicInfoCopy = libteem.nrrdBasicInfoCopy
nrrdBasicInfoCopy.restype = c_int
nrrdBasicInfoCopy.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdCopy = libteem.nrrdCopy
nrrdCopy.restype = c_int
nrrdCopy.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
nrrdAlloc_nva = libteem.nrrdAlloc_nva
nrrdAlloc_nva.restype = c_int
nrrdAlloc_nva.argtypes = [POINTER(Nrrd), c_int, c_uint, POINTER(c_size_t)]
nrrdAlloc_va = libteem.nrrdAlloc_va
nrrdAlloc_va.restype = c_int
nrrdAlloc_va.argtypes = [POINTER(Nrrd), c_int, c_uint]
nrrdMaybeAlloc_nva = libteem.nrrdMaybeAlloc_nva
nrrdMaybeAlloc_nva.restype = c_int
nrrdMaybeAlloc_nva.argtypes = [POINTER(Nrrd), c_int, c_uint, POINTER(c_size_t)]
nrrdMaybeAlloc_va = libteem.nrrdMaybeAlloc_va
nrrdMaybeAlloc_va.restype = c_int
nrrdMaybeAlloc_va.argtypes = [POINTER(Nrrd), c_int, c_uint]
nrrdCompare = libteem.nrrdCompare
nrrdCompare.restype = c_int
nrrdCompare.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_double, POINTER(c_int), STRING]
nrrdPPM = libteem.nrrdPPM
nrrdPPM.restype = c_int
nrrdPPM.argtypes = [POINTER(Nrrd), c_size_t, c_size_t]
nrrdPGM = libteem.nrrdPGM
nrrdPGM.restype = c_int
nrrdPGM.argtypes = [POINTER(Nrrd), c_size_t, c_size_t]
nrrdKindIsDomain = libteem.nrrdKindIsDomain
nrrdKindIsDomain.restype = c_int
nrrdKindIsDomain.argtypes = [c_int]
nrrdKindSize = libteem.nrrdKindSize
nrrdKindSize.restype = c_uint
nrrdKindSize.argtypes = [c_int]
nrrdAxisInfoCopy = libteem.nrrdAxisInfoCopy
nrrdAxisInfoCopy.restype = c_int
nrrdAxisInfoCopy.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_int), c_int]
nrrdAxisInfoSet_nva = libteem.nrrdAxisInfoSet_nva
nrrdAxisInfoSet_nva.restype = None
nrrdAxisInfoSet_nva.argtypes = [POINTER(Nrrd), c_int, c_void_p]
nrrdAxisInfoSet_va = libteem.nrrdAxisInfoSet_va
nrrdAxisInfoSet_va.restype = None
nrrdAxisInfoSet_va.argtypes = [POINTER(Nrrd), c_int]
nrrdAxisInfoGet_nva = libteem.nrrdAxisInfoGet_nva
nrrdAxisInfoGet_nva.restype = None
nrrdAxisInfoGet_nva.argtypes = [POINTER(Nrrd), c_int, c_void_p]
nrrdAxisInfoGet_va = libteem.nrrdAxisInfoGet_va
nrrdAxisInfoGet_va.restype = None
nrrdAxisInfoGet_va.argtypes = [POINTER(Nrrd), c_int]
nrrdAxisInfoPos = libteem.nrrdAxisInfoPos
nrrdAxisInfoPos.restype = c_double
nrrdAxisInfoPos.argtypes = [POINTER(Nrrd), c_uint, c_double]
nrrdAxisInfoIdx = libteem.nrrdAxisInfoIdx
nrrdAxisInfoIdx.restype = c_double
nrrdAxisInfoIdx.argtypes = [POINTER(Nrrd), c_uint, c_double]
nrrdAxisInfoPosRange = libteem.nrrdAxisInfoPosRange
nrrdAxisInfoPosRange.restype = None
nrrdAxisInfoPosRange.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(Nrrd), c_uint, c_double, c_double]
nrrdAxisInfoIdxRange = libteem.nrrdAxisInfoIdxRange
nrrdAxisInfoIdxRange.restype = None
nrrdAxisInfoIdxRange.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(Nrrd), c_uint, c_double, c_double]
nrrdAxisInfoSpacingSet = libteem.nrrdAxisInfoSpacingSet
nrrdAxisInfoSpacingSet.restype = None
nrrdAxisInfoSpacingSet.argtypes = [POINTER(Nrrd), c_uint]
nrrdAxisInfoMinMaxSet = libteem.nrrdAxisInfoMinMaxSet
nrrdAxisInfoMinMaxSet.restype = None
nrrdAxisInfoMinMaxSet.argtypes = [POINTER(Nrrd), c_uint, c_int]
nrrdAxisInfoCompare = libteem.nrrdAxisInfoCompare
nrrdAxisInfoCompare.restype = c_int
nrrdAxisInfoCompare.argtypes = [POINTER(NrrdAxisInfo), POINTER(NrrdAxisInfo), POINTER(c_int), STRING]
nrrdDomainAxesGet = libteem.nrrdDomainAxesGet
nrrdDomainAxesGet.restype = c_uint
nrrdDomainAxesGet.argtypes = [POINTER(Nrrd), POINTER(c_uint)]
nrrdRangeAxesGet = libteem.nrrdRangeAxesGet
nrrdRangeAxesGet.restype = c_uint
nrrdRangeAxesGet.argtypes = [POINTER(Nrrd), POINTER(c_uint)]
nrrdSpatialAxesGet = libteem.nrrdSpatialAxesGet
nrrdSpatialAxesGet.restype = c_uint
nrrdSpatialAxesGet.argtypes = [POINTER(Nrrd), POINTER(c_uint)]
nrrdNonSpatialAxesGet = libteem.nrrdNonSpatialAxesGet
nrrdNonSpatialAxesGet.restype = c_uint
nrrdNonSpatialAxesGet.argtypes = [POINTER(Nrrd), POINTER(c_uint)]
nrrdSpacingCalculate = libteem.nrrdSpacingCalculate
nrrdSpacingCalculate.restype = c_int
nrrdSpacingCalculate.argtypes = [POINTER(Nrrd), c_uint, POINTER(c_double), POINTER(c_double)]
nrrdOrientationReduce = libteem.nrrdOrientationReduce
nrrdOrientationReduce.restype = c_int
nrrdOrientationReduce.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdBiffKey = (STRING).in_dll(libteem, 'nrrdBiffKey')
nrrdSpaceDimension = libteem.nrrdSpaceDimension
nrrdSpaceDimension.restype = c_uint
nrrdSpaceDimension.argtypes = [c_int]
nrrdSpaceSet = libteem.nrrdSpaceSet
nrrdSpaceSet.restype = c_int
nrrdSpaceSet.argtypes = [POINTER(Nrrd), c_int]
nrrdSpaceDimensionSet = libteem.nrrdSpaceDimensionSet
nrrdSpaceDimensionSet.restype = c_int
nrrdSpaceDimensionSet.argtypes = [POINTER(Nrrd), c_uint]
nrrdSpaceOriginGet = libteem.nrrdSpaceOriginGet
nrrdSpaceOriginGet.restype = c_uint
nrrdSpaceOriginGet.argtypes = [POINTER(Nrrd), POINTER(c_double)]
nrrdSpaceOriginSet = libteem.nrrdSpaceOriginSet
nrrdSpaceOriginSet.restype = c_int
nrrdSpaceOriginSet.argtypes = [POINTER(Nrrd), POINTER(c_double)]
nrrdOriginCalculate = libteem.nrrdOriginCalculate
nrrdOriginCalculate.restype = c_int
nrrdOriginCalculate.argtypes = [POINTER(Nrrd), POINTER(c_uint), c_uint, c_int, POINTER(c_double)]
nrrdContentSet_va = libteem.nrrdContentSet_va
nrrdContentSet_va.restype = c_int
nrrdContentSet_va.argtypes = [POINTER(Nrrd), STRING, POINTER(Nrrd), STRING]
nrrdDescribe = libteem.nrrdDescribe
nrrdDescribe.restype = None
nrrdDescribe.argtypes = [POINTER(FILE), POINTER(Nrrd)]
nrrdCheck = libteem.nrrdCheck
nrrdCheck.restype = c_int
nrrdCheck.argtypes = [POINTER(Nrrd)]
nrrdElementSize = libteem.nrrdElementSize
nrrdElementSize.restype = c_size_t
nrrdElementSize.argtypes = [POINTER(Nrrd)]
nrrdElementNumber = libteem.nrrdElementNumber
nrrdElementNumber.restype = c_size_t
nrrdElementNumber.argtypes = [POINTER(Nrrd)]
nrrdSanity = libteem.nrrdSanity
nrrdSanity.restype = c_int
nrrdSanity.argtypes = []
nrrdSameSize = libteem.nrrdSameSize
nrrdSameSize.restype = c_int
nrrdSameSize.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdSpaceVecCopy = libteem.nrrdSpaceVecCopy
nrrdSpaceVecCopy.restype = None
nrrdSpaceVecCopy.argtypes = [POINTER(c_double), POINTER(c_double)]
nrrdSpaceVecScaleAdd2 = libteem.nrrdSpaceVecScaleAdd2
nrrdSpaceVecScaleAdd2.restype = None
nrrdSpaceVecScaleAdd2.argtypes = [POINTER(c_double), c_double, POINTER(c_double), c_double, POINTER(c_double)]
nrrdSpaceVecScale = libteem.nrrdSpaceVecScale
nrrdSpaceVecScale.restype = None
nrrdSpaceVecScale.argtypes = [POINTER(c_double), c_double, POINTER(c_double)]
nrrdSpaceVecNorm = libteem.nrrdSpaceVecNorm
nrrdSpaceVecNorm.restype = c_double
nrrdSpaceVecNorm.argtypes = [c_uint, POINTER(c_double)]
nrrdSpaceVecExists = libteem.nrrdSpaceVecExists
nrrdSpaceVecExists.restype = c_int
nrrdSpaceVecExists.argtypes = [c_uint, POINTER(c_double)]
nrrdSpaceVecSetNaN = libteem.nrrdSpaceVecSetNaN
nrrdSpaceVecSetNaN.restype = None
nrrdSpaceVecSetNaN.argtypes = [POINTER(c_double)]
nrrdSanityOrDie = libteem.nrrdSanityOrDie
nrrdSanityOrDie.restype = None
nrrdSanityOrDie.argtypes = [STRING]
nrrdSpaceVecSetZero = libteem.nrrdSpaceVecSetZero
nrrdSpaceVecSetZero.restype = None
nrrdSpaceVecSetZero.argtypes = [POINTER(c_double)]
nrrdZeroSet = libteem.nrrdZeroSet
nrrdZeroSet.restype = None
nrrdZeroSet.argtypes = [POINTER(Nrrd)]
nrrdCommentAdd = libteem.nrrdCommentAdd
nrrdCommentAdd.restype = c_int
nrrdCommentAdd.argtypes = [POINTER(Nrrd), STRING]
nrrdCommentClear = libteem.nrrdCommentClear
nrrdCommentClear.restype = None
nrrdCommentClear.argtypes = [POINTER(Nrrd)]
nrrdCommentCopy = libteem.nrrdCommentCopy
nrrdCommentCopy.restype = c_int
nrrdCommentCopy.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
nrrdKeyValueSize = libteem.nrrdKeyValueSize
nrrdKeyValueSize.restype = c_uint
nrrdKeyValueSize.argtypes = [POINTER(Nrrd)]
nrrdKeyValueAdd = libteem.nrrdKeyValueAdd
nrrdKeyValueAdd.restype = c_int
nrrdKeyValueAdd.argtypes = [POINTER(Nrrd), STRING, STRING]
nrrdKeyValueGet = libteem.nrrdKeyValueGet
nrrdKeyValueGet.restype = STRING
nrrdKeyValueGet.argtypes = [POINTER(Nrrd), STRING]
nrrdKeyValueIndex = libteem.nrrdKeyValueIndex
nrrdKeyValueIndex.restype = None
nrrdKeyValueIndex.argtypes = [POINTER(Nrrd), POINTER(STRING), POINTER(STRING), c_uint]
nrrdKeyValueErase = libteem.nrrdKeyValueErase
nrrdKeyValueErase.restype = c_int
nrrdKeyValueErase.argtypes = [POINTER(Nrrd), STRING]
nrrdKeyValueClear = libteem.nrrdKeyValueClear
nrrdKeyValueClear.restype = None
nrrdKeyValueClear.argtypes = [POINTER(Nrrd)]
nrrdKeyValueCopy = libteem.nrrdKeyValueCopy
nrrdKeyValueCopy.restype = c_int
nrrdKeyValueCopy.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
nrrdSwapEndian = libteem.nrrdSwapEndian
nrrdSwapEndian.restype = None
nrrdSwapEndian.argtypes = [POINTER(Nrrd)]
class NrrdFormat(Structure):
    pass
NrrdEncoding_t._fields_ = [
    ('name', c_char * 129),
    ('suffix', c_char * 129),
    ('endianMatters', c_int),
    ('isCompression', c_int),
    ('available', CFUNCTYPE(c_int)),
    ('read', CFUNCTYPE(c_int, POINTER(FILE), c_void_p, c_size_t, POINTER(Nrrd), POINTER(NrrdIoState_t))),
    ('write', CFUNCTYPE(c_int, POINTER(FILE), c_void_p, c_size_t, POINTER(Nrrd), POINTER(NrrdIoState_t))),
]
NrrdFormat._fields_ = [
    ('name', c_char * 129),
    ('isImage', c_int),
    ('readable', c_int),
    ('usesDIO', c_int),
    ('available', CFUNCTYPE(c_int)),
    ('nameLooksLike', CFUNCTYPE(c_int, STRING)),
    ('fitsInto', CFUNCTYPE(c_int, POINTER(Nrrd), POINTER(NrrdEncoding_t), c_int)),
    ('contentStartsLike', CFUNCTYPE(c_int, POINTER(NrrdIoState_t))),
    ('read', CFUNCTYPE(c_int, POINTER(FILE), POINTER(Nrrd), POINTER(NrrdIoState_t))),
    ('write', CFUNCTYPE(c_int, POINTER(FILE), POINTER(Nrrd), POINTER(NrrdIoState_t))),
]
nrrdFormatNRRD = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatNRRD')
nrrdFormatPNM = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatPNM')
nrrdFormatPNG = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatPNG')
nrrdFormatVTK = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatVTK')
nrrdFormatText = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatText')
nrrdFormatEPS = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatEPS')
nrrdFormatUnknown = (POINTER(NrrdFormat)).in_dll(libteem, 'nrrdFormatUnknown')
nrrdFormatArray = (POINTER(NrrdFormat) * 7).in_dll(libteem, 'nrrdFormatArray')
nrrdEncodingRaw = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingRaw')
nrrdEncodingAscii = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingAscii')
nrrdEncodingHex = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingHex')
nrrdEncodingGzip = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingGzip')
nrrdEncodingBzip2 = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingBzip2')
nrrdEncodingUnknown = (POINTER(NrrdEncoding)).in_dll(libteem, 'nrrdEncodingUnknown')
nrrdEncodingArray = (POINTER(NrrdEncoding) * 6).in_dll(libteem, 'nrrdEncodingArray')
nrrdFieldInfoParse = (CFUNCTYPE(c_int, POINTER(FILE), POINTER(Nrrd), POINTER(NrrdIoState), c_int) * 33).in_dll(libteem, 'nrrdFieldInfoParse')
nrrdLineSkip = libteem.nrrdLineSkip
nrrdLineSkip.restype = c_int
nrrdLineSkip.argtypes = [POINTER(FILE), POINTER(NrrdIoState)]
nrrdByteSkip = libteem.nrrdByteSkip
nrrdByteSkip.restype = c_int
nrrdByteSkip.argtypes = [POINTER(FILE), POINTER(Nrrd), POINTER(NrrdIoState)]
nrrdLoad = libteem.nrrdLoad
nrrdLoad.restype = c_int
nrrdLoad.argtypes = [POINTER(Nrrd), STRING, POINTER(NrrdIoState)]
nrrdLoadMulti = libteem.nrrdLoadMulti
nrrdLoadMulti.restype = c_int
nrrdLoadMulti.argtypes = [POINTER(POINTER(Nrrd)), c_uint, STRING, c_uint, POINTER(NrrdIoState)]
nrrdRead = libteem.nrrdRead
nrrdRead.restype = c_int
nrrdRead.argtypes = [POINTER(Nrrd), POINTER(FILE), POINTER(NrrdIoState)]
nrrdStringRead = libteem.nrrdStringRead
nrrdStringRead.restype = c_int
nrrdStringRead.argtypes = [POINTER(Nrrd), STRING, POINTER(NrrdIoState)]
nrrdIoStateSet = libteem.nrrdIoStateSet
nrrdIoStateSet.restype = c_int
nrrdIoStateSet.argtypes = [POINTER(NrrdIoState), c_int, c_int]
nrrdIoStateEncodingSet = libteem.nrrdIoStateEncodingSet
nrrdIoStateEncodingSet.restype = c_int
nrrdIoStateEncodingSet.argtypes = [POINTER(NrrdIoState), POINTER(NrrdEncoding)]
nrrdIoStateFormatSet = libteem.nrrdIoStateFormatSet
nrrdIoStateFormatSet.restype = c_int
nrrdIoStateFormatSet.argtypes = [POINTER(NrrdIoState), POINTER(NrrdFormat)]
nrrdIoStateGet = libteem.nrrdIoStateGet
nrrdIoStateGet.restype = c_int
nrrdIoStateGet.argtypes = [POINTER(NrrdIoState), c_int]
nrrdIoStateEncodingGet = libteem.nrrdIoStateEncodingGet
nrrdIoStateEncodingGet.restype = POINTER(NrrdEncoding)
nrrdIoStateEncodingGet.argtypes = [POINTER(NrrdIoState)]
nrrdIoStateFormatGet = libteem.nrrdIoStateFormatGet
nrrdIoStateFormatGet.restype = POINTER(NrrdFormat)
nrrdIoStateFormatGet.argtypes = [POINTER(NrrdIoState)]
nrrdSave = libteem.nrrdSave
nrrdSave.restype = c_int
nrrdSave.argtypes = [STRING, POINTER(Nrrd), POINTER(NrrdIoState)]
nrrdSaveMulti = libteem.nrrdSaveMulti
nrrdSaveMulti.restype = c_int
nrrdSaveMulti.argtypes = [STRING, POINTER(POINTER(Nrrd)), c_uint, c_uint, POINTER(NrrdIoState)]
nrrdWrite = libteem.nrrdWrite
nrrdWrite.restype = c_int
nrrdWrite.argtypes = [POINTER(FILE), POINTER(Nrrd), POINTER(NrrdIoState)]
nrrdStringWrite = libteem.nrrdStringWrite
nrrdStringWrite.restype = c_int
nrrdStringWrite.argtypes = [POINTER(STRING), POINTER(Nrrd), POINTER(NrrdIoState)]
nrrdDLoad = (CFUNCTYPE(c_double, c_void_p) * 12).in_dll(libteem, 'nrrdDLoad')
nrrdFLoad = (CFUNCTYPE(c_float, c_void_p) * 12).in_dll(libteem, 'nrrdFLoad')
nrrdILoad = (CFUNCTYPE(c_int, c_void_p) * 12).in_dll(libteem, 'nrrdILoad')
nrrdUILoad = (CFUNCTYPE(c_uint, c_void_p) * 12).in_dll(libteem, 'nrrdUILoad')
nrrdDStore = (CFUNCTYPE(c_double, c_void_p, c_double) * 12).in_dll(libteem, 'nrrdDStore')
nrrdFStore = (CFUNCTYPE(c_float, c_void_p, c_float) * 12).in_dll(libteem, 'nrrdFStore')
nrrdIStore = (CFUNCTYPE(c_int, c_void_p, c_int) * 12).in_dll(libteem, 'nrrdIStore')
nrrdUIStore = (CFUNCTYPE(c_uint, c_void_p, c_uint) * 12).in_dll(libteem, 'nrrdUIStore')
nrrdDLookup = (CFUNCTYPE(c_double, c_void_p, c_size_t) * 12).in_dll(libteem, 'nrrdDLookup')
nrrdFLookup = (CFUNCTYPE(c_float, c_void_p, c_size_t) * 12).in_dll(libteem, 'nrrdFLookup')
nrrdILookup = (CFUNCTYPE(c_int, c_void_p, c_size_t) * 12).in_dll(libteem, 'nrrdILookup')
nrrdUILookup = (CFUNCTYPE(c_uint, c_void_p, c_size_t) * 12).in_dll(libteem, 'nrrdUILookup')
nrrdDInsert = (CFUNCTYPE(c_double, c_void_p, c_size_t, c_double) * 12).in_dll(libteem, 'nrrdDInsert')
nrrdFInsert = (CFUNCTYPE(c_float, c_void_p, c_size_t, c_float) * 12).in_dll(libteem, 'nrrdFInsert')
nrrdIInsert = (CFUNCTYPE(c_int, c_void_p, c_size_t, c_int) * 12).in_dll(libteem, 'nrrdIInsert')
nrrdUIInsert = (CFUNCTYPE(c_uint, c_void_p, c_size_t, c_uint) * 12).in_dll(libteem, 'nrrdUIInsert')
nrrdSprint = (CFUNCTYPE(c_int, STRING, c_void_p) * 12).in_dll(libteem, 'nrrdSprint')
nrrdFprint = (CFUNCTYPE(c_int, POINTER(FILE), c_void_p) * 12).in_dll(libteem, 'nrrdFprint')
nrrdMinMaxExactFind = (CFUNCTYPE(None, c_void_p, c_void_p, POINTER(c_int), POINTER(Nrrd)) * 12).in_dll(libteem, 'nrrdMinMaxExactFind')
nrrdValCompare = (CFUNCTYPE(c_int, c_void_p, c_void_p) * 12).in_dll(libteem, 'nrrdValCompare')
nrrdValCompareInv = (CFUNCTYPE(c_int, c_void_p, c_void_p) * 12).in_dll(libteem, 'nrrdValCompareInv')
nrrdArrayCompare = libteem.nrrdArrayCompare
nrrdArrayCompare.restype = c_int
nrrdArrayCompare.argtypes = [c_int, c_void_p, c_void_p, c_size_t, c_double, POINTER(c_int), STRING]
nrrdAxesInsert = libteem.nrrdAxesInsert
nrrdAxesInsert.restype = c_int
nrrdAxesInsert.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdInvertPerm = libteem.nrrdInvertPerm
nrrdInvertPerm.restype = c_int
nrrdInvertPerm.argtypes = [POINTER(c_uint), POINTER(c_uint), c_uint]
nrrdAxesPermute = libteem.nrrdAxesPermute
nrrdAxesPermute.restype = c_int
nrrdAxesPermute.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_uint)]
nrrdShuffle = libteem.nrrdShuffle
nrrdShuffle.restype = c_int
nrrdShuffle.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, POINTER(c_size_t)]
nrrdAxesSwap = libteem.nrrdAxesSwap
nrrdAxesSwap.restype = c_int
nrrdAxesSwap.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_uint]
nrrdFlip = libteem.nrrdFlip
nrrdFlip.restype = c_int
nrrdFlip.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdJoin = libteem.nrrdJoin
nrrdJoin.restype = c_int
nrrdJoin.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), c_uint, c_uint, c_int]
nrrdReshape_va = libteem.nrrdReshape_va
nrrdReshape_va.restype = c_int
nrrdReshape_va.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdReshape_nva = libteem.nrrdReshape_nva
nrrdReshape_nva.restype = c_int
nrrdReshape_nva.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, POINTER(c_size_t)]
nrrdAxesSplit = libteem.nrrdAxesSplit
nrrdAxesSplit.restype = c_int
nrrdAxesSplit.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_size_t, c_size_t]
nrrdAxesDelete = libteem.nrrdAxesDelete
nrrdAxesDelete.restype = c_int
nrrdAxesDelete.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdAxesMerge = libteem.nrrdAxesMerge
nrrdAxesMerge.restype = c_int
nrrdAxesMerge.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdBlock = libteem.nrrdBlock
nrrdBlock.restype = c_int
nrrdBlock.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
nrrdUnblock = libteem.nrrdUnblock
nrrdUnblock.restype = c_int
nrrdUnblock.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdTile2D = libteem.nrrdTile2D
nrrdTile2D.restype = c_int
nrrdTile2D.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_uint, c_uint, c_size_t, c_size_t]
nrrdUntile2D = libteem.nrrdUntile2D
nrrdUntile2D.restype = c_int
nrrdUntile2D.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_uint, c_uint, c_size_t, c_size_t]
nrrdHestNrrd = (POINTER(hestCB)).in_dll(libteem, 'nrrdHestNrrd')
nrrdHestKernelSpec = (POINTER(hestCB)).in_dll(libteem, 'nrrdHestKernelSpec')
nrrdHestIter = (POINTER(hestCB)).in_dll(libteem, 'nrrdHestIter')
class NrrdIter(Structure):
    pass
nrrdIterNew = libteem.nrrdIterNew
nrrdIterNew.restype = POINTER(NrrdIter)
nrrdIterNew.argtypes = []
nrrdIterSetValue = libteem.nrrdIterSetValue
nrrdIterSetValue.restype = None
nrrdIterSetValue.argtypes = [POINTER(NrrdIter), c_double]
nrrdIterSetNrrd = libteem.nrrdIterSetNrrd
nrrdIterSetNrrd.restype = None
nrrdIterSetNrrd.argtypes = [POINTER(NrrdIter), POINTER(Nrrd)]
nrrdIterSetOwnNrrd = libteem.nrrdIterSetOwnNrrd
nrrdIterSetOwnNrrd.restype = None
nrrdIterSetOwnNrrd.argtypes = [POINTER(NrrdIter), POINTER(Nrrd)]
nrrdIterValue = libteem.nrrdIterValue
nrrdIterValue.restype = c_double
nrrdIterValue.argtypes = [POINTER(NrrdIter)]
nrrdIterContent = libteem.nrrdIterContent
nrrdIterContent.restype = STRING
nrrdIterContent.argtypes = [POINTER(NrrdIter)]
nrrdIterNix = libteem.nrrdIterNix
nrrdIterNix.restype = POINTER(NrrdIter)
nrrdIterNix.argtypes = [POINTER(NrrdIter)]
class NrrdRange(Structure):
    pass
nrrdRangeNew = libteem.nrrdRangeNew
nrrdRangeNew.restype = POINTER(NrrdRange)
nrrdRangeNew.argtypes = [c_double, c_double]
NrrdRange._pack_ = 4
NrrdRange._fields_ = [
    ('min', c_double),
    ('max', c_double),
    ('hasNonExist', c_int),
]
nrrdRangeCopy = libteem.nrrdRangeCopy
nrrdRangeCopy.restype = POINTER(NrrdRange)
nrrdRangeCopy.argtypes = [POINTER(NrrdRange)]
nrrdRangeNix = libteem.nrrdRangeNix
nrrdRangeNix.restype = POINTER(NrrdRange)
nrrdRangeNix.argtypes = [POINTER(NrrdRange)]
nrrdRangeReset = libteem.nrrdRangeReset
nrrdRangeReset.restype = None
nrrdRangeReset.argtypes = [POINTER(NrrdRange)]
nrrdRangeSet = libteem.nrrdRangeSet
nrrdRangeSet.restype = None
nrrdRangeSet.argtypes = [POINTER(NrrdRange), POINTER(Nrrd), c_int]
nrrdRangePercentileSet = libteem.nrrdRangePercentileSet
nrrdRangePercentileSet.restype = c_int
nrrdRangePercentileSet.argtypes = [POINTER(NrrdRange), POINTER(Nrrd), c_double, c_double, c_uint, c_int]
nrrdRangePercentileFromStringSet = libteem.nrrdRangePercentileFromStringSet
nrrdRangePercentileFromStringSet.restype = c_int
nrrdRangePercentileFromStringSet.argtypes = [POINTER(NrrdRange), POINTER(Nrrd), STRING, STRING, c_uint, c_int]
nrrdRangeSafeSet = libteem.nrrdRangeSafeSet
nrrdRangeSafeSet.restype = None
nrrdRangeSafeSet.argtypes = [POINTER(NrrdRange), POINTER(Nrrd), c_int]
nrrdRangeNewSet = libteem.nrrdRangeNewSet
nrrdRangeNewSet.restype = POINTER(NrrdRange)
nrrdRangeNewSet.argtypes = [POINTER(Nrrd), c_int]
nrrdHasNonExist = libteem.nrrdHasNonExist
nrrdHasNonExist.restype = c_int
nrrdHasNonExist.argtypes = [POINTER(Nrrd)]
nrrdFClamp = (CFUNCTYPE(c_float, c_float) * 12).in_dll(libteem, 'nrrdFClamp')
nrrdDClamp = (CFUNCTYPE(c_double, c_double) * 12).in_dll(libteem, 'nrrdDClamp')
nrrdConvert = libteem.nrrdConvert
nrrdConvert.restype = c_int
nrrdConvert.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdClampConvert = libteem.nrrdClampConvert
nrrdClampConvert.restype = c_int
nrrdClampConvert.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdQuantize = libteem.nrrdQuantize
nrrdQuantize.restype = c_int
nrrdQuantize.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), c_uint]
nrrdUnquantize = libteem.nrrdUnquantize
nrrdUnquantize.restype = c_int
nrrdUnquantize.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
nrrdHistoEq = libteem.nrrdHistoEq
nrrdHistoEq.restype = c_int
nrrdHistoEq.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(POINTER(Nrrd)), c_uint, c_uint, c_float]
nrrdApply1DLut = libteem.nrrdApply1DLut
nrrdApply1DLut.restype = c_int
nrrdApply1DLut.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), c_int, c_int]
nrrdApplyMulti1DLut = libteem.nrrdApplyMulti1DLut
nrrdApplyMulti1DLut.restype = c_int
nrrdApplyMulti1DLut.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), c_int, c_int]
nrrdApply1DRegMap = libteem.nrrdApply1DRegMap
nrrdApply1DRegMap.restype = c_int
nrrdApply1DRegMap.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), c_int, c_int]
nrrdApplyMulti1DRegMap = libteem.nrrdApplyMulti1DRegMap
nrrdApplyMulti1DRegMap.restype = c_int
nrrdApplyMulti1DRegMap.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), c_int, c_int]
nrrd1DIrregMapCheck = libteem.nrrd1DIrregMapCheck
nrrd1DIrregMapCheck.restype = c_int
nrrd1DIrregMapCheck.argtypes = [POINTER(Nrrd)]
nrrd1DIrregAclGenerate = libteem.nrrd1DIrregAclGenerate
nrrd1DIrregAclGenerate.restype = c_int
nrrd1DIrregAclGenerate.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_size_t]
nrrd1DIrregAclCheck = libteem.nrrd1DIrregAclCheck
nrrd1DIrregAclCheck.restype = c_int
nrrd1DIrregAclCheck.argtypes = [POINTER(Nrrd)]
nrrdApply1DIrregMap = libteem.nrrdApply1DIrregMap
nrrdApply1DIrregMap.restype = c_int
nrrdApply1DIrregMap.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), POINTER(Nrrd), c_int, c_int]
nrrdApply1DSubstitution = libteem.nrrdApply1DSubstitution
nrrdApply1DSubstitution.restype = c_int
nrrdApply1DSubstitution.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
nrrdApply2DLut = libteem.nrrdApply2DLut
nrrdApply2DLut.restype = c_int
nrrdApply2DLut.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, POINTER(NrrdRange), POINTER(NrrdRange), POINTER(Nrrd), c_int, c_int, c_int]
nrrdSlice = libteem.nrrdSlice
nrrdSlice.restype = c_int
nrrdSlice.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_size_t]
nrrdCrop = libteem.nrrdCrop
nrrdCrop.restype = c_int
nrrdCrop.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_size_t), POINTER(c_size_t)]
nrrdSliceSelect = libteem.nrrdSliceSelect
nrrdSliceSelect.restype = c_int
nrrdSliceSelect.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_uint, POINTER(Nrrd), c_double]
nrrdSample_nva = libteem.nrrdSample_nva
nrrdSample_nva.restype = c_int
nrrdSample_nva.argtypes = [c_void_p, POINTER(Nrrd), POINTER(c_size_t)]
nrrdSample_va = libteem.nrrdSample_va
nrrdSample_va.restype = c_int
nrrdSample_va.argtypes = [c_void_p, POINTER(Nrrd)]
nrrdSimpleCrop = libteem.nrrdSimpleCrop
nrrdSimpleCrop.restype = c_int
nrrdSimpleCrop.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdCropAuto = libteem.nrrdCropAuto
nrrdCropAuto.restype = c_int
nrrdCropAuto.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_size_t), POINTER(c_size_t), POINTER(c_uint), c_uint, c_int, c_double, c_int]
nrrdSplice = libteem.nrrdSplice
nrrdSplice.restype = c_int
nrrdSplice.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_uint, c_size_t]
nrrdPad_nva = libteem.nrrdPad_nva
nrrdPad_nva.restype = c_int
nrrdPad_nva.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(ptrdiff_t), POINTER(ptrdiff_t), c_int, c_double]
nrrdPad_va = libteem.nrrdPad_va
nrrdPad_va.restype = c_int
nrrdPad_va.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(ptrdiff_t), POINTER(ptrdiff_t), c_int]
nrrdSimplePad_nva = libteem.nrrdSimplePad_nva
nrrdSimplePad_nva.restype = c_int
nrrdSimplePad_nva.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_int, c_double]
nrrdSimplePad_va = libteem.nrrdSimplePad_va
nrrdSimplePad_va.restype = c_int
nrrdSimplePad_va.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_int]
nrrdInset = libteem.nrrdInset
nrrdInset.restype = c_int
nrrdInset.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(c_size_t)]
nrrdMeasureLine = (CFUNCTYPE(None, c_void_p, c_int, c_void_p, c_int, c_size_t, c_double, c_double) * 30).in_dll(libteem, 'nrrdMeasureLine')
nrrdProject = libteem.nrrdProject
nrrdProject.restype = c_int
nrrdProject.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_int, c_int]
nrrdHisto = libteem.nrrdHisto
nrrdHisto.restype = c_int
nrrdHisto.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), POINTER(Nrrd), c_size_t, c_int]
nrrdHistoCheck = libteem.nrrdHistoCheck
nrrdHistoCheck.restype = c_int
nrrdHistoCheck.argtypes = [POINTER(Nrrd)]
nrrdHistoDraw = libteem.nrrdHistoDraw
nrrdHistoDraw.restype = c_int
nrrdHistoDraw.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_size_t, c_int, c_double]
nrrdHistoAxis = libteem.nrrdHistoAxis
nrrdHistoAxis.restype = c_int
nrrdHistoAxis.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), c_uint, c_size_t, c_int]
nrrdHistoJoint = libteem.nrrdHistoJoint
nrrdHistoJoint.restype = c_int
nrrdHistoJoint.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(POINTER(NrrdRange)), c_uint, POINTER(Nrrd), POINTER(c_size_t), c_int, POINTER(c_int)]
nrrdHistoThresholdOtsu = libteem.nrrdHistoThresholdOtsu
nrrdHistoThresholdOtsu.restype = c_int
nrrdHistoThresholdOtsu.argtypes = [POINTER(c_double), POINTER(Nrrd), c_double]
nrrdArithGamma = libteem.nrrdArithGamma
nrrdArithGamma.restype = c_int
nrrdArithGamma.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdRange), c_double]
nrrdArithUnaryOp = libteem.nrrdArithUnaryOp
nrrdArithUnaryOp.restype = c_int
nrrdArithUnaryOp.argtypes = [POINTER(Nrrd), c_int, POINTER(Nrrd)]
nrrdArithBinaryOp = libteem.nrrdArithBinaryOp
nrrdArithBinaryOp.restype = c_int
nrrdArithBinaryOp.argtypes = [POINTER(Nrrd), c_int, POINTER(Nrrd), POINTER(Nrrd)]
nrrdArithTernaryOp = libteem.nrrdArithTernaryOp
nrrdArithTernaryOp.restype = c_int
nrrdArithTernaryOp.argtypes = [POINTER(Nrrd), c_int, POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
nrrdArithAffine = libteem.nrrdArithAffine
nrrdArithAffine.restype = c_int
nrrdArithAffine.argtypes = [POINTER(Nrrd), c_double, POINTER(Nrrd), c_double, c_double, c_double, c_int]
nrrdArithIterBinaryOp = libteem.nrrdArithIterBinaryOp
nrrdArithIterBinaryOp.restype = c_int
nrrdArithIterBinaryOp.argtypes = [POINTER(Nrrd), c_int, POINTER(NrrdIter), POINTER(NrrdIter)]
nrrdArithIterBinaryOpSelect = libteem.nrrdArithIterBinaryOpSelect
nrrdArithIterBinaryOpSelect.restype = c_int
nrrdArithIterBinaryOpSelect.argtypes = [POINTER(Nrrd), c_int, POINTER(NrrdIter), POINTER(NrrdIter), c_uint]
nrrdArithIterTernaryOp = libteem.nrrdArithIterTernaryOp
nrrdArithIterTernaryOp.restype = c_int
nrrdArithIterTernaryOp.argtypes = [POINTER(Nrrd), c_int, POINTER(NrrdIter), POINTER(NrrdIter), POINTER(NrrdIter)]
nrrdArithIterTernaryOpSelect = libteem.nrrdArithIterTernaryOpSelect
nrrdArithIterTernaryOpSelect.restype = c_int
nrrdArithIterTernaryOpSelect.argtypes = [POINTER(Nrrd), c_int, POINTER(NrrdIter), POINTER(NrrdIter), POINTER(NrrdIter), c_uint]
nrrdArithIterAffine = libteem.nrrdArithIterAffine
nrrdArithIterAffine.restype = c_int
nrrdArithIterAffine.argtypes = [POINTER(Nrrd), POINTER(NrrdIter), POINTER(NrrdIter), POINTER(NrrdIter), POINTER(NrrdIter), POINTER(NrrdIter), c_int]
nrrdCRC32 = libteem.nrrdCRC32
nrrdCRC32.restype = c_uint
nrrdCRC32.argtypes = [POINTER(Nrrd), c_int]
nrrdCheapMedian = libteem.nrrdCheapMedian
nrrdCheapMedian.restype = c_int
nrrdCheapMedian.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_int, c_uint, c_float, c_uint]
nrrdDistanceL2 = libteem.nrrdDistanceL2
nrrdDistanceL2.restype = c_int
nrrdDistanceL2.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, POINTER(c_int), c_double, c_int]
nrrdDistanceL2Biased = libteem.nrrdDistanceL2Biased
nrrdDistanceL2Biased.restype = c_int
nrrdDistanceL2Biased.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, POINTER(c_int), c_double, c_double, c_int]
nrrdDistanceL2Signed = libteem.nrrdDistanceL2Signed
nrrdDistanceL2Signed.restype = c_int
nrrdDistanceL2Signed.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, POINTER(c_int), c_double, c_int]
class NrrdDeringContext(Structure):
    pass
nrrdDeringContextNew = libteem.nrrdDeringContextNew
nrrdDeringContextNew.restype = POINTER(NrrdDeringContext)
nrrdDeringContextNew.argtypes = []
nrrdDeringContextNix = libteem.nrrdDeringContextNix
nrrdDeringContextNix.restype = POINTER(NrrdDeringContext)
nrrdDeringContextNix.argtypes = [POINTER(NrrdDeringContext)]
nrrdDeringVerboseSet = libteem.nrrdDeringVerboseSet
nrrdDeringVerboseSet.restype = c_int
nrrdDeringVerboseSet.argtypes = [POINTER(NrrdDeringContext), c_int]
nrrdDeringLinearInterpSet = libteem.nrrdDeringLinearInterpSet
nrrdDeringLinearInterpSet.restype = c_int
nrrdDeringLinearInterpSet.argtypes = [POINTER(NrrdDeringContext), c_int]
nrrdDeringVerticalSeamSet = libteem.nrrdDeringVerticalSeamSet
nrrdDeringVerticalSeamSet.restype = c_int
nrrdDeringVerticalSeamSet.argtypes = [POINTER(NrrdDeringContext), c_int]
nrrdDeringInputSet = libteem.nrrdDeringInputSet
nrrdDeringInputSet.restype = c_int
nrrdDeringInputSet.argtypes = [POINTER(NrrdDeringContext), POINTER(Nrrd)]
nrrdDeringCenterSet = libteem.nrrdDeringCenterSet
nrrdDeringCenterSet.restype = c_int
nrrdDeringCenterSet.argtypes = [POINTER(NrrdDeringContext), c_double, c_double]
nrrdDeringClampPercSet = libteem.nrrdDeringClampPercSet
nrrdDeringClampPercSet.restype = c_int
nrrdDeringClampPercSet.argtypes = [POINTER(NrrdDeringContext), c_double, c_double]
nrrdDeringClampHistoBinsSet = libteem.nrrdDeringClampHistoBinsSet
nrrdDeringClampHistoBinsSet.restype = c_int
nrrdDeringClampHistoBinsSet.argtypes = [POINTER(NrrdDeringContext), c_uint]
nrrdDeringRadiusScaleSet = libteem.nrrdDeringRadiusScaleSet
nrrdDeringRadiusScaleSet.restype = c_int
nrrdDeringRadiusScaleSet.argtypes = [POINTER(NrrdDeringContext), c_double]
nrrdDeringThetaNumSet = libteem.nrrdDeringThetaNumSet
nrrdDeringThetaNumSet.restype = c_int
nrrdDeringThetaNumSet.argtypes = [POINTER(NrrdDeringContext), c_uint]
nrrdDeringRadialKernelSet = libteem.nrrdDeringRadialKernelSet
nrrdDeringRadialKernelSet.restype = c_int
nrrdDeringRadialKernelSet.argtypes = [POINTER(NrrdDeringContext), POINTER(NrrdKernel), POINTER(c_double)]
nrrdDeringThetaKernelSet = libteem.nrrdDeringThetaKernelSet
nrrdDeringThetaKernelSet.restype = c_int
nrrdDeringThetaKernelSet.argtypes = [POINTER(NrrdDeringContext), POINTER(NrrdKernel), POINTER(c_double)]
nrrdDeringExecute = libteem.nrrdDeringExecute
nrrdDeringExecute.restype = c_int
nrrdDeringExecute.argtypes = [POINTER(NrrdDeringContext), POINTER(Nrrd)]
nrrdResample_t = c_double
class NrrdResampleContext(Structure):
    pass
nrrdResampleContextNew = libteem.nrrdResampleContextNew
nrrdResampleContextNew.restype = POINTER(NrrdResampleContext)
nrrdResampleContextNew.argtypes = []
nrrdResampleContextNix = libteem.nrrdResampleContextNix
nrrdResampleContextNix.restype = POINTER(NrrdResampleContext)
nrrdResampleContextNix.argtypes = [POINTER(NrrdResampleContext)]
nrrdResampleDefaultCenterSet = libteem.nrrdResampleDefaultCenterSet
nrrdResampleDefaultCenterSet.restype = c_int
nrrdResampleDefaultCenterSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleNonExistentSet = libteem.nrrdResampleNonExistentSet
nrrdResampleNonExistentSet.restype = c_int
nrrdResampleNonExistentSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleNrrdSet = libteem.nrrdResampleNrrdSet
nrrdResampleNrrdSet.restype = c_int
nrrdResampleNrrdSet.argtypes = [POINTER(NrrdResampleContext), POINTER(Nrrd)]
nrrdResampleInputSet = libteem.nrrdResampleInputSet
nrrdResampleInputSet.restype = c_int
nrrdResampleInputSet.argtypes = [POINTER(NrrdResampleContext), POINTER(Nrrd)]
nrrdResampleKernelSet = libteem.nrrdResampleKernelSet
nrrdResampleKernelSet.restype = c_int
nrrdResampleKernelSet.argtypes = [POINTER(NrrdResampleContext), c_uint, POINTER(NrrdKernel), POINTER(c_double)]
nrrdResampleSamplesSet = libteem.nrrdResampleSamplesSet
nrrdResampleSamplesSet.restype = c_int
nrrdResampleSamplesSet.argtypes = [POINTER(NrrdResampleContext), c_uint, c_size_t]
nrrdResampleRangeSet = libteem.nrrdResampleRangeSet
nrrdResampleRangeSet.restype = c_int
nrrdResampleRangeSet.argtypes = [POINTER(NrrdResampleContext), c_uint, c_double, c_double]
nrrdResampleOverrideCenterSet = libteem.nrrdResampleOverrideCenterSet
nrrdResampleOverrideCenterSet.restype = c_int
nrrdResampleOverrideCenterSet.argtypes = [POINTER(NrrdResampleContext), c_uint, c_int]
nrrdResampleRangeFullSet = libteem.nrrdResampleRangeFullSet
nrrdResampleRangeFullSet.restype = c_int
nrrdResampleRangeFullSet.argtypes = [POINTER(NrrdResampleContext), c_uint]
nrrdResampleBoundarySet = libteem.nrrdResampleBoundarySet
nrrdResampleBoundarySet.restype = c_int
nrrdResampleBoundarySet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResamplePadValueSet = libteem.nrrdResamplePadValueSet
nrrdResamplePadValueSet.restype = c_int
nrrdResamplePadValueSet.argtypes = [POINTER(NrrdResampleContext), c_double]
nrrdResampleTypeOutSet = libteem.nrrdResampleTypeOutSet
nrrdResampleTypeOutSet.restype = c_int
nrrdResampleTypeOutSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleRenormalizeSet = libteem.nrrdResampleRenormalizeSet
nrrdResampleRenormalizeSet.restype = c_int
nrrdResampleRenormalizeSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleRoundSet = libteem.nrrdResampleRoundSet
nrrdResampleRoundSet.restype = c_int
nrrdResampleRoundSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleClampSet = libteem.nrrdResampleClampSet
nrrdResampleClampSet.restype = c_int
nrrdResampleClampSet.argtypes = [POINTER(NrrdResampleContext), c_int]
nrrdResampleExecute = libteem.nrrdResampleExecute
nrrdResampleExecute.restype = c_int
nrrdResampleExecute.argtypes = [POINTER(NrrdResampleContext), POINTER(Nrrd)]
NrrdResampleInfo._pack_ = 4
NrrdResampleInfo._fields_ = [
    ('kernel', POINTER(NrrdKernel) * 16),
    ('samples', c_size_t * 16),
    ('parm', c_double * 8 * 16),
    ('min', c_double * 16),
    ('max', c_double * 16),
    ('boundary', c_int),
    ('type', c_int),
    ('renormalize', c_int),
    ('round', c_int),
    ('clamp', c_int),
    ('cheap', c_int),
    ('padValue', c_double),
]
nrrdSpatialResample = libteem.nrrdSpatialResample
nrrdSpatialResample.restype = c_int
nrrdSpatialResample.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdResampleInfo)]
nrrdSimpleResample = libteem.nrrdSimpleResample
nrrdSimpleResample.restype = c_int
nrrdSimpleResample.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(NrrdKernel), POINTER(c_double), POINTER(c_size_t), POINTER(c_double)]
nrrdCCValid = libteem.nrrdCCValid
nrrdCCValid.restype = c_int
nrrdCCValid.argtypes = [POINTER(Nrrd)]
nrrdCCSize = libteem.nrrdCCSize
nrrdCCSize.restype = c_uint
nrrdCCSize.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
nrrdCCMax = libteem.nrrdCCMax
nrrdCCMax.restype = c_uint
nrrdCCMax.argtypes = [POINTER(Nrrd)]
nrrdCCNum = libteem.nrrdCCNum
nrrdCCNum.restype = c_uint
nrrdCCNum.argtypes = [POINTER(Nrrd)]
nrrdCCFind = libteem.nrrdCCFind
nrrdCCFind.restype = c_int
nrrdCCFind.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(Nrrd), c_int, c_uint]
nrrdCCAdjacency = libteem.nrrdCCAdjacency
nrrdCCAdjacency.restype = c_int
nrrdCCAdjacency.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint]
nrrdCCMerge = libteem.nrrdCCMerge
nrrdCCMerge.restype = c_int
nrrdCCMerge.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_int, c_uint, c_uint, c_uint]
nrrdCCRevalue = libteem.nrrdCCRevalue
nrrdCCRevalue.restype = c_int
nrrdCCRevalue.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
nrrdCCSettle = libteem.nrrdCCSettle
nrrdCCSettle.restype = c_int
nrrdCCSettle.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(Nrrd)]
nrrdFFTWEnabled = (c_int).in_dll(libteem, 'nrrdFFTWEnabled')
nrrdFFTWWisdomRead = libteem.nrrdFFTWWisdomRead
nrrdFFTWWisdomRead.restype = c_int
nrrdFFTWWisdomRead.argtypes = [POINTER(FILE)]
nrrdFFT = libteem.nrrdFFT
nrrdFFT.restype = c_int
nrrdFFT.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_uint), c_uint, c_int, c_int, c_int]
nrrdFFTWWisdomWrite = libteem.nrrdFFTWWisdomWrite
nrrdFFTWWisdomWrite.restype = c_int
nrrdFFTWWisdomWrite.argtypes = [POINTER(FILE)]
nrrdKernelTMF = (POINTER(NrrdKernel) * 5 * 5 * 4).in_dll(libteem, 'nrrdKernelTMF')
nrrdKernelTMF_maxD = (c_uint).in_dll(libteem, 'nrrdKernelTMF_maxD')
nrrdKernelTMF_maxC = (c_uint).in_dll(libteem, 'nrrdKernelTMF_maxC')
nrrdKernelTMF_maxA = (c_uint).in_dll(libteem, 'nrrdKernelTMF_maxA')
nrrdKernelHann = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelHann')
nrrdKernelHannD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelHannD')
nrrdKernelHannDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelHannDD')
nrrdKernelBlackman = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBlackman')
nrrdKernelBlackmanD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBlackmanD')
nrrdKernelBlackmanDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBlackmanDD')
nrrdKernelBSpline1 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline1')
nrrdKernelBSpline1D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline1D')
nrrdKernelBSpline2 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline2')
nrrdKernelBSpline2D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline2D')
nrrdKernelBSpline2DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline2DD')
nrrdKernelBSpline3 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline3')
nrrdKernelBSpline3D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline3D')
nrrdKernelBSpline3DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline3DD')
nrrdKernelBSpline3DDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline3DDD')
nrrdKernelBSpline3ApproxInverse = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline3ApproxInverse')
nrrdKernelBSpline4 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline4')
nrrdKernelBSpline4D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline4D')
nrrdKernelBSpline4DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline4DD')
nrrdKernelBSpline4DDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline4DDD')
nrrdKernelBSpline5 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline5')
nrrdKernelBSpline5D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline5D')
nrrdKernelBSpline5DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline5DD')
nrrdKernelBSpline5DDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline5DDD')
nrrdKernelBSpline5ApproxInverse = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline5ApproxInverse')
nrrdKernelBSpline6 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline6')
nrrdKernelBSpline6D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline6D')
nrrdKernelBSpline6DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline6DD')
nrrdKernelBSpline6DDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline6DDD')
nrrdKernelBSpline7 = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline7')
nrrdKernelBSpline7D = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline7D')
nrrdKernelBSpline7DD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline7DD')
nrrdKernelBSpline7DDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline7DDD')
nrrdKernelBSpline7ApproxInverse = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBSpline7ApproxInverse')
nrrdKernelZero = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelZero')
nrrdKernelBox = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBox')
nrrdKernelBoxSupportDebug = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBoxSupportDebug')
nrrdKernelCos4SupportDebug = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCos4SupportDebug')
nrrdKernelCos4SupportDebugD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCos4SupportDebugD')
nrrdKernelCos4SupportDebugDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCos4SupportDebugDD')
nrrdKernelCos4SupportDebugDDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCos4SupportDebugDDD')
nrrdKernelCatmullRomSupportDebug = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRomSupportDebug')
nrrdKernelCatmullRomSupportDebugD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRomSupportDebugD')
nrrdKernelCatmullRomSupportDebugDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRomSupportDebugDD')
nrrdKernelCheap = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCheap')
nrrdKernelHermiteScaleSpaceFlag = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelHermiteScaleSpaceFlag')
nrrdKernelTent = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelTent')
nrrdKernelForwDiff = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelForwDiff')
nrrdKernelCentDiff = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCentDiff')
nrrdKernelBCCubic = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBCCubic')
nrrdKernelBCCubicD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBCCubicD')
nrrdKernelBCCubicDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelBCCubicDD')
nrrdKernelCatmullRom = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRom')
nrrdKernelCatmullRomD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRomD')
nrrdKernelCatmullRomDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelCatmullRomDD')
nrrdKernelAQuartic = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelAQuartic')
nrrdKernelAQuarticD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelAQuarticD')
nrrdKernelAQuarticDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelAQuarticDD')
nrrdKernelC3Quintic = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC3Quintic')
nrrdKernelC3QuinticD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC3QuinticD')
nrrdKernelC3QuinticDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC3QuinticDD')
nrrdKernelC4Hexic = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC4Hexic')
nrrdKernelC4HexicD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC4HexicD')
nrrdKernelC4HexicDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC4HexicDD')
nrrdKernelC4HexicDDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC4HexicDDD')
nrrdKernelC4HexicApproxInverse = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC4HexicApproxInverse')
nrrdKernelC5Septic = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC5Septic')
nrrdKernelC5SepticD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC5SepticD')
nrrdKernelC5SepticDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC5SepticDD')
nrrdKernelC5SepticDDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC5SepticDDD')
nrrdKernelC5SepticApproxInverse = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelC5SepticApproxInverse')
nrrdKernelGaussian = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelGaussian')
nrrdKernelGaussianD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelGaussianD')
nrrdKernelGaussianDD = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelGaussianDD')
nrrdKernelDiscreteGaussian = (POINTER(NrrdKernel)).in_dll(libteem, 'nrrdKernelDiscreteGaussian')
nrrdKernelParse = libteem.nrrdKernelParse
nrrdKernelParse.restype = c_int
nrrdKernelParse.argtypes = [POINTER(POINTER(NrrdKernel)), POINTER(c_double), STRING]
nrrdKernelSpecParse = libteem.nrrdKernelSpecParse
nrrdKernelSpecParse.restype = c_int
nrrdKernelSpecParse.argtypes = [POINTER(NrrdKernelSpec), STRING]
nrrdKernelSpecSprint = libteem.nrrdKernelSpecSprint
nrrdKernelSpecSprint.restype = c_int
nrrdKernelSpecSprint.argtypes = [STRING, POINTER(NrrdKernelSpec)]
nrrdKernelSprint = libteem.nrrdKernelSprint
nrrdKernelSprint.restype = c_int
nrrdKernelSprint.argtypes = [STRING, POINTER(NrrdKernel), POINTER(c_double)]
nrrdKernelCompare = libteem.nrrdKernelCompare
nrrdKernelCompare.restype = c_int
nrrdKernelCompare.argtypes = [POINTER(NrrdKernel), POINTER(c_double), POINTER(NrrdKernel), POINTER(c_double), POINTER(c_int), STRING]
nrrdKernelCheck = libteem.nrrdKernelCheck
nrrdKernelCheck.restype = c_int
nrrdKernelCheck.argtypes = [POINTER(NrrdKernel), POINTER(c_double), c_size_t, c_double, c_uint, c_uint, POINTER(NrrdKernel), POINTER(c_double)]
class pullInfoSpec_t(Structure):
    pass
pullInfoSpec_t._pack_ = 4
pullInfoSpec_t._fields_ = [
    ('info', c_int),
    ('source', c_int),
    ('volName', STRING),
    ('item', c_int),
    ('prop', c_int),
    ('scale', c_double),
    ('zero', c_double),
    ('constraint', c_int),
    ('volIdx', c_uint),
]
pullInfoSpec = pullInfoSpec_t
class pullPoint_t(Structure):
    pass
pullPoint_t._pack_ = 4
pullPoint_t._fields_ = [
    ('idtag', c_uint),
    ('idCC', c_uint),
    ('neighPoint', POINTER(POINTER(pullPoint_t))),
    ('neighPointNum', c_uint),
    ('neighPointArr', POINTER(airArray)),
    ('neighDistMean', c_double),
    ('neighCovar', c_float * 10),
    ('neighTanCovar', c_float * 6),
    ('stability', c_float),
    ('neighInterNum', c_uint),
    ('stuckIterNum', c_uint),
    ('status', c_int),
    ('pos', c_double * 4),
    ('energy', c_double),
    ('force', c_double * 4),
    ('stepEnergy', c_double),
    ('stepConstr', c_double),
    ('info', c_double * 1),
]
pullPoint = pullPoint_t
class pullBin_t(Structure):
    pass
pullBin_t._fields_ = [
    ('point', POINTER(POINTER(pullPoint))),
    ('pointNum', c_uint),
    ('pointArr', POINTER(airArray)),
    ('neighBin', POINTER(POINTER(pullBin_t))),
]
pullBin = pullBin_t
class pullEnergy(Structure):
    pass
pullEnergy._fields_ = [
    ('name', c_char * 129),
    ('parmNum', c_uint),
    ('well', CFUNCTYPE(c_double, POINTER(c_double), POINTER(c_double))),
    ('eval', CFUNCTYPE(c_double, POINTER(c_double), c_double, POINTER(c_double))),
]
class pullEnergySpec(Structure):
    pass
pullEnergySpec._pack_ = 4
pullEnergySpec._fields_ = [
    ('energy', POINTER(pullEnergy)),
    ('parm', c_double * 3),
]
class pullVolume(Structure):
    pass
pullVolume._pack_ = 4
pullVolume._fields_ = [
    ('verbose', c_int),
    ('name', STRING),
    ('kind', POINTER(gageKind)),
    ('ninSingle', POINTER(Nrrd)),
    ('ninScale', POINTER(POINTER(Nrrd))),
    ('scaleNum', c_uint),
    ('scalePos', POINTER(c_double)),
    ('scaleDerivNorm', c_int),
    ('scaleDerivNormBias', c_double),
    ('ksp00', POINTER(NrrdKernelSpec)),
    ('ksp11', POINTER(NrrdKernelSpec)),
    ('ksp22', POINTER(NrrdKernelSpec)),
    ('kspSS', POINTER(NrrdKernelSpec)),
    ('pullValQuery', gageQuery),
    ('gctx', POINTER(gageContext)),
    ('gpvl', POINTER(gagePerVolume)),
    ('gpvlSS', POINTER(POINTER(gagePerVolume))),
    ('seedOnly', c_int),
    ('forSeedPreThresh', c_int),
]
class pullTask_t(Structure):
    pass
pullTask_t._fields_ = [
    ('pctx', POINTER(pullContext_t)),
    ('vol', POINTER(pullVolume) * 4),
    ('ans', POINTER(c_double) * 24),
    ('processMode', c_int),
    ('probeSeedPreThreshOnly', c_int),
    ('thread', POINTER(airThread)),
    ('threadIdx', c_uint),
    ('rng', POINTER(airRandMTState)),
    ('pointBuffer', POINTER(pullPoint)),
    ('neighPoint', POINTER(POINTER(pullPoint))),
    ('addPoint', POINTER(POINTER(pullPoint))),
    ('addPointNum', c_uint),
    ('addPointArr', POINTER(airArray)),
    ('nixPoint', POINTER(POINTER(pullPoint))),
    ('nixPointNum', c_uint),
    ('nixPointArr', POINTER(airArray)),
    ('returnPtr', c_void_p),
    ('stuckNum', c_uint),
]
pullTask = pullTask_t
class pullInitParm(Structure):
    pass
pullInitParm._pack_ = 4
pullInitParm._fields_ = [
    ('method', c_int),
    ('liveThreshUse', c_int),
    ('unequalShapesAllow', c_int),
    ('jitter', c_double),
    ('numInitial', c_uint),
    ('haltonStartIndex', c_uint),
    ('samplesAlongScaleNum', c_uint),
    ('ppvZRange', c_uint * 2),
    ('pointPerVoxel', c_int),
    ('npos', POINTER(Nrrd)),
]
class pullIterParm(Structure):
    pass
pullIterParm._fields_ = [
    ('min', c_uint),
    ('max', c_uint),
    ('popCntlPeriod', c_uint),
    ('addDescent', c_uint),
    ('constraintMax', c_uint),
    ('stuckMax', c_uint),
    ('callback', c_uint),
    ('snap', c_uint),
    ('energyIncreasePermitHalfLife', c_uint),
]
class pullSysParm(Structure):
    pass
pullSysParm._pack_ = 4
pullSysParm._fields_ = [
    ('alpha', c_double),
    ('beta', c_double),
    ('gamma', c_double),
    ('separableGammaLearnRescale', c_double),
    ('theta', c_double),
    ('wall', c_double),
    ('radiusSpace', c_double),
    ('radiusScale', c_double),
    ('binWidthSpace', c_double),
    ('neighborTrueProb', c_double),
    ('probeProb', c_double),
    ('stepInitial', c_double),
    ('opporStepScale', c_double),
    ('backStepScale', c_double),
    ('constraintStepMin', c_double),
    ('energyDecreaseMin', c_double),
    ('energyDecreasePopCntlMin', c_double),
    ('energyIncreasePermit', c_double),
    ('fracNeighNixedMax', c_double),
]
class pullFlag(Structure):
    pass
pullFlag._fields_ = [
    ('permuteOnRebin', c_int),
    ('noPopCntlWithZeroAlpha', c_int),
    ('useBetaForGammaLearn', c_int),
    ('restrictiveAddToBins', c_int),
    ('energyFromStrength', c_int),
    ('nixAtVolumeEdgeSpace', c_int),
    ('constraintBeforeSeedThresh', c_int),
    ('popCntlEnoughTest', c_int),
    ('noAdd', c_int),
    ('binSingle', c_int),
    ('allowCodimension3Constraints', c_int),
    ('scaleIsTau', c_int),
    ('startSkipsPoints', c_int),
]
pullContext_t._pack_ = 4
pullContext_t._fields_ = [
    ('initParm', pullInitParm),
    ('iterParm', pullIterParm),
    ('sysParm', pullSysParm),
    ('flag', pullFlag),
    ('verbose', c_int),
    ('threadNum', c_uint),
    ('rngSeed', c_uint),
    ('progressBinMod', c_uint),
    ('iter_cb', CFUNCTYPE(None, c_void_p)),
    ('data_cb', c_void_p),
    ('vol', POINTER(pullVolume) * 4),
    ('volNum', c_uint),
    ('ispec', POINTER(pullInfoSpec) * 24),
    ('interType', c_int),
    ('energySpecR', POINTER(pullEnergySpec)),
    ('energySpecS', POINTER(pullEnergySpec)),
    ('energySpecWin', POINTER(pullEnergySpec)),
    ('haltonOffset', c_uint),
    ('bboxMin', c_double * 4),
    ('bboxMax', c_double * 4),
    ('infoTotalLen', c_uint),
    ('infoIdx', c_uint * 24),
    ('idtagNext', c_uint),
    ('haveScale', c_int),
    ('constraint', c_int),
    ('constraintDim', c_int),
    ('targetDim', c_int),
    ('finished', c_int),
    ('maxDistSpace', c_double),
    ('maxDistScale', c_double),
    ('voxelSizeSpace', c_double),
    ('voxelSizeScale', c_double),
    ('eipScale', c_double),
    ('bin', POINTER(pullBin)),
    ('binsEdge', c_uint * 4),
    ('binNum', c_uint),
    ('binNextIdx', c_uint),
    ('tmpPointPerm', POINTER(c_uint)),
    ('tmpPointPtr', POINTER(POINTER(pullPoint))),
    ('tmpPointNum', c_uint),
    ('binMutex', POINTER(airThreadMutex)),
    ('task', POINTER(POINTER(pullTask))),
    ('iterBarrierA', POINTER(airThreadBarrier)),
    ('iterBarrierB', POINTER(airThreadBarrier)),
    ('logAdd', POINTER(FILE)),
    ('timeIteration', c_double),
    ('timeRun', c_double),
    ('energy', c_double),
    ('addNum', c_uint),
    ('nixNum', c_uint),
    ('stuckNum', c_uint),
    ('pointNum', c_uint),
    ('CCNum', c_uint),
    ('iter', c_uint),
    ('count', c_uint * 15),
]
class pullTrace(Structure):
    pass
pullTrace._pack_ = 4
pullTrace._fields_ = [
    ('seedPos', c_double * 4),
    ('nvert', POINTER(Nrrd)),
    ('nstrn', POINTER(Nrrd)),
    ('nvelo', POINTER(Nrrd)),
    ('seedIdx', c_uint),
    ('whyStop', c_int * 2),
    ('whyNowhere', c_int),
]
class pullTraceMulti(Structure):
    pass
pullTraceMulti._fields_ = [
    ('trace', POINTER(POINTER(pullTrace))),
    ('traceNum', c_uint),
    ('traceArr', POINTER(airArray)),
]
class pullPtrPtrUnion(Union):
    pass
pullPtrPtrUnion._fields_ = [
    ('points', POINTER(POINTER(POINTER(pullPoint)))),
    ('v', POINTER(c_void_p)),
]
pullPresent = (c_int).in_dll(libteem, 'pullPresent')
pullPhistEnabled = (c_int).in_dll(libteem, 'pullPhistEnabled')
pullBiffKey = (STRING).in_dll(libteem, 'pullBiffKey')
pullInitRandomSet = libteem.pullInitRandomSet
pullInitRandomSet.restype = c_int
pullInitRandomSet.argtypes = [POINTER(pullContext), c_uint]
pullInitHaltonSet = libteem.pullInitHaltonSet
pullInitHaltonSet.restype = c_int
pullInitHaltonSet.argtypes = [POINTER(pullContext), c_uint, c_uint]
pullInitPointPerVoxelSet = libteem.pullInitPointPerVoxelSet
pullInitPointPerVoxelSet.restype = c_int
pullInitPointPerVoxelSet.argtypes = [POINTER(pullContext), c_int, c_uint, c_uint, c_uint, c_double]
pullInitGivenPosSet = libteem.pullInitGivenPosSet
pullInitGivenPosSet.restype = c_int
pullInitGivenPosSet.argtypes = [POINTER(pullContext), POINTER(Nrrd)]
pullInitLiveThreshUseSet = libteem.pullInitLiveThreshUseSet
pullInitLiveThreshUseSet.restype = c_int
pullInitLiveThreshUseSet.argtypes = [POINTER(pullContext), c_int]
pullInitUnequalShapesAllowSet = libteem.pullInitUnequalShapesAllowSet
pullInitUnequalShapesAllowSet.restype = c_int
pullInitUnequalShapesAllowSet.argtypes = [POINTER(pullContext), c_int]
pullIterParmSet = libteem.pullIterParmSet
pullIterParmSet.restype = c_int
pullIterParmSet.argtypes = [POINTER(pullContext), c_int, c_uint]
pullSysParmSet = libteem.pullSysParmSet
pullSysParmSet.restype = c_int
pullSysParmSet.argtypes = [POINTER(pullContext), c_int, c_double]
pullFlagSet = libteem.pullFlagSet
pullFlagSet.restype = c_int
pullFlagSet.argtypes = [POINTER(pullContext), c_int, c_int]
pullVerboseSet = libteem.pullVerboseSet
pullVerboseSet.restype = c_int
pullVerboseSet.argtypes = [POINTER(pullContext), c_int]
pullThreadNumSet = libteem.pullThreadNumSet
pullThreadNumSet.restype = c_int
pullThreadNumSet.argtypes = [POINTER(pullContext), c_uint]
pullRngSeedSet = libteem.pullRngSeedSet
pullRngSeedSet.restype = c_int
pullRngSeedSet.argtypes = [POINTER(pullContext), c_uint]
pullProgressBinModSet = libteem.pullProgressBinModSet
pullProgressBinModSet.restype = c_int
pullProgressBinModSet.argtypes = [POINTER(pullContext), c_uint]
pullCallbackSet = libteem.pullCallbackSet
pullCallbackSet.restype = c_int
pullCallbackSet.argtypes = [POINTER(pullContext), CFUNCTYPE(None, c_void_p), c_void_p]
pullInterEnergySet = libteem.pullInterEnergySet
pullInterEnergySet.restype = c_int
pullInterEnergySet.argtypes = [POINTER(pullContext), c_int, POINTER(pullEnergySpec), POINTER(pullEnergySpec), POINTER(pullEnergySpec)]
pullLogAddSet = libteem.pullLogAddSet
pullLogAddSet.restype = c_int
pullLogAddSet.argtypes = [POINTER(pullContext), POINTER(FILE)]
pullInterType = (POINTER(airEnum)).in_dll(libteem, 'pullInterType')
pullEnergyType = (POINTER(airEnum)).in_dll(libteem, 'pullEnergyType')
pullEnergyUnknown = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyUnknown')
pullEnergySpring = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergySpring')
pullEnergyGauss = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyGauss')
pullEnergyBspln = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyBspln')
pullEnergyButterworth = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyButterworth')
pullEnergyCotan = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyCotan')
pullEnergyCubic = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyCubic')
pullEnergyQuartic = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyQuartic')
pullEnergyCubicWell = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyCubicWell')
pullEnergyBetterCubicWell = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyBetterCubicWell')
pullEnergyQuarticWell = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyQuarticWell')
pullEnergyHepticWell = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyHepticWell')
pullEnergyZero = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyZero')
pullEnergyButterworthParabola = (POINTER(pullEnergy)).in_dll(libteem, 'pullEnergyButterworthParabola')
pullEnergyAll = (POINTER(pullEnergy) * 14).in_dll(libteem, 'pullEnergyAll')
pullEnergySpecNew = libteem.pullEnergySpecNew
pullEnergySpecNew.restype = POINTER(pullEnergySpec)
pullEnergySpecNew.argtypes = []
pullEnergySpecSet = libteem.pullEnergySpecSet
pullEnergySpecSet.restype = None
pullEnergySpecSet.argtypes = [POINTER(pullEnergySpec), POINTER(pullEnergy), POINTER(c_double)]
pullEnergySpecCopy = libteem.pullEnergySpecCopy
pullEnergySpecCopy.restype = None
pullEnergySpecCopy.argtypes = [POINTER(pullEnergySpec), POINTER(pullEnergySpec)]
pullEnergySpecNix = libteem.pullEnergySpecNix
pullEnergySpecNix.restype = POINTER(pullEnergySpec)
pullEnergySpecNix.argtypes = [POINTER(pullEnergySpec)]
pullEnergySpecParse = libteem.pullEnergySpecParse
pullEnergySpecParse.restype = c_int
pullEnergySpecParse.argtypes = [POINTER(pullEnergySpec), STRING]
pullHestEnergySpec = (POINTER(hestCB)).in_dll(libteem, 'pullHestEnergySpec')
pullVolumeNew = libteem.pullVolumeNew
pullVolumeNew.restype = POINTER(pullVolume)
pullVolumeNew.argtypes = []
pullVolumeNix = libteem.pullVolumeNix
pullVolumeNix.restype = POINTER(pullVolume)
pullVolumeNix.argtypes = [POINTER(pullVolume)]
pullVolumeSingleAdd = libteem.pullVolumeSingleAdd
pullVolumeSingleAdd.restype = c_int
pullVolumeSingleAdd.argtypes = [POINTER(pullContext), POINTER(gageKind), STRING, POINTER(Nrrd), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec)]
pullVolumeStackAdd = libteem.pullVolumeStackAdd
pullVolumeStackAdd.restype = c_int
pullVolumeStackAdd.argtypes = [POINTER(pullContext), POINTER(gageKind), STRING, POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(c_double), c_uint, c_int, c_double, POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec), POINTER(NrrdKernelSpec)]
pullVolumeLookup = libteem.pullVolumeLookup
pullVolumeLookup.restype = POINTER(pullVolume)
pullVolumeLookup.argtypes = [POINTER(pullContext), STRING]
pullConstraintScaleRange = libteem.pullConstraintScaleRange
pullConstraintScaleRange.restype = c_int
pullConstraintScaleRange.argtypes = [POINTER(pullContext), POINTER(c_double)]
pullInfo = (POINTER(airEnum)).in_dll(libteem, 'pullInfo')
pullSource = (POINTER(airEnum)).in_dll(libteem, 'pullSource')
pullProp = (POINTER(airEnum)).in_dll(libteem, 'pullProp')
pullProcessMode = (POINTER(airEnum)).in_dll(libteem, 'pullProcessMode')
pullTraceStop = (POINTER(airEnum)).in_dll(libteem, 'pullTraceStop')
pullCount = (POINTER(airEnum)).in_dll(libteem, 'pullCount')
pullConstraintFail = (POINTER(airEnum)).in_dll(libteem, 'pullConstraintFail')
pullPropLen = libteem.pullPropLen
pullPropLen.restype = c_uint
pullPropLen.argtypes = [c_int]
pullInfoLen = libteem.pullInfoLen
pullInfoLen.restype = c_uint
pullInfoLen.argtypes = [c_int]
pullInfoSpecNew = libteem.pullInfoSpecNew
pullInfoSpecNew.restype = POINTER(pullInfoSpec)
pullInfoSpecNew.argtypes = []
pullInfoSpecNix = libteem.pullInfoSpecNix
pullInfoSpecNix.restype = POINTER(pullInfoSpec)
pullInfoSpecNix.argtypes = [POINTER(pullInfoSpec)]
pullInfoSpecAdd = libteem.pullInfoSpecAdd
pullInfoSpecAdd.restype = c_int
pullInfoSpecAdd.argtypes = [POINTER(pullContext), POINTER(pullInfoSpec)]
pullInfoGet = libteem.pullInfoGet
pullInfoGet.restype = c_int
pullInfoGet.argtypes = [POINTER(Nrrd), c_int, POINTER(pullContext)]
pullInfoSpecSprint = libteem.pullInfoSpecSprint
pullInfoSpecSprint.restype = c_int
pullInfoSpecSprint.argtypes = [STRING, POINTER(pullContext), POINTER(pullInfoSpec)]
pullContextNew = libteem.pullContextNew
pullContextNew.restype = POINTER(pullContext)
pullContextNew.argtypes = []
pullContextNix = libteem.pullContextNix
pullContextNix.restype = POINTER(pullContext)
pullContextNix.argtypes = [POINTER(pullContext)]
pullOutputGet = libteem.pullOutputGet
pullOutputGet.restype = c_int
pullOutputGet.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(c_double), c_double, POINTER(pullContext)]
pullOutputGetFilter = libteem.pullOutputGetFilter
pullOutputGetFilter.restype = c_int
pullOutputGetFilter.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(c_double), c_double, POINTER(pullContext), c_uint, c_uint]
pullPositionHistoryGet = libteem.pullPositionHistoryGet
pullPositionHistoryGet.restype = c_int
pullPositionHistoryGet.argtypes = [POINTER(limnPolyData), POINTER(pullContext)]
pullPropGet = libteem.pullPropGet
pullPropGet.restype = c_int
pullPropGet.argtypes = [POINTER(Nrrd), c_int, POINTER(pullContext)]
pullPointInitializePerVoxel = libteem.pullPointInitializePerVoxel
pullPointInitializePerVoxel.restype = c_int
pullPointInitializePerVoxel.argtypes = [POINTER(pullContext), c_uint, POINTER(pullPoint), POINTER(pullVolume), POINTER(c_int)]
pullPointInitializeRandomOrHalton = libteem.pullPointInitializeRandomOrHalton
pullPointInitializeRandomOrHalton.restype = c_int
pullPointInitializeRandomOrHalton.argtypes = [POINTER(pullContext), c_uint, POINTER(pullPoint), POINTER(pullVolume)]
pullPointInitializeGivenPos = libteem.pullPointInitializeGivenPos
pullPointInitializeGivenPos.restype = c_int
pullPointInitializeGivenPos.argtypes = [POINTER(pullContext), POINTER(c_double), c_uint, POINTER(pullPoint), POINTER(c_int)]
pullPointScalar = libteem.pullPointScalar
pullPointScalar.restype = c_double
pullPointScalar.argtypes = [POINTER(pullContext), POINTER(pullPoint), c_int, POINTER(c_double), POINTER(c_double)]
pullPointNumber = libteem.pullPointNumber
pullPointNumber.restype = c_uint
pullPointNumber.argtypes = [POINTER(pullContext)]
pullPointNumberFilter = libteem.pullPointNumberFilter
pullPointNumberFilter.restype = c_uint
pullPointNumberFilter.argtypes = [POINTER(pullContext), c_uint, c_uint]
pullPointNew = libteem.pullPointNew
pullPointNew.restype = POINTER(pullPoint)
pullPointNew.argtypes = [POINTER(pullContext)]
pullPointNix = libteem.pullPointNix
pullPointNix.restype = POINTER(pullPoint)
pullPointNix.argtypes = [POINTER(pullPoint)]
pullProbe = libteem.pullProbe
pullProbe.restype = c_int
pullProbe.argtypes = [POINTER(pullTask), POINTER(pullPoint)]
pullBinsPointAdd = libteem.pullBinsPointAdd
pullBinsPointAdd.restype = c_int
pullBinsPointAdd.argtypes = [POINTER(pullContext), POINTER(pullPoint), POINTER(POINTER(pullBin))]
pullBinsPointMaybeAdd = libteem.pullBinsPointMaybeAdd
pullBinsPointMaybeAdd.restype = c_int
pullBinsPointMaybeAdd.argtypes = [POINTER(pullContext), POINTER(pullPoint), POINTER(POINTER(pullBin)), POINTER(c_int)]
pullTraceNew = libteem.pullTraceNew
pullTraceNew.restype = POINTER(pullTrace)
pullTraceNew.argtypes = []
pullTraceNix = libteem.pullTraceNix
pullTraceNix.restype = POINTER(pullTrace)
pullTraceNix.argtypes = [POINTER(pullTrace)]
pullTraceMultiSizeof = libteem.pullTraceMultiSizeof
pullTraceMultiSizeof.restype = c_size_t
pullTraceMultiSizeof.argtypes = [POINTER(pullTraceMulti)]
pullTraceSet = libteem.pullTraceSet
pullTraceSet.restype = c_int
pullTraceSet.argtypes = [POINTER(pullContext), POINTER(pullTrace), c_int, c_double, c_double, c_double, c_uint, POINTER(c_double)]
pullTraceMultiNew = libteem.pullTraceMultiNew
pullTraceMultiNew.restype = POINTER(pullTraceMulti)
pullTraceMultiNew.argtypes = []
pullTraceMultiNix = libteem.pullTraceMultiNix
pullTraceMultiNix.restype = POINTER(pullTraceMulti)
pullTraceMultiNix.argtypes = [POINTER(pullTraceMulti)]
pullTraceMultiAdd = libteem.pullTraceMultiAdd
pullTraceMultiAdd.restype = c_int
pullTraceMultiAdd.argtypes = [POINTER(pullTraceMulti), POINTER(pullTrace), POINTER(c_int)]
pullTraceMultiFilterConcaveDown = libteem.pullTraceMultiFilterConcaveDown
pullTraceMultiFilterConcaveDown.restype = c_int
pullTraceMultiFilterConcaveDown.argtypes = [POINTER(Nrrd), POINTER(pullTraceMulti), c_double]
pullTraceMultiPlotAdd = libteem.pullTraceMultiPlotAdd
pullTraceMultiPlotAdd.restype = c_int
pullTraceMultiPlotAdd.argtypes = [POINTER(Nrrd), POINTER(pullTraceMulti), POINTER(Nrrd), c_uint, c_uint]
pullTraceMultiWrite = libteem.pullTraceMultiWrite
pullTraceMultiWrite.restype = c_int
pullTraceMultiWrite.argtypes = [POINTER(FILE), POINTER(pullTraceMulti)]
pullTraceMultiRead = libteem.pullTraceMultiRead
pullTraceMultiRead.restype = c_int
pullTraceMultiRead.argtypes = [POINTER(pullTraceMulti), POINTER(FILE)]
pullEnergyPlot = libteem.pullEnergyPlot
pullEnergyPlot.restype = c_int
pullEnergyPlot.argtypes = [POINTER(pullContext), POINTER(Nrrd), c_double, c_double, c_double, c_uint]
pullBinProcess = libteem.pullBinProcess
pullBinProcess.restype = c_int
pullBinProcess.argtypes = [POINTER(pullTask), c_uint]
pullGammaLearn = libteem.pullGammaLearn
pullGammaLearn.restype = c_int
pullGammaLearn.argtypes = [POINTER(pullContext)]
pullStart = libteem.pullStart
pullStart.restype = c_int
pullStart.argtypes = [POINTER(pullContext)]
pullRun = libteem.pullRun
pullRun.restype = c_int
pullRun.argtypes = [POINTER(pullContext)]
pullFinish = libteem.pullFinish
pullFinish.restype = c_int
pullFinish.argtypes = [POINTER(pullContext)]
pullCCFind = libteem.pullCCFind
pullCCFind.restype = c_int
pullCCFind.argtypes = [POINTER(pullContext)]
pullCCMeasure = libteem.pullCCMeasure
pullCCMeasure.restype = c_int
pullCCMeasure.argtypes = [POINTER(pullContext), POINTER(Nrrd), c_int, c_double]
pullCCSort = libteem.pullCCSort
pullCCSort.restype = c_int
pullCCSort.argtypes = [POINTER(pullContext), c_int, c_double]
class pushPoint_t(Structure):
    pass
pushPoint_t._pack_ = 4
pushPoint_t._fields_ = [
    ('ttaagg', c_uint),
    ('pos', c_double * 3),
    ('enr', c_double),
    ('frc', c_double * 3),
    ('ten', c_double * 7),
    ('inv', c_double * 7),
    ('cnt', c_double * 3),
    ('grav', c_double),
    ('gravGrad', c_double * 3),
    ('seedThresh', c_double),
    ('neigh', POINTER(POINTER(pushPoint_t))),
    ('neighNum', c_uint),
    ('neighArr', POINTER(airArray)),
]
pushPoint = pushPoint_t
class pushBin_t(Structure):
    pass
pushBin_t._fields_ = [
    ('pointNum', c_uint),
    ('point', POINTER(POINTER(pushPoint))),
    ('pointArr', POINTER(airArray)),
    ('neighbor', POINTER(POINTER(pushBin_t))),
]
pushBin = pushBin_t
class pushTask_t(Structure):
    pass
class pushContext_t(Structure):
    pass
pushTask_t._pack_ = 4
pushTask_t._fields_ = [
    ('pctx', POINTER(pushContext_t)),
    ('gctx', POINTER(gageContext)),
    ('tenAns', POINTER(c_double)),
    ('invAns', POINTER(c_double)),
    ('cntAns', POINTER(c_double)),
    ('gravAns', POINTER(c_double)),
    ('gravGradAns', POINTER(c_double)),
    ('seedThreshAns', POINTER(c_double)),
    ('thread', POINTER(airThread)),
    ('threadIdx', c_uint),
    ('pointNum', c_uint),
    ('energySum', c_double),
    ('deltaFracSum', c_double),
    ('rng', POINTER(airRandMTState)),
    ('returnPtr', c_void_p),
]
pushTask = pushTask_t
class pushEnergy(Structure):
    pass
pushEnergy._fields_ = [
    ('name', c_char * 129),
    ('parmNum', c_uint),
    ('eval', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), c_double, POINTER(c_double))),
    ('support', CFUNCTYPE(c_double, POINTER(c_double))),
]
class pushEnergySpec(Structure):
    pass
pushEnergySpec._pack_ = 4
pushEnergySpec._fields_ = [
    ('energy', POINTER(pushEnergy)),
    ('parm', c_double * 3),
]
pushContext_t._pack_ = 4
pushContext_t._fields_ = [
    ('pointNum', c_uint),
    ('nin', POINTER(Nrrd)),
    ('npos', POINTER(Nrrd)),
    ('stepInitial', c_double),
    ('scale', c_double),
    ('wall', c_double),
    ('cntScl', c_double),
    ('deltaLimit', c_double),
    ('deltaFracMin', c_double),
    ('energyStepFrac', c_double),
    ('deltaFracStepFrac', c_double),
    ('neighborTrueProb', c_double),
    ('probeProb', c_double),
    ('energyImprovMin', c_double),
    ('detReject', c_int),
    ('midPntSmp', c_int),
    ('verbose', c_int),
    ('seedRNG', c_uint),
    ('threadNum', c_uint),
    ('maxIter', c_uint),
    ('snap', c_uint),
    ('gravItem', c_int),
    ('gravGradItem', c_int),
    ('gravScl', c_double),
    ('gravZero', c_double),
    ('seedThreshItem', c_int),
    ('seedThreshSign', c_int),
    ('seedThresh', c_double),
    ('ensp', POINTER(pushEnergySpec)),
    ('binSingle', c_int),
    ('binIncr', c_uint),
    ('ksp00', POINTER(NrrdKernelSpec)),
    ('ksp11', POINTER(NrrdKernelSpec)),
    ('ksp22', POINTER(NrrdKernelSpec)),
    ('ttaagg', c_uint),
    ('nten', POINTER(Nrrd)),
    ('ninv', POINTER(Nrrd)),
    ('nmask', POINTER(Nrrd)),
    ('gctx', POINTER(gageContext)),
    ('tpvl', POINTER(gagePerVolume)),
    ('ipvl', POINTER(gagePerVolume)),
    ('finished', c_int),
    ('dimIn', c_uint),
    ('sliceAxis', c_uint),
    ('bin', POINTER(pushBin)),
    ('binsEdge', c_uint * 3),
    ('binNum', c_uint),
    ('binIdx', c_uint),
    ('binMutex', POINTER(airThreadMutex)),
    ('step', c_double),
    ('maxDist', c_double),
    ('maxEval', c_double),
    ('meanEval', c_double),
    ('maxDet', c_double),
    ('energySum', c_double),
    ('task', POINTER(POINTER(pushTask))),
    ('iterBarrierA', POINTER(airThreadBarrier)),
    ('iterBarrierB', POINTER(airThreadBarrier)),
    ('deltaFrac', c_double),
    ('timeIteration', c_double),
    ('timeRun', c_double),
    ('iter', c_uint),
    ('noutPos', POINTER(Nrrd)),
    ('noutTen', POINTER(Nrrd)),
]
pushContext = pushContext_t
class pushPtrPtrUnion(Union):
    pass
pushPtrPtrUnion._fields_ = [
    ('point', POINTER(POINTER(POINTER(pushPoint)))),
    ('v', POINTER(c_void_p)),
]
pushPresent = (c_int).in_dll(libteem, 'pushPresent')
pushBiffKey = (STRING).in_dll(libteem, 'pushBiffKey')
pushPointNew = libteem.pushPointNew
pushPointNew.restype = POINTER(pushPoint)
pushPointNew.argtypes = [POINTER(pushContext)]
pushPointNix = libteem.pushPointNix
pushPointNix.restype = POINTER(pushPoint)
pushPointNix.argtypes = [POINTER(pushPoint)]
pushContextNew = libteem.pushContextNew
pushContextNew.restype = POINTER(pushContext)
pushContextNew.argtypes = []
pushContextNix = libteem.pushContextNix
pushContextNix.restype = POINTER(pushContext)
pushContextNix.argtypes = [POINTER(pushContext)]
pushEnergyType = (POINTER(airEnum)).in_dll(libteem, 'pushEnergyType')
pushEnergyUnknown = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergyUnknown')
pushEnergySpring = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergySpring')
pushEnergyGauss = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergyGauss')
pushEnergyCoulomb = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergyCoulomb')
pushEnergyCotan = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergyCotan')
pushEnergyZero = (POINTER(pushEnergy)).in_dll(libteem, 'pushEnergyZero')
pushEnergyAll = (POINTER(pushEnergy) * 6).in_dll(libteem, 'pushEnergyAll')
pushEnergySpecNew = libteem.pushEnergySpecNew
pushEnergySpecNew.restype = POINTER(pushEnergySpec)
pushEnergySpecNew.argtypes = []
pushEnergySpecSet = libteem.pushEnergySpecSet
pushEnergySpecSet.restype = None
pushEnergySpecSet.argtypes = [POINTER(pushEnergySpec), POINTER(pushEnergy), POINTER(c_double)]
pushEnergySpecNix = libteem.pushEnergySpecNix
pushEnergySpecNix.restype = POINTER(pushEnergySpec)
pushEnergySpecNix.argtypes = [POINTER(pushEnergySpec)]
pushEnergySpecParse = libteem.pushEnergySpecParse
pushEnergySpecParse.restype = c_int
pushEnergySpecParse.argtypes = [POINTER(pushEnergySpec), STRING]
pushHestEnergySpec = (POINTER(hestCB)).in_dll(libteem, 'pushHestEnergySpec')
pushStart = libteem.pushStart
pushStart.restype = c_int
pushStart.argtypes = [POINTER(pushContext)]
pushIterate = libteem.pushIterate
pushIterate.restype = c_int
pushIterate.argtypes = [POINTER(pushContext)]
pushRun = libteem.pushRun
pushRun.restype = c_int
pushRun.argtypes = [POINTER(pushContext)]
pushFinish = libteem.pushFinish
pushFinish.restype = c_int
pushFinish.argtypes = [POINTER(pushContext)]
pushBinInit = libteem.pushBinInit
pushBinInit.restype = None
pushBinInit.argtypes = [POINTER(pushBin), c_uint]
pushBinDone = libteem.pushBinDone
pushBinDone.restype = None
pushBinDone.argtypes = [POINTER(pushBin)]
pushBinPointAdd = libteem.pushBinPointAdd
pushBinPointAdd.restype = c_int
pushBinPointAdd.argtypes = [POINTER(pushContext), POINTER(pushPoint)]
pushBinAllNeighborSet = libteem.pushBinAllNeighborSet
pushBinAllNeighborSet.restype = None
pushBinAllNeighborSet.argtypes = [POINTER(pushContext)]
pushRebin = libteem.pushRebin
pushRebin.restype = c_int
pushRebin.argtypes = [POINTER(pushContext)]
pushBinProcess = libteem.pushBinProcess
pushBinProcess.restype = c_int
pushBinProcess.argtypes = [POINTER(pushTask), c_uint]
pushOutputGet = libteem.pushOutputGet
pushOutputGet.restype = c_int
pushOutputGet.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(pushContext)]
class seekContext(Structure):
    pass
seekContext._pack_ = 4
seekContext._fields_ = [
    ('verbose', c_int),
    ('ninscl', POINTER(Nrrd)),
    ('gctx', POINTER(gageContext)),
    ('pvl', POINTER(gagePerVolume)),
    ('type', c_int),
    ('sclvItem', c_int),
    ('gradItem', c_int),
    ('normItem', c_int),
    ('evalItem', c_int),
    ('evecItem', c_int),
    ('stngItem', c_int),
    ('hessItem', c_int),
    ('lowerInside', c_int),
    ('normalsFind', c_int),
    ('strengthUse', c_int),
    ('strengthSign', c_int),
    ('isovalue', c_double),
    ('strength', c_double),
    ('evalDiffThresh', c_double),
    ('samples', c_size_t * 3),
    ('facesPerVoxel', c_double),
    ('vertsPerVoxel', c_double),
    ('pldArrIncr', c_uint),
    ('flag', POINTER(c_int)),
    ('nin', POINTER(Nrrd)),
    ('baseDim', c_uint),
    ('_shape', POINTER(gageShape)),
    ('shape', POINTER(gageShape)),
    ('nsclDerived', POINTER(Nrrd)),
    ('sclvAns', POINTER(c_double)),
    ('gradAns', POINTER(c_double)),
    ('normAns', POINTER(c_double)),
    ('evalAns', POINTER(c_double)),
    ('evecAns', POINTER(c_double)),
    ('stngAns', POINTER(c_double)),
    ('hessAns', POINTER(c_double)),
    ('reverse', c_int),
    ('txfNormal', c_double * 9),
    ('spanSize', c_size_t),
    ('nspanHist', POINTER(Nrrd)),
    ('range', POINTER(NrrdRange)),
    ('sx', c_size_t),
    ('sy', c_size_t),
    ('sz', c_size_t),
    ('txfIdx', c_double * 16),
    ('vidx', POINTER(c_int)),
    ('facevidx', POINTER(c_int)),
    ('sclv', POINTER(c_double)),
    ('grad', POINTER(c_double)),
    ('eval', POINTER(c_double)),
    ('evec', POINTER(c_double)),
    ('hess', POINTER(c_double)),
    ('t', POINTER(c_double)),
    ('edgealpha', POINTER(c_double)),
    ('edgenorm', POINTER(c_double)),
    ('edgeicoord', POINTER(c_double)),
    ('facecoord', POINTER(c_double)),
    ('facenorm', POINTER(c_double)),
    ('faceicoord', POINTER(c_double)),
    ('gradcontext', POINTER(c_double)),
    ('hesscontext', POINTER(c_double)),
    ('tcontext', POINTER(c_double)),
    ('stngcontext', POINTER(c_double)),
    ('flip', POINTER(c_byte)),
    ('pairs', POINTER(c_byte)),
    ('treated', POINTER(c_byte)),
    ('stng', POINTER(c_double)),
    ('nvidx', POINTER(Nrrd)),
    ('nsclv', POINTER(Nrrd)),
    ('ngrad', POINTER(Nrrd)),
    ('neval', POINTER(Nrrd)),
    ('nevec', POINTER(Nrrd)),
    ('nflip', POINTER(Nrrd)),
    ('nstng', POINTER(Nrrd)),
    ('nhess', POINTER(Nrrd)),
    ('nt', POINTER(Nrrd)),
    ('nfacevidx', POINTER(Nrrd)),
    ('nedgealpha', POINTER(Nrrd)),
    ('nedgenorm', POINTER(Nrrd)),
    ('nfacecoord', POINTER(Nrrd)),
    ('nfacenorm', POINTER(Nrrd)),
    ('npairs', POINTER(Nrrd)),
    ('nedgeicoord', POINTER(Nrrd)),
    ('nfaceicoord', POINTER(Nrrd)),
    ('ngradcontext', POINTER(Nrrd)),
    ('nhesscontext', POINTER(Nrrd)),
    ('ntcontext', POINTER(Nrrd)),
    ('nstngcontext', POINTER(Nrrd)),
    ('ntreated', POINTER(Nrrd)),
    ('voxNum', c_uint),
    ('vertNum', c_uint),
    ('faceNum', c_uint),
    ('strengthSeenMax', c_double),
    ('time', c_double),
]
seekBiffKey = (STRING).in_dll(libteem, 'seekBiffKey')
seekType = (POINTER(airEnum)).in_dll(libteem, 'seekType')
seekContour3DTopoHackEdge = (c_int * 256).in_dll(libteem, 'seekContour3DTopoHackEdge')
seekContour3DTopoHackTriangle = (c_int * 16 * 256).in_dll(libteem, 'seekContour3DTopoHackTriangle')
seekPresent = (c_int).in_dll(libteem, 'seekPresent')
seekContextNew = libteem.seekContextNew
seekContextNew.restype = POINTER(seekContext)
seekContextNew.argtypes = []
seekContextNix = libteem.seekContextNix
seekContextNix.restype = POINTER(seekContext)
seekContextNix.argtypes = [POINTER(seekContext)]
seekVerboseSet = libteem.seekVerboseSet
seekVerboseSet.restype = None
seekVerboseSet.argtypes = [POINTER(seekContext), c_int]
seekDataSet = libteem.seekDataSet
seekDataSet.restype = c_int
seekDataSet.argtypes = [POINTER(seekContext), POINTER(Nrrd), POINTER(gageContext), c_uint]
seekNormalsFindSet = libteem.seekNormalsFindSet
seekNormalsFindSet.restype = c_int
seekNormalsFindSet.argtypes = [POINTER(seekContext), c_int]
seekStrengthUseSet = libteem.seekStrengthUseSet
seekStrengthUseSet.restype = c_int
seekStrengthUseSet.argtypes = [POINTER(seekContext), c_int]
seekStrengthSet = libteem.seekStrengthSet
seekStrengthSet.restype = c_int
seekStrengthSet.argtypes = [POINTER(seekContext), c_int, c_double]
seekSamplesSet = libteem.seekSamplesSet
seekSamplesSet.restype = c_int
seekSamplesSet.argtypes = [POINTER(seekContext), POINTER(c_size_t)]
seekTypeSet = libteem.seekTypeSet
seekTypeSet.restype = c_int
seekTypeSet.argtypes = [POINTER(seekContext), c_int]
seekLowerInsideSet = libteem.seekLowerInsideSet
seekLowerInsideSet.restype = c_int
seekLowerInsideSet.argtypes = [POINTER(seekContext), c_int]
seekItemScalarSet = libteem.seekItemScalarSet
seekItemScalarSet.restype = c_int
seekItemScalarSet.argtypes = [POINTER(seekContext), c_int]
seekItemStrengthSet = libteem.seekItemStrengthSet
seekItemStrengthSet.restype = c_int
seekItemStrengthSet.argtypes = [POINTER(seekContext), c_int]
seekItemNormalSet = libteem.seekItemNormalSet
seekItemNormalSet.restype = c_int
seekItemNormalSet.argtypes = [POINTER(seekContext), c_int]
seekItemGradientSet = libteem.seekItemGradientSet
seekItemGradientSet.restype = c_int
seekItemGradientSet.argtypes = [POINTER(seekContext), c_int]
seekItemEigensystemSet = libteem.seekItemEigensystemSet
seekItemEigensystemSet.restype = c_int
seekItemEigensystemSet.argtypes = [POINTER(seekContext), c_int, c_int]
seekItemHessSet = libteem.seekItemHessSet
seekItemHessSet.restype = c_int
seekItemHessSet.argtypes = [POINTER(seekContext), c_int]
seekIsovalueSet = libteem.seekIsovalueSet
seekIsovalueSet.restype = c_int
seekIsovalueSet.argtypes = [POINTER(seekContext), c_double]
seekEvalDiffThreshSet = libteem.seekEvalDiffThreshSet
seekEvalDiffThreshSet.restype = c_int
seekEvalDiffThreshSet.argtypes = [POINTER(seekContext), c_double]
seekUpdate = libteem.seekUpdate
seekUpdate.restype = c_int
seekUpdate.argtypes = [POINTER(seekContext)]
seekExtract = libteem.seekExtract
seekExtract.restype = c_int
seekExtract.argtypes = [POINTER(seekContext), POINTER(limnPolyData)]
seekVertexStrength = libteem.seekVertexStrength
seekVertexStrength.restype = c_int
seekVertexStrength.argtypes = [POINTER(Nrrd), POINTER(seekContext), POINTER(limnPolyData)]
seekDescendToDeg = libteem.seekDescendToDeg
seekDescendToDeg.restype = c_int
seekDescendToDeg.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int, c_double, c_char]
seekDescendToDegCell = libteem.seekDescendToDegCell
seekDescendToDegCell.restype = c_int
seekDescendToDegCell.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int, c_double, c_char]
seekDescendToRidge = libteem.seekDescendToRidge
seekDescendToRidge.restype = c_int
seekDescendToRidge.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int, c_double, c_char, c_double]
class tenGlyphParm(Structure):
    pass
tenGlyphParm._fields_ = [
    ('verbose', c_int),
    ('nmask', POINTER(Nrrd)),
    ('anisoType', c_int),
    ('onlyPositive', c_int),
    ('confThresh', c_float),
    ('anisoThresh', c_float),
    ('maskThresh', c_float),
    ('glyphType', c_int),
    ('facetRes', c_int),
    ('glyphScale', c_float),
    ('sqdSharp', c_float),
    ('edgeWidth', c_float * 5),
    ('colEvec', c_int),
    ('colAnisoType', c_int),
    ('colMaxSat', c_float),
    ('colIsoGray', c_float),
    ('colGamma', c_float),
    ('colAnisoModulate', c_float),
    ('ADSP', c_float * 4),
    ('sliceAxis', c_uint),
    ('slicePos', c_size_t),
    ('doSlice', c_int),
    ('sliceAnisoType', c_int),
    ('sliceOffset', c_float),
    ('sliceBias', c_float),
    ('sliceGamma', c_float),
]
class tenEvecRGBParm(Structure):
    pass
tenEvecRGBParm._pack_ = 4
tenEvecRGBParm._fields_ = [
    ('which', c_uint),
    ('aniso', c_int),
    ('confThresh', c_double),
    ('anisoGamma', c_double),
    ('gamma', c_double),
    ('bgGray', c_double),
    ('isoGray', c_double),
    ('maxSat', c_double),
    ('typeOut', c_int),
    ('genAlpha', c_int),
]
class tenFiberContext(Structure):
    pass
tenFiberContext._pack_ = 4
tenFiberContext._fields_ = [
    ('nin', POINTER(Nrrd)),
    ('ksp', POINTER(NrrdKernelSpec)),
    ('useDwi', c_int),
    ('fiberType', c_int),
    ('fiberProbeItem', c_int),
    ('intg', c_int),
    ('anisoStopType', c_int),
    ('anisoSpeedType', c_int),
    ('stop', c_int),
    ('useIndexSpace', c_int),
    ('verbose', c_int),
    ('anisoThresh', c_double),
    ('anisoSpeedFunc', c_double * 3),
    ('maxNumSteps', c_uint),
    ('minNumSteps', c_uint),
    ('stepSize', c_double),
    ('maxHalfLen', c_double),
    ('minWholeLen', c_double),
    ('confThresh', c_double),
    ('minRadius', c_double),
    ('minFraction', c_double),
    ('wPunct', c_double),
    ('ten2Which', c_uint),
    ('query', gageQuery),
    ('halfIdx', c_int),
    ('mframeUse', c_int),
    ('mframe', c_double * 9),
    ('mframeT', c_double * 9),
    ('wPos', c_double * 3),
    ('wDir', c_double * 3),
    ('lastDir', c_double * 3),
    ('seedEvec', c_double * 3),
    ('lastDirSet', c_int),
    ('lastTenSet', c_int),
    ('ten2Use', c_uint),
    ('gtx', POINTER(gageContext)),
    ('pvl', POINTER(gagePerVolume)),
    ('gageTen', POINTER(c_double)),
    ('gageEval', POINTER(c_double)),
    ('gageEvec', POINTER(c_double)),
    ('gageAnisoStop', POINTER(c_double)),
    ('gageAnisoSpeed', POINTER(c_double)),
    ('gageTen2', POINTER(c_double)),
    ('ten2AnisoStop', c_double),
    ('fiberTen', c_double * 7),
    ('fiberEval', c_double * 3),
    ('fiberEvec', c_double * 9),
    ('fiberAnisoStop', c_double),
    ('fiberAnisoSpeed', c_double),
    ('radius', c_double),
    ('halfLen', c_double * 2),
    ('numSteps', c_uint * 2),
    ('whyStop', c_int * 2),
    ('whyNowhere', c_int),
]
class tenFiberSingle(Structure):
    pass
tenFiberSingle._pack_ = 4
tenFiberSingle._fields_ = [
    ('seedPos', c_double * 3),
    ('dirIdx', c_uint),
    ('dirNum', c_uint),
    ('nvert', POINTER(Nrrd)),
    ('halfLen', c_double * 2),
    ('seedIdx', c_uint),
    ('stepNum', c_uint * 2),
    ('whyStop', c_int * 2),
    ('whyNowhere', c_int),
    ('nval', POINTER(Nrrd)),
    ('measr', c_double * 30),
]
class tenFiberMulti(Structure):
    pass
tenFiberMulti._fields_ = [
    ('fiber', POINTER(tenFiberSingle)),
    ('fiberNum', c_uint),
    ('fiberArr', POINTER(airArray)),
]
class tenEMBimodalParm(Structure):
    pass
tenEMBimodalParm._pack_ = 4
tenEMBimodalParm._fields_ = [
    ('minProb', c_double),
    ('minProb2', c_double),
    ('minDelta', c_double),
    ('minFraction', c_double),
    ('minConfidence', c_double),
    ('twoStage', c_double),
    ('verbose', c_double),
    ('maxIteration', c_uint),
    ('histo', POINTER(c_double)),
    ('pp1', POINTER(c_double)),
    ('pp2', POINTER(c_double)),
    ('vmin', c_double),
    ('vmax', c_double),
    ('delta', c_double),
    ('N', c_int),
    ('stage', c_int),
    ('iteration', c_uint),
    ('mean1', c_double),
    ('stdv1', c_double),
    ('mean2', c_double),
    ('stdv2', c_double),
    ('fraction1', c_double),
    ('confidence', c_double),
    ('threshold', c_double),
]
class tenGradientParm(Structure):
    pass
tenGradientParm._pack_ = 4
tenGradientParm._fields_ = [
    ('initStep', c_double),
    ('jitter', c_double),
    ('minVelocity', c_double),
    ('minPotentialChange', c_double),
    ('minMean', c_double),
    ('minMeanImprovement', c_double),
    ('single', c_int),
    ('insertZeroVec', c_int),
    ('verbose', c_int),
    ('snap', c_uint),
    ('report', c_uint),
    ('expo', c_uint),
    ('seed', c_uint),
    ('maxEdgeShrink', c_uint),
    ('minIteration', c_uint),
    ('maxIteration', c_uint),
    ('expo_d', c_double),
    ('step', c_double),
    ('nudge', c_double),
    ('itersUsed', c_uint),
    ('potential', c_double),
    ('potentialNorm', c_double),
    ('angle', c_double),
    ('edge', c_double),
]
class tenEstimateContext(Structure):
    pass
tenEstimateContext._pack_ = 4
tenEstimateContext._fields_ = [
    ('bValue', c_double),
    ('valueMin', c_double),
    ('sigma', c_double),
    ('dwiConfThresh', c_double),
    ('dwiConfSoft', c_double),
    ('_ngrad', POINTER(Nrrd)),
    ('_nbmat', POINTER(Nrrd)),
    ('skipList', POINTER(c_uint)),
    ('skipListArr', POINTER(airArray)),
    ('all_f', POINTER(c_float)),
    ('all_d', POINTER(c_double)),
    ('simulate', c_int),
    ('estimate1Method', c_int),
    ('estimateB0', c_int),
    ('recordTime', c_int),
    ('recordErrorDwi', c_int),
    ('recordErrorLogDwi', c_int),
    ('recordLikelihoodDwi', c_int),
    ('verbose', c_int),
    ('negEvalShift', c_int),
    ('progress', c_int),
    ('WLSIterNum', c_uint),
    ('flag', c_int * 128),
    ('allNum', c_uint),
    ('dwiNum', c_uint),
    ('nbmat', POINTER(Nrrd)),
    ('nwght', POINTER(Nrrd)),
    ('nemat', POINTER(Nrrd)),
    ('knownB0', c_double),
    ('all', POINTER(c_double)),
    ('bnorm', POINTER(c_double)),
    ('allTmp', POINTER(c_double)),
    ('dwiTmp', POINTER(c_double)),
    ('dwi', POINTER(c_double)),
    ('skipLut', POINTER(c_ubyte)),
    ('estimatedB0', c_double),
    ('ten', c_double * 7),
    ('conf', c_double),
    ('mdwi', c_double),
    ('time', c_double),
    ('errorDwi', c_double),
    ('errorLogDwi', c_double),
    ('likelihoodDwi', c_double),
]
class tenDwiGageKindData(Structure):
    pass
tenDwiGageKindData._pack_ = 4
tenDwiGageKindData._fields_ = [
    ('ngrad', POINTER(Nrrd)),
    ('nbmat', POINTER(Nrrd)),
    ('thresh', c_double),
    ('soft', c_double),
    ('bval', c_double),
    ('valueMin', c_double),
    ('est1Method', c_int),
    ('est2Method', c_int),
    ('randSeed', c_uint),
]
class tenDwiGagePvlData(Structure):
    pass
tenDwiGagePvlData._pack_ = 4
tenDwiGagePvlData._fields_ = [
    ('tec1', POINTER(tenEstimateContext)),
    ('tec2', POINTER(tenEstimateContext)),
    ('vbuf', POINTER(c_double)),
    ('wght', POINTER(c_uint)),
    ('qvals', POINTER(c_double)),
    ('qpoints', POINTER(c_double)),
    ('dists', POINTER(c_double)),
    ('weights', POINTER(c_double)),
    ('nten1EigenGrads', POINTER(Nrrd)),
    ('randState', POINTER(airRandMTState)),
    ('randSeed', c_uint),
    ('ten1', c_double * 7),
    ('ten1Evec', c_double * 9),
    ('ten1Eval', c_double * 3),
    ('levmarUseFastExp', c_int),
    ('levmarMaxIter', c_uint),
    ('levmarTau', c_double),
    ('levmarEps1', c_double),
    ('levmarEps2', c_double),
    ('levmarEps3', c_double),
    ('levmarDelta', c_double),
    ('levmarMinCp', c_double),
    ('levmarInfo', c_double * 9),
]
class tenInterpParm(Structure):
    pass
tenInterpParm._pack_ = 4
tenInterpParm._fields_ = [
    ('verbose', c_int),
    ('convStep', c_double),
    ('minNorm', c_double),
    ('convEps', c_double),
    ('wghtSumEps', c_double),
    ('enableRecurse', c_int),
    ('maxIter', c_uint),
    ('numSteps', c_uint),
    ('lengthFancy', c_int),
    ('allocLen', c_uint),
    ('eval', POINTER(c_double)),
    ('evec', POINTER(c_double)),
    ('rtIn', POINTER(c_double)),
    ('rtLog', POINTER(c_double)),
    ('qIn', POINTER(c_double)),
    ('qBuff', POINTER(c_double)),
    ('qInter', POINTER(c_double)),
    ('numIter', c_uint),
    ('convFinal', c_double),
    ('lengthShape', c_double),
    ('lengthOrient', c_double),
]
class tenExperSpec(Structure):
    pass
tenExperSpec._fields_ = [
    ('set', c_int),
    ('imgNum', c_uint),
    ('bval', POINTER(c_double)),
    ('grad', POINTER(c_double)),
]
class tenModelParmDesc(Structure):
    pass
tenModelParmDesc._pack_ = 4
tenModelParmDesc._fields_ = [
    ('name', c_char * 129),
    ('min', c_double),
    ('max', c_double),
    ('cyclic', c_int),
    ('vec3', c_int),
    ('vecIdx', c_uint),
]
class tenModel_t(Structure):
    pass
tenModel_t._fields_ = [
    ('name', c_char * 129),
    ('parmNum', c_uint),
    ('parmDesc', POINTER(tenModelParmDesc)),
    ('simulate', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(tenExperSpec))),
    ('sprint', CFUNCTYPE(STRING, STRING, POINTER(c_double))),
    ('alloc', CFUNCTYPE(POINTER(c_double))),
    ('rand', CFUNCTYPE(None, POINTER(c_double), POINTER(airRandMTState), c_int)),
    ('step', CFUNCTYPE(None, POINTER(c_double), c_double, POINTER(c_double), POINTER(c_double))),
    ('dist', CFUNCTYPE(c_double, POINTER(c_double), POINTER(c_double))),
    ('copy', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double))),
    ('convert', CFUNCTYPE(c_int, POINTER(c_double), POINTER(c_double), POINTER(tenModel_t))),
    ('sqe', CFUNCTYPE(c_double, POINTER(c_double), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), c_int)),
    ('sqeGrad', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), c_int)),
    ('sqeFit', CFUNCTYPE(c_double, POINTER(c_double), POINTER(c_double), POINTER(c_uint), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int, c_uint, c_uint, c_double, c_int)),
    ('nll', CFUNCTYPE(c_double, POINTER(c_double), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), c_int, c_double, c_int)),
    ('nllGrad', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), c_int, c_double)),
    ('nllFit', CFUNCTYPE(c_double, POINTER(c_double), POINTER(tenExperSpec), POINTER(c_double), POINTER(c_double), c_int, c_double, c_int)),
]
tenModel = tenModel_t
tenPresent = (c_int).in_dll(libteem, 'tenPresent')
tenBiffKey = (STRING).in_dll(libteem, 'tenBiffKey')
tenDefFiberKernel = (c_char * 0).in_dll(libteem, 'tenDefFiberKernel')
tenDefFiberStepSize = (c_double).in_dll(libteem, 'tenDefFiberStepSize')
tenDefFiberUseIndexSpace = (c_int).in_dll(libteem, 'tenDefFiberUseIndexSpace')
tenDefFiberMaxNumSteps = (c_int).in_dll(libteem, 'tenDefFiberMaxNumSteps')
tenDefFiberMaxHalfLen = (c_double).in_dll(libteem, 'tenDefFiberMaxHalfLen')
tenDefFiberAnisoStopType = (c_int).in_dll(libteem, 'tenDefFiberAnisoStopType')
tenDefFiberAnisoThresh = (c_double).in_dll(libteem, 'tenDefFiberAnisoThresh')
tenDefFiberIntg = (c_int).in_dll(libteem, 'tenDefFiberIntg')
tenDefFiberWPunct = (c_double).in_dll(libteem, 'tenDefFiberWPunct')
tenTripleConvertSingle_d = libteem.tenTripleConvertSingle_d
tenTripleConvertSingle_d.restype = None
tenTripleConvertSingle_d.argtypes = [POINTER(c_double), c_int, POINTER(c_double), c_int]
tenTripleConvertSingle_f = libteem.tenTripleConvertSingle_f
tenTripleConvertSingle_f.restype = None
tenTripleConvertSingle_f.argtypes = [POINTER(c_float), c_int, POINTER(c_float), c_int]
tenTripleCalcSingle_d = libteem.tenTripleCalcSingle_d
tenTripleCalcSingle_d.restype = None
tenTripleCalcSingle_d.argtypes = [POINTER(c_double), c_int, POINTER(c_double)]
tenTripleCalcSingle_f = libteem.tenTripleCalcSingle_f
tenTripleCalcSingle_f.restype = None
tenTripleCalcSingle_f.argtypes = [POINTER(c_float), c_int, POINTER(c_float)]
tenTripleCalc = libteem.tenTripleCalc
tenTripleCalc.restype = c_int
tenTripleCalc.argtypes = [POINTER(Nrrd), c_int, POINTER(Nrrd)]
tenTripleConvert = libteem.tenTripleConvert
tenTripleConvert.restype = c_int
tenTripleConvert.argtypes = [POINTER(Nrrd), c_int, POINTER(Nrrd), c_int]
tenGradientParmNew = libteem.tenGradientParmNew
tenGradientParmNew.restype = POINTER(tenGradientParm)
tenGradientParmNew.argtypes = []
tenGradientParmNix = libteem.tenGradientParmNix
tenGradientParmNix.restype = POINTER(tenGradientParm)
tenGradientParmNix.argtypes = [POINTER(tenGradientParm)]
tenGradientCheck = libteem.tenGradientCheck
tenGradientCheck.restype = c_int
tenGradientCheck.argtypes = [POINTER(Nrrd), c_int, c_uint]
tenGradientRandom = libteem.tenGradientRandom
tenGradientRandom.restype = c_int
tenGradientRandom.argtypes = [POINTER(Nrrd), c_uint, c_uint]
tenGradientIdealEdge = libteem.tenGradientIdealEdge
tenGradientIdealEdge.restype = c_double
tenGradientIdealEdge.argtypes = [c_uint, c_int]
tenGradientJitter = libteem.tenGradientJitter
tenGradientJitter.restype = c_int
tenGradientJitter.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double]
tenGradientBalance = libteem.tenGradientBalance
tenGradientBalance.restype = c_int
tenGradientBalance.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(tenGradientParm)]
tenGradientMeasure = libteem.tenGradientMeasure
tenGradientMeasure.restype = None
tenGradientMeasure.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(Nrrd), POINTER(tenGradientParm), c_int]
tenGradientDistribute = libteem.tenGradientDistribute
tenGradientDistribute.restype = c_int
tenGradientDistribute.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(tenGradientParm)]
tenGradientGenerate = libteem.tenGradientGenerate
tenGradientGenerate.restype = c_int
tenGradientGenerate.argtypes = [POINTER(Nrrd), c_uint, POINTER(tenGradientParm)]
tenAniso = (POINTER(airEnum)).in_dll(libteem, 'tenAniso')
tenInterpType = (POINTER(airEnum)).in_dll(libteem, 'tenInterpType')
tenGage = (POINTER(airEnum)).in_dll(libteem, 'tenGage')
tenFiberType = (POINTER(airEnum)).in_dll(libteem, 'tenFiberType')
tenDwiFiberType = (POINTER(airEnum)).in_dll(libteem, 'tenDwiFiberType')
tenFiberStop = (POINTER(airEnum)).in_dll(libteem, 'tenFiberStop')
tenFiberIntg = (POINTER(airEnum)).in_dll(libteem, 'tenFiberIntg')
tenGlyphType = (POINTER(airEnum)).in_dll(libteem, 'tenGlyphType')
tenEstimate1Method = (POINTER(airEnum)).in_dll(libteem, 'tenEstimate1Method')
tenEstimate2Method = (POINTER(airEnum)).in_dll(libteem, 'tenEstimate2Method')
tenTripleType = (POINTER(airEnum)).in_dll(libteem, 'tenTripleType')
tenInterpParmNew = libteem.tenInterpParmNew
tenInterpParmNew.restype = POINTER(tenInterpParm)
tenInterpParmNew.argtypes = []
tenInterpParmCopy = libteem.tenInterpParmCopy
tenInterpParmCopy.restype = POINTER(tenInterpParm)
tenInterpParmCopy.argtypes = [POINTER(tenInterpParm)]
tenInterpParmBufferAlloc = libteem.tenInterpParmBufferAlloc
tenInterpParmBufferAlloc.restype = c_int
tenInterpParmBufferAlloc.argtypes = [POINTER(tenInterpParm), c_uint]
tenInterpParmNix = libteem.tenInterpParmNix
tenInterpParmNix.restype = POINTER(tenInterpParm)
tenInterpParmNix.argtypes = [POINTER(tenInterpParm)]
tenInterpTwo_d = libteem.tenInterpTwo_d
tenInterpTwo_d.restype = None
tenInterpTwo_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_int, c_double, POINTER(tenInterpParm)]
tenInterpN_d = libteem.tenInterpN_d
tenInterpN_d.restype = c_int
tenInterpN_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_uint, c_int, POINTER(tenInterpParm)]
tenInterpPathLength = libteem.tenInterpPathLength
tenInterpPathLength.restype = c_double
tenInterpPathLength.argtypes = [POINTER(Nrrd), c_int, c_int, c_int]
tenInterpTwoDiscrete_d = libteem.tenInterpTwoDiscrete_d
tenInterpTwoDiscrete_d.restype = c_int
tenInterpTwoDiscrete_d.argtypes = [POINTER(Nrrd), POINTER(c_double), POINTER(c_double), c_int, c_uint, POINTER(tenInterpParm)]
tenInterpDistanceTwo_d = libteem.tenInterpDistanceTwo_d
tenInterpDistanceTwo_d.restype = c_double
tenInterpDistanceTwo_d.argtypes = [POINTER(c_double), POINTER(c_double), c_int, POINTER(tenInterpParm)]
tenInterpMulti3D = libteem.tenInterpMulti3D
tenInterpMulti3D.restype = c_int
tenInterpMulti3D.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(c_double), c_uint, c_int, POINTER(tenInterpParm)]
tenGlyphParmNew = libteem.tenGlyphParmNew
tenGlyphParmNew.restype = POINTER(tenGlyphParm)
tenGlyphParmNew.argtypes = []
tenGlyphParmNix = libteem.tenGlyphParmNix
tenGlyphParmNix.restype = POINTER(tenGlyphParm)
tenGlyphParmNix.argtypes = [POINTER(tenGlyphParm)]
tenGlyphParmCheck = libteem.tenGlyphParmCheck
tenGlyphParmCheck.restype = c_int
tenGlyphParmCheck.argtypes = [POINTER(tenGlyphParm), POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
tenGlyphGen = libteem.tenGlyphGen
tenGlyphGen.restype = c_int
tenGlyphGen.argtypes = [POINTER(limnObject), POINTER(echoScene), POINTER(tenGlyphParm), POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
tenGlyphBqdZoneEval = libteem.tenGlyphBqdZoneEval
tenGlyphBqdZoneEval.restype = c_uint
tenGlyphBqdZoneEval.argtypes = [POINTER(c_double)]
tenGlyphBqdUvEval = libteem.tenGlyphBqdUvEval
tenGlyphBqdUvEval.restype = None
tenGlyphBqdUvEval.argtypes = [POINTER(c_double), POINTER(c_double)]
tenGlyphBqdEvalUv = libteem.tenGlyphBqdEvalUv
tenGlyphBqdEvalUv.restype = None
tenGlyphBqdEvalUv.argtypes = [POINTER(c_double), POINTER(c_double)]
tenGlyphBqdZoneUv = libteem.tenGlyphBqdZoneUv
tenGlyphBqdZoneUv.restype = c_uint
tenGlyphBqdZoneUv.argtypes = [POINTER(c_double)]
tenGlyphBqdAbcUv = libteem.tenGlyphBqdAbcUv
tenGlyphBqdAbcUv.restype = None
tenGlyphBqdAbcUv.argtypes = [POINTER(c_double), POINTER(c_double), c_double]
tenVerbose = (c_int).in_dll(libteem, 'tenVerbose')
tenRotateSingle_f = libteem.tenRotateSingle_f
tenRotateSingle_f.restype = None
tenRotateSingle_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
tenTensorCheck = libteem.tenTensorCheck
tenTensorCheck.restype = c_int
tenTensorCheck.argtypes = [POINTER(Nrrd), c_int, c_int, c_int]
tenMeasurementFrameReduce = libteem.tenMeasurementFrameReduce
tenMeasurementFrameReduce.restype = c_int
tenMeasurementFrameReduce.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
tenExpand2D = libteem.tenExpand2D
tenExpand2D.restype = c_int
tenExpand2D.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double, c_double]
tenExpand = libteem.tenExpand
tenExpand.restype = c_int
tenExpand.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double, c_double]
tenShrink = libteem.tenShrink
tenShrink.restype = c_int
tenShrink.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
tenEigensolve_f = libteem.tenEigensolve_f
tenEigensolve_f.restype = c_int
tenEigensolve_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float)]
tenEigensolve_d = libteem.tenEigensolve_d
tenEigensolve_d.restype = c_int
tenEigensolve_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
tenMakeSingle_f = libteem.tenMakeSingle_f
tenMakeSingle_f.restype = None
tenMakeSingle_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float), POINTER(c_float)]
tenMakeSingle_d = libteem.tenMakeSingle_d
tenMakeSingle_d.restype = None
tenMakeSingle_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double), POINTER(c_double)]
tenMake = libteem.tenMake
tenMake.restype = c_int
tenMake.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd)]
tenSlice = libteem.tenSlice
tenSlice.restype = c_int
tenSlice.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_uint, c_size_t, c_uint]
tenInvariantGradientsK_d = libteem.tenInvariantGradientsK_d
tenInvariantGradientsK_d.restype = None
tenInvariantGradientsK_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double]
tenInvariantGradientsR_d = libteem.tenInvariantGradientsR_d
tenInvariantGradientsR_d.restype = None
tenInvariantGradientsR_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double]
tenRotationTangents_d = libteem.tenRotationTangents_d
tenRotationTangents_d.restype = None
tenRotationTangents_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double)]
tenLogSingle_d = libteem.tenLogSingle_d
tenLogSingle_d.restype = None
tenLogSingle_d.argtypes = [POINTER(c_double), POINTER(c_double)]
tenLogSingle_f = libteem.tenLogSingle_f
tenLogSingle_f.restype = None
tenLogSingle_f.argtypes = [POINTER(c_float), POINTER(c_float)]
tenExpSingle_d = libteem.tenExpSingle_d
tenExpSingle_d.restype = None
tenExpSingle_d.argtypes = [POINTER(c_double), POINTER(c_double)]
tenExpSingle_f = libteem.tenExpSingle_f
tenExpSingle_f.restype = None
tenExpSingle_f.argtypes = [POINTER(c_float), POINTER(c_float)]
tenSqrtSingle_d = libteem.tenSqrtSingle_d
tenSqrtSingle_d.restype = None
tenSqrtSingle_d.argtypes = [POINTER(c_double), POINTER(c_double)]
tenSqrtSingle_f = libteem.tenSqrtSingle_f
tenSqrtSingle_f.restype = None
tenSqrtSingle_f.argtypes = [POINTER(c_float), POINTER(c_float)]
tenPowSingle_d = libteem.tenPowSingle_d
tenPowSingle_d.restype = None
tenPowSingle_d.argtypes = [POINTER(c_double), POINTER(c_double), c_double]
tenPowSingle_f = libteem.tenPowSingle_f
tenPowSingle_f.restype = None
tenPowSingle_f.argtypes = [POINTER(c_float), POINTER(c_float), c_float]
tenInv_f = libteem.tenInv_f
tenInv_f.restype = None
tenInv_f.argtypes = [POINTER(c_float), POINTER(c_float)]
tenInv_d = libteem.tenInv_d
tenInv_d.restype = None
tenInv_d.argtypes = [POINTER(c_double), POINTER(c_double)]
tenDoubleContract_d = libteem.tenDoubleContract_d
tenDoubleContract_d.restype = c_double
tenDoubleContract_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double)]
tenDWMRIModalityKey = (STRING).in_dll(libteem, 'tenDWMRIModalityKey')
tenDWMRIModalityVal = (STRING).in_dll(libteem, 'tenDWMRIModalityVal')
tenDWMRINAVal = (STRING).in_dll(libteem, 'tenDWMRINAVal')
tenDWMRIBValueKey = (STRING).in_dll(libteem, 'tenDWMRIBValueKey')
tenDWMRIGradKeyFmt = (STRING).in_dll(libteem, 'tenDWMRIGradKeyFmt')
tenDWMRIBmatKeyFmt = (STRING).in_dll(libteem, 'tenDWMRIBmatKeyFmt')
tenDWMRINexKeyFmt = (STRING).in_dll(libteem, 'tenDWMRINexKeyFmt')
tenDWMRISkipKeyFmt = (STRING).in_dll(libteem, 'tenDWMRISkipKeyFmt')
tenDWMRIKeyValueParse = libteem.tenDWMRIKeyValueParse
tenDWMRIKeyValueParse.restype = c_int
tenDWMRIKeyValueParse.argtypes = [POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(c_double), POINTER(POINTER(c_uint)), POINTER(c_uint), POINTER(Nrrd)]
tenBMatrixCalc = libteem.tenBMatrixCalc
tenBMatrixCalc.restype = c_int
tenBMatrixCalc.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
tenEMatrixCalc = libteem.tenEMatrixCalc
tenEMatrixCalc.restype = c_int
tenEMatrixCalc.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int]
tenEstimateLinearSingle_f = libteem.tenEstimateLinearSingle_f
tenEstimateLinearSingle_f.restype = None
tenEstimateLinearSingle_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_double), POINTER(c_double), c_uint, c_int, c_float, c_float, c_float]
tenEstimateLinearSingle_d = libteem.tenEstimateLinearSingle_d
tenEstimateLinearSingle_d.restype = None
tenEstimateLinearSingle_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_uint, c_int, c_double, c_double, c_double]
tenEstimateLinear3D = libteem.tenEstimateLinear3D
tenEstimateLinear3D.restype = c_int
tenEstimateLinear3D.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), c_uint, POINTER(Nrrd), c_int, c_double, c_double, c_double]
tenEstimateLinear4D = libteem.tenEstimateLinear4D
tenEstimateLinear4D.restype = c_int
tenEstimateLinear4D.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(Nrrd), POINTER(Nrrd), c_int, c_double, c_double, c_double]
tenSimulateSingle_f = libteem.tenSimulateSingle_f
tenSimulateSingle_f.restype = None
tenSimulateSingle_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float), POINTER(c_double), c_uint, c_float]
tenSimulate = libteem.tenSimulate
tenSimulate.restype = c_int
tenSimulate.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_double]
tenEstimateContextNew = libteem.tenEstimateContextNew
tenEstimateContextNew.restype = POINTER(tenEstimateContext)
tenEstimateContextNew.argtypes = []
tenEstimateVerboseSet = libteem.tenEstimateVerboseSet
tenEstimateVerboseSet.restype = None
tenEstimateVerboseSet.argtypes = [POINTER(tenEstimateContext), c_int]
tenEstimateNegEvalShiftSet = libteem.tenEstimateNegEvalShiftSet
tenEstimateNegEvalShiftSet.restype = None
tenEstimateNegEvalShiftSet.argtypes = [POINTER(tenEstimateContext), c_int]
tenEstimateMethodSet = libteem.tenEstimateMethodSet
tenEstimateMethodSet.restype = c_int
tenEstimateMethodSet.argtypes = [POINTER(tenEstimateContext), c_int]
tenEstimateSigmaSet = libteem.tenEstimateSigmaSet
tenEstimateSigmaSet.restype = c_int
tenEstimateSigmaSet.argtypes = [POINTER(tenEstimateContext), c_double]
tenEstimateValueMinSet = libteem.tenEstimateValueMinSet
tenEstimateValueMinSet.restype = c_int
tenEstimateValueMinSet.argtypes = [POINTER(tenEstimateContext), c_double]
tenEstimateGradientsSet = libteem.tenEstimateGradientsSet
tenEstimateGradientsSet.restype = c_int
tenEstimateGradientsSet.argtypes = [POINTER(tenEstimateContext), POINTER(Nrrd), c_double, c_int]
tenEstimateBMatricesSet = libteem.tenEstimateBMatricesSet
tenEstimateBMatricesSet.restype = c_int
tenEstimateBMatricesSet.argtypes = [POINTER(tenEstimateContext), POINTER(Nrrd), c_double, c_int]
tenEstimateSkipSet = libteem.tenEstimateSkipSet
tenEstimateSkipSet.restype = c_int
tenEstimateSkipSet.argtypes = [POINTER(tenEstimateContext), c_uint, c_int]
tenEstimateSkipReset = libteem.tenEstimateSkipReset
tenEstimateSkipReset.restype = c_int
tenEstimateSkipReset.argtypes = [POINTER(tenEstimateContext)]
tenEstimateThresholdSet = libteem.tenEstimateThresholdSet
tenEstimateThresholdSet.restype = c_int
tenEstimateThresholdSet.argtypes = [POINTER(tenEstimateContext), c_double, c_double]
tenEstimateUpdate = libteem.tenEstimateUpdate
tenEstimateUpdate.restype = c_int
tenEstimateUpdate.argtypes = [POINTER(tenEstimateContext)]
tenEstimate1TensorSimulateSingle_f = libteem.tenEstimate1TensorSimulateSingle_f
tenEstimate1TensorSimulateSingle_f.restype = c_int
tenEstimate1TensorSimulateSingle_f.argtypes = [POINTER(tenEstimateContext), POINTER(c_float), c_float, c_float, c_float, POINTER(c_float)]
tenEstimate1TensorSimulateSingle_d = libteem.tenEstimate1TensorSimulateSingle_d
tenEstimate1TensorSimulateSingle_d.restype = c_int
tenEstimate1TensorSimulateSingle_d.argtypes = [POINTER(tenEstimateContext), POINTER(c_double), c_double, c_double, c_double, POINTER(c_double)]
tenEstimate1TensorSimulateVolume = libteem.tenEstimate1TensorSimulateVolume
tenEstimate1TensorSimulateVolume.restype = c_int
tenEstimate1TensorSimulateVolume.argtypes = [POINTER(tenEstimateContext), POINTER(Nrrd), c_double, c_double, POINTER(Nrrd), POINTER(Nrrd), c_int, c_int]
tenEstimate1TensorSingle_f = libteem.tenEstimate1TensorSingle_f
tenEstimate1TensorSingle_f.restype = c_int
tenEstimate1TensorSingle_f.argtypes = [POINTER(tenEstimateContext), POINTER(c_float), POINTER(c_float)]
tenEstimate1TensorSingle_d = libteem.tenEstimate1TensorSingle_d
tenEstimate1TensorSingle_d.restype = c_int
tenEstimate1TensorSingle_d.argtypes = [POINTER(tenEstimateContext), POINTER(c_double), POINTER(c_double)]
tenEstimate1TensorVolume4D = libteem.tenEstimate1TensorVolume4D
tenEstimate1TensorVolume4D.restype = c_int
tenEstimate1TensorVolume4D.argtypes = [POINTER(tenEstimateContext), POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(Nrrd), c_int]
tenEstimateContextNix = libteem.tenEstimateContextNix
tenEstimateContextNix.restype = POINTER(tenEstimateContext)
tenEstimateContextNix.argtypes = [POINTER(tenEstimateContext)]
tenAnisoEval_f = libteem.tenAnisoEval_f
tenAnisoEval_f.restype = c_float
tenAnisoEval_f.argtypes = [POINTER(c_float), c_int]
tenAnisoEval_d = libteem.tenAnisoEval_d
tenAnisoEval_d.restype = c_double
tenAnisoEval_d.argtypes = [POINTER(c_double), c_int]
tenAnisoTen_f = libteem.tenAnisoTen_f
tenAnisoTen_f.restype = c_float
tenAnisoTen_f.argtypes = [POINTER(c_float), c_int]
tenAnisoTen_d = libteem.tenAnisoTen_d
tenAnisoTen_d.restype = c_double
tenAnisoTen_d.argtypes = [POINTER(c_double), c_int]
tenAnisoPlot = libteem.tenAnisoPlot
tenAnisoPlot.restype = c_int
tenAnisoPlot.argtypes = [POINTER(Nrrd), c_int, c_uint, c_int, c_int, c_int]
tenAnisoVolume = libteem.tenAnisoVolume
tenAnisoVolume.restype = c_int
tenAnisoVolume.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_double]
tenAnisoHistogram = libteem.tenAnisoHistogram
tenAnisoHistogram.restype = c_int
tenAnisoHistogram.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_int, c_int, c_uint]
tenEvecRGBParmNew = libteem.tenEvecRGBParmNew
tenEvecRGBParmNew.restype = POINTER(tenEvecRGBParm)
tenEvecRGBParmNew.argtypes = []
tenEvecRGBParmNix = libteem.tenEvecRGBParmNix
tenEvecRGBParmNix.restype = POINTER(tenEvecRGBParm)
tenEvecRGBParmNix.argtypes = [POINTER(tenEvecRGBParm)]
tenEvecRGBParmCheck = libteem.tenEvecRGBParmCheck
tenEvecRGBParmCheck.restype = c_int
tenEvecRGBParmCheck.argtypes = [POINTER(tenEvecRGBParm)]
tenEvecRGBSingle_f = libteem.tenEvecRGBSingle_f
tenEvecRGBSingle_f.restype = None
tenEvecRGBSingle_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float), POINTER(c_float), POINTER(tenEvecRGBParm)]
tenEvecRGBSingle_d = libteem.tenEvecRGBSingle_d
tenEvecRGBSingle_d.restype = None
tenEvecRGBSingle_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double), POINTER(c_double), POINTER(tenEvecRGBParm)]
tenEvecRGB = libteem.tenEvecRGB
tenEvecRGB.restype = c_int
tenEvecRGB.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(tenEvecRGBParm)]
tenEvqVolume = libteem.tenEvqVolume
tenEvqVolume.restype = c_int
tenEvqVolume.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_int, c_int, c_int]
tenBMatrixCheck = libteem.tenBMatrixCheck
tenBMatrixCheck.restype = c_int
tenBMatrixCheck.argtypes = [POINTER(Nrrd), c_int, c_uint]
tenFiberSingleInit = libteem.tenFiberSingleInit
tenFiberSingleInit.restype = None
tenFiberSingleInit.argtypes = [POINTER(tenFiberSingle)]
tenFiberSingleDone = libteem.tenFiberSingleDone
tenFiberSingleDone.restype = None
tenFiberSingleDone.argtypes = [POINTER(tenFiberSingle)]
tenFiberSingleNew = libteem.tenFiberSingleNew
tenFiberSingleNew.restype = POINTER(tenFiberSingle)
tenFiberSingleNew.argtypes = []
tenFiberSingleNix = libteem.tenFiberSingleNix
tenFiberSingleNix.restype = POINTER(tenFiberSingle)
tenFiberSingleNix.argtypes = [POINTER(tenFiberSingle)]
tenFiberContextNew = libteem.tenFiberContextNew
tenFiberContextNew.restype = POINTER(tenFiberContext)
tenFiberContextNew.argtypes = [POINTER(Nrrd)]
tenFiberContextDwiNew = libteem.tenFiberContextDwiNew
tenFiberContextDwiNew.restype = POINTER(tenFiberContext)
tenFiberContextDwiNew.argtypes = [POINTER(Nrrd), c_double, c_double, c_double, c_int, c_int]
tenFiberVerboseSet = libteem.tenFiberVerboseSet
tenFiberVerboseSet.restype = None
tenFiberVerboseSet.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberTypeSet = libteem.tenFiberTypeSet
tenFiberTypeSet.restype = c_int
tenFiberTypeSet.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberKernelSet = libteem.tenFiberKernelSet
tenFiberKernelSet.restype = c_int
tenFiberKernelSet.argtypes = [POINTER(tenFiberContext), POINTER(NrrdKernel), POINTER(c_double)]
tenFiberProbeItemSet = libteem.tenFiberProbeItemSet
tenFiberProbeItemSet.restype = c_int
tenFiberProbeItemSet.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberIntgSet = libteem.tenFiberIntgSet
tenFiberIntgSet.restype = c_int
tenFiberIntgSet.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberStopSet = libteem.tenFiberStopSet
tenFiberStopSet.restype = c_int
tenFiberStopSet.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberStopAnisoSet = libteem.tenFiberStopAnisoSet
tenFiberStopAnisoSet.restype = c_int
tenFiberStopAnisoSet.argtypes = [POINTER(tenFiberContext), c_int, c_double]
tenFiberStopDoubleSet = libteem.tenFiberStopDoubleSet
tenFiberStopDoubleSet.restype = c_int
tenFiberStopDoubleSet.argtypes = [POINTER(tenFiberContext), c_int, c_double]
tenFiberStopUIntSet = libteem.tenFiberStopUIntSet
tenFiberStopUIntSet.restype = c_int
tenFiberStopUIntSet.argtypes = [POINTER(tenFiberContext), c_int, c_uint]
tenFiberStopOn = libteem.tenFiberStopOn
tenFiberStopOn.restype = None
tenFiberStopOn.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberStopOff = libteem.tenFiberStopOff
tenFiberStopOff.restype = None
tenFiberStopOff.argtypes = [POINTER(tenFiberContext), c_int]
tenFiberStopReset = libteem.tenFiberStopReset
tenFiberStopReset.restype = None
tenFiberStopReset.argtypes = [POINTER(tenFiberContext)]
tenFiberAnisoSpeedSet = libteem.tenFiberAnisoSpeedSet
tenFiberAnisoSpeedSet.restype = c_int
tenFiberAnisoSpeedSet.argtypes = [POINTER(tenFiberContext), c_int, c_double, c_double, c_double]
tenFiberAnisoSpeedReset = libteem.tenFiberAnisoSpeedReset
tenFiberAnisoSpeedReset.restype = c_int
tenFiberAnisoSpeedReset.argtypes = [POINTER(tenFiberContext)]
tenFiberParmSet = libteem.tenFiberParmSet
tenFiberParmSet.restype = c_int
tenFiberParmSet.argtypes = [POINTER(tenFiberContext), c_int, c_double]
tenFiberUpdate = libteem.tenFiberUpdate
tenFiberUpdate.restype = c_int
tenFiberUpdate.argtypes = [POINTER(tenFiberContext)]
tenFiberContextCopy = libteem.tenFiberContextCopy
tenFiberContextCopy.restype = POINTER(tenFiberContext)
tenFiberContextCopy.argtypes = [POINTER(tenFiberContext)]
tenFiberContextNix = libteem.tenFiberContextNix
tenFiberContextNix.restype = POINTER(tenFiberContext)
tenFiberContextNix.argtypes = [POINTER(tenFiberContext)]
tenFiberTraceSet = libteem.tenFiberTraceSet
tenFiberTraceSet.restype = c_int
tenFiberTraceSet.argtypes = [POINTER(tenFiberContext), POINTER(Nrrd), POINTER(c_double), c_uint, POINTER(c_uint), POINTER(c_uint), POINTER(c_double)]
tenFiberTrace = libteem.tenFiberTrace
tenFiberTrace.restype = c_int
tenFiberTrace.argtypes = [POINTER(tenFiberContext), POINTER(Nrrd), POINTER(c_double)]
tenFiberDirectionNumber = libteem.tenFiberDirectionNumber
tenFiberDirectionNumber.restype = c_uint
tenFiberDirectionNumber.argtypes = [POINTER(tenFiberContext), POINTER(c_double)]
tenFiberSingleTrace = libteem.tenFiberSingleTrace
tenFiberSingleTrace.restype = c_int
tenFiberSingleTrace.argtypes = [POINTER(tenFiberContext), POINTER(tenFiberSingle), POINTER(c_double), c_uint]
tenFiberMultiNew = libteem.tenFiberMultiNew
tenFiberMultiNew.restype = POINTER(tenFiberMulti)
tenFiberMultiNew.argtypes = []
tenFiberMultiNix = libteem.tenFiberMultiNix
tenFiberMultiNix.restype = POINTER(tenFiberMulti)
tenFiberMultiNix.argtypes = [POINTER(tenFiberMulti)]
tenFiberMultiTrace = libteem.tenFiberMultiTrace
tenFiberMultiTrace.restype = c_int
tenFiberMultiTrace.argtypes = [POINTER(tenFiberContext), POINTER(tenFiberMulti), POINTER(Nrrd)]
tenFiberMultiPolyData = libteem.tenFiberMultiPolyData
tenFiberMultiPolyData.restype = c_int
tenFiberMultiPolyData.argtypes = [POINTER(tenFiberContext), POINTER(limnPolyData), POINTER(tenFiberMulti)]
tenFiberMultiProbeVals = libteem.tenFiberMultiProbeVals
tenFiberMultiProbeVals.restype = c_int
tenFiberMultiProbeVals.argtypes = [POINTER(tenFiberContext), POINTER(Nrrd), POINTER(tenFiberMulti)]
tenEpiRegister3D = libteem.tenEpiRegister3D
tenEpiRegister3D.restype = c_int
tenEpiRegister3D.argtypes = [POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), c_uint, POINTER(Nrrd), c_int, c_double, c_double, c_double, c_double, c_int, POINTER(NrrdKernel), POINTER(c_double), c_int, c_int]
tenEpiRegister4D = libteem.tenEpiRegister4D
tenEpiRegister4D.restype = c_int
tenEpiRegister4D.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(Nrrd), c_int, c_double, c_double, c_double, c_double, c_int, POINTER(NrrdKernel), POINTER(c_double), c_int, c_int]
tenExperSpecNew = libteem.tenExperSpecNew
tenExperSpecNew.restype = POINTER(tenExperSpec)
tenExperSpecNew.argtypes = []
tenExperSpecGradSingleBValSet = libteem.tenExperSpecGradSingleBValSet
tenExperSpecGradSingleBValSet.restype = c_int
tenExperSpecGradSingleBValSet.argtypes = [POINTER(tenExperSpec), c_int, c_double, POINTER(c_double), c_uint]
tenExperSpecGradBValSet = libteem.tenExperSpecGradBValSet
tenExperSpecGradBValSet.restype = c_int
tenExperSpecGradBValSet.argtypes = [POINTER(tenExperSpec), c_int, POINTER(c_double), POINTER(c_double), c_uint]
tenExperSpecFromKeyValueSet = libteem.tenExperSpecFromKeyValueSet
tenExperSpecFromKeyValueSet.restype = c_int
tenExperSpecFromKeyValueSet.argtypes = [POINTER(tenExperSpec), POINTER(Nrrd)]
tenExperSpecNix = libteem.tenExperSpecNix
tenExperSpecNix.restype = POINTER(tenExperSpec)
tenExperSpecNix.argtypes = [POINTER(tenExperSpec)]
tenExperSpecKnownB0Get = libteem.tenExperSpecKnownB0Get
tenExperSpecKnownB0Get.restype = c_double
tenExperSpecKnownB0Get.argtypes = [POINTER(tenExperSpec), POINTER(c_double)]
tenExperSpecMaxBGet = libteem.tenExperSpecMaxBGet
tenExperSpecMaxBGet.restype = c_double
tenExperSpecMaxBGet.argtypes = [POINTER(tenExperSpec)]
tenDWMRIKeyValueFromExperSpecSet = libteem.tenDWMRIKeyValueFromExperSpecSet
tenDWMRIKeyValueFromExperSpecSet.restype = c_int
tenDWMRIKeyValueFromExperSpecSet.argtypes = [POINTER(Nrrd), POINTER(tenExperSpec)]
tenModelPrefixStr = (STRING).in_dll(libteem, 'tenModelPrefixStr')
tenModelParse = libteem.tenModelParse
tenModelParse.restype = c_int
tenModelParse.argtypes = [POINTER(POINTER(tenModel)), POINTER(c_int), c_int, STRING]
tenModelFromAxisLearnPossible = libteem.tenModelFromAxisLearnPossible
tenModelFromAxisLearnPossible.restype = c_int
tenModelFromAxisLearnPossible.argtypes = [POINTER(NrrdAxisInfo)]
tenModelFromAxisLearn = libteem.tenModelFromAxisLearn
tenModelFromAxisLearn.restype = c_int
tenModelFromAxisLearn.argtypes = [POINTER(POINTER(tenModel)), POINTER(c_int), POINTER(NrrdAxisInfo)]
tenModelSimulate = libteem.tenModelSimulate
tenModelSimulate.restype = c_int
tenModelSimulate.argtypes = [POINTER(Nrrd), c_int, POINTER(tenExperSpec), POINTER(tenModel), POINTER(Nrrd), POINTER(Nrrd), c_int]
tenModelSqeFit = libteem.tenModelSqeFit
tenModelSqeFit.restype = c_int
tenModelSqeFit.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(POINTER(Nrrd)), POINTER(tenModel), POINTER(tenExperSpec), POINTER(Nrrd), c_int, c_int, c_int, c_uint, c_uint, c_uint, c_double, POINTER(airRandMTState), c_int]
tenModelNllFit = libteem.tenModelNllFit
tenModelNllFit.restype = c_int
tenModelNllFit.argtypes = [POINTER(Nrrd), POINTER(POINTER(Nrrd)), POINTER(tenModel), POINTER(tenExperSpec), POINTER(Nrrd), c_int, c_double, c_int]
tenModelConvert = libteem.tenModelConvert
tenModelConvert.restype = c_int
tenModelConvert.argtypes = [POINTER(Nrrd), POINTER(c_int), POINTER(tenModel), POINTER(Nrrd), POINTER(tenModel)]
tenModelZero = (POINTER(tenModel)).in_dll(libteem, 'tenModelZero')
tenModelB0 = (POINTER(tenModel)).in_dll(libteem, 'tenModelB0')
tenModelBall = (POINTER(tenModel)).in_dll(libteem, 'tenModelBall')
tenModel1Vector2D = (POINTER(tenModel)).in_dll(libteem, 'tenModel1Vector2D')
tenModel1Unit2D = (POINTER(tenModel)).in_dll(libteem, 'tenModel1Unit2D')
tenModel2Unit2D = (POINTER(tenModel)).in_dll(libteem, 'tenModel2Unit2D')
tenModel1Stick = (POINTER(tenModel)).in_dll(libteem, 'tenModel1Stick')
tenModelBall1StickEMD = (POINTER(tenModel)).in_dll(libteem, 'tenModelBall1StickEMD')
tenModelBall1Stick = (POINTER(tenModel)).in_dll(libteem, 'tenModelBall1Stick')
tenModelBall1Cylinder = (POINTER(tenModel)).in_dll(libteem, 'tenModelBall1Cylinder')
tenModel1Cylinder = (POINTER(tenModel)).in_dll(libteem, 'tenModel1Cylinder')
tenModel1Tensor2 = (POINTER(tenModel)).in_dll(libteem, 'tenModel1Tensor2')
tenSizeNormalize = libteem.tenSizeNormalize
tenSizeNormalize.restype = c_int
tenSizeNormalize.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_double), c_double, c_double]
tenSizeScale = libteem.tenSizeScale
tenSizeScale.restype = c_int
tenSizeScale.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double]
tenAnisoScale = libteem.tenAnisoScale
tenAnisoScale.restype = c_int
tenAnisoScale.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double, c_int, c_int]
tenEigenvaluePower = libteem.tenEigenvaluePower
tenEigenvaluePower.restype = c_int
tenEigenvaluePower.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double]
tenEigenvalueClamp = libteem.tenEigenvalueClamp
tenEigenvalueClamp.restype = c_int
tenEigenvalueClamp.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double, c_double]
tenEigenvalueAdd = libteem.tenEigenvalueAdd
tenEigenvalueAdd.restype = c_int
tenEigenvalueAdd.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double]
tenEigenvalueMultiply = libteem.tenEigenvalueMultiply
tenEigenvalueMultiply.restype = c_int
tenEigenvalueMultiply.argtypes = [POINTER(Nrrd), POINTER(Nrrd), c_double]
tenLog = libteem.tenLog
tenLog.restype = c_int
tenLog.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
tenExp = libteem.tenExp
tenExp.restype = c_int
tenExp.argtypes = [POINTER(Nrrd), POINTER(Nrrd)]
tenBVecNonLinearFit = libteem.tenBVecNonLinearFit
tenBVecNonLinearFit.restype = c_int
tenBVecNonLinearFit.argtypes = [POINTER(Nrrd), POINTER(Nrrd), POINTER(c_double), POINTER(c_double), c_int, c_double]
tenGageKind = (POINTER(gageKind)).in_dll(libteem, 'tenGageKind')
tenDwiGage = (POINTER(airEnum)).in_dll(libteem, 'tenDwiGage')
tenDwiGageKindNew = libteem.tenDwiGageKindNew
tenDwiGageKindNew.restype = POINTER(gageKind)
tenDwiGageKindNew.argtypes = []
tenDwiGageKindNix = libteem.tenDwiGageKindNix
tenDwiGageKindNix.restype = POINTER(gageKind)
tenDwiGageKindNix.argtypes = [POINTER(gageKind)]
tenDwiGageKindSet = libteem.tenDwiGageKindSet
tenDwiGageKindSet.restype = c_int
tenDwiGageKindSet.argtypes = [POINTER(gageKind), c_double, c_double, c_double, c_double, POINTER(Nrrd), POINTER(Nrrd), c_int, c_int, c_uint]
tenDwiGageKindCheck = libteem.tenDwiGageKindCheck
tenDwiGageKindCheck.restype = c_int
tenDwiGageKindCheck.argtypes = [POINTER(gageKind)]
tenEMBimodalParmNew = libteem.tenEMBimodalParmNew
tenEMBimodalParmNew.restype = POINTER(tenEMBimodalParm)
tenEMBimodalParmNew.argtypes = []
tenEMBimodalParmNix = libteem.tenEMBimodalParmNix
tenEMBimodalParmNix.restype = POINTER(tenEMBimodalParm)
tenEMBimodalParmNix.argtypes = [POINTER(tenEMBimodalParm)]
tenEMBimodal = libteem.tenEMBimodal
tenEMBimodal.restype = c_int
tenEMBimodal.argtypes = [POINTER(tenEMBimodalParm), POINTER(Nrrd)]
tend_epiregCmd = (unrrduCmd).in_dll(libteem, 'tend_epiregCmd')
tend_pointCmd = (unrrduCmd).in_dll(libteem, 'tend_pointCmd')
tend_evalclampCmd = (unrrduCmd).in_dll(libteem, 'tend_evalclampCmd')
tend_evaladdCmd = (unrrduCmd).in_dll(libteem, 'tend_evaladdCmd')
tend_satinCmd = (unrrduCmd).in_dll(libteem, 'tend_satinCmd')
tend_evalpowCmd = (unrrduCmd).in_dll(libteem, 'tend_evalpowCmd')
tend_evalCmd = (unrrduCmd).in_dll(libteem, 'tend_evalCmd')
tend_glyphCmd = (unrrduCmd).in_dll(libteem, 'tend_glyphCmd')
tend_aboutCmd = (unrrduCmd).in_dll(libteem, 'tend_aboutCmd')
tend_gradsCmd = (unrrduCmd).in_dll(libteem, 'tend_gradsCmd')
tend_unmfCmd = (unrrduCmd).in_dll(libteem, 'tend_unmfCmd')
tend_mfitCmd = (unrrduCmd).in_dll(libteem, 'tend_mfitCmd')
tend_normCmd = (unrrduCmd).in_dll(libteem, 'tend_normCmd')
tend_bfitCmd = (unrrduCmd).in_dll(libteem, 'tend_bfitCmd')
tend_evqCmd = (unrrduCmd).in_dll(libteem, 'tend_evqCmd')
tend_helixCmd = (unrrduCmd).in_dll(libteem, 'tend_helixCmd')
tend_fiberCmd = (unrrduCmd).in_dll(libteem, 'tend_fiberCmd')
tend_stenCmd = (unrrduCmd).in_dll(libteem, 'tend_stenCmd')
tend_anhistCmd = (unrrduCmd).in_dll(libteem, 'tend_anhistCmd')
tend_shrinkCmd = (unrrduCmd).in_dll(libteem, 'tend_shrinkCmd')
tend_tripleCmd = (unrrduCmd).in_dll(libteem, 'tend_tripleCmd')
tend_evecCmd = (unrrduCmd).in_dll(libteem, 'tend_evecCmd')
tend_makeCmd = (unrrduCmd).in_dll(libteem, 'tend_makeCmd')
tend_tconvCmd = (unrrduCmd).in_dll(libteem, 'tend_tconvCmd')
tend_simCmd = (unrrduCmd).in_dll(libteem, 'tend_simCmd')
tend_avgCmd = (unrrduCmd).in_dll(libteem, 'tend_avgCmd')
tend_estimCmd = (unrrduCmd).in_dll(libteem, 'tend_estimCmd')
tend_sliceCmd = (unrrduCmd).in_dll(libteem, 'tend_sliceCmd')
tend_evecrgbCmd = (unrrduCmd).in_dll(libteem, 'tend_evecrgbCmd')
tend_expandCmd = (unrrduCmd).in_dll(libteem, 'tend_expandCmd')
tend_logCmd = (unrrduCmd).in_dll(libteem, 'tend_logCmd')
tend_msimCmd = (unrrduCmd).in_dll(libteem, 'tend_msimCmd')
tend_anplotCmd = (unrrduCmd).in_dll(libteem, 'tend_anplotCmd')
tend_expCmd = (unrrduCmd).in_dll(libteem, 'tend_expCmd')
tend_ellipseCmd = (unrrduCmd).in_dll(libteem, 'tend_ellipseCmd')
tend_bmatCmd = (unrrduCmd).in_dll(libteem, 'tend_bmatCmd')
tend_mconvCmd = (unrrduCmd).in_dll(libteem, 'tend_mconvCmd')
tend_evalmultCmd = (unrrduCmd).in_dll(libteem, 'tend_evalmultCmd')
tend_anvolCmd = (unrrduCmd).in_dll(libteem, 'tend_anvolCmd')
tend_anscaleCmd = (unrrduCmd).in_dll(libteem, 'tend_anscaleCmd')
tendCmdList = (POINTER(unrrduCmd) * 0).in_dll(libteem, 'tendCmdList')
tendFiberStopCB = (POINTER(hestCB)).in_dll(libteem, 'tendFiberStopCB')
tendTitle = (STRING).in_dll(libteem, 'tendTitle')
class tijk_sym_fun_t(Structure):
    pass
tijk_sym_fun_t._fields_ = [
    ('s_form_d', CFUNCTYPE(c_double, POINTER(c_double), POINTER(c_double))),
    ('s_form_f', CFUNCTYPE(c_float, POINTER(c_float), POINTER(c_float))),
    ('mean_d', CFUNCTYPE(c_double, POINTER(c_double))),
    ('mean_f', CFUNCTYPE(c_float, POINTER(c_float))),
    ('var_d', CFUNCTYPE(c_double, POINTER(c_double))),
    ('var_f', CFUNCTYPE(c_float, POINTER(c_float))),
    ('v_form_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(c_double))),
    ('v_form_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float))),
    ('m_form_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(c_double))),
    ('m_form_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float))),
    ('grad_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(c_double))),
    ('grad_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float))),
    ('hess_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(c_double))),
    ('hess_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float))),
    ('make_rank1_d', CFUNCTYPE(None, POINTER(c_double), c_double, POINTER(c_double))),
    ('make_rank1_f', CFUNCTYPE(None, POINTER(c_float), c_float, POINTER(c_float))),
    ('make_iso_d', CFUNCTYPE(None, POINTER(c_double), c_double)),
    ('make_iso_f', CFUNCTYPE(None, POINTER(c_float), c_float)),
]
tijk_sym_fun = tijk_sym_fun_t
tijk_type_t._fields_ = [
    ('name', STRING),
    ('order', c_uint),
    ('dim', c_uint),
    ('num', c_uint),
    ('mult', POINTER(c_uint)),
    ('unsym2uniq', POINTER(c_int)),
    ('uniq2unsym', POINTER(c_int)),
    ('uniq_idx', POINTER(c_uint)),
    ('tsp_d', CFUNCTYPE(c_double, POINTER(c_double), POINTER(c_double))),
    ('tsp_f', CFUNCTYPE(c_float, POINTER(c_float), POINTER(c_float))),
    ('norm_d', CFUNCTYPE(c_double, POINTER(c_double))),
    ('norm_f', CFUNCTYPE(c_float, POINTER(c_float))),
    ('trans_d', CFUNCTYPE(None, POINTER(c_double), POINTER(c_double), POINTER(c_double))),
    ('trans_f', CFUNCTYPE(None, POINTER(c_float), POINTER(c_float), POINTER(c_float))),
    ('convert_d', CFUNCTYPE(c_int, POINTER(c_double), POINTER(tijk_type_t), POINTER(c_double))),
    ('convert_f', CFUNCTYPE(c_int, POINTER(c_float), POINTER(tijk_type_t), POINTER(c_float))),
    ('approx_d', CFUNCTYPE(c_int, POINTER(c_double), POINTER(tijk_type_t), POINTER(c_double))),
    ('approx_f', CFUNCTYPE(c_int, POINTER(c_float), POINTER(tijk_type_t), POINTER(c_float))),
    ('_convert_from_d', CFUNCTYPE(c_int, POINTER(c_double), POINTER(c_double), POINTER(tijk_type_t))),
    ('_convert_from_f', CFUNCTYPE(c_int, POINTER(c_float), POINTER(c_float), POINTER(tijk_type_t))),
    ('_approx_from_d', CFUNCTYPE(c_int, POINTER(c_double), POINTER(c_double), POINTER(tijk_type_t))),
    ('_approx_from_f', CFUNCTYPE(c_int, POINTER(c_float), POINTER(c_float), POINTER(tijk_type_t))),
    ('sym', POINTER(tijk_sym_fun)),
]
tijk_2o2d_unsym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o2d_unsym')
tijk_2o2d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o2d_sym')
tijk_2o2d_asym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o2d_asym')
tijk_3o2d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_3o2d_sym')
tijk_4o2d_unsym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_4o2d_unsym')
tijk_4o2d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_4o2d_sym')
tijk_1o3d = (POINTER(tijk_type)).in_dll(libteem, 'tijk_1o3d')
tijk_2o3d_unsym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o3d_unsym')
tijk_2o3d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o3d_sym')
tijk_2o3d_asym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_2o3d_asym')
tijk_3o3d_unsym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_3o3d_unsym')
tijk_3o3d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_3o3d_sym')
tijk_4o3d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_4o3d_sym')
tijk_6o3d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_6o3d_sym')
tijk_8o3d_sym = (POINTER(tijk_type)).in_dll(libteem, 'tijk_8o3d_sym')
tijkPresent = (c_int).in_dll(libteem, 'tijkPresent')
tijk_add_d = libteem.tijk_add_d
tijk_add_d.restype = None
tijk_add_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_add_f = libteem.tijk_add_f
tijk_add_f.restype = None
tijk_add_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_sub_d = libteem.tijk_sub_d
tijk_sub_d.restype = None
tijk_sub_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_sub_f = libteem.tijk_sub_f
tijk_sub_f.restype = None
tijk_sub_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_incr_d = libteem.tijk_incr_d
tijk_incr_d.restype = None
tijk_incr_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_incr_f = libteem.tijk_incr_f
tijk_incr_f.restype = None
tijk_incr_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_negate_d = libteem.tijk_negate_d
tijk_negate_d.restype = None
tijk_negate_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_negate_f = libteem.tijk_negate_f
tijk_negate_f.restype = None
tijk_negate_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_scale_d = libteem.tijk_scale_d
tijk_scale_d.restype = None
tijk_scale_d.argtypes = [POINTER(c_double), c_double, POINTER(c_double), POINTER(tijk_type)]
tijk_scale_f = libteem.tijk_scale_f
tijk_scale_f.restype = None
tijk_scale_f.argtypes = [POINTER(c_float), c_float, POINTER(c_float), POINTER(tijk_type)]
tijk_zero_d = libteem.tijk_zero_d
tijk_zero_d.restype = None
tijk_zero_d.argtypes = [POINTER(c_double), POINTER(tijk_type)]
tijk_zero_f = libteem.tijk_zero_f
tijk_zero_f.restype = None
tijk_zero_f.argtypes = [POINTER(c_float), POINTER(tijk_type)]
tijk_copy_d = libteem.tijk_copy_d
tijk_copy_d.restype = None
tijk_copy_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_copy_f = libteem.tijk_copy_f
tijk_copy_f.restype = None
tijk_copy_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_refine_rank1_parm_t._pack_ = 4
tijk_refine_rank1_parm_t._fields_ = [
    ('eps_start', c_double),
    ('eps_impr', c_double),
    ('beta', c_double),
    ('gamma', c_double),
    ('sigma', c_double),
    ('maxtry', c_uint),
]
tijk_refine_rank1_parm_new = libteem.tijk_refine_rank1_parm_new
tijk_refine_rank1_parm_new.restype = POINTER(tijk_refine_rank1_parm)
tijk_refine_rank1_parm_new.argtypes = []
tijk_refine_rank1_parm_nix = libteem.tijk_refine_rank1_parm_nix
tijk_refine_rank1_parm_nix.restype = POINTER(tijk_refine_rank1_parm)
tijk_refine_rank1_parm_nix.argtypes = [POINTER(tijk_refine_rank1_parm)]
class tijk_refine_rankk_parm_t(Structure):
    pass
tijk_refine_rankk_parm_t._pack_ = 4
tijk_refine_rankk_parm_t._fields_ = [
    ('eps_res', c_double),
    ('eps_impr', c_double),
    ('pos', c_char),
    ('rank1_parm', POINTER(tijk_refine_rank1_parm)),
]
tijk_refine_rankk_parm = tijk_refine_rankk_parm_t
tijk_refine_rankk_parm_new = libteem.tijk_refine_rankk_parm_new
tijk_refine_rankk_parm_new.restype = POINTER(tijk_refine_rankk_parm)
tijk_refine_rankk_parm_new.argtypes = []
tijk_refine_rankk_parm_nix = libteem.tijk_refine_rankk_parm_nix
tijk_refine_rankk_parm_nix.restype = POINTER(tijk_refine_rankk_parm)
tijk_refine_rankk_parm_nix.argtypes = [POINTER(tijk_refine_rankk_parm)]
class tijk_approx_heur_parm_t(Structure):
    pass
tijk_approx_heur_parm_t._pack_ = 4
tijk_approx_heur_parm_t._fields_ = [
    ('eps_res', c_double),
    ('eps_impr', c_double),
    ('ratios', POINTER(c_double)),
    ('refine_parm', POINTER(tijk_refine_rankk_parm)),
]
tijk_approx_heur_parm = tijk_approx_heur_parm_t
tijk_approx_heur_parm_new = libteem.tijk_approx_heur_parm_new
tijk_approx_heur_parm_new.restype = POINTER(tijk_approx_heur_parm)
tijk_approx_heur_parm_new.argtypes = []
tijk_approx_heur_parm_nix = libteem.tijk_approx_heur_parm_nix
tijk_approx_heur_parm_nix.restype = POINTER(tijk_approx_heur_parm)
tijk_approx_heur_parm_nix.argtypes = [POINTER(tijk_approx_heur_parm)]
tijk_init_rank1_2d_d = libteem.tijk_init_rank1_2d_d
tijk_init_rank1_2d_d.restype = c_int
tijk_init_rank1_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_init_rank1_2d_f = libteem.tijk_init_rank1_2d_f
tijk_init_rank1_2d_f.restype = c_int
tijk_init_rank1_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_init_rank1_3d_d = libteem.tijk_init_rank1_3d_d
tijk_init_rank1_3d_d.restype = c_int
tijk_init_rank1_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_init_rank1_3d_f = libteem.tijk_init_rank1_3d_f
tijk_init_rank1_3d_f.restype = c_int
tijk_init_rank1_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_init_max_2d_d = libteem.tijk_init_max_2d_d
tijk_init_max_2d_d.restype = c_int
tijk_init_max_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_init_max_2d_f = libteem.tijk_init_max_2d_f
tijk_init_max_2d_f.restype = c_int
tijk_init_max_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_init_max_3d_d = libteem.tijk_init_max_3d_d
tijk_init_max_3d_d.restype = c_int
tijk_init_max_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_init_max_3d_f = libteem.tijk_init_max_3d_f
tijk_init_max_3d_f.restype = c_int
tijk_init_max_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_refine_rank1_2d_d = libteem.tijk_refine_rank1_2d_d
tijk_refine_rank1_2d_d.restype = c_int
tijk_refine_rank1_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_rank1_2d_f = libteem.tijk_refine_rank1_2d_f
tijk_refine_rank1_2d_f.restype = c_int
tijk_refine_rank1_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_rank1_3d_d = libteem.tijk_refine_rank1_3d_d
tijk_refine_rank1_3d_d.restype = c_int
tijk_refine_rank1_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_rank1_3d_f = libteem.tijk_refine_rank1_3d_f
tijk_refine_rank1_3d_f.restype = c_int
tijk_refine_rank1_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_max_2d_d = libteem.tijk_refine_max_2d_d
tijk_refine_max_2d_d.restype = c_int
tijk_refine_max_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_max_2d_f = libteem.tijk_refine_max_2d_f
tijk_refine_max_2d_f.restype = c_int
tijk_refine_max_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_max_3d_d = libteem.tijk_refine_max_3d_d
tijk_refine_max_3d_d.restype = c_int
tijk_refine_max_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_max_3d_f = libteem.tijk_refine_max_3d_f
tijk_refine_max_3d_f.restype = c_int
tijk_refine_max_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), POINTER(tijk_refine_rank1_parm)]
tijk_refine_rankk_2d_d = libteem.tijk_refine_rankk_2d_d
tijk_refine_rankk_2d_d.restype = c_int
tijk_refine_rankk_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double, POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_refine_rankk_2d_f = libteem.tijk_refine_rankk_2d_f
tijk_refine_rankk_2d_f.restype = c_int
tijk_refine_rankk_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_refine_rankk_3d_d = libteem.tijk_refine_rankk_3d_d
tijk_refine_rankk_3d_d.restype = c_int
tijk_refine_rankk_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), c_double, POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_refine_rankk_3d_f = libteem.tijk_refine_rankk_3d_f
tijk_refine_rankk_3d_f.restype = c_int
tijk_refine_rankk_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), c_float, POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_approx_rankk_2d_d = libteem.tijk_approx_rankk_2d_d
tijk_approx_rankk_2d_d.restype = c_int
tijk_approx_rankk_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_approx_rankk_2d_f = libteem.tijk_approx_rankk_2d_f
tijk_approx_rankk_2d_f.restype = c_int
tijk_approx_rankk_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_approx_rankk_3d_d = libteem.tijk_approx_rankk_3d_d
tijk_approx_rankk_3d_d.restype = c_int
tijk_approx_rankk_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_approx_rankk_3d_f = libteem.tijk_approx_rankk_3d_f
tijk_approx_rankk_3d_f.restype = c_int
tijk_approx_rankk_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), c_uint, POINTER(tijk_refine_rankk_parm)]
tijk_approx_heur_2d_d = libteem.tijk_approx_heur_2d_d
tijk_approx_heur_2d_d.restype = c_int
tijk_approx_heur_2d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), c_uint, POINTER(tijk_approx_heur_parm)]
tijk_approx_heur_2d_f = libteem.tijk_approx_heur_2d_f
tijk_approx_heur_2d_f.restype = c_int
tijk_approx_heur_2d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), c_uint, POINTER(tijk_approx_heur_parm)]
tijk_approx_heur_3d_d = libteem.tijk_approx_heur_3d_d
tijk_approx_heur_3d_d.restype = c_int
tijk_approx_heur_3d_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(c_double), POINTER(tijk_type), c_uint, POINTER(tijk_approx_heur_parm)]
tijk_approx_heur_3d_f = libteem.tijk_approx_heur_3d_f
tijk_approx_heur_3d_f.restype = c_int
tijk_approx_heur_3d_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(c_float), POINTER(tijk_type), c_uint, POINTER(tijk_approx_heur_parm)]
tijk_esh_len = (c_uint * 0).in_dll(libteem, 'tijk_esh_len')
tijk_max_esh_order = (c_uint).in_dll(libteem, 'tijk_max_esh_order')
tijk_eval_esh_basis_d = libteem.tijk_eval_esh_basis_d
tijk_eval_esh_basis_d.restype = c_uint
tijk_eval_esh_basis_d.argtypes = [POINTER(c_double), c_uint, c_double, c_double]
tijk_eval_esh_basis_f = libteem.tijk_eval_esh_basis_f
tijk_eval_esh_basis_f.restype = c_uint
tijk_eval_esh_basis_f.argtypes = [POINTER(c_float), c_uint, c_float, c_float]
tijk_eval_esh_d = libteem.tijk_eval_esh_d
tijk_eval_esh_d.restype = c_double
tijk_eval_esh_d.argtypes = [POINTER(c_double), c_uint, c_double, c_double]
tijk_eval_esh_f = libteem.tijk_eval_esh_f
tijk_eval_esh_f.restype = c_float
tijk_eval_esh_f.argtypes = [POINTER(c_float), c_uint, c_float, c_float]
tijk_esh_sp_d = libteem.tijk_esh_sp_d
tijk_esh_sp_d.restype = c_double
tijk_esh_sp_d.argtypes = [POINTER(c_double), POINTER(c_double), c_uint]
tijk_esh_sp_f = libteem.tijk_esh_sp_f
tijk_esh_sp_f.restype = c_float
tijk_esh_sp_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
tijk_3d_sym_to_esh_d = libteem.tijk_3d_sym_to_esh_d
tijk_3d_sym_to_esh_d.restype = c_int
tijk_3d_sym_to_esh_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_3d_sym_to_esh_f = libteem.tijk_3d_sym_to_esh_f
tijk_3d_sym_to_esh_f.restype = c_int
tijk_3d_sym_to_esh_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_esh_to_3d_sym_d = libteem.tijk_esh_to_3d_sym_d
tijk_esh_to_3d_sym_d.restype = POINTER(tijk_type)
tijk_esh_to_3d_sym_d.argtypes = [POINTER(c_double), POINTER(c_double), c_uint]
tijk_esh_to_3d_sym_f = libteem.tijk_esh_to_3d_sym_f
tijk_esh_to_3d_sym_f.restype = POINTER(tijk_type)
tijk_esh_to_3d_sym_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
tijk_esh_convolve_d = libteem.tijk_esh_convolve_d
tijk_esh_convolve_d.restype = None
tijk_esh_convolve_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_uint]
tijk_esh_convolve_f = libteem.tijk_esh_convolve_f
tijk_esh_convolve_f.restype = None
tijk_esh_convolve_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_uint]
tijk_esh_deconvolve_d = libteem.tijk_esh_deconvolve_d
tijk_esh_deconvolve_d.restype = None
tijk_esh_deconvolve_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(c_double), c_uint]
tijk_esh_deconvolve_f = libteem.tijk_esh_deconvolve_f
tijk_esh_deconvolve_f.restype = None
tijk_esh_deconvolve_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(c_float), c_uint]
tijk_esh_make_kernel_rank1_f = libteem.tijk_esh_make_kernel_rank1_f
tijk_esh_make_kernel_rank1_f.restype = c_int
tijk_esh_make_kernel_rank1_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
tijk_esh_make_kernel_rank1_d = libteem.tijk_esh_make_kernel_rank1_d
tijk_esh_make_kernel_rank1_d.restype = c_int
tijk_esh_make_kernel_rank1_d.argtypes = [POINTER(c_double), POINTER(c_double), c_uint]
tijk_esh_make_kernel_delta_f = libteem.tijk_esh_make_kernel_delta_f
tijk_esh_make_kernel_delta_f.restype = c_int
tijk_esh_make_kernel_delta_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
tijk_esh_make_kernel_delta_d = libteem.tijk_esh_make_kernel_delta_d
tijk_esh_make_kernel_delta_d.restype = c_int
tijk_esh_make_kernel_delta_d.argtypes = [POINTER(c_double), POINTER(c_double), c_uint]
tijk_max_efs_order = (c_uint).in_dll(libteem, 'tijk_max_efs_order')
tijk_eval_efs_basis_d = libteem.tijk_eval_efs_basis_d
tijk_eval_efs_basis_d.restype = c_uint
tijk_eval_efs_basis_d.argtypes = [POINTER(c_double), c_uint, c_double]
tijk_eval_efs_basis_f = libteem.tijk_eval_efs_basis_f
tijk_eval_efs_basis_f.restype = c_uint
tijk_eval_efs_basis_f.argtypes = [POINTER(c_float), c_uint, c_float]
tijk_eval_efs_d = libteem.tijk_eval_efs_d
tijk_eval_efs_d.restype = c_double
tijk_eval_efs_d.argtypes = [POINTER(c_double), c_uint, c_double]
tijk_eval_efs_f = libteem.tijk_eval_efs_f
tijk_eval_efs_f.restype = c_float
tijk_eval_efs_f.argtypes = [POINTER(c_float), c_uint, c_float]
tijk_2d_sym_to_efs_d = libteem.tijk_2d_sym_to_efs_d
tijk_2d_sym_to_efs_d.restype = c_int
tijk_2d_sym_to_efs_d.argtypes = [POINTER(c_double), POINTER(c_double), POINTER(tijk_type)]
tijk_2d_sym_to_efs_f = libteem.tijk_2d_sym_to_efs_f
tijk_2d_sym_to_efs_f.restype = c_int
tijk_2d_sym_to_efs_f.argtypes = [POINTER(c_float), POINTER(c_float), POINTER(tijk_type)]
tijk_efs_to_2d_sym_d = libteem.tijk_efs_to_2d_sym_d
tijk_efs_to_2d_sym_d.restype = POINTER(tijk_type)
tijk_efs_to_2d_sym_d.argtypes = [POINTER(c_double), POINTER(c_double), c_uint]
tijk_efs_to_2d_sym_f = libteem.tijk_efs_to_2d_sym_f
tijk_efs_to_2d_sym_f.restype = POINTER(tijk_type)
tijk_efs_to_2d_sym_f.argtypes = [POINTER(c_float), POINTER(c_float), c_uint]
tijk_class = (POINTER(airEnum)).in_dll(libteem, 'tijk_class')
tijk_set_axis_tensor = libteem.tijk_set_axis_tensor
tijk_set_axis_tensor.restype = c_int
tijk_set_axis_tensor.argtypes = [POINTER(Nrrd), c_uint, POINTER(tijk_type)]
tijk_set_axis_esh = libteem.tijk_set_axis_esh
tijk_set_axis_esh.restype = c_int
tijk_set_axis_esh.argtypes = [POINTER(Nrrd), c_uint, c_uint]
tijk_set_axis_efs = libteem.tijk_set_axis_efs
tijk_set_axis_efs.restype = c_int
tijk_set_axis_efs.argtypes = [POINTER(Nrrd), c_uint, c_uint]
class tijk_axis_info_t(Structure):
    pass
tijk_axis_info_t._fields_ = [
    ('tclass', c_int),
    ('masked', c_uint),
    ('type', POINTER(tijk_type)),
    ('order', c_uint),
]
tijk_axis_info = tijk_axis_info_t
tijk_get_axis_type = libteem.tijk_get_axis_type
tijk_get_axis_type.restype = c_int
tijk_get_axis_type.argtypes = [POINTER(tijk_axis_info), POINTER(Nrrd), c_uint]
unrrdu_makeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_makeCmd')
unrrdu_w2iCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_w2iCmd')
unrrdu_envCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_envCmd')
unrrdu_vidiconCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_vidiconCmd')
unrrdu_joinCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_joinCmd')
unrrdu_ccmergeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_ccmergeCmd')
unrrdu_axdeleteCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_axdeleteCmd')
unrrdu_tileCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_tileCmd')
unrrdu_unquantizeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_unquantizeCmd')
unrrdu_flipCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_flipCmd')
unrrdu_dataCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_dataCmd')
unrrdu_2opCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_2opCmd')
unrrdu_mrmapCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_mrmapCmd')
unrrdu_shuffleCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_shuffleCmd')
unrrdu_i2wCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_i2wCmd')
unrrdu_cropCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_cropCmd')
unrrdu_convertCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_convertCmd')
unrrdu_axinfoCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_axinfoCmd')
unrrdu_distCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_distCmd')
unrrdu_axmergeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_axmergeCmd')
unrrdu_headCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_headCmd')
unrrdu_resampleCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_resampleCmd')
unrrdu_sselectCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_sselectCmd')
unrrdu_ccadjCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_ccadjCmd')
unrrdu_deringCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_deringCmd')
unrrdu_histaxCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_histaxCmd')
unrrdu_imapCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_imapCmd')
unrrdu_dnormCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_dnormCmd')
unrrdu_insetCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_insetCmd')
unrrdu_substCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_substCmd')
unrrdu_permuteCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_permuteCmd')
unrrdu_histoCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_histoCmd')
unrrdu_cmedianCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_cmedianCmd')
unrrdu_spliceCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_spliceCmd')
unrrdu_acropCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_acropCmd')
unrrdu_diffCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_diffCmd')
unrrdu_lut2Cmd = (unrrduCmd).in_dll(libteem, 'unrrdu_lut2Cmd')
unrrdu_affineCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_affineCmd')
unrrdu_sliceCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_sliceCmd')
unrrdu_quantizeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_quantizeCmd')
unrrdu_unorientCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_unorientCmd')
unrrdu_axsplitCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_axsplitCmd')
unrrdu_jhistoCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_jhistoCmd')
unrrdu_reshapeCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_reshapeCmd')
unrrdu_dhistoCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_dhistoCmd')
unrrdu_ccsettleCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_ccsettleCmd')
unrrdu_fftCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_fftCmd')
unrrdu_projectCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_projectCmd')
unrrdu_axinsertCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_axinsertCmd')
unrrdu_padCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_padCmd')
unrrdu_swapCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_swapCmd')
unrrdu_rmapCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_rmapCmd')
unrrdu_heqCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_heqCmd')
unrrdu_lutCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_lutCmd')
unrrdu_3opCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_3opCmd')
unrrdu_cksumCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_cksumCmd')
unrrdu_ccfindCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_ccfindCmd')
unrrdu_diceCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_diceCmd')
unrrdu_mlutCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_mlutCmd')
unrrdu_saveCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_saveCmd')
unrrdu_minmaxCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_minmaxCmd')
unrrdu_untileCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_untileCmd')
unrrdu_gammaCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_gammaCmd')
unrrdu_aboutCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_aboutCmd')
unrrdu_1opCmd = (unrrduCmd).in_dll(libteem, 'unrrdu_1opCmd')
unrrduPresent = (c_int).in_dll(libteem, 'unrrduPresent')
unrrduBiffKey = (STRING).in_dll(libteem, 'unrrduBiffKey')
unrrduDefNumColumns = (c_uint).in_dll(libteem, 'unrrduDefNumColumns')
unrrduCmdList = (POINTER(unrrduCmd) * 0).in_dll(libteem, 'unrrduCmdList')
unrrduUsageUnu = libteem.unrrduUsageUnu
unrrduUsageUnu.restype = None
unrrduUsageUnu.argtypes = [STRING, POINTER(hestParm)]
unrrduUsage = libteem.unrrduUsage
unrrduUsage.restype = c_int
unrrduUsage.argtypes = [STRING, POINTER(hestParm), STRING, POINTER(POINTER(unrrduCmd))]
unrrduHestPosCB = (hestCB).in_dll(libteem, 'unrrduHestPosCB')
unrrduHestMaybeTypeCB = (hestCB).in_dll(libteem, 'unrrduHestMaybeTypeCB')
unrrduHestScaleCB = (hestCB).in_dll(libteem, 'unrrduHestScaleCB')
unrrduHestBitsCB = (hestCB).in_dll(libteem, 'unrrduHestBitsCB')
unrrduHestFileCB = (hestCB).in_dll(libteem, 'unrrduHestFileCB')
unrrduHestEncodingCB = (hestCB).in_dll(libteem, 'unrrduHestEncodingCB')
_airThread._fields_ = [
]
_airThreadMutex._fields_ = [
]
_airThreadCond._fields_ = [
]
NrrdIoState_t._fields_ = [
    ('path', STRING),
    ('base', STRING),
    ('line', STRING),
    ('dataFNFormat', STRING),
    ('dataFN', POINTER(STRING)),
    ('headerStringWrite', STRING),
    ('headerStringRead', STRING),
    ('dataFNArr', POINTER(airArray)),
    ('headerFile', POINTER(FILE)),
    ('dataFile', POINTER(FILE)),
    ('dataFileDim', c_uint),
    ('lineLen', c_uint),
    ('charsPerLine', c_uint),
    ('valsPerLine', c_uint),
    ('lineSkip', c_uint),
    ('headerStrlen', c_uint),
    ('headerStrpos', c_uint),
    ('byteSkip', c_long),
    ('dataFNMin', c_int),
    ('dataFNMax', c_int),
    ('dataFNStep', c_int),
    ('dataFNIndex', c_uint),
    ('pos', c_int),
    ('endian', c_int),
    ('seen', c_int * 33),
    ('detachedHeader', c_int),
    ('bareText', c_int),
    ('skipData', c_int),
    ('skipFormatURL', c_int),
    ('keepNrrdDataFileOpen', c_int),
    ('zlibLevel', c_int),
    ('zlibStrategy', c_int),
    ('bzip2BlockSize', c_int),
    ('learningHeaderStrlen', c_int),
    ('oldData', c_void_p),
    ('oldDataSize', c_size_t),
    ('format', POINTER(NrrdFormat)),
    ('encoding', POINTER(NrrdEncoding)),
]
class NrrdResampleAxis(Structure):
    pass
NrrdResampleAxis._pack_ = 4
NrrdResampleAxis._fields_ = [
    ('kernel', POINTER(NrrdKernel)),
    ('kparm', c_double * 8),
    ('min', c_double),
    ('max', c_double),
    ('samples', c_size_t),
    ('overrideCenter', c_int),
    ('center', c_int),
    ('sizeIn', c_size_t),
    ('sizePerm', c_size_t * 16),
    ('axIdx', c_uint),
    ('passIdx', c_uint),
    ('axisPerm', c_uint * 16),
    ('ratio', c_double),
    ('nrsmp', POINTER(Nrrd)),
    ('nline', POINTER(Nrrd)),
    ('nindex', POINTER(Nrrd)),
    ('nweight', POINTER(Nrrd)),
]
NrrdResampleContext._pack_ = 4
NrrdResampleContext._fields_ = [
    ('nin', POINTER(Nrrd)),
    ('verbose', c_int),
    ('boundary', c_int),
    ('typeOut', c_int),
    ('renormalize', c_int),
    ('roundlast', c_int),
    ('clamp', c_int),
    ('defaultCenter', c_int),
    ('nonExistent', c_int),
    ('padValue', c_double),
    ('dim', c_uint),
    ('passNum', c_uint),
    ('topRax', c_uint),
    ('botRax', c_uint),
    ('permute', c_uint * 17),
    ('passAxis', c_uint * 16),
    ('axis', NrrdResampleAxis * 17),
    ('flag', POINTER(c_int)),
    ('time', c_double),
]
NrrdIter._pack_ = 4
NrrdIter._fields_ = [
    ('nrrd', POINTER(Nrrd)),
    ('ownNrrd', POINTER(Nrrd)),
    ('val', c_double),
    ('size', c_size_t),
    ('data', STRING),
    ('left', c_size_t),
    ('load', CFUNCTYPE(c_double, c_void_p)),
]
NrrdDeringContext._pack_ = 4
NrrdDeringContext._fields_ = [
    ('verbose', c_int),
    ('linearInterp', c_int),
    ('verticalSeam', c_int),
    ('nin', POINTER(Nrrd)),
    ('center', c_double * 2),
    ('clampPerc', c_double * 2),
    ('radiusScale', c_double),
    ('thetaNum', c_uint),
    ('clampHistoBins', c_uint),
    ('rkernel', POINTER(NrrdKernel)),
    ('rkparm', c_double * 8),
    ('tkernel', POINTER(NrrdKernel)),
    ('tkparm', c_double * 8),
    ('cdataIn', STRING),
    ('cdataOut', STRING),
    ('sliceSize', c_size_t),
    ('clampDo', c_int),
    ('clamp', c_double * 2),
    ('ringMagnitude', c_double),
]
__all__ = ['tenFiberStopUIntSet', 'biffMsgAddf',
           'limnCameraPathTrack', 'gageVecLambda2', 'miteUserNix',
           'gageVecSOmega', 'tenInterpTypeRThetaPhiLinear',
           'ell_4m_post_mul_f', 'nrrdArithGamma', 'ell_Nm_check',
           'tijk_refine_max_2d_f', 'pushEnergyCoulomb', 'tijk_class',
           'tenEstimate1MethodMLE', 'nrrdHasNonExistOnly',
           'nrrdFormatPNG', 'pullInterTypeLast', 'miteBiffKey',
           'limnEdgeTypeLast', 'tenGageFAShapeIndex',
           'tijk_approx_rankk_3d_f', 'baneMeasrUnknown', 'alanParmF',
           'seekTypeMinimalSurface', 'pullIterParmLast',
           'airRandMTStateNix', 'nrrdKernelCatmullRomD',
           'pullInfoTangent1', 'pullInfoTangent2', 'alanParmK',
           'gageContextCopy', 'miteValVdefTdotV', 'nrrdKernelC4Hexic',
           'unrrdu_dnormCmd', 'pullEnergyCotan',
           'tenEstimateContextNix', 'tenGageFAGeomTens',
           'airEndsWith', 'miteUser', 'ell_4m_to_q_d',
           'nrrdField_block_size', 'mossSamplerNew',
           'tenFiberIntgLast', 'tenDoubleContract_d',
           'pullInfoQuality', 'limnSpaceView', 'limnSplineMinT',
           'nrrdResampleNonExistentRenormalize', 'nrrdFieldInfoParse',
           'nrrdField_space', 'baneStateHistEqSmart',
           'tenGageConfDiffusionAlign', 'gageSclK2',
           'hestRespFileComment', 'nrrdApply2DLut', 'gageSclK1',
           'tenGageNormGradMag', 'ell_q_exp_f',
           'tijk_refine_max_3d_f', 'bane1DOpacInfoFrom2D',
           'tijk_refine_max_3d_d', 'tijk_refine_max_2d_d',
           'nrrdBoundaryWrap', 'seekLowerInsideSet',
           'limnEdgeTypeBackFacet', 'ell_q_exp_d',
           'tenInterpTypeLoxR', 'tijk_3o3d_unsym', 'pushBinPointAdd',
           'nrrdFlip', 'airFP_SNAN', 'tenDwiGageTensorMLEError',
           'nrrdKernelBlackmanD', 'pullInitMethodLast',
           'seekContextNew', 'nrrdField_comment',
           'limnSplineInfoSize', 'nrrdSimpleResample',
           'tenInterpTypeLoxK', 'nrrdTernaryOpIfElse',
           'tenGlyphTypePolarPlot', 'limnPolyDataCylinder',
           'tendFiberStopCB', 'seekTypeMaximalSurface',
           'unrrdu_flipCmd', 'nrrdKeyValueSize', 'gageErrUnknown',
           'limnPolyDataNeighborArray', 'nrrdBinaryOpSgnPow',
           'nrrdKeyValueGet', 'nrrdKernelCatmullRomSupportDebugDD',
           'limnQN16octa', 'nrrdKernelC3QuinticD', 'airTypeFloat',
           'pullFlagBinSingle', 'nrrdField_line_skip', 'miteValYi',
           'limnLightReset', 'ellPresent', 'nrrdField_space_units',
           'gageSclShapeTrace', 'seekStrengthSet',
           'pullCondEnergyTry', 'tenDwiGage2TensorPeled',
           'nrrdKernelBSpline4DDD', 'tenGageTraceHessianEvec0',
           'tenGageTraceHessianEvec1', 'nrrdMeasureMax',
           'miteShadeMethodLast', 'echoMatterLightUnit',
           'unrrdu_substCmd', 'limnHestPolyDataLMPD',
           'baneGkms_hvolCmd', 'nrrdUnaryOpExists',
           'nrrdSpace3DRightHandedTime', 'airArrayNix',
           'nrrdArithIterBinaryOp', 'airFPClass_d', 'airNoDio_format',
           'gageCtxFlagLast', 'dyeConvert', 'ell_q_3v_rotate_d',
           'limnQNLast', 'gageParmOrientationFromSpacing',
           'nrrdBasicInfoMeasurementFrame', 'limnQN8octa',
           'limnPolyDataNix', 'tenInterpTypeWang',
           'limnPolyDataOctahedron', 'unrrdu_envCmd',
           'nrrdSpace3DLeftHanded', 'nrrdUnaryOpCbrt',
           'nrrdAxisInfoLast', 'coilMethodTesting',
           'tenFiberDirectionNumber', 'tijk_eval_efs_f',
           'coilKind7Tensor', 'baneIncAnswer', 'hooverThreadBegin_t',
           'airFastExp', 'tenExperSpecNix', 'pullStatusNixMe',
           'tenGageQGradVec', 'tenGageOmegaLaplacian',
           'pullTraceMultiNix', 'nrrdOriginStatusNoMin',
           'nrrdResampleInputSet', 'tenGlyphType',
           'pullInitMethodPointPerVoxel', 'tenFiberSingleTrace',
           'tenGageOmegaDiffusionFraction', 'tijk_refine_rank1_3d_f',
           'gageVecProjHelGradient', 'miteRangeChar',
           'nrrdStateMeasureType', 'tijk_class_last', 'pullInfoLast',
           'tenTripleConvert', 'hestElideSingleOtherDefault',
           'gageSclHessianTen', 'echoTypeRectangle', 'nrrdUntile2D',
           'nrrdSpaceLeftAnteriorSuperior', 'nrrdTypeULLong',
           'airInsane_UCSize', 'limnSplineTypeSpecParse',
           'limnSplineInfo4Vector', 'tenInterpParmBufferAlloc',
           'nrrdResampleRangeSet', 'unrrdu_dhistoCmd',
           'tenFiberIntgRK4', 'pushEnergySpring', 'tenGageModeWarp',
           'nrrdFormatUnknown', 'gageStackBlurParmScaleSet',
           'elfMaximaParmSet', 'tenInterpTwoDiscrete_d',
           'tenFiberStopMinNumSteps', 'nrrdKernelSprint',
           'gageKindVolumeCheck', 'tenGageNormGradVec',
           'tenGageQHessian', 'airHeapNix', 'limnPolyDataCone',
           'unrrdu_distCmd', 'hestParmNew', 'tenEstimate2Method',
           'nrrdUnaryOpAcos', 'tenModel1Stick', 'tendCmdList',
           'airMopAlways', 'gageKindAnswerLength', 'nrrdMeasureSD',
           'tenBMatrixCalc', 'nrrdLoad', 'miteVariableParse',
           'pullCCSort', 'echoThreadStateNew', 'coilKindTypeLast',
           'mossMatTranslateSet', 'nrrdBinaryOpGT',
           'tenDefFiberMaxHalfLen', 'tenGlyphBqdEvalUv',
           'banePosCalc', 'tijk_3o2d_sym', 'airFloatQNaN',
           'limnPolyDataIcoSphere', 'tenEigensolve_f',
           'pullEnergyTypeZero', 'tenEigensolve_d',
           'meetNrrdKernelAllCheck', 'tenGageQGradMag',
           'gageDefStackNormalizeDeriv', 'nrrdArithUnaryOp',
           'tenGageCp1HessianEvec2', 'tenGageCp1HessianEvec1',
           'tenGageCp1HessianEvec0', 'pullTask_t', 'echoColorSet',
           'pullConstraintFailTravel',
           'nrrdEnvVarStateMeasureModeBins', 'tenFiberMultiProbeVals',
           'miteRayBegin', 'alanParmNumThreads', 'pullFlagSet',
           'gageParmDefaultCenter', 'unrrdu_ccmergeCmd',
           'miteThreadNew', 'miteStage', 'airDrandMT53_r',
           'airMopNever', 'tenFiberTypeEvec1', 'tenFiberTypeEvec0',
           'tenFiberTypeEvec2', 'gageVecCurlNorm', 'ell_4m_to_q_f',
           'ell_3v_print_d', 'nrrdMeasureHistoMedian',
           'ell_3v_print_f', 'pullSysParmEnergyDecreasePopCntlMin',
           'unrrdu_ccsettleCmd', 'tenGageCa1HessianEvec',
           'tenGageFADiffusionFraction', 'gageStackBlurParm',
           'limnPolyDataSpiralSuperquadric', 'seekTypeRidgeSurfaceT',
           'nrrdBasicInfoSpaceOrigin', 'airUnescape', 'airEnumPrint',
           'tenGageCa1HessianEval', 'alanRun',
           'pullProcessModeNixing', 'airFPGen_f', 'airFPGen_d',
           'airInsane_FltDblFPClass', 'pullInfoSpecNew',
           'nrrdBinaryOpIf', 'nrrdAxisInfoSpacing', 'airExists',
           'pullInfoLiveThresh', 'gageStackBlurParmNix',
           'tenDWMRINexKeyFmt', 'pullInfoInside',
           'tijk_approx_heur_3d_f', 'nrrdBinaryOpLTE',
           'gageErrStackUnused', 'nrrdZeroSet',
           'nrrdSpaceLeftAnteriorSuperiorTime', 'unrrduScaleUnknown',
           'nrrdRangePercentileFromStringSet', 'limnPolyDataCopy',
           'coilMethodArray', 'gageDeconvolveSeparableKnown',
           'coilMethodTypeLast', 'tijk_zero_f', 'nrrdAxisInfoUnknown',
           'tijk_zero_d', 'meetHestConstGageKind', 'miteThreadBegin',
           'nrrdKernelBSpline2DD', 'nrrdTernaryOpMinSmooth',
           'gageShapeItoW', 'miteThreadNix', 'limnPrimitiveLines',
           'pullSysParmBeta', 'unrrduCmdList', 'nrrdUnaryOpNerf',
           'pushTask', 'gageShapeCopy', 'tenFiberVerboseSet',
           'nrrdSanity', 'nrrdCCFind', 'nrrdUnaryOpTan',
           'tijk_copy_f', 'tenAniso_RA', 'tenTripleTypeRThetaZ',
           'tenGageRHessian', 'gageKindCheck', 'airNoDio_size',
           'seekTypeRidgeSurface', 'pullEnergyZero',
           'gagePerVolumeNew', 'alanParmDiffB',
           'pullFlagPopCntlEnoughTest', 'alanParmDiffA',
           'pushBinDone', 'pullInfoLiveThresh2',
           'pullInfoLiveThresh3', 'nrrdAxesSwap',
           'gageOptimSigTruthSet', 'gageItemSpec', 'baneMakeHVol',
           'gageSclHessRidgeness', 'mossFlagLast',
           'nrrdDefaultWriteBareText', 'airShuffle_r',
           'limnObjectRender', 'miteValXw',
           'nrrdSpacingStatusScalarWithSpace', 'tenDWMRIModalityKey',
           'pullFlag', 'nrrdKind3DMaskedMatrix', 'miteValXi',
           'gageParmStackNormalizeDerivBias', 'alanContext_t',
           'nrrdOriginStatusDirection', 'baneMeasrValuePositive',
           'baneSigmaCalc', 'nrrdWrite', 'pullInfoIsovalue',
           'nrrdAlloc_va', 'gageItemPackPartHessEval1',
           'gageItemPackPartHessEval0', 'gageItemPackPartHessEval2',
           'seekDescendToRidge', 'tenFiberParmStepSize',
           'pullPointInitializeRandomOrHalton',
           'limnObjectSpaceTransform', 'nrrdKeyValueErase',
           'limnPolyDataPrimitiveArea', 'nrrdResampleTypeOutSet',
           'unrrduHestScaleCB', 'nrrdArithBinaryOp',
           'meetHestPullVol', 'nrrdZlibStrategyDefault',
           'baneClipUnknown', 'pushOutputGet', 'tenEMBimodalParmNix',
           'tenAniso_Cp1', 'nrrdIterNix', 'tenAniso_Cp2',
           'airMopSingleOkay', 'tijk_refine_rankk_parm_new',
           'nrrdUIInsert', 'gageErrNone', 'tend_shrinkCmd',
           'tend_expCmd', 'ell_3m_svd_d', 'limnQN9octa',
           'unrrdu_axinsertCmd', 'airBesselIn', 'baneHVolParmNew',
           'pullCCMeasure', 'gageDefGenerateErrStr',
           'nrrdEnvVarDefaultSpacing', 'nrrdRangePercentileSet',
           'tenGradientParmNew', 'tijk_esh_to_3d_sym_f',
           'nrrdTypeUChar', 'nrrdAxisInfoThickness',
           'pullPropStepConstr', 'tijk_esh_to_3d_sym_d',
           'airHeapFrontPeek', 'pushBin_t', 'airTypeLast',
           'nrrdBasicInfoSpace', 'miteStageOpLast',
           'tenDwiGageConfidence', 'ell_cubic_root_last', 'biffGet',
           'gageProbe', 'nrrdMeasureL2', 'nrrdMeasureL1',
           'alanParmConstantFilename', 'miteShadeMethodLitTen',
           'nrrdCenterUnknown', 'limnHestCameraOptAdd',
           'echoTypeInstance', 'airBesselI1', 'seekSamplesSet',
           'nrrdIterValue', 'nrrdKind2DMaskedMatrix',
           'pullPhistEnabled', 'airSgnPow', 'nrrdBasicInfoOldMin',
           'airMopUnMem', 'gageVecHelicity', 'gageSclHessFrob',
           'airThreadNew', 'tenGageOmegaHessianEval2',
           'tenGageOmegaHessianEval1', 'tenGageOmegaHessianEval0',
           'nrrdAxisInfoLabel', 'nrrdSpacingStatusScalarNoSpace',
           'tend_glyphCmd', 'nrrdHistoEq', 'limnSpline_t', 'biffDone',
           'tenDWMRIBmatKeyFmt', 'tenGage', 'nrrdBinaryOpExists',
           'tenEigenvalueMultiply', 'alanTextureTypeLast',
           'tenGageTraceHessianEvec', 'nrrdKernelBSpline3',
           'seekDescendToDegCell', 'echoGlobalStateNix', 'limnLook',
           'unrrdu_w2iCmd', 'limnLightSet', 'baneGkms_scatCmd',
           'pullInfoSpecNix', 'tenModelParmDesc', 'nrrdUnaryOpExp',
           'tijk_refine_rank1_parm_new', 'baneRangeNix',
           'limnObjectReadOFF', 'pullInfoIsovalueGradient',
           'tenGradientParm', 'hooverContextNew', 'elfGlyphPolar',
           'limnPolyDataVertexWindingFlip', 'nrrdBoundaryBleed',
           'ell_cubic_root_unknown', 'pullPointNew',
           'nrrdArithAffine', 'meetHestPullInfo',
           'nrrdKernelCos4SupportDebugDDD', 'elfMaximaContext',
           'echoJitterUnknown', 'nrrdResampleRenormalizeSet',
           'ell_aa_to_q_f', 'ell_aa_to_q_d', 'baneRawScatterplots',
           'nrrdKernelBSpline7D', 'limnSplineNrrdCleverFix',
           'pullSysParmEnergyIncreasePermit', 'miteValGageKind',
           'nrrdEnvVarDefaultWriteEncodingType',
           'pullInfoHeightLaplacian', 'echoSuperquadSet',
           'nrrdSpaceOriginSet', 'nrrdResampleInfoNew',
           'seekItemHessSet', 'pushEnergySpecNix',
           'limnPolyDataSquare', 'dyeLUVtoXYZ', 'tenAnisoUnknown',
           'pullFlagNixAtVolumeEdgeSpace', 'gageItemPack',
           'nrrdKernelCentDiff', 'miteThread', 'tenGageFAHessianEvec',
           'limnSplineInfoLast', 'nrrdMeasureLineSlope',
           'pullLogAddSet', 'tenFiberKernelSet', 'nrrdTypeIsUnsigned',
           'nrrdHistoCheck', 'gageStackBlurParmCheck',
           'pullIterParmSet', 'airNoDio_setfl', 'tend_anhistCmd',
           'ell_3m_print_f', 'nrrdKernelBSpline7DDD',
           'ell_3m_print_d', 'tenGageTraceDiffusionAlign',
           'gagePvlFlagNeedD', 'nrrdAxisInfoCompare',
           'nrrdBasicInfoComments', 'echoSuperquad',
           'nrrdKind3DMaskedSymMatrix', 'limnPolyDataTransform_f',
           'tenGlyphTypeCylinder',
           'tenEstimate1TensorSimulateSingle_f',
           'tenEstimate1TensorSimulateSingle_d', 'nrrdHistoAxis',
           'tenDWMRINAVal', 'tenDwiGageTensorWLS',
           'tenInterpTypeQuatGeoLoxR', 'limnPrimitiveNoop',
           'tenGageTensorGradMag', 'pullIterParmMax',
           'nrrdIoStateSkipData', 'nrrdSpaceVecExists',
           'echoJittableLast', 'nrrdCenterNode', 'nrrdJoin',
           'echoCylinder', 'airUIrandMT_r', 'nrrdDStore',
           'mossHestOrigin', 'tenGageFAKappa2', 'nrrdUnaryOpLast',
           'tenGageFAKappa1', 'unrrdu_imapCmd', 'tijk_max_esh_order',
           'tenDwiGageTensorLLSErrorLog', 'limnPrimitive',
           'nrrdKind2DSymMatrix', 'tenAniso_Ca2', 'pullFinish',
           'tenAniso_Ca1', 'tenGageModeHessian',
           'tijk_approx_heur_3d_d', 'nrrdKernelC5SepticApproxInverse',
           'mossMatApply', 'tenInvariantGradientsK_d',
           'NrrdResampleInfo', 'gageDefDefaultCenter', 'meetTeemLibs',
           'airTypeUInt', 'coilKindScalar', 'tenInterpTypeLinear',
           'unrrduCmd', 'limnVertex', 'nrrdCheck', 'pullCCFind',
           'limnObjectVertexNumPreSet', 'gageVecMultiGrad',
           'coilMethodTypeSelf', 'airBesselI0', 'nrrdKindUnknown',
           'ell_cubic_root', 'tenEstimateMethodSet', 'nrrdUnaryOpErf',
           'nrrdResampleNonExistentNoop', 'nrrdSliceSelect',
           'airNoDio_arch', 'tijk_4o3d_sym', 'tenInterpPathLength',
           'echoMatterGlassFuzzy', 'pullTraceStop', 'meetPullVolNew',
           'nrrdRangeSafeSet', 'pullCount', 'tenInterpParmNew',
           'airCbrt', 'airTypeEnum', 'nrrdApply1DRegMap',
           'tend_mconvCmd', 'tenGageCl2', 'tenGageCl1',
           'pullFlagScaleIsTau', 'tenFiberStopMinLength',
           'nrrdKernelBlackman', 'echoInstance',
           'nrrdMeasureHistoMax', 'limnPolyDataPlane',
           'nrrdIoStateValsPerLine', 'pullPropIdCC', 'nrrdFormatText',
           'tend_evalmultCmd', 'nrrdResampleNrrdSet',
           'nrrdEnvVarDefaultWriteValsPerLine',
           'pullCondConstraintSatB', 'miteStageOpMax',
           'pullCondConstraintSatA', 'airArrayNew', 'nrrdKernelHann',
           'ell_q_pow_d', 'nrrdBinaryOpGTE', 'ell_q_pow_f',
           'pullCountCC', 'tenFiberAnisoSpeedSet', 'pushFinish',
           'tenGageFAGradVecDotEvec0', 'tenDwiGageKindNix',
           'nrrdKindPoint', 'pullFlagUnknown',
           'limnPolyDataPolygonNumber', 'mossMatRightMultiply',
           'tenBiffKey', 'pullTraceStopSpeeding', 'nrrdFormatType',
           'nrrdDistanceL2Biased', 'nrrdUnaryOpLog',
           'limnPolyDataWriteLMPD', 'tenGageTraceHessianEvec2',
           'nrrdUnaryOpNegative', 'pullCondNew', 'nrrdFInsert',
           'limnCameraPathTrackFrom', 'meetGageKindParse',
           'hestRespFileFlag', 'baneDefMakeMeasrVol',
           'nrrdMeasureMode', 'nrrdDefaultWriteValsPerLine',
           'gageSclLaplacian', 'tenGlyphParm', 'nrrdConvert',
           'biffMaybeAddf', 'tenGlyphTypeSuperquad',
           'nrrdFormatTypeText', 'miteValYw', 'airDioRead',
           'unrrdu_minmaxCmd', 'pullEnergyTypeButterworth',
           'hooverContext', 'echoMatterLast', 'airHeapFrontUpdate',
           'tenEstimateSkipReset', 'tenGlyphTypeBox',
           'tenGageOmegaDiffusionAlign', 'nrrdMeasureHistoSD',
           'tenEstimateContextNew', 'tenAnisoPlot', 'nrrdIoStateInit',
           'nrrdKernelCatmullRom', 'dyeHSVtoRGB',
           'nrrdEnvVarStateMeasureHistoType', 'pullVerboseSet',
           'nrrdAxisInfoKind', 'airTime', 'limnFace',
           'limnPolyDataInfoNorm', 'echoType', 'tenGageQNormal',
           'limnPolyDataInfoTex2', 'nrrdHisto', 'baneHVolParmNix',
           'mossMatRotateSet', 'tenEvecRGBParm',
           'tijk_refine_rankk_parm_nix', 'tenFiberContextNix',
           'nrrdHasNonExistFalse', 'tenDWMRISkipKeyFmt',
           'miteVariablePrint', 'tenFiberParmUseIndexSpace',
           'nrrdKind3Gradient', 'pushEnergyTypeUnknown',
           'gageAnswerPointer', 'coilOutputGet', 'nrrdKeyValueClear',
           'pushEnergyZero', 'nrrdCenter', 'baneHVolParmAxisSet',
           'airBesselI1ExpScaled', 'nrrdKernelC3Quintic',
           'pullProcessModeLast', 'gageShapeNix',
           'echoJittableNormalA', 'echoJittableNormalB',
           'nrrdResampleDefaultCenterSet', 'pullPropForce',
           'tenGageSNormal', 'miteShadeSpecNix', 'nrrdTypeShort',
           'mossVerbose', 'baneHVolParmClipSet',
           'ell_cubic_root_single', 'gageShapeReset',
           'tenGageBGradMag', 'tenGlyphBqdZoneEval',
           'limnCameraPathTrackUnknown', 'nrrdDeringClampPercSet',
           'ell_3m_1d_nullspace_d', 'nrrdGetenvInt',
           'nrrdKindIsDomain', 'ell_3mv_mul_d', 'dyeXYZtoLUV',
           'ell_3mv_mul_f', 'nrrdType', 'echoThreadStateInit',
           'baneHVolParmGKMSInit', 'airExp', 'NrrdResampleAxis',
           'nrrdAxisInfoCenter', 'hestElideSingleOtherType',
           'tenEMBimodalParm', 'tenInterpTypeQuatGeoLoxK',
           'echoAABBox', 'NrrdIter', 'gageParmVerbose',
           'airThreadMutexNew', 'tenGageTensorGrad',
           'limnHestSplineTypeSpec', 'pullPropGet',
           'limnSplineTypeUnknown', 'nrrdUnaryOpExpm1',
           'tend_unmfCmd', 'tenMeasurementFrameReduce',
           'nrrdTernaryOpLerp', 'NrrdIoState', 'airErfc',
           'tenGlyphBqdZoneUv', 'airNoDio_dioinfo',
           'gageItemPackPartScalar', 'pullTraceMultiRead',
           'pushBiffKey', 'biffSetStr', 'nrrdBinaryOpDivide',
           'nrrdDeringCenterSet', 'nrrdFprint', 'biffMsg',
           'elfBallStickODF_f', 'nrrdMeasureVariance',
           'nrrdHistoThresholdOtsu', 'airEnumVal', 'tenExperSpecNew',
           'nrrdSpaceLeftPosteriorSuperiorTime', 'airHeapFrontPop',
           'airTypeStr', 'tenFiberStopOn', 'hooverErrSample',
           'nrrdZlibStrategyHuffman', 'gageStackBlurCheck',
           'pullInfoNegativeTangent1', 'pullInfoNegativeTangent2',
           'nrrdSprint', 'hooverBiffKey', 'pullEnergyTypeQuarticWell',
           'gageOptimSigPlot', 'nrrdTypeMax',
           'pullInterTypeUnivariate', 'gageParmLast',
           'pullPropUnknown', 'airParseStrF', 'airParseStrD',
           'airParseStrE', 'airParseStrB', 'airParseStrC',
           'nrrdDistanceL2', 'nrrdEnvVarStateKeyValuePairsPropagate',
           'gageSclMeanCurv', 'tend_evalclampCmd',
           'tenModel1Cylinder', 'airParseStrI', 'nrrdKeyValueAdd',
           'airParseStrS', 'nrrdTernaryOpMin', 'unrrdu_convertCmd',
           'limnEdge', 'tenGageEval1', 'tenGageEval0', 'tenAniso_Cs1',
           'dyePresent', 'tenGageAniso', 'tenDwiGageTensor',
           'echoRTRender', 'gageItemPackPartNormal', 'dyeXYZtoRGB',
           'alanStopUnknown', 'gageKindTotalAnswerLength',
           'miteStageOpAdd', 'dyeSpaceLUV', 'nrrdKernelGaussianD',
           'pullInfoTensor', 'airAtod', 'nrrdField_number',
           'tenGageModeGradMag', 'tijk_esh_make_kernel_delta_d',
           'tenAniso_Conf', 'airHeapNew', 'tijk_incr_f',
           'nrrdDeringInputSet', 'nrrdByteSkip', 'nrrdBasicInfoData',
           'baneBcptsCheck', 'gageKernelReset', 'airThreadCapable',
           'seekContext', 'nrrdFormatTypeLast', 'dyeColorCopy',
           'nrrdEnvVarStateVerboseIO', 'gageDefVerbose',
           'gageSclNProj', 'tenGageDelNormR2', 'miteNtxfCheck',
           'pullTraceMultiWrite', 'tenAniso_Omega',
           'gageStackBlurParmNew', 'pushEnergySpecSet',
           'hooverStubThreadBegin', 'unrrdu_1opCmd',
           'pullTraceStopUnknown', 'nrrdField_data_file',
           'alanParmSaveInterval', 'tenGageFACurvDir1',
           'tenGageFACurvDir2', 'hooverErrThreadCreate',
           'tenGageCl1HessianEvec2', 'tenGageCl1HessianEvec1',
           'tenGageCl1HessianEvec0', 'pullEnergyUnknown',
           'limnQN12checker', 'nrrdDLookup', 'ell_q_3v_rotate_f',
           'nrrdDInsert', 'pullSourceProp', 'tenModelFromAxisLearn',
           'nrrdIoStateCharsPerLine', 'ell_3m_eigenvalues_d',
           'hooverDefVolCentering', 'gageVecHessian',
           'gageParmStackNormalizeDeriv', 'limnObject',
           'pullIterParm', 'tenFiberStopFraction', 'airToLower',
           'nrrd1DIrregAclCheck', 'unrrdu_joinCmd',
           'elfKernelStick_f', 'miteValZw', 'airThreadCond',
           'tendTitle', 'pullSysParmWall', 'tenMake',
           'unrrdu_makeCmd', 'miteValZi', 'ell_cubic',
           'tenGageClpmin2', 'nrrdResampleNonExistentWeight',
           'nrrdUnaryOpCeil', 'tenGageClpmin1', 'limnObjectPreSet',
           'gageShape', 'tijk_copy_d', 'tenRotateSingle_f',
           'nrrdCCValid', 'mossMatIdentitySet', 'tenDefFiberIntg',
           'limnCameraNix', 'pullTraceMulti', 'nrrdKernelBSpline4DD',
           'tenDwiFiberType2Evec0', 'pullStatusNewbie',
           'tenMakeSingle_f', 'tenGageCa1HessianEval1',
           'tenGageCa1HessianEval0', 'nrrdUILookup',
           'tenGageCa1HessianEval2', 'tenEstimate1MethodWLS',
           'unrrdu_axsplitCmd', 'nrrdAxisInfoPos', 'hooverErrNone',
           'tend_fiberCmd', 'ell_Nm_pseudo_inv', 'nrrdIoStateNix',
           'echoObjectAdd', 'pullEnergyQuartic', 'gageVecVector0',
           'tenBVecNonLinearFit', 'hooverSample_t',
           'tenEstimateNegEvalShiftSet', 'nrrdCCAdjacency',
           'mossDefBoundary', 'pullTask', 'airEnumDesc', 'tijk_add_f',
           'baneIncNix', 'nrrdWrap_va',
           'nrrdStateKeyValueReturnInternalPointers',
           'unrrduHestBitsCB', 'limnSplineNew', 'miteValGTdotV',
           'pushPtrPtrUnion', 'gageItemPackPart', 'nrrdKindTime',
           'meetPresent', 'airArrayLenPreSet', 'nrrdMeasure',
           'tenModelSqeFit', 'airParseStrZ', 'airMopAdd',
           'alanPresent', 'limnObjectEmpty', 'coilMethodType',
           'airEqvAdd', 'ell_3m_inv_d', 'tenGageEval2',
           'pullProgressBinModSet', 'nrrdKernelCos4SupportDebugD',
           'miteValNormal', 'tijk_eval_efs_basis_f',
           'tijk_eval_efs_basis_d', 'tenEstimate2MethodUnknown',
           'tend_evalpowCmd', 'unrrdu_lutCmd', 'tenDwiGageUnknown',
           'miteValTw', 'tenFiberIntg', 'miteValTi',
           'nrrdFormatTypeEPS', 'tijk_negate_f', 'tend_tripleCmd',
           'dyeColorParse', 'airIndexClamp', 'nrrdEncodingTypeLast',
           'nrrdTypeDefault', 'baneHVolParm', 'pullBin_t',
           'tijk_init_max_3d_f', 'nrrdEncodingTypeAscii', 'coil_t',
           'tenAniso_FA', 'tenGageFAHessian', 'gageStackBlurGet',
           'limnPolyDataReadOFF', 'gageSclValue', 'airEqvSettle',
           'echoIsosurface', 'echoMatterPhongSp', 'nrrdField_max',
           'seekTypeRidgeSurfaceOP', 'nrrdFLookup', 'mossPresent',
           'ell_q_to_3m_f', 'unrrdu_diceCmd', 'pushBinInit',
           'hestNoArgsIsNoProblem', 'limnPolyDataInfoLast',
           'airHeapFromArray', 'nrrdResampleSamplesSet',
           'gageVecHelGradient', 'miteShadeMethodNone',
           'unrrdu_ccfindCmd', 'gagePvlFlagUnknown',
           'nrrdIterContent', 'tenEstimateLinear3D', 'gageContextNix',
           'nrrdRangeCopy', 'pullPositionHistoryGet', 'alan3DSizeSet',
           'tenFiberStopLast', 'tenModelConvert', 'tenModelZero',
           'nrrdKernelBSpline5D', 'hooverStubSample', 'biffMsgErrNum',
           'gagePerVolumeDetach', 'gageScl',
           'nrrdResampleNonExistentUnknown', 'airBool',
           'tend_makeCmd', 'alanParmLast', 'limnSplineNix',
           'tenEvecRGB', 'hestGlossary', 'nrrdUILoad',
           'pullHestEnergySpec', 'airNull', 'nrrdField_keyvalue',
           'unrrdu_2opCmd', 'gageAnswerLength', 'airTypeOther',
           'nrrdKernelBSpline3DD', 'nrrdIoStateFormatSet',
           'pullPropIdtag', 'ell_3v_angle_d', 'unrrdu_i2wCmd',
           'ell_3v_angle_f', 'airEnumUnknown', 'nrrdFormatVTK',
           'echoRayIntx', 'pullPointScalar',
           'nrrdField_space_dimension', 'limnObjectPartAdd',
           'tenEvecRGBParmCheck', 'limnSplineNrrdEvaluate',
           'tijk_incr_d', 'limnQN12octa', 'seekBiffKey',
           'nrrdDefaultResampleCheap', 'airOneLine',
           'nrrdKernelForwDiff', 'tijk_get_axis_type',
           'miteShadeSpecNew', 'hestCB', 'tenEstimate2MethodLast',
           'tenAniso_eval2', 'tenAniso_eval0', 'tenAniso_eval1',
           'baneClipNix', 'pullTraceStopConstrFail', 'ell_4m_det_f',
           'ell_4m_det_d', 'nrrdFFTWPlanRigorLast',
           'tenEstimate2MethodPeled', 'gageVecNCurlNormGrad',
           'nrrdDefaultSpacing', 'unrrdu_unorientCmd', 'hestColumns',
           'alanStopConverged', 'tenFiberTraceSet',
           'nrrdApplyMulti1DLut', 'nrrdCCMerge',
           'nrrdMeasureHistoMode', 'nrrdBinaryOpNotEqual',
           'pullVolumeSingleAdd', 'nrrdBinaryOpMultiply',
           'gageParmGenerateErrStr', 'pullConstraintFailLast',
           'tenInterpTypeUnknown', 'tenGageOmegaHessianContrTenEvec1',
           'biffMaybeAdd', 'tijk_esh_len', 'hooverContextNix',
           'nrrdSpatialResample', 'pullPointNix', 'echoSplit',
           'dyeColorGetAs', 'tenDefFiberStepSize', 'echoObjectNix',
           'pullEnergySpecNew', 'coilContext', 'pushEnergyTypeLast',
           'pullSysParmNeighborTrueProb', 'nrrdBiffKey',
           'limnPrimitiveQuads', 'limnPolyDataVertexNormals',
           'limnLightNix', 'unrrdu_untileCmd', 'gageVecCurl',
           'nrrdInset', 'pullInitParm', 'dyeLABtoXYZ',
           'nrrdBinaryOpMod', 'tenFiberTypeUnknown',
           'limnSplineNumPoints', 'hestOptAdd', 'tenGageDelNormR1',
           'nrrdTypeMin', 'airStrdup', 'echoRoughSphereNew',
           'airThreadMutexLock', 'nrrdInit', 'gageKernelStack',
           'tenGradientIdealEdge', 'nrrdGetenvBool',
           'nrrdIoStateEncodingGet', 'alanDimensionSet',
           'baneOpacCalc', 'dyeSpaceRGB', 'tijk_refine_rankk_3d_d',
           'baneClip', 'tijk_refine_rankk_3d_f',
           'tenTripleCalcSingle_f', 'miteThread_t', 'limnBiffKey',
           'tijk_2o3d_unsym', 'alanContextNix', 'tenAniso_Mode',
           'pullEnergyQuarticWell', 'echoJitterJitter',
           'baneMeasrLaplacian', 'limnObjectVertexAdd',
           'nrrdBinaryOpLT', 'unrrdu_acropCmd', 'coilKindType',
           'pullSysParmProbeProb', 'airStrtokQuoting',
           'pullInfoHeightGradient', 'pullPropStability',
           'coilMethod', 'gageSclMedian', 'miteQueryAdd',
           'limnPolyDataClipMulti', 'airTypeSize', 'pullSysParmGamma',
           'airStrcmp', 'airStrlen', 'tenGageCp1HessianEval',
           'echoMatterUnknown', 'unrrdu_saveCmd', 'gageSclGradVec',
           'tenDwiFiberType', 'tijk_init_rank1_2d_d',
           'tijk_init_rank1_2d_f', 'tenLog', 'tenGageCp1HessianEval2',
           'tenGageCp1HessianEval0', 'tenGageCp1HessianEval1',
           'nrrdSpaceDimension', 'miteDefNormalSide',
           'nrrdTernaryOpGTSmooth', 'unrrdu_axmergeCmd',
           'pullSourceLast', 'tijk_type_t', 'pullInfoSpec',
           'nrrdFStore', 'biffAdd', 'tijk_scale_f',
           'tenGradientDistribute', 'tijk_scale_d', 'nrrdKind',
           'nrrdValCompare', 'gagePvlFlagQuery',
           'pullTraceMultiPlotAdd', 'nrrdIterSetValue',
           'limnCameraPathMake', 'unrrdu_affineCmd', 'unrrduScaleAdd',
           'nrrdHasNonExistUnknown', 'elfBallStickPredict_f',
           'miteRenderEnd', 'miteRender', 'nrrdBinaryOpFlippedSgnPow',
           'pullPropNeighCovarDet', 'limnObjectWorldHomog',
           'tijk_6o3d_sym', 'tenGradientParmNix',
           'tenGageEvalHessian', 'nrrdKernelC4HexicApproxInverse',
           'nrrdBinaryOpEqual', 'limnQN10checker', 'mitePresent',
           'tenFiberStopAnisoSet', 'pullTraceMultiFilterConcaveDown',
           'meetHestGageKind', 'tenAnisoTen_d', 'tenPowSingle_d',
           'tenAnisoTen_f', 'echoMatterPhongSet', 'echoMatterMetal',
           'nrrdTernaryOpMultiply', 'mossImageCheck',
           'tenFiberMultiNix', 'nrrdBinaryOpAdd', 
           'nrrdTernaryOpExists', 'limnObjectCubeAdd',
           'nrrdKindVector', 'echoRTParm', 'tijkPresent',
           'limnLightAmbientSet', 'gageShapeSet',
           'tenDefFiberUseIndexSpace', 'tijk_esh_sp_f',
           'nrrdBlind8BitRangeFalse', 'tenGageDetGradVec',
           'airFP_NEG_INF', 'hestOptFree', 'tenGageModeHessianEval',
           'echoJitterGrid', 'nrrdIoStateBzip2BlockSize',
           'hooverErrRenderBegin', 'hooverErrRayBegin',
           'airFPPartsToVal_f', 'hestVerbosity',
           'alanParmMaxIteration', 'nrrdDefaultWriteEncodingType',
           'limnLight', 'tenAnisoVolume', 'echoMatterGlassKa',
           'airHalton', 'echoMatterGlassKd', 'nrrdAxisInfoCopy',
           'NrrdRange', 'airMyDio', 'tenBMatrixCheck',
           'limnObjectDescribe', 'nrrdBinaryOpRicianRand',
           'pushPoint_t', 'nrrdIoStateSet', 'tenFiberContextCopy',
           'tend_helixCmd', 'echoTypeIsosurface',
           'tenEstimate1MethodUnknown', 'coilKindTypeScalar',
           'echoMatterLightPower', 'nrrdSpaceRightAnteriorSuperior',
           'gageVecCurlNormGrad', 'seekEvalDiffThreshSet',
           'gageVecNormHelicity', 'pullSysParmBinWidthSpace',
           'nrrdContentSet_va', 'pullConstraintFail',
           'tenFiberProbeItemSet', 'baneClipTopN',
           'nrrdEncodingAscii', 'hooverErrRenderEnd',
           'echoRectangleSet', 'ell_4v_norm_f',
           'nrrdKernelCos4SupportDebug', 'ell_q_avgN_d', 'airStdout',
           'airThreadCondNix', 'baneMeasrValueAnywhere',
           'alanParmDeltaT', 'airInsane_not', 'tenExp',
           'miteValVdefT', 'tenModel_t', 'alanParmDeltaX',
           'tenFiberParmSet', 'pullEnergyBetterCubicWell',
           'airTypeChar', 'airRandInt_r', 'nrrdResampleKernelSet',
           'tenGageRNormal', 'limnPolyDataReadLMPD',
           'tijk_refine_rank1_parm', 'nrrdDefaultWriteCharsPerLine',
           'nrrdMaybeAlloc_va', 'nrrdStateDisableContent',
           'nrrdKindQuaternion', 'nrrdNonSpatialAxesGet',
           'tenExperSpecGradSingleBValSet',
           'tenDwiGageTensorErrorLog', 'limnPolyDataInfo',
           'airFP_QNAN', 'tijk_axis_info_t', 'nrrdProject',
           'baneRangePositive', 'nrrdField_endian',
           'nrrdKindCovariantVector', 'baneClipAnswer',
           'ell_4v_print_d', 'ell_4v_print_f', 'nrrdEncodingTypeGzip',
           'gageParm', 'tenGageOmegaHessian', 'unrrdu_lut2Cmd',
           'alanBiffKey', 'limnWindowNix', 'nrrdEnvVarDefaultCenter',
           'unrrdu_3opCmd', 'tijk_esh_convolve_f', 'tenEvqVolume',
           'nrrdEncodingTypeRaw', 'ell_aa_to_4m_f',
           'nrrdKernelBSpline4D', 'nrrdSpaceDimensionSet',
           'tijk_type', 'nrrdFormatEPS', 'unrrduScaleLast',
           'gageContext', 'gageCtxFlagKernel', 'tend_evaladdCmd',
           'limnObjectDepthSortParts', 'tijk_approx_heur_2d_f',
           'pullInfoLen', 'nrrdKindSize', 'pullSourceUnknown',
           'limnPrimitiveTriangleStrip', 'airThreadMutexNix',
           'tenGradientCheck', 'tenSimulateSingle_f',
           'tenGageFATotalCurv', 'tijk_4o2d_sym', 'airRandInt',
           'pushHestEnergySpec', 'nrrdAlloc_nva', 'miteRayEnd',
           'airFloatNegInf', 'nrrdKernelSpecSprint', 'limnVtoQN_f',
           'limnVtoQN_d', 'tijk_approx_heur_2d_d', 'miteRangeSP',
           'pullStatusLast', 'airThreadCondSignal', 'airEndianBig',
           'nrrdUnaryOpReciprocal', 'biffMsgStrSet', 'hestOptCheck',
           'hooverErr', 'hooverRayEnd_t', 'echoTriMeshSet',
           'nrrdIterSetOwnNrrd', 'limnEnvMapFill', 'unrrdu_aboutCmd',
           'tijk_init_max_2d_f', 'dyeSpaceLAB', 'nrrdIoStateNew',
           'tenTripleType', 'unrrdu_insetCmd', 'nrrdSample_nva',
           'airTypeSize_t', 'tenGradientRandom', 'tenAniso_VF',
           'tijk_2o3d_asym', 'seekDataSet', 'unrrdu_histaxCmd',
           'tenInterpParm', 'limnPolyDataVertexNormalsNO',
           'pullCountConstraintSatisfy', 'tenInterpParmCopy',
           'tijk_approx_rankk_2d_f', 'gageBiffKey', 'gageSclCurvDir2',
           'tenGageRotTans', 'gageSclCurvDir1',
           'nrrdSpaceLeftPosteriorSuperior', 'baneIncLast',
           'alanTensorSet', 'nrrdHasNonExistTrue', 'gageProbeSpace',
           'baneAxis', 'limnSplineInfo', 'pullEnergyTypeLast',
           'tenGageCa1', 'NrrdEncoding_t', 'tenGageCa2',
           'pullEnergyBspln', 'pullCountForceFromImage',
           'ell_4m_pre_mul_f', 'elfMaximaRefineSet',
           'tenMakeSingle_d', 'dyeBiffKey', 'miteVal',
           'nrrdAxisInfoSpacingSet', 'tenGageDet',
           'baneMeasrValueZeroCentered', 'tenAniso_Ct1',
           'tenGageModeGradVec', 'tenAniso_Ct2',
           'limnEdgeTypeBackCrease', 'limnPolyDataJoin',
           'hooverDefImgCentering', 'hooverErrThreadJoin',
           'airPrettySprintSize_t', 'airFree', 'tijk_class_tensor',
           'unrrdu_jhistoCmd', 'hestRespFileEnable', 'nrrdSpaceSet',
           'pullCountProbe', 'limnPolyDataNeighborList',
           'limnSplineEvaluate', 'hooverStubRenderBegin',
           'tijk_refine_rank1_3d_d', 'biffSetStrDone',
           'pullInfoStrength', 'gageKernel10', 'gageKernel11',
           'tenFiberTypeTensorLine', 'airFPFprintf_f',
           'airFPFprintf_d', 'limnSpaceUnknown',
           'pullEnergyTypeCubicWell', 'gageQueryItemOn', 'nrrdILoad',
           'tenTensorCheck', 'pullPropPosition', 'gageVecVector',
           'tenExpSingle_d', 'airMopPrint', 'tenExpSingle_f', 'Nrrd',
           'tenInterpDistanceTwo_d', 'ell_4m_to_aa_f',
           'gageOptimSigParm', 'ell_4m_to_aa_d', 'tenPowSingle_f',
           'alanParmBeta', 'airFP_Last', 'limnPolyDataColorSet',
           'tenGageFAFlowlineCurv', 'echoRTRenderCheck',
           'nrrdKernelCatmullRomSupportDebug', 'nrrdAxisInfoMin',
           'hestParseOrDie', 'echoJittableMotionA',
           'pullInitMethodGivenPos', 'echoJittableMotionB',
           'echoInstanceSet', 'gageStructureTensor',
           'nrrdOrientationReduce', 'tenGageRGradMag',
           'alanTextureTypeUnknown', 'pullCountAdding',
           'tenDwiGage2TensorQSegAndError', 'ell_aa_to_4m_d',
           'tenGageB', 'nrrdPad_nva', 'nrrdKeyValueCopy',
           'pullStatusStuck', 'baneRangeNew', 'tenGageS', 'tenGageR',
           'tenGageQ', 'tenGageTheta', 'miteShadeSpec', 'nrrdSave',
           'gageSclGaussCurv', 'tenEMBimodal', 'limnObjectFaceAdd',
           'nrrdUnaryOpFloor', 'gageErrLast', 'tenAniso',
           'pushTask_t', 'baneClipPeakRatio', 'nrrdBasicInfoUnknown',
           'tenEigenvaluePower', 'tenSizeNormalize',
           'nrrdKernelBSpline3D', 'baneRangeNegative', 'baneIncStdv',
           'tijk_sym_fun', 'gageParmStackNormalizeRecon',
           'tenFiberStopDoubleSet', 'gageItemPackPartHessian',
           'nrrdKernelBoxSupportDebug', 'nrrdIInsert',
           'airInsane_pInfExists', 'baneOpacInfo',
           'limnObjectWriteOFF', 'alanParmRandRange',
           'tenDwiFiberType1Evec0', 'airLogBesselI0',
           'gageDefGradMagCurvMin', 'pushEnergySpecParse',
           'nrrdKernelBSpline6D', 'airMop',
           'limnPolyDataSuperquadric', 'nrrdTernaryOpUnknown',
           'nrrdHistoJoint', 'tend_anvolCmd', 'airInsane_QNaNHiBit',
           'nrrdEnvVarStateMeasureType', 'baneDefRenormalize',
           'airArrayStructCB', 'limnSpaceWorld', 'pullInfoHeight',
           'unrrdu_gammaCmd', 'nrrdBoundaryLast',
           'miteStageOpMultiply', 'limnPolyDataNeighborArrayComp',
           'airVanDerCorput', 'tenGageKind', 'tijk_add_d', 'gageVec',
           'nrrdEnvVarDefaultWriteBareTextOld',
           'gageStackBlurParmBoundarySet', 'nrrdTypeLast',
           'pullTraceStopLength', 'baneHack', 'gageQuerySet',
           'tenDwiFiberType12BlendEvec0', 'echoMatterGlassIndex',
           'gageStackBlurManage', 'tenSimulate', 'pullPropLast',
           'nrrdEnvVarStateDisableContent', 'gageVecDivGradient',
           'nrrdKind3DSymMatrix', 'nrrdBasicInfoSpaceDimension',
           'tijk_eval_esh_basis_d', 'nrrdAxisInfoIdx', 'alanInit',
           'gageStackBlur', 'nrrdEncodingBzip2',
           'pullEnergyTypeButterworthParabola', 'nrrd1DIrregMapCheck',
           'echoRTParmNix', 'echoRay', 'elfMaximaContextNew',
           'echoMatterGlassSet', 'unrrdu_cropCmd',
           'tenGageTensorRThetaPhiLinear', 'meetPullVolAddMulti',
           'pullPropNeighCovarTrace', 'gageDefOrientationFromSpacing',
           'limnCameraAspectSet', 'tenInvariantGradientsR_d',
           'meetPullVolLoadMulti', 'nrrdRangeNew', 'baneDefVerbose',
           'ell_q_mul_d', 'ell_q_mul_f', 'tenGageTraceHessianEval',
           'nrrdEncodingRaw', 'airInsane_NaNExists', 'pullEnergy',
           'limnHestPolyDataOFF', 'nrrdQuantize',
           'nrrdSpacingStatusDirection', 'tijk_refine_rank1_parm_t',
           'tenEstimateSigmaSet', 'tijk_efs_to_2d_sym_f',
           'pullBinProcess', 'pullProcessModeAdding', 'tend_simCmd',
           'limnEdgeTypeLone', 'unrrdu_heqCmd', 'airStrntok',
           'nrrdTernaryOpInOpen', 'nrrdPGM', 'airMopOnOkay',
           'baneFindInclusion', 'gageDefK3Pack', 'echoTypeAABBox',
           'nrrdZlibStrategyUnknown', 'tenGageFADiffusionAlign',
           'unrrdu_diffCmd', 'airRician', 'coilKindType7Tensor',
           'echoMatterLightSet', 'echoPresent',
           'limnPrimitiveTriangles', 'nrrdTernaryOpClamp',
           'echoObjectHasMatter', 'ell_3m_to_aa_f', 'ell_3m_to_aa_d',
           'airIsNaN', 'alanParmTextureType', 'tend_epiregCmd',
           'gageVecCurlGradient', 'airMopMem', 'biffMsgStrGet',
           'gageDefRenormalize', 'coilKind', 'tenGageCp2',
           'pullInfoSpecSprint', 'tenGageCp1', 'limnObjectNew',
           'nrrdBasicInfoLast', 'pushPresent', 'tenAniso_Clpmin1',
           'tenAniso_Clpmin2', 'echoCube', 'pullTrace',
           'echoMatterMetalR0', 'limnEdge_t', 'alanStopLast',
           'limnEdgeTypeFrontFacet', 'tenFiberIntgUnknown',
           'limnObjectDepthSortFaces', 'tenGageOmegaNormal',
           'airStdin', 'gageTeeOfTau',
           'tenGageTraceDiffusionFraction', 'airThreadCondBroadcast',
           'nrrdBinaryOp', 'tenDwiGage2TensorPeledAndError',
           'mossMatShearSet', 'pullInfo', 'nrrdMeasureMin',
           'nrrdNuke', 'nrrdTypeIsIntegral', 'airNoDio_disable',
           'limnSplineTypeHermite', '_airThreadCond',
           'tenEvecRGBSingle_f', 'tenDwiGagePvlData',
           'pushContextNix', 'limnSpaceScreen', 'pushRebin',
           'airThreadBarrierWait', 'gageItemSpecNew',
           'nrrdClampConvert', 'nrrdKernelCos4SupportDebugDD',
           'alanStop', 'tenExpand', 'gageItemPackSclValue',
           'tijk_refine_rankk_parm', 'ell_3m_mul_f',
           'tenTripleTypeWheelParm', 'seekVertexStrength',
           'hooverRayBegin_t', 'tenSlice', 'airIndexULL',
           'airNormalRand_r', 'baneBiffKey', 'miteValView',
           'nrrdReshape_va', 'tijk_sym_fun_t', 'nrrdKindComplex',
           'echoChannelAverage', 'limnQN13octa', 'baneMeasrTotalCurv',
           'ell_3m_inv_f', 'limnQN14octa', 'tenGageCp1GradVec',
           'alanContextNew', 'echoTriangleSet', 'gageKernel00',
           'pullCountTestStep', 'nrrdEmpty', 'limnSplineTypeTimeWarp',
           'hestMinNumArgs', 'limnObjectVertexNormals',
           'tenTripleTypeEigenvalue', 'nrrdKind4Vector', 'airPresent',
           'nrrdArithIterAffine', 'tenGageFARidgeSurfaceAlignment',
           'nrrdKernelBSpline5ApproxInverse', 'pushPointNix',
           'tenAnisoEval_f', 'tijk_2o2d_sym', 'tenAnisoEval_d',
           'tenDWMRIBValueKey', 'tenGageCa1HessianEvec0',
           'tenGageCa1HessianEvec1', 'tenGageCa1HessianEvec2',
           'nrrdFFTWPlanRigorPatient', 'hooverErrInit', 'tend_avgCmd',
           'nrrdUnquantize', 'baneMeasrCopy', 'pullEnergyType',
           'tenGageOmegaHessianEval', 'nrrdStateUnknownContent',
           'baneIncCopy', 'alanParmMinAverageChange',
           'echoTypeTriangle', 'airFclose', 'pullPropEnergy',
           'tijk_eval_esh_f', 'nrrdEnvVarDefaultWriteBareText',
           'limnPolyDataSpiralSphere', 'tenGageModeHessianEvec2',
           'tenGageModeHessianEvec1', 'tenGageModeHessianEvec0',
           'airFP_POS_INF', 'echoBoundsGet',
           'limnObjectPolarSuperquadFancyAdd', 'pullBinsPointAdd',
           'baneClipCopy', 'pullSysParmAlpha', 'gageShapeNew',
           'pullInterTypeJustR', 'pullIterParmConstraintMax',
           'nrrdKind3DMatrix', 'mossSamplerUpdate',
           'hestGreedySingleString', 'meetAirEnumAll',
           'tenFiberStopAniso', 'gageShapeWtoI',
           'pullBinsPointMaybeAdd', 'nrrdHestKernelSpec',
           'unrrduScaleNothing', 'nrrdMeasureLinf', 'limnPart',
           'gagePerVolume', 'tenGageCl1GradVec', 'seekUpdate',
           'tenGradientJitter', 'banePresent', 'baneRangeCopy',
           'tenFiberStop', 'alanParmAlpha', 'gageParmGradMagCurvMin',
           'miteDefOpacNear1', 'nrrdEncodingTypeUnknown',
           'tenTripleCalc', 'biffGetDone', 'alanTextureTypeGrayScott',
           'ell_debug', 'tenGageSHessian',
           'limnSplineTypeCubicBezier', 'nrrdUnaryOpRand',
           'airArrayLenIncr', 'tenEstimate1TensorSingle_d',
           'tenEstimate1TensorSingle_f', 'alanStopNonExist',
           'pullTraceMultiNew', 'pullProcessModeNeighLearn',
           'pullCountLast', 'ell_4mv_mul_d',
           'tenDefFiberAnisoStopType', 'nrrdSlice',
           'tenFiberMultiNew', 'nrrdKernelBlackmanDD',
           'airNoDio_test', 'tenGageOmegaGradVecDotEvec0',
           'gageStackBlurParmKernelSet', 'limnDefCameraRightHanded',
           'nrrdKernelAQuarticD', 'nrrdDefaultResampleNonExistent',
           'nrrdBoundaryWeight', 'tenGlyphParmCheck',
           'pullCountDescent', 'baneMeasrFlowlineCurv',
           'mossLinearTransform', 'ell_4m_inv_d',
           'nrrdSpaceVecScaleAdd2', 'nrrdFClamp',
           'coilMethodTypeFinish', 'nrrdBlind8BitRangeLast',
           'nrrdField_centers', 'pullPropLen', 'airLog2',
           'airThreadBarrier', 'ell_q_inv_d', 'pullSysParmUnknown',
           'tenGageSGradVec', 'airFP_NEG_DENORM',
           'nrrdAxisInfoGet_va', 'pullInterTypeUnknown',
           'limnEnvMapCB', 'tenGageOmegaGradVec', 'airFP_NEG_NORM',
           'airToUpper', 'tenEigenvalueClamp', 'nrrdApply1DIrregMap',
           'airFloatSNaN', 'nrrdKernelC3QuinticDD', 'echoTypeTriMesh',
           'nrrdStateGrayscaleImage3D', 'hooverRenderEnd_t',
           'tenFiberMulti', 'ell_Nm_tran', 'tijk_esh_sp_d',
           'nrrdUnaryOpLog10', 'airStrcpy', 'tenFiberMultiPolyData',
           'airHeapUpdate', 'nrrdFormatTypePNG',
           'gageParmKernelIntegralNearZero', 'meetPullVolLeechable',
           'nrrdFormatTypePNM', 'airErf', 'baneGkms_pvgCmd',
           'pullPresent', 'miteValNdotV', 'mossHestTransform',
           'ell_3m_det_f', 'ell_3m_det_d', 'ell_q_4v_rotate_d',
           'alanParmUnknown', 'gagePerVolumeIsAttached',
           'pullEnergySpecParse', 'nrrdField_measurement_frame',
           'limnCamera', 'nrrdPPM', 'echoTypeList', 'pullInfoGet',
           'nrrdMeasureLast', 'nrrdUnaryOpLog1p', 'airInsane_endian',
           'tenEMBimodalParmNew', 'pullInfoInsideGradient',
           'pullStatusUnknown', 'tenFiberParmLast',
           'nrrdBasicInfoInit', 'nrrdIterSetNrrd', 'pullStart',
           'tenModelSimulate', 'tenGageFAHessianEvec2',
           'tenGageFAHessianEvec1', 'tenGageFAHessianEvec0',
           'ell_4m_post_mul_d', 'echoIntxMaterialColor',
           'pullEnergySpring', 'gageSclHessEval',
           'airThreadNoopWarning', 'airMopSingleDone', 'limnDevicePS',
           'nrrdBasicInfoSpaceUnits', 'nrrdKernelCatmullRomDD',
           'tend_mfitCmd', 'gageStackProbe', 'nrrdBinaryOpAtan2',
           'unrrdu_cmedianCmd', 'tenAniso_Tr', 'biffMove',
           'hooverRenderBegin_t', 'nrrdHestNrrd', 'echoSceneNew',
           'pullCallbackSet', 'nrrdEnvVarStateAlwaysSetContent',
           'tijk_approx_heur_parm_t', 'pushEnergyCotan',
           'tijk_eval_efs_d', 'limnWindowNew',
           'pullConstraintFailProjGradZeroB',
           'pullConstraintFailProjGradZeroA', 'tenAniso_Th',
           'nrrdTypeDouble', 'ell_3m_rotate_between_d',
           'gageTauOfTee', 'nrrdTypeBlock',
           'pullEnergyTypeHepticWell', 'pullCountNixing',
           'nrrdSpatialAxesGet', 'seekItemGradientSet',
           'tenGageTensor', 'pushContext', 'nrrdSpaceScannerXYZ',
           'airBesselInExpScaled', 'coilMethodTypeTesting',
           'nrrdEncodingGzip', 'airTeemVersion', 'meetPullInfo',
           'airHeapMerge', 'airThreadMutex', 'unrrduUsage',
           'nrrdDistanceL2Signed', 'tenGageTensorQuatGeoLoxR',
           'tenGageInvarKGrads', 'tenSizeScale',
           'tenGageTensorQuatGeoLoxK', 'biffAddf',
           'gageStackPerVolumeAttach', 'biffGetStrlen',
           'gageDefCheckIntegrals', 'coilBiffKey',
           'nrrdBinaryOpCompare', 'tend_normCmd', 'airNoDio_okay',
           'airTypeUnknown', 'tenAnisoHistogram', 'tenGageFA',
           'nrrdSpaceVecNorm', 'alanStopNot', 'tenDwiGageJustDWI',
           'tenDwiGageTensorLLSError', 'tenDwiGageTensorAllDWIError',
           'tenDwiGage', 'tijk_2d_sym_to_efs_f', 'nrrdBinaryOpFmod',
           'nrrdKind3Vector', 'airStrtrans', 'meetPullVolParse',
           'nrrdTypeChar', 'nrrdCCRevalue',
           'ell_3v_barycentric_spherical_d', 'echoObject',
           'nrrdFFTWWisdomWrite', 'pullInitHaltonSet',
           'pullIterParmSnap', 'nrrdSpace3DLeftHandedTime',
           'ell_biff_key', 'gageSclNormal', 'nrrdDefaultResampleType',
           'nrrdDeringContextNew', 'unrrdu_axdeleteCmd',
           'nrrdBasicInfoCopy', 'baneInc_t',
           'tenDwiGageTensorNLSError', 'dyeConverter', 'nrrdCrop',
           'tenGageFiberDispersion', 'nrrdUnaryOpAbs',
           'limnSplineUpdate', 'tenGageCovariance', 'nrrdCompare',
           'echoCylinderSet', 'alan2DSizeSet', 'unrrduScaleSubtract',
           'hestMultiFlagSep', 'limnObjectPSDraw', 'baneMeasr',
           'airInsane_FISize', 'pullTraceStopLast', 'hestParm',
           'nrrdKeyValueIndex', 'limnPolyDataCompress', 'seekType',
           'nrrdSpacingStatusUnknown', 'limnSplineTypeSpec',
           'airEnumStr', 'pushEnergyTypeGauss', 'airDioTest',
           'pullEnergyTypeQuartic', 'miteValVrefN',
           'pushEnergyTypeZero', 'unrrduPresent', 'tenFiberTrace',
           'limnEdgeTypeFrontCrease', 'miteSample',
           'nrrdBinaryOpNormalRandScaleAdd', 'tenFiberIntgMidpoint',
           'meetPullInfoAddMulti', 'limnWindow', 'tend_bfitCmd',
           'nrrdField_old_min', 'unrrduScaleExact',
           'pullConstraintFailIterMaxed', 'airThreadBarrierNix',
           'ell_q_avg4_d', 'coilKindTypeUnknown', 'nrrdTypeFloat',
           'airParseStrUI', 'coilContextNew', 'nrrdKernelBSpline1D',
           'airEqvMap', 'seekTypeLast', 'gageKind_t',
           'gageDefKernelIntegralNearZero', 'nrrdEncodingTypeHex',
           'tenGageEvec0', 'tenGageEvec1', 'tenGageEvec2',
           'unrrdu_tileCmd', 'pullInterTypeSeparable',
           'nrrdKind2DMaskedSymMatrix',
           'pullSysParmFracNeighNixedMax', 'baneDefPercHistBins',
           'limnPolyDataPrimitiveSort', 'tenGageTraceHessian',
           'nrrdField_space_directions', 'baneRangeAnywhere',
           'nrrdHasNonExist', 'tenTripleConvertSingle_f',
           'tenGageOmegaGradMag', 'airThreadMutexUnlock',
           'pullSysParmTheta', 'nrrdMeasureHistoProduct',
           'alanContext', 'tenTripleConvertSingle_d', 'nrrdUnaryOpIf',
           'tenGageUnknown', 'tijk_approx_heur_parm_new',
           'nrrdBasicInfoBlocksize', 'baneClipNew',
           'unrrdu_unquantizeCmd', 'miteValUnknown', 'nrrdFormatNRRD',
           'pullEnergyTypeUnknown', 'elfPresent', 'tenGageNormNormal',
           'nrrdKindRGBColor', 'gageDefStackNormalizeRecon',
           'airSingleSscanf', 'airThreadCondWait',
           'pullFlagRestrictiveAddToBins', 'pullProcessModeDescent',
           'limnSplineTypeSpecNix', 'gageOptimSigParmNew',
           'gageVecMGEval', 'tenFiberIntgSet', 'tenModel1Unit2D',
           'pullBin', 'nrrdField_unknown', 'nrrdCCNum',
           'pullInitUnequalShapesAllowSet', 'pullPropStepEnergy',
           'nrrdBinaryOpMax',
           'pullIterParmEnergyIncreasePermitHalfLife', 'tenGageOmega',
           'tijk_set_axis_efs', 'pullIterParmAddDescent',
           'tijk_set_axis_tensor', 'pullSysParmEnergyDecreaseMin',
           'tend_logCmd', 'pullSysParmLast', 'mossSamplerFill',
           'nrrdBinaryOpSubtract', 'limnObjectNix',
           'tenGageDetHessian', 'tenGageBGradVec', 'limnQN15octa',
           'nrrdTernaryOpRician', 'pullEnergyCubic', 'limnSplineMaxT',
           'pullPropNeighCovar7Ten', 'gageErrStackIntegral',
           'nrrdRangeNewSet', 'miteShadeSpecQueryAdd',
           'nrrdEnvVarStateKindNoop', 'tenGageInvarRGradMags',
           'nrrdSpaceVecSetNaN', 'limnCameraInit',
           'pullConstraintFailUnknown', 'meetPullInfoParse',
           'tend_sliceCmd', 'tenFiberTypePureLine', 'nrrdKindScalar',
           'tenFiberStopNumSteps', 'airTypeInt',
           'pushBinAllNeighborSet', 'tenGlyphTypeSphere',
           'tijk_refine_rankk_2d_d', 'unrrdu_cksumCmd',
           'baneGkmsHestGthresh', 'tijk_8o3d_sym', 'baneClipLast',
           'gagePointReset', 'nrrdKernelC5SepticDD', 'hestOpt',
           'nrrdMeasureLineError', 'alanParmWrapAround',
           'nrrdField_labels', 'elfBallStickOptimize_f',
           'nrrdKernelBCCubicDD', 'limnOptsPS',
           'nrrdSpacingStatusLast', 'tenFiberStopBounds',
           'airSrandMT_r', 'pullProp', 'limnSplineInfo2Vector',
           'nrrdKernelBSpline7ApproxInverse', 'tenDwiGageAll',
           'nrrdFFTWWisdomRead', 'nrrdKernelSpecNew',
           'baneGkms_txfCmd', 'pullFlagEnergyFromStrength',
           'nrrdRangeSet', 'limnEdgeTypeContour', 'ell_4m_inv_f',
           'nrrdField_space_origin', 'dyeXYZtoLAB',
           'nrrdFormatTypeNRRD', 'echoLightPosition', 'tenAnisoScale',
           'echoScene_t', 'nrrdResampleClampSet', 'mossMatPrint',
           'gageVecGradient2', 'gageVecGradient0', 'gageVecGradient1',
           'limnDeviceGL', 'pullTraceNix', 'tenInterpTypeLast',
           'tenGageFAHessianEval2', 'gageItemPackPartGradMag',
           'tenGageFAHessianEval0', 'tenGageFAHessianEval1',
           'nrrdSpaceLast', 'limnPolyDataEdgeHalve',
           'nrrdKernelC5SepticDDD', 'nrrdResampleNonExistentSet',
           'pushRun', 'airNoDio_ptr', 'airEndian',
           'nrrdIoStateBareText', 'ell_Nm_inv',
           'tijk_init_rank1_3d_f', 'hestElideSingleEnumType',
           'tijk_init_rank1_3d_d', 'ell_q_log_d',
           'unrrduHestEncodingCB', 'ell_q_log_f', 'airInsaneErr',
           'tenGageCovarianceRGRT', 'mossFlagImage', 'pullVolumeNew',
           'coilMethodTypeModifiedCurvatureRings',
           'meetNrrdKernelAll', 'gageKernel21', 'gageKernel20',
           'gageKernel22', 'miteDefRefStep', 'airArrayNuke',
           'echoMatterPhong', 'tenGageFARidgeLineAlignment',
           'nrrdCropAuto', 'tenGageSGradMag', 'tenGageEvalGrads',
           'limnLightNew', 'miteRangeEmissivity',
           'pullIterParmUnknown', 'nrrdAxisInfoPosRange',
           'gageItemEntry', 'pullSource', 'echoJitter',
           'seekItemStrengthSet', 'nrrdFormatPNM', 'nrrdReshape_nva',
           'pullBiffKey', 'tenGlyphTypeUnknown', 'pushEnergyUnknown',
           'pushEnergyTypeSpring', 'gageVecMGFrob',
           'tenGageModeHessianEvec', 'nrrdMeasureHistoMin',
           'nrrdUnaryOpRoundUp', 'tenFiberTypeLast', 'nrrdILookup',
           'gageParmCheckIntegrals', 'tend_evqCmd', 'nrrdUnaryOpCos',
           'tenDWMRIKeyValueFromExperSpecSet', 'pullEnergyTypeGauss',
           'tijk_class_unknown', 'ell_6m_mul_d', 'dyeRGBtoHSL',
           'limnPolyDataPrimitiveVertexNumber', 'nrrdField_content',
           'nrrdSpaceVecSetZero', 'pullOutputGetFilter',
           'gageKernelUnknown', 'nrrdKindSpace', 'nrrdKindRGBAColor',
           'gageDefStackUse', 'airHeapInsert', 'pullCountIteration',
           'hestUsage', 'nrrdUnaryOpZero', 'dyeRGBtoHSV',
           'elfGlyphHOME', 'hooverPresent', 'limnEnvMapCheck',
           'nrrdResampleOverrideCenterSet', 'airEnumValCheck',
           'pullFlagConstraintBeforeSeedThresh', 'airThread',
           'tenGageMode', 'nrrdKernelBSpline6DDD',
           'tenGageCp1HessianEvec', 'gageUpdate',
           'nrrdSpacingCalculate', 'miteDefRenorm', 'nrrdKernelHannD',
           'limnObjectPolarSuperquadAdd', 'seekTypeSet',
           'limnPolyData', 'airThreadCondNew', 'nrrdStateGetenv',
           'tenInterpType', 'tenGageCp1Normal', 'airEndianUnknown',
           'pullVolume', 'echoIntxColor', 'nrrdMeasureMean',
           'miteValWdotD', 'pullInitPointPerVoxelSet', 'tenGlyphGen',
           'miteShadeSpecParse', 'airTypeBool', 'unrrdu_deringCmd',
           'tenDwiGage2TensorQSeg', 'nrrdStateKeyValuePairsPropagate',
           'nrrdKernelCompare', 'gageShapeEqual', 'pullFlagLast',
           'echoJittableLens', 'tijk_sub_f', 'pullGammaLearn',
           'tenInterpParmNix', 'limnObjectPolarSphereAdd',
           'tenGageFiberCurving', 'nrrdKernelC5SepticD',
           'pullSourceGage', 'nrrdDeringVerticalSeamSet', 'pushPoint',
           'nrrdStateMeasureHistoType', 'echoJitterNone',
           'limnSplineInfoQuaternion', 'tenGageTraceGradMag',
           'NrrdKernel', 'nrrdField_encoding', 'nrrdKernelGaussian',
           'biffMovef', 'echoScene', 'limnSplineTypeBC',
           'nrrdIoStateZlibStrategy', 'nrrdField_thicknesses',
           'baneMeasrGradMag', 'echoTypeLast',
           'gageStackPerVolumeNew', 'nrrdArithIterBinaryOpSelect',
           'nrrdEncodingArray', 'gageKernelSet', 'nrrdKindList',
           'limnCamera_t', 'echoSphereSet', 'echoGlobalState',
           'pullEnergyGauss', 'tenModel', 'baneIncProcess',
           'gageItemSpecNix', 'echoTypeSplit',
           'nrrdArithIterTernaryOp', 'tenDwiGageFA',
           'tenEstimateGradientsSet', 'nrrdHasNonExistLast',
           'miteDefOpacMatters', 'nrrdCommentAdd', 'limnSplineType',
           'pullIterParmStuckMax', 'nrrdCCSize', 'baneClipAbsolute',
           'echoBiffKey', 'pushContextNew', 'tenGageDetGradMag',
           'tenDwiGageKindSet', 'tenGageOmegaHessianEvec0',
           'tenGageOmegaHessianEvec1', 'nrrdBoundary',
           'nrrdAxesPermute', 'tenFiberParmWPunct',
           'limnCameraPathTrackBoth', 'echoMatterMetalSet',
           'ell_6ms_eigensolve_d', 'limnSplineTypeLinear',
           'tijk_esh_deconvolve_f', 'gageParmCurvNormalSide',
           'gageSclHessMode', 'tenGageFAGradMag', 'pullPointNumber',
           'pullContextNix', 'limnSplineInfoNormal',
           'tenGageFAValleySurfaceStrength', 'airFopen',
           'airSprintVecSize_t', 'echoEnvmapLookup',
           'unrrdu_quantizeCmd', 'tenAniso_Skew',
           'nrrdMeasureHistoMean', 'limnQN16border1',
           'nrrdCenterLast', 'tijk_refine_rank1_2d_d',
           'tijk_refine_rank1_2d_f', 'nrrdAxisInfoUnits',
           'miteRangeKa', 'tenFiberSingleDone', 'miteRangeKd',
           'nrrdMeasureMedian', 'nrrdMinMaxExactFind',
           'pullEnergyTypeCotan', 'ell_q_div_f', 'ell_q_div_d',
           'nrrdPad_va', 'nrrdAxisInfoSize', 'miteRangeKs',
           'baneMeasr_t', 'pullCondLast', 'nrrdStateAlwaysSetContent',
           'tenGageFAGaussCurv', 'NrrdFormat', 'nrrdKernelCheap',
           'pullFlagUseBetaForGammaLearn', 'limnSplineTypeLast',
           'nrrdArithTernaryOp', 'pushEnergy', 'airInsane_dio',
           'baneInc', 'nrrdTernaryOpMax', 'tenGageLast',
           'gageScl3PFilter4', 'tenGlyphParmNew', 'baneMeasrAnswer',
           'dyeColorNix', 'tenFiberTypeZhukov', 'pullInitGivenPosSet',
           'echoListSplit3', 'tenDwiGageKindNew', 'gageQueryPrint',
           'tenEstimateVerboseSet', 'airSgn', 'meetAirEnumAllPrint',
           'gageCtxFlagUnknown', 'echoJittableUnknown', 'pullPoint',
           'pullPropStuck', 'nrrdKernelBCCubicD',
           'tenGageCl1HessianEvec', 'nrrdBasicInfoDimension',
           'coilKindArray', 'alanParmHomogAniso',
           'limnPolyDataCCFind', 'airTeemReleaseDate',
           'limnObjectFaceNormals', 'gageStackBlurParmVerboseSet',
           'nrrdKernelTMF_maxC', 'nrrdIoStateDetachedHeader',
           'alanStopDiverged', 'tend_expandCmd', 'tenGlyphParmNix',
           'tenEstimate2MethodQSegLLS', 'unrrduHestMaybeTypeCB',
           'airOneLinify', 'tenEvecRGBSingle_d', 'dyeColorInit',
           'gageItemPackPartGradVec', 'pullProcessModeUnknown',
           'tenDwiGageKindCheck', 'airMopError', 'coilVolumeCheck',
           'echoTriangle', 'limnPolyDataRasterize',
           'hestElideMultipleEmptyStringDefault', 'miteValRi',
           'echoPos_t', 'hestVarParamStopFlag', 'seekTypeValleyLine',
           'pullSysParmStepInitial', 'nrrdUIStore', 'airCRC32',
           'tenFiberAnisoSpeedReset', 'coilMethodTypePeronaMalik',
           'miteRangeBlue', 'limnPolyDataInfoRGBA', 'miteValRw',
           'tenGradientGenerate', 'coilPresent', 'tend_stenCmd',
           'limnEdgeTypeUnknown', 'airSprintSize_t',
           'seekDescendToDeg', 'nrrdBasicInfoOldMax',
           'unrrdu_shuffleCmd', 'echoJittableLight',
           'tenInterpMulti3D', 'seekIsovalueSet', 'airMopDebug',
           'nrrdEncodingType', 'nrrdCRC32', 'baneGkmsCmdList',
           'pullCondUnknown', 'limnQN11octa', 'pullEnergyTypeBspln',
           'tenDwiGageTensorMLE', 'pullEnergyTypeBetterCubicWell',
           'ell_q_to_aa_d', 'gagePoint_t', 'ell_q_to_aa_f',
           'unrrdu_padCmd', 'pushEnergyTypeCoulomb', 'airMopOnError',
           'nrrdDefaultKernelParm0', 'tend_pointCmd',
           'echoTypeUnknown', 'airFPClass_f',
           'unrrduScaleAspectRatio', 'tenDwiGageMeanDWIValue',
           'tijk_set_axis_esh', 'nrrdGetenvEnum', 'baneRangeLast',
           'nrrdUnaryOpSqrt', 'airFP_POS_ZERO', 'nrrdIoStateGet',
           'tenModelFromAxisLearnPossible', 'tenGageHessian',
           'nrrdUnaryOpOne', 'gageCtxFlagRadius',
           'tenInterpTypeLogLinear', 'ell_3m_mul_d',
           'mossFlagUnknown', 'coilContext_t', 'gageKindAnswerOffset',
           'nrrdNew', 'nrrdEncodingTypeBzip2', 'airMopSingleError',
           'nrrdField_sample_units', 'hooverErrRayEnd',
           'tend_anplotCmd', 'pullInfoTensorInverse',
           'pullPropNeighTanCovar', 'nrrdAxesSplit', 'nrrdSameSize',
           'nrrdTernaryOpMaxSmooth', 'tenEstimateContext',
           'unrrdu_swapCmd', 'seekItemEigensystemSet', 'airDioMalloc',
           'limnPrimitiveLineStrip', 'airThreadJoin',
           'pullEnergyTypeCubic', 'pullSysParmConstraintStepMin',
           'tenDefFiberWPunct', 'nrrdTypeUShort',
           'hooverContextCheck', 'tenFiberStopSet',
           'echoMatterPhongKs', 'limnSpaceDevice', 'nrrdUnaryOpAsin',
           'biffMsgAdd', 'tenGageInvarRGrads', 'echoMatterPhongKd',
           'nrrdUnblock', 'pushEnergySpec', 'echoMatterPhongKa',
           'tenFiberStopRadius', 'limnPrimitiveUnknown',
           'airSinglePrintf', 'airNormalRand', 'nrrdIterNew',
           'pullIterParmPopCntlPeriod', 'airNoDio_std',
           'tenModel2Unit2D', 'nrrdFFTWPlanRigorUnknown', 'airFloat',
           'tenFiberStopConfidence', 'nrrdKind3Normal',
           'tenGageModeHessianEval2', 'tenGageModeHessianEval0',
           'tenGageModeHessianEval1', 'airThreadNix',
           'gageSclTotalCurv', 'gageCtxFlagK3Pack', 'nrrdMeasureSum',
           'airGaussian', 'elfMaximaContextNix',
           'nrrdResampleBoundarySet', 'tenEMatrixCalc',
           'tenRotationTangents_d', 'nrrdBasicInfoType',
           'coilContextNix', 'tenEigenvalueAdd', 'tenModelBall1Stick',
           'hooverErrLast', 'nrrdKernelBSpline4',
           'nrrdKernelC4HexicDD', 'nrrdTile2D', 'airIndex',
           'tenFiberStopStub', 'limnCameraUpdate',
           'nrrdKernelBSpline5DDD', 'dyeSpaceLast', 'airDrandMT_r',
           'airMode3_d', 'miteRangeAlpha', 'limnPolyDataSave',
           'nrrdStateVerboseIO', 'nrrdDefaultResamplePadValue',
           'gageOptimSigCalculate', 'nrrd1DIrregAclGenerate',
           'baneRange', 'tenGageModeNormal', 'tenTripleCalcSingle_d',
           'ell_3v_perp_d', 'ell_3v_perp_f', 'pullIterParmMin',
           'nrrdKind2DMatrix', 'airRandMTStateGlobal', 'tijk_sub_d',
           'airLLong', 'tenGageConfidence', 'seekItemScalarSet',
           'hooverStubThreadEnd', 'nrrdArrayCompare', 'tenGageEvec',
           'tenDwiGageTensorLLS', 'limnSplineParse',
           'baneClipPercentile', 'tenEpiRegister4D',
           'seekItemNormalSet', 'limnSpaceLast', 'miteRenderBegin',
           'airMyEndian', 'pullPropNeighCovar', 'miteRangeRed',
           'gageVecVector2', 'gageVecVector1', 'nrrdBinaryOpMin',
           'tenGageThetaNormal', 'nrrdKernelC4HexicDDD',
           'nrrdSimplePad_nva', 'pullEnergySpecNix',
           'pullInitRandomSet', 'airPrimeList', 'tijk_negate_d',
           'gageSclHessEvec', 'echoThreadStateNix', 'airThreadStart',
           'tenFiberSingle', 'ell_3m_to_q_d', 'ell_3m_to_q_f',
           'airFP_POS_DENORM', 'nrrdAxesInsert',
           'airThreadBarrierNew', 'gageSclHessian', 'baneIncNew',
           'limnSpline', 'meetPullInfoNix', 'limnDeviceLast',
           'tijk_eval_esh_d', 'nrrdSample_va', 'limnPolyDataSmoothHC',
           'tenGageOmegaHessianContrTenEvec2',
           'nrrdAxisInfoSpaceDirection',
           'tenGageOmegaHessianContrTenEvec0', 'tenAniso_Det',
           'tijk_class_esh', 'nrrdResampleNonExistent',
           'tenGageFA2ndDD', 'elfSingleShellDWI', 'tenGageCl1GradMag',
           'tenFiberContextNew',  'gageParmK3Pack',
           'tenGageBNormal', 'tenEpiRegister3D', 'baneGkmsUsage',
           'echoSphere', 'nrrdApply1DSubstitution',
           'gageOptimSigParmNix', 'airEnumFmtDesc', 'seekPresent',
           'tenExperSpecFromKeyValueSet', 'echoJittablePixel',
           'tenGageTraceHessianEval2', 'ell_3m_eigensolve_d',
           'echoIntxLightColor', 'dyeSimpleConvert',
           'nrrdSpaceVecCopy', 'seekExtract', 'pullRngSeedSet',
           'nrrdField_last', 'nrrdHestIter', 'alanParmVerbose',
           'gageVecImaginaryPart', 'nrrdBasicInfoContent',
           'tenEstimateValueMinSet', 'tijk_3d_sym_to_esh_f',
           'limnPolyDataInfoTang', 'limnCameraPathTrackLast',
           'mossImageAlloc', 'tenGlyphTypeLast', 'airRandMTStateNew',
           'nrrdEnvVarDefaultCenterOld', 'tenExperSpecMaxBGet',
           'pullPointNumberFilter', 'tenEstimateUpdate',
           'pullInfoIsovalueHessian', 'baneRangeZeroCentered',
           'nrrdLineSkip', 'coilStart', 'coilMethodTypeHomogeneous',
           'nrrdField_kinds', 'tijk_refine_rankk_parm_t',
           'tenExpand2D', 'gageVecJacobian',
           'nrrdBlind8BitRangeState', 'tenEstimate1Method',
           'tijk_4o2d_unsym', 'pullTraceMultiSizeof',
           'tijk_axis_info', 'airFP_NEG_ZERO', 'pushEnergyAll',
           'echoMatter', 'pullFlagStartSkipsPoints',
           'tenFiberParmUnknown', 'airStderr', 'pushEnergyType',
           'unrrdu_histoCmd', 'pullSysParmSeparableGammaLearnRescale',
           'unrrduDefNumColumns', 'tenModel1Tensor2',
           'airEndianLittle', 'nrrdKind4Color', 'nrrdField_dimension',
           'seekTypeUnknown', 'seekContour3DTopoHackTriangle',
           'nrrdCommentClear', 'limnPolyDataSpiralTubeWrap',
           'tenGageRGradVec', 'nrrdStateBlind8BitRange',
           'airPtrPtrUnion', 'pullInfoSpecAdd',
           'tenDwiFiberTypeUnknown', 'tenGageOmegaHessianEvec',
           'seekContextNix', 'tijk_efs_to_2d_sym_d',
           'nrrdFFTWPlanRigorExhaustive', 'nrrdTernaryOpAdd',
           'nrrdKernelHermiteScaleSpaceFlag', 'ell_cubic_root_triple',
           'nrrdKernelSpecNix', 'nrrdDefaultResampleBoundary',
           'nrrdAxesDelete', 'airFloatPosInf', 'nrrdKernelSpecSet',
           'limnPolyDataInfoUnknown', 'echoJitterRandom',
           'gageItemSpecInit', 'tend_aboutCmd', 'gageErr',
           'gagePoint', 'pullTraceNew', 'tenGageFAHessianFrob',
           'alanParmMaxPixelChange', 'seekVerboseSet', 'airMopper',
           'nrrdApply1DLut', 'tenGradientMeasure', 'nrrdKindStub',
           'nrrdTypeSize', 'tenDwiGageTensorLLSLikelihood',
           'nrrdBlock', 'mossFlagKernel', 'airTypeString',
           'nrrdKernelC4HexicD', 'miteStageOpMin',
           'nrrdFormatTypeUnknown', 'dyeColorSprintf',
           'pullEnergySpecCopy', 'airFlippedSgnPow', 'baneMeasr2ndDD',
           'pullCountPoints', 'meetConstGageKindParse',
           'nrrdSpacingStatusNone', 'airTypeULongInt', 'gageShape_t',
           'alanParmSet', 'limnPolyDataCube',
           'limnDefCameraAtRelative', 'ell_cubic_root_three',
           'biffMsgNix', 'tenGageCa1GradMag', 'limnPolyDataNew',
           'nrrdDefaultResampleRound',
           'coilMethodTypeModifiedCurvature', 'echoRTParmNew',
           'gageSclHessEvec0', 'gageSclHessEvec1', 'gageSclHessEvec2',
           'tenGlyphBqdUvEval', 'hestElideSingleNonExistFloatDefault',
           'tenFiberStopLength', 'ell_4m_print_f',
           'limnPrimitiveTriangleFan', 'ell_4m_print_d',
           'tenDefFiberMaxNumSteps', 'limnLightDiffuseCB',
           'nrrdMeasureHistoSum', 'tenGageFARidgeSurfaceStrength',
           'nrrdField_axis_mins', 'pullEnergyCubicWell',
           'tenFiberUpdate', 'biffMsgStrAlloc', 'tenDwiGageADC',
           'pullProbe', 'nrrdOriginCalculate', 'tenInterpN_d',
           'mossMatInvert', 'seekTypeRidgeLine',
           'pullCountEnergyFromPoints', 'gageSclLast',
           'gageVecLength', 'pullSysParmRadiusSpace', 'pushContext_t',
           'limnSpace', 'nrrdIoStateFormatGet', 'gageStackWtoI',
           'nrrdKernelBSpline5DD', 'pushPointNew',
           'pushEnergySpecNew', 'pullContext_t', 'tenDwiGageKindData',
           'nrrdDeringRadiusScaleSet', 'nrrdTypePrintfStr',
           'nrrdField_sizes', 'nrrdAxisInfoGet_nva',
           'nrrdSimplePad_va', 'tenDwiGageTensorLikelihood',
           'tenGageThetaGradMag', 'pullInterEnergySet',
           'tijk_2d_sym_to_efs_d', 'nrrdKindLast', 'gageParm_t',
           'nrrdIoStateLast', 'tenEvecRGBParmNew', 'limnFace_t',
           'banePosCheck', 'nrrdField_axis_maxs', 'tenGageRotTanMags',
           'tenGageBHessian', 'airHeapRemove',
           'limnObjectPSDrawConcave', 'limnObjectFaceNumPreSet',
           'tend_ellipseCmd', 'tenGageCovarianceKGRT',
           'biffMsgStrlen', 'NrrdDeringContext',
           'mossMatLeftMultiply', 'tenGageOmega2ndDD',
           'nrrdDefaultResampleClamp',
           'pullEnergyButterworthParabola',
           'hestElideSingleEmptyStringDefault', 'tenExperSpec',
           'nrrdDeringVerboseSet', 'tenDwiGage2TensorQSegError',
           'hestElideMultipleNonExistFloatDefault', 'gageScl2ndDD',
           'limnPolyDataTransform_d', 'airTypeDouble',
           'pullEnergyHepticWell', 'tijk_esh_make_kernel_rank1_d',
           'tijk_esh_make_kernel_rank1_f', 'baneIncUnknown',
           'pullInfoUnknown', 'pullEnergyAll', 'unrrdu_permuteCmd',
           'limnDeviceUnknown', '_airThread', 'tenGageDelNormPhi3',
           'tenGageDelNormPhi2', 'tenGageDelNormPhi1',
           'airRandMTState', 'NrrdKernelSpec', 'pullCondEnergyBad',
           'tenGageTensorGradRotE', 'nrrdInvertPerm', 'nrrdTernaryOp',
           'tenGlyphBqdAbcUv', 'nrrdUnaryOpSgn',
           'ell_3v_area_spherical_d', 'pullSysParmBackStepScale',
           'dyeColorSet', 'baneIncAbsolute', 'nrrdKernelBSpline5',
           'nrrdKernelBSpline6', 'nrrdKernelBSpline7',
           'nrrdKernelBSpline1', 'nrrdKernelBSpline2',
           'gageSclGeomTensTen', 'nrrdMeasureHistoL2',
           'limnPolyDataAlloc', 'tenGradientBalance',
           'tijk_esh_make_kernel_delta_f',
           'tenDwiGageTensorWLSErrorLog', 'meetBiffKey',
           'nrrdHistoDraw', 'nrrdGetenvDouble', 'nrrdLoadMulti',
           'echoMatterTextureSet', 'limnQNtoV_f', 'limnQNtoV_d',
           'tenGageTraceHessianEval1', 'tenGageTraceHessianEval0',
           'echoSceneNix', 'nrrdZlibStrategyFiltered',
           'nrrdTernaryOpLTSmooth', 'elfColorGlyphMaxima',
           'nrrdKindHSVColor', 'elfBallStickParms',
           'nrrdFormatTypeVTK', 'pullCondOld',
           'alanTextureTypeTuring', 'pullCountForceFromPoints',
           'tend_evecrgbCmd', 'pushEnergyTypeCotan',
           'tenGageThetaGradVec', 'pullPtrPtrUnion',
           'tenGageOmegaHessianEvec2', 'echoIntx', 'gageCtxFlagShape',
           'gageVecDivergence', 'limnCameraPathTrackAt',
           'limnPolyDataCopyN', 'tijk_3d_sym_to_esh_d',
           'tenDWMRIModalityVal', 'pullTraceSet',
           'nrrdKernelAQuartic', 'nrrdSpace3DRightHanded',
           'nrrdUnaryOpSin', 'nrrdFFTWPlanRigorMeasure',
           'airHeapFind', 'ell_Nm_mul', 'nrrdKindXYZColor',
           'echoTypeCylinder', 'nrrdAxisInfoMinMaxSet',
           'gageVolumeCheck', 'gageVecDirHelDeriv', 'tijk_2o2d_unsym',
           'nrrdStringWrite', 'tenAniso_B', 'limnLightUpdate',
           'nrrdOriginStatusOkay', 'tenAniso_Q', 'tenAniso_R',
           'tenAniso_S', 'limnQN16simple', 'tijk_max_efs_order',
           'dyeColorGet', 'nrrdMeasureLine', 'tenGageFAMeanCurv',
           'ell_4m_mul_f', 'gagePresent', 'ell_4m_mul_d',
           'limnPresent', 'tenDwiGageTensorWLSError',
           'tenGageCp1Hessian', 'tenTripleTypeLast', 'nrrdSwapEndian',
           'gageErrBoundsStack', 'tijk_approx_heur_parm',
           'tenEstimate1TensorSimulateVolume', 'unrrdu_resampleCmd',
           'limnPolyDataInfoBitFlag', 'hooverStubRayBegin',
           'nrrdRangeAxesGet', 'tenGageConfDiffusionFraction',
           'nrrdKernelBCCubic', 'pullVolumeStackAdd',
           'tenGageCa1Normal', 'airDoneStr', 'pullSysParmSet',
           'nrrdResamplePadValueSet', 'nrrdDeringContextNix',
           'nrrdMeasureNormalizedL2', 'echoMatterMetalFuzzy',
           'mossMatScaleSet', 'miteRangeLast', 'unrrdu_sliceCmd',
           'gageKindVec', 'echoMatterMetalKd', 'tenGageCp1GradMag',
           'echoMatterMetalKa', 'unrrduScaleMultiply',
           'unrrdu_vidiconCmd', 'gageKindScl',
           'hestCleverPluralizeOtherY', 'nrrdCheapMedian',
           'nrrdKernelDiscreteGaussian', 'limnSplineInfoUnknown',
           'tenEstimateLinearSingle_d', 'tenEstimateLinearSingle_f',
           'tenModel1Vector2D', 'nrrdSaveMulti', 'baneDefIncLimit',
           'tenLogSingle_d', 'tend_satinCmd', 'nrrdIoStateZlibLevel',
           'gageQueryAdd', 'gageItemPackPartLast',
           'nrrdKernelBSpline3ApproxInverse', 'baneMeasrLast',
           'tenFiberSingleNix', 'gageVecLast', 'limnQNUnknown',
           'nrrdKernelAQuarticDD', 'airIsInf_f', 'tend_anscaleCmd',
           'airIsInf_d', 'tenGageTensorGradMagMag',
           'tenDWMRIGradKeyFmt', 'alan_t', 'tenGageCl1Hessian',
           'seekTypeIsocontour', 'airFP_Unknown',
           'nrrdBasicInfoKeyValuePairs', 'limnQN8checker',
           'gageParmUnknown', 'pushBin', 'miteShadeMethodUnknown',
           'nrrdBinaryOpPow', 'elfMaximaFind_d', 'biffMsgNoop',
           'baneIncPercentile', 'elfMaximaFind_f',
           'nrrdTernaryOpLast', 'tenGageTensorLogEuclidean',
           'pullVolumeLookup', 'unrrduScaleDivide', 'airParseStr',
           'unrrdu_fftCmd', 'pullInitMethodHalton',
           'tenInterpTypeGeoLoxR', 'nrrdKernelZero', 'pullRun',
           'tenGageFAGradVec', 'tenInterpTypeGeoLoxK',
           'nrrdDefaultCenter', 'limnPolyDataWriteVTK',
           'ell_3m_post_mul_f', 'ell_3m_post_mul_d', 'limnPart_t',
           'pullIterParmCallback', 'tenDWMRIKeyValueParse',
           'airIndexClampULL', 'baneIncRangeRatio',
           'baneStateHistEqBins', 'nrrdFLoad', 'echoGlobalStateNew',
           'tenEstimateThresholdSet', 'pullFlagPermuteOnRebin',
           'baneProbe', 'biffMsgLineLenMax', 'nrrdKernelParse',
           'tenSqrtSingle_d', 'limnSplineTypeSpecNew',
           'gageVecMGEvec', 'echoRectangle', 'unrrdu_ccadjCmd',
           'tijk_approx_rankk_3d_d', 'ell_q_to_4m_f',
           'nrrdStateDisallowIntegerNonExist', 'ell_q_to_4m_d',
           'biffMsgClear', 'ell_3m_2d_nullspace_d',
           'nrrdBinaryOpLast', 'tend_evalCmd', 'coilDefaultRadius',
           'nrrdRangeNix', 'dyeSpaceUnknown',
           'airRandMTStateGlobalInit', 'nrrdDomainAxesGet', 'airHeap',
           'pullInterTypeAdditive', 'tenGageDetNormal',
           'nrrdDeringClampHistoBinsSet', 'airDrandMT',
           'nrrdUnaryOpLog2', 'pullEnergyTypeSpring', 'airMode3',
           'tijk_refine_rank1_parm_nix', 'limnObjectConeAdd',
           'NrrdAxisInfo', 'tijk_esh_convolve_d', 'airMopDone',
           'tenSqrtSingle_f', 'tenDwiGageTensorNLSLikelihood',
           'baneGkms_infoCmd', 'meetAirEnumAllCheck', 'baneGkmsMeasr',
           'nrrdField_min', 'dyeStrToSpace', 'gageVecStrain',
           'nrrdShuffle', 'baneGkms_miteCmd', 'mite_t',
           'gageDeconvolveSeparable', 'airSetNull',
           'pullThreadNumSet', 'airDioInfo', 'airArray',
           'nrrdResampleContextNew', 'limnSplineTypeSpec_t',
           'echoListAdd', 'tenDefFiberAnisoThresh',
           'pullTraceStopBounds', 'tenGageFAHessianEval',
           'nrrdResampleExecute', 'nrrdField_spacings',
           'nrrdKernelSpecCopy', 'gageParmStackUse', 'airNoDio_fpos',
           'nrrdOriginStatusNoMaxOrSpacing',
           'nrrdResampleNonExistentLast', 'nrrdDClamp',
           'unrrdu_reshapeCmd', 'pullInfoHessian',
           'limnPolyDataPrimitiveTypes', 'gageOptimSigSet',
           'gageStackItoW', 'tenTripleTypeMoment',
           'nrrdKernelBSpline2D', 'nrrdIStore', 'mossSamplerNix',
           'tenModelParse', 'miteRangeUnknown',
           'tenGageInvarKGradMags', 'biffPresent', 'nrrdTypeInt',
           'seekTypeValleySurfaceT', 'limnPolyDataWriteIV',
           'nrrdFormatArray', 'nrrdCCMax', 'airBesselI0ExpScaled',
           'tenTripleTypeK', 'tenTripleTypeJ', 'ell_4mv_mul_f',
           'coilTask', 'tenTripleTypeR', 'mossDefCenter',
           'tenVerbose', 'nrrdIoStateUnknown',
           'pullSysParmRadiusScale', 'nrrdKernelSpecParse',
           'gageDefCurvNormalSide', 'tijk_approx_heur_parm_nix',
           'tenGageCa1GradVec', 'tijk_approx_rankk_2d_d',
           'tenGageDelNormK3', 'tenGageDelNormK2', 'biffMsgMovef',
           'gageItemPackPartHessEvec0', 'gageItemPackPartHessEvec1',
           'gageItemPackPartHessEvec2', 'limnHestSpline',
           'nrrdEnvVarStateBlind8BitRange', 'echoLightColor',
           'tenFiberSingleNew', 'dyeRGBtoXYZ', 'tijk_2o2d_asym',
           'baneInfoCheck', 'unrrdu_mrmapCmd', 'hestParmFree',
           'tenFiberIntgEuler', 'baneGkmsHestIncStrategy',
           'echoTextureLookup', 'pullOutputGet', 'nrrdGetenvUInt',
           'pullVolumeNix', 'nrrdBoundaryMirror', 'nrrdFFTWPlanRigor',
           'pullCountPointsStuck', 'pullInfoSpec_t',
           'nrrdTernaryOpInClosed', 'tenGageFAHessianEvalMode',
           'echoTypeSphere', 'gagePerVolumeAttach', 'pushIterate',
           'nrrdField_units', 'unrrduUsageUnu', 'unrrdu_mlutCmd',
           'ell_aa_to_3m_f', 'ell_aa_to_3m_d', 'baneMeasrNix',
           'pullCondConstraintFail', 'tenGageTraceGradVec',
           'tenAniso_Cs2', 'alanStopMaxIteration', 'miteUserNew',
           'nrrdSimpleCrop', 'tenEstimate1MethodNLS', 'gageKind',
           'nrrdSanityOrDie', 'seekStrengthUseSet', 'pullContextNew',
           'tenDwiGageTensorNLSErrorLog', 'echoList', 'airMopNew',
           'nrrdOriginStatusLast', 'tijk_3o3d_sym', 'gageQueryReset',
           'gageDefStackNormalizeDerivBias', 'pullInfoSeedPreThresh',
           'alanUpdate', 'seekNormalsFindSet', 'pullEnergySpec',
           'airRandMTSanity', 'nrrdKernelCatmullRomSupportDebugD',
           'tenFiberSingleInit', 'tenModelBall1Cylinder',
           'unrrdu_projectCmd', 'biffCheck', 'pullInitMethodRandom',
           'pullInfoSeedThresh', 'tenDwiGageTensorMLEErrorLog',
           'hooverRender', 'biffMsgMove',
           'tenDwiGage2TensorPeledError', 'tenEstimate1MethodLLS',
           'nrrdEnvVarDefaultWriteCharsPerLine', 'tenInterpTwo_d',
           'hestParseFree', 'hooverStubRenderEnd', 'pullPoint_t',
           'tenGageTrace', 'mossSamplerKernelSet', 'echoRayColor',
           'gageSclGradMag', 'nrrdCopy', 'nrrdUnaryOp',
           'nrrdKernelTMF', 'pullEnergyButterworth',
           'gagePerVolumeNix', 'tenEstimateSkipSet',
           'airInsane_nInfExists', 'tenDwiFiberTypeLast',
           'gageScl3PFilter_t', 'echoTriMesh',
           'tenDwiGageTensorError', 'coilIterate', 'airTypeLongInt',
           'nrrdKernelParmSet',
           'pullFlagAllowCodimension3Constraints',
           'limnPrimitiveLast', 'gageParmRenormalize', 'tenGageNorm',
           'nrrdFFT', 'pullFlagNoAdd',
           'tenDwiGage2TensorPeledLevmarInfo', 'baneMeasrNew',
           'airLogRician', 'tenGageTraceGradVecDotEvec0',
           'tenDwiGageTensorWLSLikelihood', 'nrrdSplice',
           'nrrdKernelGaussianDD', 'gageSigOfTau', 'nrrdFFTWEnabled',
           'nrrdRangeReset', 'nrrdKind3Color', 'airSrandMT',
           'tenGageModeHessianFrob', 'tenGageConfGradVecDotEvec0',
           'echoThreadState', 'tenDwiGageTensorNLS', 'baneInputCheck',
           'airNoDio_fd', 'pushEnergyGauss', 'tend_tconvCmd',
           'nrrdAxisInfoSet_va', 'gageVecNormalized',
           'nrrdValCompareInv', 'nrrdStringRead', 'unrrdu_rmapCmd',
           'nrrdDeringLinearInterpSet', 'limnPolyDataPrimitiveSelect',
           'pullPointInitializePerVoxel', 'ell_q_inv_f',
           'pullPropNeighDistMean', 'nrrdArithIterTernaryOpSelect',
           'nrrdSpace', 'pullContext', 'NrrdResampleContext',
           'hestParse', 'limnObjectFaceReverse', 'miteShadeSpecPrint',
           'NrrdIoState_t', 'nrrdEncodingUnknown',
           'airFPValToParts_f', 'airFPValToParts_d', 'dyeColor',
           'tenFiberStopReset', 'pullInterType', 'pullEnergySpecSet',
           'gageCtxFlagNeedD', 'limnPolyDataClip',
           'alanParmFrameInterval', 'nrrdKernelC5Septic',
           'gageCtxFlagNeedK', 'mossSamplerEmpty', 'limnQN16checker',
           'tenExperSpecGradBValSet', 'gageZeroNormal',
           'nrrdFFTWPlanRigorEstimate', 'gageSclHessValleyness',
           'nrrdSpacingStatus', 'miteRangeGreen', 'meetPullVol',
           'nrrdMeasureCoV', 'airBesselI1By0',
           'nrrdBasicInfoSampleUnits', 'nrrdIoStateEncodingSet',
           'nrrdMeasureUnknown', 'ell_3m_pre_mul_d',
           'ell_3m_pre_mul_f', 'tijk_esh_deconvolve_d', 'tenPresent',
           'unrrduBiffKey', 'coilFinish', 'nrrdResampleRoundSet',
           'miteShadeMethodPhong', 'airSprintPtrdiff_t', 'biffMsgNew',
           'airEndianLast', 'nrrdSpaceVecScale', 'ell_q_to_3m_d',
           'nrrdDLoad', 'hestInfo', 'miteStageOpUnknown', 'nrrdField',
           'echoPtrPtrUnion', 'nrrdEncodingHex',
           'nrrdStateMeasureModeBins', 'tijk_init_max_3d_d',
           'gagePerVolume_t', 'limnPolyDataPolarSphere',
           'tend_bmatCmd', 'tenDwiGageB0', 'nrrdApplyMulti1DRegMap',
           'gageSclNPerp', 'baneGKMSHVol', 'echoTypeSuperquad',
           'limnPolyDataCubeTriangles', 'nrrdKindNormal',
           'miteValLast', 'gageErrStackSearch', 'tenGageTraceNormal',
           'nrrdKernelBSpline7DD', 'baneRangeAnswer',
           'airFPPartsToVal_d', 'nrrdAxesMerge', 'echoJitterLast',
           'airIntPow', 'tenModelBall', 'hooverThreadEnd_t',
           'tenTripleTypeRThetaPhi', 'nrrdAxisInfoSet_nva',
           'nrrdEnvVarStateGrayscaleImage3D',
           'tenEstimateBMatricesSet', 'airHeapLength', 'dyeColorNew',
           'gageParmSet', 'nrrdRead',
           'pullFlagNoPopCntlWithZeroAlpha', 'nrrdElementNumber',
           'tijk_eval_esh_basis_f', 'nrrdDeringExecute',
           'tenDefFiberKernel', 'echoJitterCompute', 'tijk_class_efs',
           'airInsane_AIR_NAN', 'nrrdBinaryOpUnknown',
           'nrrdDefaultResampleRenormalize', 'tenEvecRGBParmNix',
           'nrrdUnaryOpNormalRand', 'tend_msimCmd',
           'seekTypeValleySurface', 'airShuffle', 'dyeSpaceXYZ',
           'tenGageCl1HessianEval', 'mossBiffKey', 'tenAniso_Cl1',
           'tenAniso_Cl2', 'miteValNdotL', 'airULLong', 'gageKernel',
           'gageSclGeomTens', 'nrrdKernelBSpline3DDD',
           'ell_cubic_root_single_double', 'airEnum',
           'nrrdCenterCell', 'hooverErrThreadBegin',
           'nrrdUnaryOpUnknown', 'elfCart2Thetaphi_f',
           'baneGkms_opacCmd', 'airNaN',
           'limnPolyDataVertexWindingFix', 'miteStageOp',
           'gageDefStackBlurSigmaMax', 'dyeSpaceHSV',
           'tenEstimate1MethodLast', 'gageShapeBoundingBox',
           'limnObjectPartTransform', 'gageTauOfSig',
           'nrrdField_byte_skip', 'pullPropNeighInterNum',
           'airDisableDio', 'airArrayLenSet', 'gageQuery',
           'pullEnergyPlot', 'gageScl3PFilter8',
           'nrrdSpaceRightAnteriorSuperiorTime', 'tenFiberContext',
           'gageScl3PFilter2', 'nrrdBlind8BitRangeTrue',
           'gageScl3PFilter6', 'dyeSpaceHSL',
           'nrrdSpaceScannerXYZTime', 'echoTypeCube',
           'nrrdCommentCopy', 'airSanity', 'tenFiberContextDwiNew',
           'nrrdKernelTMF_maxA', 'dyeSpaceToStr', 'nrrdKindDomain',
           'nrrdKernelTMF_maxD', 'unrrduHestPosCB', 'nrrdKernelTent',
           'unrrduHestFileCB', 'gageParmReset', 'limnSplineSample',
           'airDouble', 'mossSamplerImageSet', 'tenFiberType',
           'airInsane_DLSize', 'baneRangeUnknown', 'nrrdElementSize',
           'limnCameraNew', 'gageVecUnknown', 'nrrdMeasureSkew',
           'tenGlyphTypeBetterquad', 'echoCol_t', 'echoListSplit',
           'pullPropScale', 'gageKernelLast', 'airStrtok',
           'tenGageTraceHessianFrob', 'seekContour3DTopoHackEdge',
           'nrrdBlind8BitRangeUnknown', 'limnQNDemo',
           'gageScl3PFilterN', 'unrrdu_spliceCmd', 'nrrdAxisInfoMax',
           'tijk_1o3d', 'nrrdTypeLLong', 'nrrdKernelBSpline6DD',
           'echoMatterGlass', 'unrrdu_sselectCmd', 'tenGageFANormal',
           'pullStatusEdge', 'nrrdIoStateKeepNrrdDataFileOpen',
           'nrrdMaybeAlloc_nva', 'nrrdSpaceUnknown',
           'tenModelPrefixStr', 'meetPullVolNix', '_airThreadMutex',
           'nrrdWrap_nva', 'nrrdPresent', 'nrrdNix',
           'nrrdResampleInfoNix', 'pushBinProcess',
           'tenGageFALaplacian', 'nrrdCCSettle', 'gagePvlFlagLast',
           'mossSamplerSample', 'ell_q_4v_rotate_f', 'airFP_POS_NORM',
           'limnSplineInfo3Vector', 'nrrdField_type', 'miteThreadEnd',
           'pullInfoHeightHessian', 'coilMethodTypeUnknown',
           'tenInterpTypeAffineInvariant', 'airMopSub', 'dyeHSLtoRGB',
           'unrrdu_axinfoCmd', 'tenGageCl1Normal',
           'tenGageCa1Hessian', 'limnDefCameraOrthographic',
           'airDioWrite', 'nrrdStateKindNoop', 'nrrdUnaryOpAtan',
           'tenDwiGageTensorMLELikelihood', 'airMopOkay',
           'gagePvlFlagVolume', 'NrrdEncoding', 'tenFiberStopOff',
           'nrrdBoundaryPad', 'hestPresent',
           'tenEstimate1TensorVolume4D', 'nrrdMeasureHistoVariance',
           'tenFiberTypeSet', 'baneGkmsHestBEF',
           'limnSplineTypeHasImplicitTangents', 'tenTripleTypeXYZ',
           'tenAnisoLast', 'nrrdKernelCheck', 'nrrdDescribe',
           'limnObjectEdgeAdd', 'gageStackProbeSpace',
           'nrrdDeringRadialKernelSet', 'nrrdKernelBox',
           'tenModelBall1StickEMD', 'coilContextAllSet',
           'gageContext_t', 'nrrdTypeUInt', 'tenShrink',
           'tenLogSingle_f', 'limnObjectCylinderAdd',
           'gageErrBoundsSpace', 'gageSclShapeIndex',
           'pullSysParmOpporStepScale', 'nrrdKernelHannDD',
           'limnQN10octa', 'pullConstraintScaleRange',
           'echoIntxFuzzify', 'nrrdTypeUnknown',
           'nrrdResampleContextNix', 'hooverStubRayEnd',
           'limnSplineBCSet', 'limnPolyDataSpiralBetterquadric',
           'pullCountUnknown', 'limnQNBins', 'ell_Nm_wght_pseudo_inv',
           'limnObjectSquareAdd', 'limnSplineCleverNew',
           'nrrdMeasureRootMeanSquare', 'limnQN14checker',
           'tend_estimCmd', 'gageContextNew', 'tend_evecCmd',
           'unrrdu_dataCmd', 'tenGageEval', 'coilKindType3Color',
           'alanParmReact', 'elfESHEstimMatrix_f',
           'pullCountEnergyFromImage', 'tenModelB0', 'mossMatFlipSet',
           'nrrdZlibStrategyLast', 'unrrdu_headCmd',
           'limnSplineInfoScalar', 'nrrdField_old_max',
           'hooverErrThreadEnd', 'seekTypeValleySurfaceOP',
           'mossSampler', 'gageSclFlowlineCurv',
           'tenExperSpecKnownB0Get', 'nrrdMeasureProduct',
           'nrrdTernaryOpGaussian', 'pullPointInitializeGivenPos',
           'airNoDio_small', 'gageSclUnknown',
           'nrrdResampleRangeFullSet', 'pullSysParm',
           'nrrdDeringThetaKernelSet', 'limnPolyDataSize',
           'airMyQNaNHiBit', 'coilMethodTypeCurvatureFlow',
           'pullInitMethodUnknown', 'pushStart', 'tend_gradsCmd',
           'tenFiberParmVerbose', 'limnObjectLookAdd',
           'tijk_refine_rankk_2d_f', 'tenModelNllFit',
           'tenFiberMultiTrace', 'limnEdgeTypeBorder',
           'nrrdSpaceOriginGet', 'nrrdBoundaryUnknown', 'tenInv_f',
           'tenInv_d', 'baneHVolCheck', 'pullInitLiveThreshUseSet',
           'tenGageCl1HessianEval2', 'tenTripleTypeUnknown',
           'tenGageCl1HessianEval0', 'tenGageCl1HessianEval1',
           'pullTraceStopStub', 'tenFiberStopUnknown',
           'tenDwiGageLast', 'meetPullInfoNew', 'limnLightSwitch',
           'echoObjectNew', 'tijk_init_max_2d_d', 'pullTraceMultiAdd',
           'nrrdMeasureLineIntercept', 'airNoDioErr',
           'nrrdResample_t', 'nrrdUnaryOpRoundDown', 'coilVerbose',
           'pullProcessMode', 'airArrayPointerCB', 'airEnumCheck',
           'nrrdOriginStatusUnknown', 'nrrdKind2Vector',
           'nrrdEnvVarDefaultKernelParm0', 'nrrdAxisInfoIdxRange',
           'echoMatterLight', 'gageItemPackPartUnknown',
           'tijk_2o3d_sym', 'gageDeconvolve', 'gageSclHessEval1',
           'gageSclHessEval0', 'gageSclHessEval2',
           'nrrdDeringThetaNumSet', 'tenEstimateLinear4D',
           'nrrdDefaultGetenv']

# =============================================================
# What follows are the all #define's in Teem, excluding macros,
# and #defines that depend on compile-time tests done by the
# C pre-processor.
# This is created by something akin to grep'ing through the
# public header files, with some extra filters.

TEEM_VERSION_MAJOR = 1   # must be 1 digit 
TEEM_VERSION_MINOR = 11   # 1 or 2 digits 
TEEM_VERSION_PATCH = 00   # 1 or 2 digits 
TEEM_VERSION = 11100   # must be 5 digits, to facilitate
TEEM_VERSION_STRING = "1.11.0" # cannot be so easily compared 
AIR_PI = 3.14159265358979323846
AIR_E = 2.71828182845904523536
AIR_STRLEN_SMALL = (128+1) # has to be big enough to hold:
AIR_STRLEN_MED = (256+1)
AIR_STRLEN_LARGE = (512+1)
AIR_STRLEN_HUGE = (1024+1) # has to be big enough to hold
AIR_RANDMT_N = 624
AIR_TYPE_MAX = 12
AIR_INSANE_MAX = 11
AIR_PRIME_NUM = 1000
AIR_NODIO_MAX = 12
AIR_TRUE = 1
AIR_FALSE = 0
AIR_ENDIAN = (airMyEndian())
AIR_QNANHIBIT = (airMyQNaNHiBit)
AIR_DIO = (airMyDio)
AIR_NAN = (airFloatQNaN.f)
AIR_QNAN = (airFloatQNaN.f)
AIR_SNAN = (airFloatSNaN.f)
AIR_POS_INF = (airFloatPosInf.f)
AIR_NEG_INF = (airFloatNegInf.f)
ALAN = alanBiffKey
ALAN_THREAD_MAX = 256
ALAN_STOP_MAX = 5
BANE = baneBiffKey
BANE_PARM_NUM = 5
COIL = coilBiffKey
COIL_PARMS_NUM = 6
COIL_METHOD_TYPE_MAX = 8
COIL_KIND_TYPE_MAX = 3
DYE = dyeBiffKey
DYE_MAX_SPACE = 6
ECHO = echoBiffKey
ECHO_LIST_OBJECT_INCR = 32
ECHO_IMG_CHANNELS = 5
ECHO_EPSILON = 0.00005      # used for adjusting ray positions 
ECHO_NEAR0 = 0.004          # used for comparing transparency to zero 
ECHO_LEN_SMALL_ENOUGH = 5   # to control splitting for split objects 
ECHO_THREAD_MAX = 512       # max number of threads 
ECHO_JITTER_NUM = 4
ECHO_JITTABLE_NUM = 7
ECHO_MATTER_MAX = 4
ECHO_MATTER_PARM_NUM = 4
ECHO_TYPE_NUM = 12
ELL = ell_biff_key
ELL_EPS = 1.0e-10
ELL_CUBIC_ROOT_MAX = 4
GAGE = gageBiffKey
GAGE_DERIV_MAX = 2
GAGE_ERR_MAX = 6
GAGE_CTX_FLAG_MAX = 6
GAGE_PVL_FLAG_MAX = 3
GAGE_KERNEL_MAX = 7
GAGE_ITEM_PREREQ_MAXNUM = 8
GAGE_SCL_ITEM_MAX = 35
GAGE_VEC_ITEM_MAX = 31
GAGE_ITEM_PACK_PART_MAX = 11
GAGE_QUERY_BYTES_NUM = 32
GAGE_ITEM_MAX = ((8*GAGE_QUERY_BYTES_NUM)-1)
GAGE_PERVOLUME_ARR_INCR = 32
GAGE_OPTIMSIG_SIGMA_MAX = 11
GAGE_OPTIMSIG_SAMPLES_MAXNUM = 11
HOOVER = hooverBiffKey
HOOVER_THREAD_MAX = 512
HOOVER_ERR_MAX = 10
LIMN = limnBiffKey
LIMN_LIGHT_NUM = 8
LIMN_SPLINE_Q_AVG_EPS = 0.00001
LIMN_EDGE_TYPE_MAX = 7
LIMN_SPACE_MAX = 4
LIMN_PRIMITIVE_MAX = 7
LIMN_POLY_DATA_INFO_MAX = 4
LIMN_QN_MAX = 16
LIMN_SPLINE_TYPE_MAX = 5
LIMN_SPLINE_INFO_MAX = 6
LIMN_CAMERA_PATH_TRACK_MAX = 3
MEET = meetBiffKey
MITE = miteBiffKey
MITE_RANGE_NUM = 9
MITE_STAGE_OP_MAX = 4
MITE_VAL_ITEM_MAX = 19
MOSS = mossBiffKey
MOSS_FLAG_NUM = 2
NRRD = nrrdBiffKey
NRRD_DIM_MAX = 16            # Max array dimension (nrrd->dim) 
NRRD_SPACE_DIM_MAX = 8       # Max dimension of "space" around array
NRRD_EXT_NRRD = ".nrrd"
NRRD_EXT_NHDR = ".nhdr"
NRRD_EXT_PGM = ".pgm"
NRRD_EXT_PPM = ".ppm"
NRRD_EXT_PNG = ".png"
NRRD_EXT_VTK = ".vtk"
NRRD_EXT_TEXT = ".txt"
NRRD_EXT_EPS = ".eps"
NRRD_KERNEL_PARMS_NUM = 8    # max # arguments to a kernel-
NRRD_MINMAX_PERC_SUFF = "%"
NRRD_COMMENT_CHAR = '#'
NRRD_FILENAME_INCR = 32
NRRD_COMMENT_INCR = 16
NRRD_KEYVALUE_INCR = 32
NRRD_LIST_FLAG = "LIST"
NRRD_PNM_COMMENT = "# NRRD>"    # this is designed to be robust against
NRRD_PNG_FIELD_KEY = "NRRD"     # this is the key used for getting nrrd
NRRD_PNG_COMMENT_KEY = "NRRD#"  # this is the key used for getting nrrd
NRRD_UNKNOWN = "???"           # how to represent something unknown in
NRRD_NONE = "none"              # like NRRD_UNKNOWN, but with an air
NRRD_FORMAT_TYPE_MAX = 6
NRRD_BOUNDARY_MAX = 5
NRRD_TYPE_MAX = 11
NRRD_TYPE_SIZE_MAX = 8    # max(sizeof()) over all scalar types 
NRRD_ENCODING_TYPE_MAX = 5
NRRD_ZLIB_STRATEGY_MAX = 3
NRRD_CENTER_MAX = 2
NRRD_KIND_MAX = 31
NRRD_AXIS_INFO_SIZE_BIT = (1<< 1)
NRRD_AXIS_INFO_SPACING_BIT = (1<< 2)
NRRD_AXIS_INFO_THICKNESS_BIT = (1<< 3)
NRRD_AXIS_INFO_MIN_BIT = (1<< 4)
NRRD_AXIS_INFO_MAX_BIT = (1<< 5)
NRRD_AXIS_INFO_SPACEDIRECTION_BIT = (1<< 6)
NRRD_AXIS_INFO_CENTER_BIT = (1<< 7)
NRRD_AXIS_INFO_KIND_BIT = (1<< 8)
NRRD_AXIS_INFO_LABEL_BIT = (1<< 9)
NRRD_AXIS_INFO_UNITS_BIT = (1<<10)
NRRD_AXIS_INFO_MAX = 10
NRRD_AXIS_INFO_NONE = 0
NRRD_BASIC_INFO_DATA_BIT = (1<< 1)
NRRD_BASIC_INFO_TYPE_BIT = (1<< 2)
NRRD_BASIC_INFO_BLOCKSIZE_BIT = (1<< 3)
NRRD_BASIC_INFO_DIMENSION_BIT = (1<< 4)
NRRD_BASIC_INFO_CONTENT_BIT = (1<< 5)
NRRD_BASIC_INFO_SAMPLEUNITS_BIT = (1<< 6)
NRRD_BASIC_INFO_SPACE_BIT = (1<< 7)
NRRD_BASIC_INFO_SPACEDIMENSION_BIT = (1<< 8)
NRRD_BASIC_INFO_SPACEUNITS_BIT = (1<< 9)
NRRD_BASIC_INFO_SPACEORIGIN_BIT = (1<<10)
NRRD_BASIC_INFO_MEASUREMENTFRAME_BIT = (1<<11)
NRRD_BASIC_INFO_OLDMIN_BIT = (1<<12)
NRRD_BASIC_INFO_OLDMAX_BIT = (1<<13)
NRRD_BASIC_INFO_COMMENTS_BIT = (1<<14)
NRRD_BASIC_INFO_KEYVALUEPAIRS_BIT = (1<<15)
NRRD_BASIC_INFO_MAX = 15
NRRD_BASIC_INFO_NONE = 0
NRRD_FIELD_MAX = 32
NRRD_HAS_NON_EXIST_MAX = 3
NRRD_SPACE_MAX = 12
NRRD_SPACING_STATUS_MAX = 4
NRRD_MEASURE_MAX = 29
NRRD_BLIND_8BIT_RANGE_MAX = 3
NRRD_UNARY_OP_MAX = 30
NRRD_BINARY_OP_MAX = 23
NRRD_TERNARY_OP_MAX = 16
NRRD_FFTW_PLAN_RIGOR_MAX = 4
NRRD_RESAMPLE_NON_EXISTENT_MAX = 3
PULL = pullBiffKey
PULL_THREAD_MAXNUM = 512
PULL_VOLUME_MAXNUM = 4
PULL_POINT_NEIGH_INCR = 16
PULL_BIN_MAXNUM = 40000000 # sanity check on max number bins 
PULL_PHIST = 0
PULL_HINTER = 0
PULL_TANCOVAR = 1
PULL_INFO_MAX = 23
PULL_PROP_MAX = 17
PULL_STATUS_STUCK_BIT = (1<< 1)
PULL_STATUS_NEWBIE_BIT = (1<< 2)
PULL_STATUS_NIXME_BIT = (1<< 3)
PULL_STATUS_EDGE_BIT = (1<< 4)
PULL_INTER_TYPE_MAX = 4
PULL_ENERGY_TYPE_MAX = 13
PULL_ENERGY_PARM_NUM = 3
PULL_PROCESS_MODE_MAX = 4
PULL_SOURCE_MAX = 2
PULL_COUNT_MAX = 14
PULL_TRACE_STOP_MAX = 5
PULL_CONSTRAINT_FAIL_MAX = 4
PUSH = pushBiffKey
PUSH_THREAD_MAXNUM = 512
PUSH_ENERGY_TYPE_MAX = 5
PUSH_ENERGY_PARM_NUM = 3
SEEK = seekBiffKey
SEEK_TYPE_MAX = 11
TEN = tenBiffKey
TEN_ANISO_MAX = 29
TEN_INTERP_TYPE_MAX = 11
TEN_GLYPH_TYPE_MAX = 6
TEN_GAGE_ITEM_MAX = 207
TEN_DWI_GAGE_ITEM_MAX = 35
TEN_ESTIMATE_1_METHOD_MAX = 4
TEN_ESTIMATE_2_METHOD_MAX = 2
TEN_FIBER_TYPE_MAX = 6
TEN_DWI_FIBER_TYPE_MAX = 3
TEN_FIBER_INTG_MAX = 3
TEN_FIBER_STOP_MAX = 10
TEN_FIBER_NUM_STEPS_MAX = 10240
TEN_FIBER_PARM_MAX = 4
TEN_TRIPLE_TYPE_MAX = 9
TEN_MODEL_B0_MAX = 65500    # HEY: fairly arbitrary, but is set to be
TEN_MODEL_DIFF_MAX = 0.006  # in units of mm^2/sec; diffusivity of
TEN_MODEL_PARM_GRAD_EPS = 0.000005 # for gradient calculations 
TEN_MODEL_STR_ZERO = "zero"
TEN_MODEL_STR_B0 = "b0"
TEN_MODEL_STR_BALL = "ball"
TEN_MODEL_STR_1VECTOR2D = "1vector2d"
TEN_MODEL_STR_1UNIT2D = "1unit2d"
TEN_MODEL_STR_2UNIT2D = "2unit2d"
TEN_MODEL_STR_1STICK = "1stick"
TEN_MODEL_STR_BALL1STICKEMD = "ball1stickemd"
TEN_MODEL_STR_BALL1STICK = "ball1stick"
TEN_MODEL_STR_BALL1CYLINDER = "ball1cylinder"
TEN_MODEL_STR_1CYLINDER = "1cylinder"
TEN_MODEL_STR_1TENSOR2 = "1tensor2"
TEN_DWI_GAGE_KIND_NAME = "dwi"
TIJK_TYPE_MAX_NUM = 45
TIJK_CLASS_MAX = 3
UNRRDU = unrrduBiffKey
UNRRDU_COLUMNS = 78  # how many chars per line do we allow hest 

# =============================================================
# Make sure this shared library will work on this machine.
if not nrrdSanity():
    errstr = biffGetDone(NRRD)
    print "**"
    print "** Sorry, there is a problem (described below) with the "
    print "** Teem shared library that prevents its use. This will "
    print "** have to be fixed by recompiling the Teem library for "
    print "** this platform. "
    print "**"
    print "** %s" % errstr
    raise ImportError

# =============================================================
# Its nice to have these FILE*s around for utility use, but they 
# aren't available in a platform-independent way in ctypes. These 
# air functions were created for this purpose.
stderr = airStderr()
stdout = airStdout()
stdin = airStdin()
