/*
 *========================================================================
 * $Id: select_option.c 231 2004-07-07 01:08:54Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * This routine is a callback for select on keyboard (stdin) I/O.
 * We eventually need to document these controls in the man page.
 * In the meantime I know the controls (I wrote them:-) and they
 * are documented in comments below.
 *
 * The display type is going to be tricky.  We really want something
 * like "t" plus a digit from a menu that "pops up" in the messages,
 * while the cycle is suspended.  What we'll probably do first is just
 * give different options their own letter until this gets boring.
 *========================================================================
 */

#include "wulfstat.h"

void select_option(char c)
{

 /*
  * We sometimes have to count characters to decide if a special key
  * was struck.  This is our counter.  We have to reset it to zero when
  * we process the actual special character.
  */
 static int escape = 0;

 if((verbose == D_ALL) || (verbose == D_SELECT_OPTION)){
   fprintf(OUTFP,"D_SELECT_OPTION: Starting D_SELECT_OPTION.  Use -v %d to focus.\n",D_SELECT_OPTION);
   fprintf(OUTFP,"D_SELECT_OPTION: Key %d (ascii) or %c (character) pressed.\n",c,c);
 }
 wclear(debugpad);

 switch(c){
   /*
    * escape precedes all special keyboard characters, e.g. pgup, pgdn.
    * We toggle it each time it is struck, which can produce odd
    * odd results if it is struck directly.
    */
   case 27:
     if(escape){
       escape = 0;
     } else {
       escape = 1;
     }
     break;
   case 'O':
     /*
      * This is the second character of up, down, left, right arrows.
      */
     if(escape == 1){
       escape = 2;
     }
     break;
       
   case '[':
     /*
      * This is the second character of pageup, pagedown
      */
     if(escape == 1){
       escape = 2;
     }
     break;
       
   case 'A':
     /*
      * This is up arrow
      */
     if(escape == 2){
       scroll_displaypad(-1);
       escape = 0;
     }
     break;

   case '5':
     /*
      * This is Page down
      */
     if(escape == 2){
       scroll_displaypad(-display.lines_displaypad+2);
       escape = 0;
     }
     break;

   case '6':
     /*
      * This is Page up
      */
     if(escape == 2){
       scroll_displaypad(display.lines_displaypad-2);
       escape = 0;
     }
     break;

   /* q(uit), obviously */
   case 'q':
   case 'Q':
     escape = 0;
     quit();
     break;
   /* We accept f(orward) or n(ext) */
   /* and b(ackward) or p(revious) */
   case 'B':
     /*
      * This is down arrow
      */
     if(escape == 2){
       scroll_displaypad(1);
       escape = 0;
     }
     break;
   /* 
    * +/- step the cycle delay up and down, in seconds.  Can't be less
    * 0, though.
    */
   case '+':
     update_delay++;
     break;
   case '-':
     update_delay--;
     if(update_delay < 0) update_delay = 0;
     break;
   case 'b':
     display.type = DISPLAY_BASIC;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 'c':
     display.type = DISPLAY_PIDS_CMDLINE;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 'l':
     display.type = DISPLAY_LOAD;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 'm':
     display.type = DISPLAY_MEMORY;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 'n':
     display.type = DISPLAY_NET;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 'p':
     display.type = DISPLAY_PIDS;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   case 's':
     show_status();
     break;
   case 't':
     display.type = DISPLAY_TIMES;
     set_display_dctl_state(hostlist);
     init_host_values(hostlist);
     break;
   default:
     break;
 }

}
