from scipy.stats import scoreatpercentile
from scipy.misc.common import comb
import numpy as np
import sys
import hddm
from hddm import wfpt
from scipy.stats import *
from time import time
reload(hddm)
reload(wfpt)
from numpy import *
from scipy.integrate import *

d = array([ 0.755,  0.415,  0.815,  0.455,  0.645,  0.59 ,  1.295,  0.37 ,
        1.285,  1.035,  0.66 ,  1.1  ,  0.575,  0.835,  1.77 ,  0.415,
        0.475,  1.03 ,  0.76 ,  0.98 ,  1.29 ,  0.655,  0.97 ,  0.78 ,
        1.68 ,  0.82 ,  0.795,  0.52 ,  1.215,  0.87 ,  1.355,  0.46 ,
        0.64 ,  0.805,  1.12 ,  0.765,  0.59 ,  0.71 ,  0.485,  0.86 ,
        0.87 ,  0.415,  0.615,  1.76 ,  0.325,  0.425,  0.79 ,  0.825,
        0.66 ,  1.435,  0.805,  0.715,  0.635,  0.58 ,  1.365,  0.555,
        0.65 ,  0.665,  0.38 ,  0.595,  0.655,  0.4  ,  0.53 ,  0.83 ,
        1.01 ,  0.415,  0.635,  0.55 ,  1.19 ,  0.455,  0.815,  0.425,
        0.535,  0.69 ,  0.42 ,  0.75 ,  1.2  ,  0.305,  0.96 ,  0.36 ,
        0.57 ,  1.435,  1.59 , -0.955, -0.585, -1.145, -1.37 , -1.27 ,
       -1.71 , -1.54 , -0.7  , -0.4  , -0.645, -0.455, -0.405, -0.73 ,
       -0.915, -0.42 , -0.505, -1.2  ])


def fivenum(res, logp, calc_err=False):
    print 'min:     %.4f' % min(res)
    print 'Q1:      %.4f' % scoreatpercentile(res,25)
    print 'median:  %.4f' % median(res)
    print 'Q3:      %.4f' % scoreatpercentile(res,75)
    print 'max:     %.4f' % max(res)
    print 'err0.10: %.4f' % calc_err_chance(res,0.1, logp)
    print 'err0.05: %.4f' % calc_err_chance(res,0.05, logp)
    print 'err0.01: %.4f' % calc_err_chance(res,0.01, logp)
    

v=1; V=0.1; z=0.5; Z=0.1; t=0.3; T=0.1; a=1.5
value = np.array([0.36],dtype=float)

def calc_err_chance(res,t, logp):
    res = sort(res)
    count = 0
    N = len(res)
    for i in xrange(N):
        if logp==1:
            count += sum(res >= log(1+t) + res[i])
        else:
            count += sum(res >= (1+t)*res[i])
    return count/comb(N,2)

            
            
def test(v=v,V=V,z=z,Z=Z,t=t,T=T,a=a,value=value,logp=1):
    
    #print "true_value %f" 
    N = 1000
    l_reps = [10, 50, 100, 500]#, 1000, 2000]
    
    res = np.empty((N,len(l_reps)), dtype=float)
    for i_reps in range(len(l_reps)):
        i_t = time()
        for i in range(N):
            res[i,i_reps] = sum(wfpt.wiener_like_full_mc(value, v, V, z, Z, t, T, a, err=.0001,
                                                            reps=l_reps[i_reps], logp=logp))
        print '*** check  %d reps ***' % l_reps[i_reps]
        print '%f seconds to evaluate' %((time() - i_t)/N)    
        fivenum(res[:,i_reps], logp)
        sys.stdout.flush()
    
def test_V(v=v,V=V,z=z,Z=Z,t=t,T=T,a=a,value=value,logp=1):
    
    f = lambda v_i,value=value: hddm.wfpt.pdf_array(value, v=v_i, a=a, z=z, t=t, err=.0001, logp=0)[0] *norm.pdf(v_i,v,V)
    i_t = time();
    y = quad(f,-inf,inf, full_output=0)[0]
    print 'true value: %f' % y
    print '%f seconds to evaluate' %(time() - i_t)
   
    #print "true_value %f" 
    N = 1000
    l_reps = [10, 50, 100, 250, 500, 1000, 2000]
    
    res = np.empty((N,len(l_reps)), dtype=float)
    for i_reps in range(len(l_reps)):
        i_t = time()
        for i in range(N):
            res[i,i_reps] = sum(wfpt.wiener_like_full_mc(value, v, V, z, Z, t, T, a, err=.0001,
                                                            reps=l_reps[i_reps], logp=logp))
        print '*** check  %d reps ***' % l_reps[i_reps]
        print '%f seconds to evaluate' %((time() - i_t)/N)
        t_res = np.abs(res[:,i_reps] - y)    
        print 'mean: %f' % mean(t_res)
        print '95%%:  %f' % scoreatpercentile(t_res,95)
        sys.stdout.flush()
        
def atest(v=v,V=V,z=z,Z=Z,t=t,T=T,a=a,value=value):
    
    big_N = 10000
    i_t = time()
    y = sum(wfpt.wiener_like_full_mc(value, v, V, z, Z, t, T, a, err=.0001,
                                                            reps=big_N,logp=1))
    
    print 'true value: %f' % y
    print '%f seconds to evaluate' %(time() - i_t)
   
    #print "true_value %f" 
    N = 1000
    l_reps = [10, 50, 100, 250, 500, 1000]
    
    i_t = time()
    g_value = grid_value(value,v,V,z,Z,t,T,a, n=10)
    print '*** check  grid ***' 
    print '%f seconds to evaluate' %((time() - i_t))
    print 'err:      %f' % (np.abs(g_value - y))
    
    res = np.empty((N,len(l_reps)), dtype=float)
    for i_reps in range(len(l_reps)):
        i_t = time()
        for i in range(N):
            res[i,i_reps] = sum(wfpt.wiener_like_full_mc(value, v, V, z, Z, t, T, a, err=.0001,
                                                            reps=l_reps[i_reps], logp=1))
        print '*** check  %d reps ***' % l_reps[i_reps]
        print '%f seconds to evaluate' %((time() - i_t)/N)
        t_res = np.abs(res[:,i_reps] - y)    
        print 'mean      :  %f' % mean(t_res)
        print 'p(err>.05):  %f' % (np.sum(t_res>log(1.05))*1./N)
        sys.stdout.flush()

def true_val(value,v=v,V=V,z=z,Z=Z,t=t,T=T,a=a, big_N = 50000):
    i_t = time()
    y = sum(wfpt.wiener_like_full_mc(value, v, V, z, Z, t, T, a, err=.0001,
                                                            reps=big_N,logp=1))
    return y

#from scipy.integrate import *
f = lambda v_i,value=value: hddm.wfpt.pdf_array(value, v=v_i, a=a, z=z, t=t, err=.0001, logp=0)[0] *norm.pdf(v_i,v,V)
#i_t = time();
y = quad(f,-inf,inf, args = (array([0.1]),))
#print '%f seconds to evaluate' %(time() - i_t)    
#
#def f3(t_i,z_i,v_i, value,v=v,V=V):
#    return wfpt.pdf_array(value, v=v_i, a=a, z=z_i, t=t_i, err=.0001, logp=0)[0] * \
#            norm.pdf(v_i,v,V)
#            
#f3_lb1 = lambda x,z=z,Z=Z:z-Z/2.
#f3_ub1 = lambda x,z=z,Z=Z:z+Z/2.
#f3_lb2 = lambda x,y,t=t,T=T:t-T/2.
#f3_ub2 = lambda x,y,t=t,T=T:t+T/2.
#
#i_t = time();
#val = array([0.3, 0.4, 0.6, 1])
#y = [None]*len(val)
#err = y[:]
#for i in range(len(val)):
#    i_t = time()
#    tmp =  tplquad(f3, -inf,inf, f3_lb1, f3_ub1,f3_lb2, f3_ub2, epsabs=1e-4, epsrel=1e-4, args=(val[i:i+1],))
#    y[i] = tmp[0]/(Z*T)
#    err[i] = tmp[1]
#    print '%f seconds to evaluate' %(time() - i_t)    
#    print y[i]

def test_full_mc(nChunks=1, reps=1e6):
    values = np.tile(array([0.3, 0.4, 0.6, 1]),nChunks)
    print "testing %d data points" % (len(values))

    v=1; V=0.1; z=0.5; Z=0.1; t=0.3; T=0.1; a=1.5
    true_vals = np.log(np.array([0.019925699375943847,
                       1.0586617338544908,
                       1.2906014938998163,
                       0.446972173706388]))
    true_vals = np.tile(true_vals,nChunks)
    
    y = np.empty(len(values), dtype=float)
    for i in xrange(len(values)):
        y[i] = sum(wfpt.wiener_like_full_mc(values[i:i+1], v, V, z, Z, t, T, a, err=.0001,
                                                        reps=reps,logp=1))
    fail = (np.abs(y - true_vals) > log(1.01))
    print "Fail on %d (out of %d) values" % (sum(fail), len(fail))
    if (np.abs(np.sum(y) - np.sum(true_vals)) > log(1.01)):
        print "Fail on the combined data"
    else:
        print "everything is o.k."    

def grid_value(value,v=v,V=V,z=z,Z=Z,t=t,T=T,a=a, n=3):
    
    z_points = np.linspace(z-Z/2.,z+Z/2.,n+2)[1:-1]
    t_points = np.linspace(t-T/2.,t+T/2.,n+2)[1:-1]
    v_probs = np.linspace(0.025,0.975,n)
    v_points = norm.ppf(v_probs,v,V)
    w = norm.pdf(v_points)
    w = w/np.sum(w)
    s = 0
    for z_i in z_points:
        for t_i in t_points:
            for (idx,v_i) in enumerate(v_points):
                s += hddm.wfpt.pdf_array(value, v=v_i, a=a, z=z_i, t=t_i, err=.0001, logp=0)*w[idx]
    return np.sum(np.log(s/(n**2))) 

#def check_convrg(value,v=v,V=V,z=z,Z=Z,t=t,T=T,a=a,block=, max_iter=1000, eps=1e-3):
#    for i=1:


def pdf_V(x,v,V,z,t,a, err=0.0001, logp=1):
    if a<z or z<0 or z>1 or a<0:
        return -np.Inf

    if x<0:
        x = np.abs(x) - t
    else:
        x = x-t
        v = -v
        z = 1.-z
        

    pdf_noV =  wfpt.pdf(x, v, a, z, err, 1)
    f_noV = pdf_noV - (-v*a*z -(pow(v,2))*x/2.) + 2*log(a)
    final = f_noV - 2*log(a) + (pow(a*z*V,2) - 2*a*v*z - pow(v,2)*x)/(2*pow(V,2)*x+2) - log(sqrt(pow(V,2)*x+1))
    if logp:
        return final
    else:
        return exp(final)

def test_pdv_V():
    values = [0.2,0.5 ,1., -0.4,-1]
    v=1; z=0.55; t=0.3; a=1.5; V=0.1; err = 0.0001
    values = [1.013815]
    v=0.1682; z=0.20561; t=0;   a=2.258911; V=0.0013789;  err = 1e-13
    bb1 = hddm.wfpt.pdf_V(abs(values[0]),v=-v,V=V, z=1-z,a=a,err=err,logp=0)
    bb2 = hddm.wfpt.pdf_V(abs(values[0]),v=-v,V=V, z=1-z,a=a,err=err,logp=1)
    print bb1
    print bb2
    print log(bb1)
    func = lambda v_i,value,err=err,v=v,V=V,z=z,a=a: hddm.wfpt.pdf_sign(value, v=v_i, a=a, z=z, t=t, err=err, logp=0) *norm.pdf(v_i,v,V)
    
    for i in range(len(values)):
        my_res =  pdf_V(values[i],v=v,V=V,z=z,t=t,a=a, err=err, logp=0)
        quad_res = quad(func,-inf,inf, args=(values[i],),epsrel=1e-20,epsabs=1e-20)[0]
        print 'my result:            %f' % my_res
        print 'interpolation result: %f' % quad_res
        my_res =  pdf_V(values[i],v=v,V=V,z=z,t=t,a=a, err=err, logp=1)
        quad_res = log(quad(func,-inf,inf, args=(values[i],))[0])
        print 'my result:            %f' % my_res
        print 'interpolation result: %f' % quad_res
        
    i_t = time()
    N = 20;
    for i in range(N):        
        my_res =  pdf_V(values[0],v=v,V=V,z=z,t=t,a=a, err=err)
    print "analytic takes %f secs" % ((time() - i_t)/N)
    for i in range(N):        
        log(quad(func,-inf,inf, args=(values[0],))[0])
    print "quad takes %f secs" % ((time() - i_t)/N)
    
def like_V(x, v=v,V=V,z=z,a=a):
    w = z
    m = v
    sv = V
    pdf_noV = wfpt.pdf(x, v, a, z, err=0.00001, logp=1)
    f_noV = pdf_noV - (-v*a*w -(pow(v,2))*x/2.) + 2*log(a)
    final = f_noV - 2*log(a) + (pow(a*w*sv,2) - 2*a*m*w - pow(m,2)*x)/(2*pow(sv,2)*x+2) - log(sqrt(pow(sv,2)*x+1))
    
    print 'my result:            %f' % final
    
    func = lambda v_i,value=array([x]),v=v,sv=sv,z=z,a=a: hddm.wfpt.pdf(value, v=v_i, a=a, z=z, err=.00001, logp=0) *norm.pdf(v_i,v,sv)
    y = log(quad(func,-inf,inf)[0])
    print 'interpolation result: %f' % y
    
#TODO: unit test from likelihood_with_V

def my_simpson(f, a ,b, n):
    """f=name of function, a=initial value, b=end value, n=number of double intervals of size 2h"""
    assert ((n%2)==0), "n should be even"
 
    h = (b - a) / n;
    S = f(a)
 
    for i in range(1, n, 2):
        x = a + h * i
        S += 4 * f(x)
 
    for i in range(2, n-1, 2):
        x = a + h * i
        S += 2 * f(x)
 
    S += f(b)
    F = h * S / 3
 
    return F

def test_simpson_on_T(timing=False):
    values = [0.5,0.2 ,1., -0.4,-1]
    T = 0.3
    v=1; z=0.55; t=0.3; a=1.5; V=0.3; err = 0.0001
    n = 8
    
    func = lambda t_i,value,err=err,v=v,V=V,z=z,a=a,T=T: pdf_V(value,v=v,V=V,z=z,t=t_i,a=a, err=err, logp=0)/T
    
    for i in range(len(values)):
        my_func = lambda t_i,value=values[i],err=err,v=v,V=V,z=z,a=a,T=T: pdf_V(value,v=v,V=V,z=z,t=t_i,a=a, err=err, logp=0)/T
        my_res =  my_simpson(my_func,-T/2.,T/2.,n)
        #their_simps = simps([my_func(x) for x in linspace(-T/2.,T/2.,10+1)], linspace(-T/2.,T/2.,10+1)) 
        quad_res = quad(func,-T/2.,T/2., args=(values[i],))[0]
        print 'my result:            %f' % my_res
        #print 'their simps:          %f'% their_simps
        print 'interpolation result: %f' % quad_res
        my_res =  log(my_res)
        quad_res = log(quad(func,-T/2.,T/2., args=(values[i],))[0])
        print 'my result:            %f' % my_res
        print 'interpolation result: %f' % quad_res
        
    i_t = time()
    N = 20;
    if timing:
        for i in range(N):        
            my_res =  my_simpson(my_func,-T/2.,T/2.,10)
        print "analytic takes %f secs" % ((time() - i_t)/N)
        for i in range(N):        
            quad(func,-T/2.,T/2., args=(values[0],))
        print "quad takes %f secs" % ((time() - i_t)/N)
        

def simps_bound(v,a,t,w):
    A = pi/2*exp(-v*a*w-v**2*t/2)
    b = -(pi**2)/(2*a**2)
    S = 0
    n =4
    for i in range(n+1):
        p = 1;
        for j in range(1,i+1):
            p = p*(2*i-2*j+2)
        S += ((-v/2)**(n-i)) * (abs(b)**i) * ((-1)**i+1) / ((2*b*t)**i+1) * p
        
    return A*S

def in_b_test(T):
    hT = T/nT
    for j in range(nT+1):
        t_tag = -T/2. + hT*j
        y_t[j] = hddm.wfpt.pdf_sign(rt, v=v, a=a, z=z, t=t_tag, err=err,logp=0)             
    if logp:
        res[2+vvv*4] = np.log(simps(y_t, x=None, dx=hT))
    else:
       res[2+vvv*4] = simps(y_t, x=None, dx=hT)



def b_test():
    rt  = 0.5
    t = 0.2
    T = 0
    v = 1
    V= 0
    z = 0.5
    Z = 0
    err = 1e-10
    logp = 1
    nT = 10
    

                   
    print hddm.wfpt.full_pdf(rt,v,V,a,z,Z,t,T,err,logp, nT=nT, nZ=0)
    T = 0.01
    print hddm.wfpt.full_pdf(rt,v,V,a,z,Z,t,T,err,logp, nT=nT, nZ=0)
    T = 0.011
    print hddm.wfpt.full_pdf(rt,v,V,a,z,Z,t,T,err,logp, nT=nT, nZ=0)

def WTF():
    rt  = 0.5
    t = 0.2
    T = 0
    v = 1
    V= 1
    z = 0.5
    Z = 0
    err = 1e-10
    logp = 1
    nT = 10
        
    print hddm.wfpt.full_pdf(rt,v=v,V=V,a=a,z=z,Z=0,t=t, T=0,err=err,logp=logp, nT=nT, nZ=0)
    print hddm.wfpt.full_pdf(rt,v=v,V=0,a=a,z=z,Z=0,t=t, T=0,err=err,logp=logp, nT=nT, nZ=0)
    print hddm.wfpt.pdf_sign(rt, v=v, a=a, z=z, t=t, err=err,logp=logp)
                