def test_HDDM_on_cuttoff_data(sim, n_lower, n_upper):
    """
    test basic HDDM on cutoff data
    sim - simResults object
    n_lower/n_upper - number of lower/upper trials that will be removed from the data        
    """
    lower_idx = [x[2] for x in sorted(sim.data, key=lambda x:abs(x['rt']))[:n_lower]]
    if n_upper > 0:
        upper_idx = [x[2] for x in sorted(sim.data, key=lambda x:abs(x['rt']))[-n_upper:]]
    else:
        upper_idx = []
    rm_idx = np.array(lower_idx + upper_idx, np.int)
    data = sim.data.copy()
    all_idx = np.ones(len(data), np.bool)
    all_idx[rm_idx] = False
    data = data[all_idx]
    print "length of old data:", len(sim.data)
    print "length of new data:", len(data)
    if len(lower_idx) > 0:
        print "maximal early sample removed:",  max(sim.data['rt'][np.array(lower_idx)])
        print "new minimum early sample:", min(abs(data['rt']))

    h = hddm.model.HDDM(data)
    burn = 8000
    done_tuning = burn_until_tuned(h, burn, max_iter=10)
    h.sample(5000, tune_throughout = False)
    all_stats = h.stats()
    for (name, stats) in sim.stats.iteritems():
        if name == 'pi':
            continue
        np.testing.assert_allclose(all_stats[name]['mean'], stats['mean'], 0.1, 0.1)
        for (q, value) in stats['quantiles'].iteritems():
            np.testing.assert_allclose(all_stats[name]['quantiles'][q], value , 0.1, 0.1)

    return h

def burn_until_tuned(model, burn, max_iter=10, verbose=1):
    """
    burn samples from 'model' until it does not need more tuning
    this is done by sampling from the model 'burn' samples, and checking if the model
    was not tuned for 5 consecutive times. this all procedure runs 'max_iter' times
    or until the model found to be tuned.
    """
    done_tuning = False
    iter = 0
    while (not done_tuning) and (iter < max_iter):
        iter +=1
        if verbose > 0:
            print "%d iteration of burning " % iter
        model.sample(burn+1,burn, tune_throughout=False)
        done_tuning = model.mc._tuned_count == 5
        if verbose > 0:
            print "tuned_count: ", model.mc._tuned_count

    if verbose > 0:
        if done_tuning:
            print "burning phase was done"
        else:
            print "Tuning was not finished !-!-!-!-!-!"


    return done_tuning