import numpy as np
from numpy.random import rand

import hddm
from hddm.likelihoods import *
from hddm.generate import *
from scipy.integrate import *
from time import time
from copy import copy

def one_test(adap_max, err, simps_err, nTests = 400, simps_inter=10):
    a_time = np.zeros(nTests)
    n_time = np.zeros(nTests)
    for i_test in range(nTests):
        ok= 0
        while not ok:        
            params = {}
            params['v'] = (rand()-.5)*4
            params['T'] = rand()*0.3 
            params['t'] = rand()*.5+(params['T']/2)
            params['a'] = 1.5+rand()
            params['z'] = .5
            params['V'] = rand()    
            params['Z'] =  rand()*0.3
            n_samples = 500
            samples = hddm.generate.gen_rts(params, samples=n_samples)
            if len(samples)==n_samples:
                ok = 1
        
        v = params['v']
        t = params['t']
        a = params['a']
        z = params['z']
        V = params['V']
        T = params['T']
        Z = params['Z']
    
        i_t = time()
        for i_samp in range(n_samples):        
            adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, adap_max, adap_max, 1, simps_err)
        a_time[i_test] = time() - i_t
        
        i_t = time()
        for i_samp in range(n_samples):
            non_adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, simps_inter, simps_inter, 0)
        n_time[i_test] = time() - i_t
        
    return a_time, n_time

all_err = [1e-4, 1e-5, 1e-6, 1e-7];
all_adap = range(5)

    
def run_one_test(all_err, all_adap):    
    a_res = [None]*len(all_err)
    n_res = [None]*len(all_err)
    for i_err in range(len(all_err)):
        a_res[i_err] = [None]*len(all_adap)
        n_res[i_err] = [None]*len(all_adap)
        for i_adap in range(len(all_adap)):
            print i_err, i_adap        
            b1 , b2 = one_test(all_adap[i_adap], all_err[i_err])
            a_res[i_err][i_adap] = copy(b1)
            n_res[i_err][i_adap] = copy(b2)
    print "done"
    
    rel_res = [None]*len(all_err)
    for i in range(len(all_err)):
        rel_res[i] = [None]*len(all_adap)
        for j in range(len(all_adap)):
            rel_res[i][j] = np.median(n_res[i][j] / a_res[i][j])                                  
    return rel_res

# rel_res = run_one_test([1e-5], range(10))

def compare_to_quad(err, adap_max, simps_err, dest_err, nTests = 200):
    a_time = np.zeros(nTests)
    q_time = np.zeros(nTests)
    r_time = np.zeros(nTests)
    for i_test in range(nTests):
        print i_test
        ok= 0
        while not ok:        
            params = {}
            params['v'] = (rand()-.5)*4
            params['T'] = rand()*0.2
            params['t'] = rand()*.5+(params['T']/2)
            params['a'] = 1.5+rand()
            params['z'] = .5
            params['V'] = rand()    
            params['Z'] =  0 #rand()*0.3
            n_samples = 500
            samples = hddm.generate.gen_rts(params, samples=n_samples)
            if len(samples)==n_samples:
                ok = 1
        
        v = params['v']
        t = params['t']
        a = params['a']
        z = params['z']
        V = params['V']
        T = params['T']
        Z = params['Z']
    
#        i_t = time()
#        for i_samp in range(n_samples):        
#            adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, adap_max, adap_max, 0, simps_err=simps_err)            
#        a_time[i_test] = time() - i_t
        
        func_t = lambda t, value,v,V,a,z,T,err: hddm.wfpt.full_pdf(value,v,V,a,z,0,t, 0,err, 0, 0, 0)/T
        adap_time = 0
        non_adap_time = 0
        for i_samp in range(n_samples):
            i_t = time()
            adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, adap_max, adap_max, 1, simps_err=simps_err)
            adap_time += time() - i_t     
            i_t = time()     
            non_adap_res = hddm.wfpt.full_pdf_quad(samples[i_samp],v,V,a,z,Z,t, T,err)
            non_adap_time += time() - i_t          

           # n2 = quad(func_t, t - T/2., t + T/2., args = (samples[i_samp], v, V, a, z, T, err/2), epsabs=1e-10, epsrel=1e-10, limit=1)[0]
            assert (abs(adap_res - non_adap_res) < dest_err), "bla"
        
#        func_t = lambda t, value,v,V,a,z,T,err: hddm.wfpt.full_pdf(value,v,V,a,z,0,t, 0,err, 0, 0, 0)/T
#        adap_time = 0
#        non_adap_time = 0
#        for i_samp in range(n_samples):
#            i_t = time()
#            adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, adap_max, adap_max, 1, simps_err=simps_err)
#            adap_time += time() - i_t     
#            i_t = time()     
#            non_adap_res = quad(func_t, t - T/2., t + T/2., args = (samples[i_samp], v, V, a, z, T, err/2), 
#                                      epsabs=simps_err, epsrel=simps_err, limit=2, full_output=1)[0]
#            non_adap_time += time() - i_t          
#
#           # n2 = quad(func_t, t - T/2., t + T/2., args = (samples[i_samp], v, V, a, z, T, err/2), epsabs=1e-10, epsrel=1e-10, limit=1)[0]
#            assert (abs(adap_res - non_adap_res) < dest_err), "bla"
        a_time[i_test] = adap_time
        q_time[i_test] = non_adap_time
#        
#        func_t = lambda t, value,v,V,a,z,T,err: [hddm.wfpt.full_pdf(value,v,V,a,z,0,xx, 0,err, 0, 0, 0)/T for xx in t]
#        i_t = time()
#        for i_samp in range(n_samples):
##            adap_res = hddm.wfpt.full_pdf(samples[i_samp],v,V,a,z,Z,t, T,err, adap_max, adap_max, 1)            
#            fixed_quad(func_t, t - T/2., t + T/2., args = (1, v, V, a, z, T, err/2))
#           # n2 = quad(func_t, t - T/2., t + T/2., args = (samples[i_samp], v, V, a, z, T, err/2), epsabs=1e-10, epsrel=1e-10, limit=1)[0]
#           # assert (abs(adap_res - non_adap_res) < err), "bla"
#        q_time[i_test] = time() - i_t
#        
#        
        
    return a_time, q_time


a_time, q_time = compare_to_quad(1e-5, 5, simps_err = 1e-8, dest_err=1e-5, nTests=60)
print np.median(q_time / a_time)        

#a_time, n_time = one_test(adap_max=5, err=1e-5, simps_err=1e-7, nTests = 100, simps_inter=10)
#print np.median(n_time / a_time)        
"""
I run the test for different errors and different
I tested it on 
errors = [1e-4, 1e-5, 1e-6, 1e-7];
adap_max = range(5)
res[i][j] represent a combination for errors[i] and adap_max[j]

res  =
[[4.4183609374384361,
  3.5370792769037727,
  3.2902593065535619,
  3.1908562629961397,
  3.1327317405395956],
 [4.4143323098042364,
  2.8026129960350659,
  2.0947658635783286,
  1.9080202865687204,
  1.6921352416746112],
 [4.4315745452851107,
  2.1320221689789722,
  1.3265007389031451,
  0.93622725606613488,
  0.81747502036872688],
 [4.421356524310152,
  1.7513499876687939,
  0.74926406890971997,
  0.41351906510699532,
  0.34177945036038015]]

you can see from the results that 1e-5 is the maximum error that get better results
for adaptive simpson then the none-adaptive one.


[[4.369923563918503,
  2.8255027311661305,
  2.0249844648906126,
  1.8519333140404077,
  1.838398399156659,
  1.7577399738182564,
  1.8757550940947274,
  1.697544664594163,
  1.7607769058142524,
  1.8263630853223871]]

 
"""


