from __future__ import division

import nose

import unittest
import sys
import numpy as np
import numpy.testing
import numpy.lib.recfunctions as rec
import matplotlib.pyplot as plt

import platform
from copy import copy
import subprocess

import pymc as pm

import hddm

from hddm.likelihoods import *
from hddm.generate import *
from numpy.random import rand
from time import time, clock, ctime
from numpy import *

from nose import SkipTest
print ""
import cPickle
from hddm.tests.test_models import check_model, check_rejection


def test_acc_full_intrp(nTests=20, use_db = False):
    
    thin = 1
    n_iter = 10000
    burn  = 10000
    all_wp = []
    all_wp = all_wp + [{'err': 1e-5, 'nT':3, 'nZ':3, 'use_adaptive':1, 'simps_err':1e-5}]
#    all_wp = all_wp + [{'err': 1e-5, 'nT':3, 'nZ':3, 'use_adaptive':1, 'simps_err':1e-5}]
#    all_wp = all_wp + [{'err': 1e-5, 'nT':2, 'nZ':2, 'use_adaptive':1, 'simps_err':1e-4}]
#    all_wp = all_wp + [{'err': 1e-4, 'nT':2, 'nZ':2, 'use_adaptive':1, 'simps_err':1e-4}]
#    all_wp = all_wp + [{'err': 1e-4, 'nT':2, 'nZ':2, 'use_adaptive':1, 'simps_err':1e-3}]   

    for i_test in range(nTests):
        print "!!!!! test no. %d" % i_test
        params = {}
        params['v'] = (rand()-.5)*4
        params['T'] = 0 #rand()*0.2
        params['t'] = rand()*.5+(params['T']/2)
        params['a'] = 1+rand()
        params['z'] = .5
        params['V'] = rand()    
        params['Z'] = 0 #rand()*0.3
        n_samples = 300
        data, temp = hddm.generate.gen_rand_data(n_samples, params)

        print "running test %d, with the following params: " % i_test, params
        
        i_res={}
        i_res['params'] = copy(params)
        i_res['data'] = copy(data)
        i_res['sample_time'] = [None]*len(all_wp)
        i_res['init_time'] = [None]*len(all_wp)
        i_res['burn_time'] = [None]*len(all_wp)
        i_res['stats'] = [None]*len(all_wp)
        i_res['logp'] = [None]*len(all_wp)
        i_res['dbname'] = [None]*len(all_wp)
        i_res['nodes'] = [{} for x in range(len(all_wp))]
                
        for i_params in range(len(all_wp)):
            print "working on model %d" % i_params
            
            model = hddm.model.HDDM(data, model_type='full_intrp', no_bias=False, wiener_params=all_wp[i_params], 
                                    exclude_inter_var_params = ['T','Z'])#, init_value=params)
            i_t = time()
            if use_db:
                dbname = 'speed.'+ str(clock()) + '.db'
                i_res['dbname'][i_params] = dbname[:]
            else:
                dbname = None
            model.mcmc(sample=False, dbname=dbname);
            d_time = time() - i_t;
            print "initilize took %f secs" % d_time
            sys.stdout.flush()
            i_res['init_time'][i_params] = d_time
            [model.mcmc_model.use_step_method(pm.Metropolis, x,proposal_sd=0.5) for x in model.group_params.values()]

            i_t = time()
            model.mcmc_model.sample(burn+1, burn)
            d_time = time() - i_t;
            i_res['burn_time'][i_params] = d_time
            print "burn phase took %f secs" % d_time
           
            i_t = time()
            model.mcmc_model.sample(n_iter, 0, thin=thin)
            d_time = time() - i_t;
            i_res['sample_time'][i_params] = d_time

            print "sampling took in %f secs" % d_time
            sys.stdout.flush()
            
            
            if bug_report(model):
                res[i_test] = copy(i_res)
                return res, data, params, model
            model._gen_stats()
            i_res['stats'][i_params] = gen_stats(model)
            try:
                i_res['logp'][i_params] = model.mcmc_model.logp
            except:
                i_res['logp'][i_params] = np.NAN
                
            for i_node in model.group_params:
                i_res['nodes'][i_params][i_node] = model.group_params[i_node].trace()[:]
                
            if bug_report(model):
                res[i_test] = copy(i_res)
                return res, data, params, model
            
            if dbname is not None:
                model.mcmc_model.db.commit()
                model.mcmc_model.db.close()

                   
        
    return i_res, data, params, model
       

def gen_stats(model):
    stats = {}    
    for param_name in model.group_params.iterkeys():
        stats[param_name] = [scoreatpercentile(model.mcmc_model.trace(param_name)[:],x) for x in [2.5, 25, 50, 75, 97.5]]
    return stats


def gen_data_and_params(n_samples=300):
    params = {}
    params['v'] = (rand()-.5)*4
    params['T'] = rand()*0.2
    params['t'] = rand()*.5+(params['T']/2)
    params['a'] = 1.5+rand()
    params['z'] = .5
    params['V'] = rand()    
    params['Z'] = rand()*0.3
    data, temp = hddm.generate.gen_rand_data(n_samples, params)
    return data, params


def bug_report(model):
    
    epsi = 0.05
    node_list = set(model.group_params.keys()) - set(['a','v','t','z'])
    for node in node_list:
        trace = model.mcmc_model.trace(node)[-50:]
        a = trace[::2]
        b = trace[1::2]
        da = mean(a)
        db = mean(b)
        dc = mean(trace)
        if abs(db-dc)>epsi and abs(da-dc)>epsi:
            print "May found Something!!!!!!!!!!"
            print node, da, db, dc
            return True
    return False
                

        

#data, params, model = find_bug()
#res, data, params, model =test_acc_full_intrp(use_db = False)
    

for i in range(3):
    curr_time = time()
    print "******* going into the %i iter - started at %s, %f****************" % (i, ctime(curr_time), curr_time)
    res, data, params, model = test_acc_full_intrp(1, use_db=False)
    check_model(model, params, assert_=False)
    check_rejection(model, assert_ =False)
    file = open('speed_est_%d.pckl' % (i),'w')
    cPickle.dump(res, file)
    file.close()    