import hddm
import kabuki
import numpy as np
import pymc as pm
from pprint import pprint
from pymc.sandbox import GibbsStepMethods

def gen_data():
    conds_params = {'a':1., 'v': [0.2, 0.8], 'V':0, 't': 0.3, 'T': 0, 'z': 0.5, 'Z': 0}
    n_conds = len(conds_params['v'])
    data, params_subj, combined_params = \
    hddm.generate.gen_rand_cond_subj_data(conds_params, samples_per_cond=200, n_conds=n_conds,
                                num_subjs=5, include = (), noise=.05)
    return data, params_subj, combined_params

def my_wiener_like(value, v, t, a, z=0.5, V=0, Z=0, T=0, err=1e-4, nT=2, nZ=2, use_adaptive=1, simps_err=1e-3):
    """Log-likelihood for the full DDM using the interpolation method"""
    logp = 0;
    for i in range(value.shape[0]):
        logp += hddm.wfpt.wiener_like(value[i,:], v[i], V, a[i], z, Z, t[i], T, err, nT, nZ, use_adaptive, simps_err)
        if np.isinf(logp):
            return logp 

    return logp



my_WienerFullIntrp = pm.stochastic_from_dist(name="Wiener Diffusion Process",
                                       logp=my_wiener_like,
                                       dtype=np.float,
                                       mv=False)



def create_vec_hddm(data):

    n_conds = len(np.unique(data['cond']))
    n_subjs = len(np.unique(data['subj_idx']))

    a = pm.Uniform('a', 0.1, 4, value=1)
    avar = pm.Uniform('avar', 1e-3, 10, value=1)
    asubj = pm.TruncatedNormal('asubj', a=0.3, b=1e4, mu=a, tau=avar**-2, value=np.ones(n_subjs)*0.5)

    t = []
    tvar  = []
    tsubj = []
    for i_cond in range(n_conds):
        t.append(pm.Uniform('t%d' % i_cond, 0.01, 4, value=0.1))
        tvar.append(pm.Uniform('t%dvar' % i_cond, 1e-3, 10, value=1))
        tsubj.append(pm.TruncatedNormal('t%dsubj' % i_cond, a=0.01, b=1e4, mu=t[i_cond],
                                        tau=tvar[i_cond]**-2, value=np.ones(n_subjs)*0.1))

    v = []; vvar = []; vsubj = []
    for i_cond in range(n_conds):
        v.append(pm.Normal('v%d' % i_cond, mu=0, tau=1./(10**2), value=0))
        vvar.append(pm.Uniform('v%dvar' % i_cond, 1e-6, 10, value=1))
        vsubj.append(pm.Normal('v%dsubj' % i_cond, mu=v[i_cond], tau=vvar[i_cond]**-2, value=np.zeros(n_subjs)))

    data = hddm.utils.flip_errors(data)
    len_cond = len(data[(data['cond'] == 0) & (data['subj_idx'] == 0)])
    wfpt = []
    for i_cond in range(n_conds):
        value = np.empty((n_subjs, len_cond))
        for i_subj in range(n_subjs):
            value[i_subj,:] = data[(data['subj_idx'] == i_subj) & (data['cond'] == i_cond)]['rt']
        tmp = my_WienerFullIntrp('wfpt%d' % i_cond , v=alpha * vsubj[i_cond], a=asubj, t=tsubj[i_cond],
                                 value=value, observed=True)
        wfpt.append(tmp)

    del data, n_subjs, i_cond, tmp, value, n_conds, i_subj, len_cond, use_alpha

    dic = locals()
    return dic



def multi_normal_like(values, vec_mu, tau):
    """logp for multi normal"""
    logp = 0
    for i in xrange(len(vec_mu)):
        logp += pm.normal_like(values[i,:], vec_mu[i], tau)
    
    return logp
    
MN = pm.stochastic_from_dist(name="MultiNormal", logp=multi_normal_like, dtype=np.double, mv=True)

def create_nodes(sigma_x=1, n_subjs=5, size=100, mu_value=4, seed=1, vec=False):

    #init
    np.random.seed(seed)
    if np.isscalar(mu_value):
        mu_value = [mu_value]
    n_conds = len(mu_value)
    mu = [None] * n_conds
    subj_nodes = [None]*n_conds
    data_nodes = [None]*n_conds

    #true_values
    true_values = {}
    true_values['sigma'] = sigma_x
    true_values['mu'] = mu_value

    #init sigma node
    sigma = pm.Uniform('sigma', 1e-10,1e10, value=1)

    #create nodes for each cond
    for i_cond in range(n_conds):
        #initalize the true value of x
        true_x = randn(n_subjs)*sigma_x + mu_value[i_cond]
        value = np.random.randn(n_subjs, size).T + true_x
        value = value.T
        print true_x

        #init mu and sigma
        mu[i_cond] = pm.Normal('mu%d' % i_cond, 0, 100.**-2, value=0)

        #create subj_nodes (x + y)
        if vec:
            subj_nodes[i_cond] = pm.Normal('x%d' % (i_cond), mu[i_cond], sigma**-2, size=n_subjs, value=true_x)
            data_nodes[i_cond] = MN('y%d' % (i_cond), vec_mu=subj_nodes[i_cond], tau=1, value=value, observed=True)
        else:
            subj_nodes[i_cond] = [None]*n_subjs
            data_nodes[i_cond] = [None]*n_subjs
            for i_subj in range(n_subjs):
                #x is generate from the mean.
                subj_nodes[i_cond][i_subj] = pm.Normal('x%d_%d' % (i_cond, i_subj), mu[i_cond], sigma**-2, value=true_x[i_subj])
                data_nodes[i_cond][i_subj] = pm.Normal('y%d_%d' % (i_cond, i_subj),
                                                       mu=subj_nodes[i_cond][i_subj],
                                                       tau=1, value=value[i_subj,:], observed=True)

    #create nodes dictionary
    nodes = {}
    nodes['x'] = subj_nodes
    nodes['y'] = data_nodes
    nodes['mu'] = mu
    nodes['sigma'] = sigma

    return nodes, true_values


def test(sigma_x=1, n_subjs=5, size=10, mu_value=(4,3), seed=1, vec=False):

    nodes_b, tmp = create_nodes(sigma_x=sigma_x, n_subjs=n_subjs, size=size, mu_value=mu_value, seed=seed, vec=False)
    nodes_vec, tmp = create_nodes(sigma_x=sigma_x, n_subjs=n_subjs, size=size, mu_value=mu_value, seed=seed, vec=True)

    iter = 20000
    burn = 15000
    mc_vec = pm.MCMC(nodes_vec)
    mc_vec.sample(iter, burn)
    mc_b = pm.MCMC(nodes_b)
    mc_b.sample(iter, burn)
    
    return mc_vec, mc_b



#data, params_subj, combined_params = gen_data()
#new_steps = {'var_step_method': pm.Metropolis, 'group_step_method': pm.Metropolis};
#update_params = {'v': new_steps}
#t_h = hddm.model.HDDM(data, depends_on={'v':'cond'}, plot_var = True, plot_subjs=True,
#                      include=(), update_params = update_params)
#mc = t_h.mcmc()
#mc.sample(10000,8000, progress_bar=True)
#t_h.print_stats()
#
#nodes = create_vec_model(data, use_alpha=False)
#vec_mc = pm.MCMC(nodes)
#vec_mc.sample(10000,8000, progress_bar=True)
#print vec_mc.stats()['v0var']
#print vec_mc.stats()['v0subj']['95% HPD interval']
#print vec_mc.stats()['v0subj']['mean']

#nodes2 = create_vec_model(data, use_alpha=False)
#vec_mc2 = pm.MCMC(nodes2)
#vec_mc2.sample(10000,8000)


