"""root package"""

import logging, time
import warnings

log = logging.getLogger(__name__)

def measure_time(funct):
    """decorator that measures the time spent in a function"""

    def newf(*args, **kwargs):
        "with time"

        start_time = time.time()
        res = funct(*args, **kwargs)
        log.info("operation took %.2f seconds\n", time.time()-start_time)
        return res

    return newf


def deprecated(func):
    """This is a decorator which can be used to mark functions
    as deprecated. It will result in a warning being emmitted
    when the function is used."""

    def newfunc(*args, **kwargs):
        warnings.warn("Call to deprecated function %s." % func.__name__,
                category=DeprecationWarning)
        return func(*args, **kwargs)

    newfunc.__name__ = func.__name__
    newfunc.__doc__ = func.__doc__
    newfunc.__dict__.update(func.__dict__)
    return newfunc





