"modules for dealing with (mainly importing to datasets) genomic data"


def parseBED(s, use_score=True, bg_val=1.0):
    """parse a feature in BED4 or BED5 format

    s: tab-separated line from the BED file
    use_score: use the score of the feature or set it to bg_val
    return: BED5+ feature"""

    cols = s.rstrip().split("\t")
    if len(cols) < 4:
        raise ValueError("feature (%s) must be at least BED4" % s)

    if len(cols) == 4:
        if use_score:
            raise ValueError("feature (%s) must be at least BED5 with use_score=True" % s)
        else:
            return (cols[0], int(cols[1]), int(cols[2]), cols[3], bg_val)
    elif len(cols) > 4:
        if use_score:
            ctp = [str, int, int, str, float] + ([str] * (len(cols) - 5))
        else:
            ctp = [str, int, int, str, lambda v: 1.0] + ([str] * (len(cols) - 5))
        return map(lambda t: t[0](t[1]), zip(ctp, cols))
    else:
        raise ValueError("please report this BUG")
