

import sys, os
import unittest
import tempfile
from operator import itemgetter
from functools import partial

from monitor import *

#@unittest.skip("for now")
class TestMonitor( unittest.TestCase ):
    def setUp(self):
        self.incr = map(LearnMonitor._make, (
            (0,0,0,0,0,0,0,0),
            (0,0,1,0,0,0,0,0),
            (0,0,2,0,0,0,0,0),
            (0,0,1,0,0,0,0,0),
            (0,0,2,0,0,0,0,0),
            (0,0,3,0,0,0,0,0)))

    def test_seqmonotonicity(self):
        self.assertTrue( LearnMonitor.is_min_up("traincost", 2, self.incr) )
        self.assertFalse( LearnMonitor.is_min_still("traincost", 2, self.incr[:-1]) )
        self.assertTrue( LearnMonitor.is_min_up("traincost", 1, self.incr[:-1]) )
        self.assertTrue( LearnMonitor.is_max_still("traincost", 2, self.incr[:-1]) )

    def test_reldiff(self):
        self.assertEqual( LearnMonitor.rel_diff(init=90, final=100), 0.1 )
        self.assertEqual( LearnMonitor.rel_diff(init=100, final=90), -0.1 )
