'''
common operations on numpy arrays
@author: odenas
'''

import numpy as np

def fit(x, axis=None, nans=0.0):
    """scale values of x in the interval [-1, 1]
    
    @param x: ndarray
    @param axis: passed to numpy.max and numpy.min
    @param nans: if nan values are produced replace them with this
    @return: scaled values of x"""
    
    
    M = x.max(axis = axis)
    m = x.min(axis = axis)
    mid_p = (M + m) / 2
    rng = (M - m)
    
    fitx = 2 * (x - mid_p) / rng
    fitx[ np.isnan(fitx) ] = nans

    #if not (np.max(fitx) == 1 and np.min(fitx) == -1):
    #    import pdb
    #    pdb.set_trace()
    
    return fitx

def standardize(x, axis=None, nans=0.0):
    """transform each component of flattened X examples to 0 mean and 1 std
    So the values of track t at position i are 0 mean and 1 std

    x: a pandas data panel of the form <anchors> X <tracks> X <genome position>
    return: (the shifted input,
    the mean for each input component, the sd of each input component)
    the latter 2 are arrays of shape(<tracks>, <genome position>)
    """


    m = x.mean( axis = axis )
    v = x.std( axis = axis )

    normX = ( (x - m) / v )
    normX[ np.isnan(normX) ] = nans
    
    return normX, m, v



