from elements import Elements

class Parameter(Elements):
    _tag = 'parm'
    _children = Elements._children.copy()
    _attributes = Elements._attributes.copy()

    _attributes['name'] = 'name'
    _attributes['value'] = 'value'

    def __init__(self, name=None, value=None):
        self.name = name
        self.value = value

class Characteristic(Elements):
    _tag = 'characteristic'
    _children = Elements._children.copy()
    _attributes = Elements._attributes.copy()

    _attributes['type'] = 'type'
    _children['parm'] = ('parms', [Parameter])
    _children['characteristic'] = ('characteristics', [])
    
    def __init__(self, characteristics=None, parms=None, type=None):
        self.parms = parms or []
        self.characteristics = characteristics or None
        self.type = type

class WapProvisioningDoc(Elements):
    _tag = 'wap-provisioningdoc'
    _children = Elements._children.copy()
    _attributes = Elements._attributes.copy()

    _attributes['version'] = 'version'
    _children['characteristic'] = ('characteristics', [Characteristic])

    def __init__(self, characteristics=None, version=None):
        self.characteristics = characteristics or []
        self.version = version

