from elements import Elements

xml_string1 = """
<message>
	<last/>
</message>
"""

xml_string2 = """
<message>
</message>
"""

class Message(Elements):
  _tag = 'message'
  _children = Elements._children.copy()    
  
  _children['last'] = ('last', bool)

  def __init__(self, last=False, text=None):
    self.last = last
    self.text = text

def test_bool():
    e = Message()
    e.from_string(xml_string1)
    
    assert e.last == True
    assert type(e.last) == bool

    e = Message()
    e.from_string(xml_string2)

    assert e.last == False

    for truth in [False, True]:
        e = Message(last=truth)
        xml_string = e.to_string()
        e = Message()
        e.from_string(xml_string)
        assert e.last == truth
        
if __name__ == '__main__':
	test_bool()