from elements import Elements

import sys

xml_string = """
<message>
	<integer>1</integer>
	<integer>2</integer>
	<integer>3</integer>
	<integer>4</integer>
</message>
"""

class Message(Elements):
  _tag = 'message'
  _children = Elements._children.copy()    
  
  _children['integer'] = ('myints', [int])

  def __init__(self, myints=False, text=None):
    self.myints = myints or []
    self.text = text

def test_int_list():
    global xml_string
    e = Message()
    e.from_string(xml_string)
    
    assert e.myints == [1,2,3,4]
    assert type(e.myints) == list

    # Contruct a new list
    val = [-1, 0, 1]
    e = Message(myints=val)
    xml_string = e.to_string()
    
    # Parse our own output
    e = Message()
    e.from_string(xml_string) 
    assert e.myints == val
        
if __name__ == '__main__':
	test_int_list()