
import re
from pwpeg import *

from random import randint

def _choose(lbracket, text, repeat, rbracket):
    l = [text] + repeat
    return l[randint(0, len(l) - 1)]

text = Rule(re.compile("([^\[\]\|]|\\\[|\\\]|\\\|)+"))

spin = Rule("[", R("toplevel"), ZeroOrMore("|", R("toplevel"), Action(lambda a, b: b)), "]",
    Action(_choose))

toplevel = Rule(ZeroOrMore(Either(text, spin)), Action(lambda l: "".join(l)))

p = Parser(toplevel)

if __name__ == "__main__":
    import string
    import sys
    print(p.parse(" ".join(sys.argv[1:])))


