"""
    A simple calculator test.
"""

import re
from pwpeg import *

literal = Rule(re.compile("[0-9]+"), Action(lambda n: int(n)))

parengroup = Either(
    literal,
    ("(", R("addition"), ")", Action(lambda _1, res, _2: res))
)

multiplication = Either(
    (parengroup, Either("/", "*"), parengroup, Action(lambda left, op, right: left / right if op == "/" else left * right)),
    parengroup
)

addition = Either(
    (multiplication, Either("-", "+"), multiplication, Action(lambda left, op, right: left - right if op == "-" else left + right)),
    multiplication,
    skip=re.compile("\s+")
)

#p = Parser(addition, re.compile("\s+"))
p = Parser(addition)

print(p.parse("2 * (2 + 3)"))

