from __future__ import unicode_literals

import os
from collections import deque

from PyProto.eventloop import EventLoop, Events
from PyProto.splitter import Exceptions
from PyProto.utils import Printer, Errors 

# Line util.for line-ending delimited protocols
class LineSplitter(Events.SocketEvent):
    def __init__(self, event, line_end='\r\n', read_count=512, encoding='UTF-8', **kwargs):
        super(LineSplitter, self).__init__(event, **kwargs)

        self.line_end = line_end
        self.write_buf = deque()
        self.read_buf = list() # XXX should it be a deque?
        self.read_count = read_count
        self.encoding = encoding

    def read_callback(self):
        self.read_buf.append(os.read(self.readfd, self.read_count).decode(self.encoding))

        if self.read_buf[-1] == '':
            raise Exceptions.SplitterException("Remote host disconnected")

        buf = ''.join(self.read_buf)

        lines = buf.split(self.line_end)
        self.read_buf = [lines[-1]]

        for line in lines[:-1]:
            self.read_line(line)

        return True

    def write_callback(self):
        while True:
            try:
                string = self.write_buf.popleft()
            except IndexError:
                return False # Drained

            try:
                writelen = os.write(self.writefd, string)
            except (IOError, OSError) as e:
                if e.errno in Errors.ignore_errno:
                    return True
                else:
                    raise

            if writelen < len(string):
                self.write_buf.append(string[writelen:])
                return True

    @Printer.print_lines
    def read_line(self, line):
        return line

    @Printer.print_lines
    def write_line(self, line, raw=False):
        if not raw and (line.rfind(self.line_end) == -1):
            line += self.line_end

        self.write_buf.append(line.encode(self.encoding))
        self.event.set_event(self, EventLoop.EVENT_OUT)
        return line

