#!/usr/bin/env python3

from PyProto.eventloop import EventLoop, Events
from PyProto.protocol import IRC

class IRCTest(IRC.IRCProtocol):
    def command_PRIVMSG(self, sender, command, params):
        message = params[-1]
        if not (message.startswith('\x01') and message.endswith('\x01')):
            return

        if message.find('PING', 1, 5) != -1:
            self.write_line("NOTICE {} :{}".format(sender[0], message))
        elif message.find('VERSION', 1, 8) != -1:
            self.write_line("NOTICE {} :{}".format(sender[0], '\x01VERSION testbot v0.0.0.0.0.0.0.0.1 PyProto test\x01'))
        elif message.find('FINGER', 1, 7) != -1:
            self.write_line("NOTICE {} :{}".format(sender[0], '\x01FINGER ew.\x01'))

class HeartbeatTimer(Events.TimerEvent):
    def __init__(self, event, instance):
        super(HeartbeatTimer, self).__init__(event)
        self.instance = instance
    def run_timer(self):
        self.instance.write_line("PING :{}".format(self.instance.host))

event = EventLoop.EventLoop()
instance = IRCTest(event, nick="Elizabot", user="Elizabot", gecos="Shitting dicknipples", host="irc.staticbox.net", port=6667, ipv6=False)
instance.connect()
event.set_timer(30, HeartbeatTimer(event, instance), recur=True)
event.run_forever()
