from math import sin, cos, pi

# the angles here are given in (90 / 4)th - so multiply it with (90 / 4) to get
# the actual angles
channels = {
    'Fpz' : (0.0, 4.0),
    'Fp1' : (-4.0, 3.5),
    'AFp1' : (-1.5, 3.5),
    'AFp2' : (1.5, 3.5),
    'Fp2' : (4.0, 3.5),
    'AF7' : (-4.0, 3.0),
    'AF5' : (-3.0, 3.0),
    'AF3' : (-2.0, 3.0),
    'AFz' : (0.0, 3.0),
    'AF4' : (2.0, 3.0),
    'AF6' : (3.0, 3.0),
    'AF8' : (4.0, 3.0),
    'FAF5' : (-2.5, 2.5),
    'FAF1' : (-0.65, 2.5),
    'FAF2' : (0.65, 2.5),
    'FAF6' : (2.5, 2.5),
    'F9' : (-5.0, 2.0),
    'F7' : (-4.0, 2.0),
    'F5' : (-3.0, 2.0),
    'F3' : (-2.0, 2.0),
    'F1' : (-1.0, 2.0),
    'Fz' : (0.0, 2.0),
    'F2' : (1.0, 2.0),
    'F4' : (2.0, 2.0),
    'F6' : (3.0, 2.0),
    'F8' : (4.0, 2.0),
    'F10' : (5.0, 2.0),
    'FFC9' : (-4.5, 1.5),
    'FFC7' : (-3.5, 1.5),
    'FFC5' : (-2.5, 1.5),
    'FFC3' : (-1.5, 1.5),
    'FFC1' : (-0.5, 1.5),
    'FFC2' : (0.5, 1.5),
    'FFC4' : (1.5, 1.5),
    'FFC6' : (2.5, 1.5),
    'FFC8' : (3.5, 1.5),
    'FFC10' : (4.5, 1.5),
    'FT9' : (-5.0, 1.0),
    'FT7' : (-4.0, 1.0),
    'FC5' : (-3.0, 1.0),
    'FC3' : (-2.0, 1.0),
    'FC1' : (-1.0, 1.0),
    'FCz' : (0.0, 1.0),
    'FC2' : (1.0, 1.0),
    'FC4' : (2.0, 1.0),
    'FC6' : (3.0, 1.0),
    'FT8' : (4.0, 1.0),
    'FT10' : (5.0, 1.0),
    'CFC9' : (-4.5, 0.5),
    'CFC7' : (-3.5, 0.5),
    'CFC5' : (-2.5, 0.5),
    'CFC3' : (-1.5, 0.5),
    'CFC1' : (-0.5, 0.5),
    'CFC2' : (0.5, 0.5),
    'CFC4' : (1.5, 0.5),
    'CFC6' : (2.5, 0.5),
    'CFC8' : (3.5, 0.5),
    'CFC10' : (4.5, 0.5),
    'T9' : (-5.0, 0.0),
    'T7' : (-4.0, 0.0),
    'C5' : (-3.0, 0.0),
    'C3' : (-2.0, 0.0),
    'C1' : (-1.0, 0.0),
    'Cz' : (0.0, 0.0),
    'C2' : (1.0, 0.0),
    'C4' : (2.0, 0.0),
    'C6' : (3.0, 0.0),
    'T8' : (4.0, 0.0),
    'T10' : (5.0, 0.0),
    'A1' : (-5.0, -0.5),
    'CCP7' : (-3.5, -0.5),
    'CCP5' : (-2.5, -0.5),
    'CCP3' : (-1.5, -0.5),
    'CCP1' : (-0.5, -0.5),
    'CCP2' : (0.5, -0.5),
    'CCP4' : (1.5, -0.5),
    'CCP6' : (2.5, -0.5),
    'CCP8' : (3.5, -0.5),
    'A2' : (5.0, -0.5),
    'TP9' : (-5.0, -1.0),
    'TP7' : (-4.0, -1.0),
    'CP5' : (-3.0, -1.0),
    'CP3' : (-2.0, -1.0),
    'CP1' : (-1.0, -1.0),
    'CPz' : (0.0, -1.0),
    'CP2' : (1.0, -1.0),
    'CP4' : (2.0, -1.0),
    'CP6' : (3.0, -1.0),
    'TP8' : (4.0, -1.0),
    'TP10' : (5.0, -1.0),
    'PCP9' : (-4.5, -1.5),
    'PCP7' : (-3.5, -1.5),
    'PCP5' : (-2.5, -1.5),
    'PCP3' : (-1.5, -1.5),
    'PCP1' : (-0.5, -1.5),
    'PCP2' : (0.5, -1.5),
    'PCP4' : (1.5, -1.5),
    'PCP6' : (2.5, -1.5),
    'PCP8' : (3.5, -1.5),
    'PCP10' : (4.5, -1.5),
    'P9' : (-5.0, -2.0),
    'P7' : (-4.0, -2.0),
    'P5' : (-3.0, -2.0),
    'P3' : (-2.0, -2.0),
    'P1' : (-1.0, -2.0),
    'Pz' : (0.0, -2.0),
    'P2' : (1.0, -2.0),
    'P4' : (2.0, -2.0),
    'P6' : (3.0, -2.0),
    'P8' : (4.0, -2.0),
    'P10' : (5.0, -2.0),
    'PPO7' : (-4.5, -2.5),
    'PPO5' : (-3.0, -2.5),
    'PPO3' : (-2.0, -2.5),
    'PPO1' : (-0.65, -2.5),
    'PPO2' : (0.65, -2.5),
    'PPO4' : (2.0, -2.5),
    'PPO6' : (3.0, -2.5),
    'PPO8' : (4.5, -2.5),
    'PO9' : (-5.5, -2.6),
    'PO7' : (-4.0, -3),
    'PO5' : (-3.0, -3),
    'PO3' : (-2.0, -3),
    'PO1' : (-1.0, -3),
    'POz' : (0.0, -3),
    'PO2' : (1.0, -3),
    'PO4' : (2.0, -3),
    'PO6' : (3.0, -3),
    'PO8' : (4.0, -3),
    'PO10' : (5.5, -2.6),
    'OPO1' : (-1.5, -3.5),
    'OPO2' : (1.5, -3.5),
    'O9' : (-6.5, -3.5),
    'O1' : (-4.0, -3.5),
    'O2' : (4.0, -3.5),
    'O10' : (6.5, -3.5),
    'Oz' : (0.0, -4.0),
    'OI1' : (1.5, -4.5),
    'OI2' : (-1.5, -4.5),
    'I1' : (1.0, -5),
    'Iz' : (0.0, -5),
    'I2' : (-1, -5)
}


# calculate the (x, y, z) positions for each channel
for k, v in channels.iteritems():
    ea, eb = v[0] * (90 / 4.), v[1] * (90 / 4.)
    ea = ea * pi / 180
    eb = eb * pi / 180
    x = sin(ea) * cos(eb)
    y = sin(eb)
    z = cos(ea) * cos(eb)
    channels[k] = (x, y, z)

