//jQuery OpenID Plugin 1.1 Copyright 2009 Jarrett Vance http://jvance.com/pages/jQueryOpenIdPlugin.xhtml
$.fn.authenticator = function() {
    var signin_page = $(this);
    var signin_form = $('#signin-form');
    var openid_login_token_input = $('input[name=openid_login_token]');
    var openid_login_token_input_fields = $('#openid-fs');
    var provider_name_input = $('input[name=login_provider_name]');
    var email_input_fields = $('#email-input-fs');
    var account_recovery_heading = $('#account-recovery-heading');
    var account_recovery_hint = $('#account-recovery-form>.hint');
    var account_recovery_link = $('#account-recovery-form>.hint>span.link'); 
    var account_recovery_text_span = $('#account-recovery-form>.hint>span.text');
    var password_input_fields = $('#password-fs');
    var existing_login_methods_div = $('#existing-login-methods');
    var openid_submit_button = $('input[name=openid_login_with_extra_token]');
    var existing_login_methods = {};

    var account_recovery_question_text = account_recovery_heading.html();
    var account_recovery_prompt_text = account_recovery_text_span.html();

    var setup_event_handlers = function(elements, handler_function){
        elements.unbind('click').click(handler_function); 
        elements.unbind('keypress').keypress(
            function(e){
                if ((e.which && e.which == 13)||(e.keyCode && e.keyCode == 13)){
                    return handler_function();
                }
            }
        );
    };

    var read_existing_login_methods = function(){
        $('.ab-provider-row').each(
            function(i, provider_row){
                var provider_name = $(
                                    provider_row
                                ).find(
                                    '.ab-provider-name'
                                ).html().trim();
                existing_login_methods[provider_name] = true;
            }
        );
    };

    var setup_login_method_deleters = function(){
        $('.ab-provider-row').each(
            function(i, provider_row){
                var provider_name = $(
                                    provider_row
                                ).find(
                                    '.ab-provider-name'
                                ).html().trim();
                var remove_button = $(
                                    provider_row
                                ).find('button');
                remove_button.click(
                    function(){
                        var message = $.i18n._(
                                                'Are you sure you want to remove ' +
                                                'your {provider} login?'
                                            ).replace(
                                                '{provider}', 
                                                provider_name
                                            );
                        if (confirm(message)){
                            $.ajax({
                                type: 'POST',
                                url: authUrl + 'delete_login_method/',//url!!!
                                data: {provider_name: provider_name},
                                success: function(data, text_status, xhr){
                                    $(provider_row).remove();
                                    delete existing_login_methods[provider_name];
                                    provider_count -=1;
                                    if (provider_count < 0){
                                        provider_count === 0;
                                    }
                                    if (provider_count === 0){
                                        $('#ab-existing-login-methods').remove();
                                        $('#ab-show-login-methods').remove();
                                        $('h1').html(
                                            $.i18n._("Please add one or more login methods.")
                                        );
                                        $('#login-intro').html(
                                            $.i18n._("You don\'t have a method to log in right now, please add one or more by clicking any of the icons below.")
                                        );
                                        existing_login_methods = null;
                                    }
                                },

                            });
                        }
                    }
                );
            }
        );
    }

    var submit_login_with_password = function(){
        var username = $('#id_username');
        var password = $('#id_password');
        if (username.val().length < 1){
            username.focus();
            return false;
        }
        if (password.val().length < 1){
            password.focus();
            return false;
        }
        return true;
    };

    var submit_change_password = function(){
        var newpass = $('#id_new_password');
        var newpass_retyped = $('#id_new_password_retyped');
        if (newpass.val().length < 1){
            newpass.focus();
            return false
        }
        if (newpass_retyped.val().length < 1){
            newpass_retyped.focus();
            return false;
        }
        if (newpass.val() !== newpass_retyped.val()){
            newpass_retyped.after(
                    '<span class="error">' +
                    $.i18n._('passwords do not match') + 
                    '</span>'
                );
            newpass.val('').focus();
            newpass_retyped.val('');
            return false;
        }
        return true;
    };

    //validator, may be extended to check url for openid
    var submit_with_extra_openid_token = function() {
        if (openid_login_token_input.val().length < 1) {
            openid_login_token_input.focus();
            return false;
        }
        return true;
    };

    var insert_login_list_enabler = function(){
        var enabler = $('#login-list-enabler');
        if (enabler.is('p#login-list-enabler')){
            enabler.show();
        }
        else {
            enabler = $(
                    '<p id="login-list-enabler"><a href="#">' +
                    $.i18n._('Show/change current login methods') +
                    '</a></p>');
            setup_event_handlers(
                enabler,
                function(){
                    password_input_fields.hide();
                    openid_login_token_input_fields.hide();
                    enabler.hide();
                    existing_login_methods_div.show();
                }
            );
            existing_login_methods_div.after(enabler);
        }
    };

    var reset_password_input_fields = function(){
        if (userIsAuthenticated){
            $('#id_new_password').val('');
            $('#id_new_password_retyped').val('');
        }
        else {
            $('#id_username').val('');
            $('#id_password').val('');
        }
    };

    var reset_form = function(){
        openid_login_token_input_fields.hide();
        password_input_fields.hide();
        reset_password_input_fields();
        $('.error').remove();
        if (userIsAuthenticated === false){
            email_input_fields.hide();
            account_recovery_heading.hide();
            account_recovery_link.show();
            account_recovery_hint.show();
            $('#account-recovery-form>p.hint').css('margin-top','10px');
            account_recovery_text_span.html(account_recovery_question_text).show();
        }
        else {
            if (existing_login_methods !== null){
                existing_login_methods_div.hide();
                insert_login_list_enabler();
            }
        }
    };

    var set_provider_name = function(element){
        var provider_name = element.attr('name');
        provider_name_input.val(provider_name);
    };

    var show_openid_input_fields = function(provider_name){
        reset_form();
        var token_name = extra_token_name[provider_name]
        if (userIsAuthenticated){
            var heading_text = $.i18n._(
                'Please enter your {token_name}, then proceed'
            );
            $('#openid-heading').html(
                heading_text.replace('{token_name}', token_name)
            );
            var button_text = $.i18n._('Connect your {provider_name} account to {site}');
            button_text = button_text.replace(
                                '{provider_name}', provider_name
                            ).replace(
                                '{site}', siteName
                            );
            openid_submit_button.val(button_text);
        } 
        else {
            $('#openid-heading>span').html(token_name);
        }
        openid_login_token_input_fields.show();
        openid_login_token_input.focus();
    };

    var start_simple_login = function() {
        //$('#openid_form .providers td').removeClass('highlight');
        //$li.addClass('highlight');
        set_provider_name($(this));
        signin_form.submit();
        return true;
    };

    var start_login_with_extra_openid_token = function() {
        show_openid_input_fields($(this).attr('name'));
        set_provider_name($(this));
        setup_event_handlers(
            openid_submit_button,
            function(){
                signin_form.unbind(
                                'submit'
                            ).submit(
                                submit_with_extra_openid_token
                            );
            }
        );
        return false;
    };

    var start_facebook_login = function(){
        set_provider_name($(this));
        if (typeof FB != 'undefined'){
            FB.login();
            //FB.getLoginStatus(function(response){
            //    if (response.session){
            //        alert('you are logged in');
            //    }
            //    else {
            //    }
            //});
        }
        return false;
    };

    var start_password_login_or_change = function(){
        reset_form();
        set_provider_name($(this));
        var provider_name = $(this).attr('name');
        var token_name = extra_token_name[provider_name]
        var password_action_input = $('input[name=password_action]');
        if (userIsAuthenticated === true){
            var password_button = $('input[name=change_password]');
            var submit_action = submit_change_password;
            if (existing_login_methods && existing_login_methods[provider_name]){
                var change_pw_heading = 'Change your {provider} password';
                var password_heading_text = $.i18n._(change_pw_heading);
                var password_button_text = $.i18n._('Change password');
            }
            else {
                var create_pw_heading = 'Create a password for {provider}';
                var password_heading_text = $.i18n._(create_pw_heading);
                var password_button_text = $.i18n._('Create password');
            }
            if (provider_name === 'local'){
                var provider_cleaned_name = siteName;
            }
            else {
                var provider_cleaned_name = provider_name;
            }
            $('#password-heading').html(
                password_heading_text.replace('{provider}', provider_cleaned_name)
            )
            password_button.val(password_button_text);
            password_action_input.val('change_password');
        }
        else{
            $('#password-heading>span').html(token_name);
            var password_button = $('input[name=login_with_password]');
            var submit_action = submit_login_with_password;
            var create_pw_link = $('a.create-password-account')
            create_pw_link.html($.i18n._('Create a password-protected account'));
            var url = create_pw_link.attr('href');
            if (url.indexOf('?') !== -1){
                url = url.replace(/\?.*$/,'?login_provider=' + provider_name);
            }
            else{
                url += '?login_provider=' + provider_name;
            }
            create_pw_link.attr('href', url);
            password_action_input.val('login');
        }
        password_input_fields.show();
        setup_event_handlers(
            password_button,
            function(){
                signin_form.unbind(
                                'submit'
                            ).submit(
                                submit_action
                            );
            }
        );
        return false;
    };

    var start_account_recovery = function(){
        reset_form();
        account_recovery_hint.hide(); 
        account_recovery_heading.css('margin-bottom', '0px');
        account_recovery_heading.html(account_recovery_prompt_text).show();
        email_input_fields.show();
        $('#id_email').focus();
    };

    var clear_password_fields = function(){
        $('#id_password').val('');
        $('#id_new_password').val('');
        $('#id_new_password_retyped').val('');
    };

    setup_event_handlers(
        signin_page.find('input.openid-direct'),
        start_simple_login
    );

    setup_event_handlers(
        signin_page.find('input.openid-username'),
        start_login_with_extra_openid_token
    );

    setup_event_handlers(
        signin_page.find('input.openid-generic'),
        start_login_with_extra_openid_token
    );

    setup_event_handlers(
        signin_page.find('input.facebook'),
        start_facebook_login
    );

    setup_event_handlers(
        signin_page.find('input.oauth'),
        start_simple_login
    );

    setup_event_handlers( 
        signin_page.find('input.password'),
        start_password_login_or_change
    );

    setup_event_handlers(account_recovery_link, start_account_recovery);
    if (userIsAuthenticated){
        read_existing_login_methods();
        setup_login_method_deleters();
    }

    clear_password_fields();
    return this;
};
