import gzip
import json
from pkg_resources import resource_filename

from Bio.SeqUtils.CheckSum import seguid


# TODO: load on demand
seguid_acs = json.loads(gzip.open(resource_filename('bdi','/data/refseq-protein-seguid-acs.json.gz')).read())
def aaseq_to_ac(seq):
    "placeholder function that returns an accession for a given amino acid sequence"
    seq = seq.rstrip('*')
    hash = seguid(seq)
    try:
        return seguid_acs[hash][0]
    except KeyError:
        return 'SEGUID_' + hash

## <LICENSE>
## Copyright 2014 BDI Contributors (https://bitbucket.org/invitae/bdi)
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
## </LICENSE>
