/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.browser.BrowserControl;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.model.RunData;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserStartupAction
implements Action {
    private final Set<BrowserRunner> browsers;
    private final String captureAddress;
    private final JsTestDriverClient client;
    private final ExecutorService executor;
    private final BrowserControl.BrowserControlFactory browserControlFactory;

    @Inject
    public BrowserStartupAction(Set<BrowserRunner> browsers, JsTestDriverClient client, @Named(value="captureAddress") String captureAddress, ExecutorService executor, BrowserControl.BrowserControlFactory browserControlFactory) {
        this.browsers = browsers;
        this.client = client;
        this.captureAddress = captureAddress;
        this.executor = executor;
        this.browserControlFactory = browserControlFactory;
    }

    @Override
    public RunData run(final RunData runData) {
        ArrayList<Future<String>> browserIds = Lists.newArrayListWithCapacity(this.browsers.size());
        for (final BrowserRunner browserRunner : this.browsers) {
            browserIds.add(this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return BrowserStartupAction.this.browserControlFactory.create(browserRunner, BrowserStartupAction.this.captureAddress, runData.getTestCases()).captureBrowser(BrowserStartupAction.this.client.getNextBrowserId());
                }
            }));
        }
        for (Future future : browserIds) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return runData;
    }

    public Set<BrowserRunner> getBrowsers() {
        return this.browsers;
    }

    public String getServerAddress() {
        return this.captureAddress;
    }
}

