/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.JstdTestCaseDelta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JstdTestCaseStore {
    private static final Logger logger = LoggerFactory.getLogger(JstdTestCaseStore.class);
    private final ConcurrentMap<String, JstdTestCase> cases = new ConcurrentHashMap<String, JstdTestCase>();
    private final FilesCache files = new FilesCache(Maps.<String, FileInfo>newHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstdTestCaseDelta addCase(JstdTestCase testCase) {
        JstdTestCase updatedTestCase;
        FilesCache filesCache = this.files;
        synchronized (filesCache) {
            updatedTestCase = testCase.applyDelta(new JstdTestCaseDelta(this.updateCache(testCase.getDependencies()), this.updateCache(testCase.getTests()), this.updateCache(testCase.getPlugins())));
        }
        logger.info("adding TestCase {} to {}", (Object)testCase.getId(), (Object)this);
        this.cases.put(testCase.getId(), updatedTestCase);
        return updatedTestCase.createUnloadedDelta();
    }

    private List<FileInfo> updateCache(List<FileInfo> newFiles) {
        ArrayList<FileInfo> replace = Lists.newArrayList();
        for (FileInfo file : newFiles) {
            FileInfo oldFile = this.files.getFile(file.getDisplayPath());
            if (oldFile == null) {
                this.files.addFile(file);
                logger.debug("adding {}", (Object)file.getDisplayPath());
                continue;
            }
            if (oldFile.shouldReplaceWith(file)) {
                logger.debug("replacing {}", (Object)oldFile.getDisplayPath());
                this.files.addFile(file);
                continue;
            }
            if (file.isLoaded()) {
                logger.debug("updating {} (loaded)", (Object)file.getDisplayPath());
                this.files.addFile(file);
                continue;
            }
            if (oldFile.isLoaded() && !file.isLoaded()) {
                logger.debug("not replacing {}", (Object)file.getDisplayPath());
                replace.add(oldFile);
                continue;
            }
            logger.debug("files are equal {}", (Object)file.getDisplayPath());
        }
        return replace;
    }

    public Collection<JstdTestCase> getCases() {
        return this.cases.values();
    }

    public JstdTestCase getCase(String testCaseId) {
        if (testCaseId == null) {
            return null;
        }
        return (JstdTestCase)this.cases.get(testCaseId);
    }

    public String getFileContent(String path) {
        return this.files.getFileContent(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDelta(JstdTestCaseDelta delta) {
        Object object = this.files;
        synchronized (object) {
            this.updateCache(delta.getDependencies());
            this.updateCache(delta.getTests());
            this.updateCache(delta.getPlugins());
        }
        object = this.cases;
        synchronized (object) {
            HashMap applied = Maps.newHashMap();
            for (Map.Entry entry : this.cases.entrySet()) {
                applied.put(entry.getKey(), ((JstdTestCase)entry.getValue()).applyDelta(delta));
            }
            this.cases.putAll(applied);
        }
    }
}

