/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Objects;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Lock;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.commands.NoopCommand;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.PageType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveBrowser {
    private static final String CLIENT_CONSOLE_RUNNER = "/slave/id/%s/page/CONSOLE/mode/%s/timeout/%s/upload_size/%s/rt/" + (Object)((Object)RunnerType.CLIENT);
    private static final String STANDALONE_CONSOLE_RUNNER = "/runner/id/%s/page/RUNNER/mode/%s/timeout/%s/upload_size/%s/rt/" + (Object)((Object)RunnerType.STANDALONE);
    private static final String BROWSER_CONTROLLED_RUNNER = "/bcr/id/%s/page/" + (Object)((Object)PageType.VISUAL_STANDALONE_RUNNER) + "/mode/%s/" + "timeout" + "/%s/" + "upload_size" + "/%s/" + "rt" + "/" + (Object)((Object)RunnerType.BROWSER);
    private static final Logger LOGGER = LoggerFactory.getLogger(SlaveBrowser.class);
    public static final long TIMEOUT = 30000L;
    public static final long SESSION_TIMEOUT = 2000L;
    private static final int POLL_RESPONSE_TIMEOUT = 2;
    private final Time time;
    private final String id;
    private final BrowserInfo browserInfo;
    private final BlockingQueue<Command> commandsToRun = new LinkedBlockingQueue<Command>();
    private long dequeueTimeout = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private AtomicReference<Instant> lastHeartbeat;
    private Set<FileInfo> fileSet = new LinkedHashSet<FileInfo>();
    private final BlockingQueue<StreamMessage> responses = new LinkedBlockingQueue<StreamMessage>();
    private AtomicReference<Command> commandRunning = new AtomicReference<Object>(null);
    private AtomicReference<Command> lastCommandDequeued = new AtomicReference<Object>(null);
    private final long timeout;
    private final Lock lock = new Lock();
    private final HandlerPathPrefix prefix;
    private final String mode;
    private final RunnerType type;
    private AtomicReference<BrowserState> state;
    private ConcurrentMap<FileResult, Boolean> fileResults = new ConcurrentHashMap<FileResult, Boolean>();

    public SlaveBrowser(Time time, String id, BrowserInfo browserInfo, long timeout, HandlerPathPrefix prefix, String mode, RunnerType type, BrowserState state) {
        this.time = time;
        this.timeout = timeout;
        this.id = id;
        this.browserInfo = browserInfo;
        this.prefix = prefix;
        this.mode = mode;
        this.type = type;
        this.state = new AtomicReference<BrowserState>(state);
        this.lastHeartbeat = new AtomicReference<Instant>(new Instant(0L));
    }

    public String getId() {
        return this.id;
    }

    public boolean tryLock(String sessionId) {
        boolean success = this.lock.tryLock(sessionId);
        if (success) {
            this.heartBeatLock(sessionId);
        }
        return success;
    }

    public void unlock(String sessionId) {
        this.lock.unlock(sessionId);
    }

    public void forceUnlock() {
        this.lock.forceUnlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public void heartBeatLock(String sessionId) {
        if (Objects.equal(this.lock.getSessionId(), sessionId)) {
            this.lock.setLastHeartBeat(this.time.now().getMillis());
        } else {
            LOGGER.error("Session heartbeat {} without a session on {}", (Object)sessionId, (Object)this.browserInfo);
        }
    }

    public void createCommand(String data) {
        try {
            this.commandsToRun.put(new Command(data));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command dequeueCommand() {
        try {
            Command command = this.commandsToRun.poll(this.dequeueTimeout, this.timeUnit);
            LOGGER.trace("dequeue {}", command);
            SlaveBrowser slaveBrowser = this;
            synchronized (slaveBrowser) {
                if (command != null) {
                    this.commandRunning.set(command);
                    this.lastCommandDequeued.set(command);
                    return command;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new NoopCommand();
    }

    public Command getLastDequeuedCommand() {
        return this.lastCommandDequeued.get();
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setDequeueTimeout(long dequeueTimeout, TimeUnit timeUnit) {
        this.dequeueTimeout = dequeueTimeout;
        this.timeUnit = timeUnit;
    }

    public synchronized void heartBeat() {
        this.lastHeartbeat.set(this.time.now());
        this.state.set(BrowserState.HEARTBEAT);
        this.browserInfo.setServerReceivedHeartbeat(true);
    }

    public Instant getLastHeartbeat() {
        return this.lastHeartbeat.get();
    }

    public boolean receivedHeartbeat() {
        return this.lastHeartbeat.get().getMillis() != 0L;
    }

    public synchronized void ready() {
        this.state.set(BrowserState.READY);
        this.browserInfo.setReady(true);
    }

    public double getSecondsSinceLastHeartbeat() {
        return !this.receivedHeartbeat() ? -1.0 : (double)(this.time.now().getMillis() - this.lastHeartbeat.get().getMillis()) / 1000.0;
    }

    public synchronized void addFiles(Collection<FileInfo> fileSet, LoadedFiles loadedFiles) {
        this.fileSet.removeAll(fileSet);
        this.fileSet.addAll(fileSet);
    }

    public Set<FileInfo> getFileSet() {
        return this.fileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFileSet() {
        LOGGER.debug("Resetting fileSet for {}", this);
        SlaveBrowser slaveBrowser = this;
        synchronized (slaveBrowser) {
            this.fileSet.clear();
            this.fileResults.clear();
        }
    }

    public StreamMessage getResponse() {
        try {
            StreamMessage message = this.responses.poll(2L, TimeUnit.SECONDS);
            if (message == null) {
                LOGGER.trace("responses size {}", this.responses.size());
                message = new StreamMessage(false, new Response(Response.ResponseType.UNKNOWN.name(), "{}", this.browserInfo, "", 0L));
            } else {
                LOGGER.trace("returning type {}", (Object)message.getResponse().getResponseType());
            }
            return message;
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception during poll {}", e);
            return new StreamMessage(false, new Response(Response.ResponseType.UNKNOWN.name(), "{}", this.browserInfo, "", 0L));
        }
    }

    public void addResponse(Response response, boolean isLast) {
        if (isLast) {
            this.commandRunning.set(null);
        }
        LOGGER.debug("adding response type {} done: {}", (Object)response.getResponseType(), (Object)isLast);
        this.responses.offer(new StreamMessage(isLast, response));
    }

    public void clearResponseQueue() {
        this.responses.clear();
    }

    public boolean isCommandRunning() {
        return this.commandRunning.get() != null;
    }

    public Command getCommandRunning() {
        return this.commandRunning.get();
    }

    public Command peekCommand() {
        return (Command)this.commandsToRun.peek();
    }

    public void clearCommandRunning() {
        if (this.commandRunning != null) {
            this.commandRunning.set(null);
            this.commandsToRun.clear();
            this.responses.clear();
        }
    }

    public boolean isAlive() {
        boolean alive;
        boolean bl = alive = this.receivedHeartbeat() && (this.time.now().getMillis() - this.lastHeartbeat.get().getMillis() < this.timeout || this.timeout == -1L);
        if (!alive) {
            this.state.set(BrowserState.DEAD);
            LOGGER.debug("Browser dead: {}", (Object)this.toString());
        }
        return alive;
    }

    public String getCaptureUrl() {
        switch (this.type) {
            case CLIENT: {
                return this.prefix.prefixPath(String.format(CLIENT_CONSOLE_RUNNER, this.id, this.mode, this.timeout, this.browserInfo.getUploadSize()));
            }
            case STANDALONE: {
                return this.prefix.prefixPath(String.format(STANDALONE_CONSOLE_RUNNER, this.id, this.mode, this.timeout, this.browserInfo.getUploadSize()));
            }
            case BROWSER: {
                return this.prefix.prefixPath(String.format(BROWSER_CONTROLLED_RUNNER, this.id, this.mode, this.timeout, this.browserInfo.getUploadSize()));
            }
        }
        throw new UnsupportedOperationException("Unsupported Runner type: " + (Object)((Object)this.type));
    }

    public String toString() {
        return String.format("SlaveBrowser(browserInfo=%s,\n\tid=%s,\n\tsinceLastCheck=%ss,\n\ttimeout=%s)", this.browserInfo, this.id, this.getSecondsSinceLastHeartbeat(), this.timeout);
    }

    public boolean inUse() {
        return this.time.now().getMillis() - this.lock.getLastHeartBeat() <= 2000L;
    }

    public synchronized void resetCommandQueue() {
        LOGGER.debug("resetCommandQueue: queued[{}]\n running:[{}]", this.commandsToRun, this.commandRunning);
        this.clearCommandRunning();
        this.commandsToRun.clear();
    }

    public void addFileResults(Collection<FileResult> allLoadedFiles) {
        for (FileResult fileResult : allLoadedFiles) {
            FileSource fileSource = fileResult.getFileSource();
            this.fileSet.add(fileSource.toFileInfo(null));
            this.fileResults.put(fileResult, true);
        }
    }

    public boolean hasFileLoadErrors() {
        for (FileResult result : this.fileResults.keySet()) {
            if (result.isSuccess()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowserState {
        CAPTURED,
        READY,
        HEARTBEAT,
        DEAD;

    }
}

