/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Singleton;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.hooks.TestListener;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TestResultHolder
implements TestListener {
    private final Multimap<BrowserInfo, TestResult> results = Multimaps.synchronizedMultimap(this.createMultiMap(Maps.newLinkedHashMap()));
    private final Multimap<BrowserInfo, TestCase> testCases = Multimaps.synchronizedMultimap(this.createMultiMap(Maps.newLinkedHashMap()));
    private Multimap<BrowserInfo, FileResult> fileResults = Multimaps.synchronizedMultimap(this.createMultiMap(Maps.newLinkedHashMap()));

    private <T> Multimap<BrowserInfo, T> createMultiMap(Map<BrowserInfo, Collection<T>> map) {
        LinkListSupplier collectionSupplier = new LinkListSupplier();
        Multimap<BrowserInfo, T> resultMultimap = Multimaps.newMultimap(map, collectionSupplier);
        return resultMultimap;
    }

    public Multimap<BrowserInfo, TestResult> getResults() {
        return this.results;
    }

    public Multimap<BrowserInfo, TestCase> getCases() {
        return this.testCases;
    }

    public Multimap<BrowserInfo, FileResult> getFileResults() {
        return this.fileResults;
    }

    @Override
    public void onTestComplete(TestResult testResult) {
        this.results.put(testResult.getBrowserInfo(), testResult);
    }

    @Override
    public void finish() {
    }

    @Override
    public void onFileLoad(BrowserInfo browser, FileResult fileResult) {
    }

    @Override
    public void onTestRegistered(BrowserInfo browser, TestCase testCase) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinkListSupplier<T>
    implements Supplier<Collection<T>> {
        private LinkListSupplier() {
        }

        @Override
        public Collection<T> get() {
            return Lists.newLinkedList();
        }
    }
}

