"""
Serialize data to/from JSON
"""
from django.utils import simplejson
from json import Serializer as JsonSerializer
from django.core.serializers.json import Deserializer as JSONDeserializer, \
    DjangoJSONEncoder
from django.http import HttpResponse

class Serializer(JsonSerializer):
    """
    Wrap a json serializer in an HttpResponse
    """

    def getvalue(self):
        return HttpResponse(super(Serializer, self).getvalue())


Deserializer = JSONDeserializer
