#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
    manage
    ~~~~~~
"""
import subprocess
from flask.ext.script import Shell, Manager, prompt_bool
from flask.ext.script.commands import ShowUrls,Clean
from flask.ext.xxl.mr_bob import manager as mrbob_manager
from flask.ext.alembic.cli.script import manager as alembic_manager
from app import app
from ext import db,alembic

manager = Manager(app)



@manager.command
def init_data():
    """Fish data for project"""
    if prompt_bool('Do you want to kill your db?'):
    try:
        db.drop_all()
    except:
        pass
    try:
        db.create_all()
    except:
        pass

manager.add_command('shell', Shell(make_context=lambda:{'app': app, 'db': db}))


if __name__ == '__main__':
    manager.add_command('clean',Clean())
    manager.add_command('urls',ShowUrls())
    manager.add_command('mrbob',mrbob_manager)
    manager.add_command('db',alembic_manager)
    manager.run()
