#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of python-gnupg, a Python interface to GnuPG.
# Copyright © 2013 Isis Lovecruft
#           © 2008-2012 Vinay Sajip
#           © 2005 Steve Traugott
#           © 2004 A.M. Kuchling
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

from __future__ import absolute_import

from .         import gnupg
from .         import copyleft
from .         import _ansistrm
from .         import _logger
from .         import _meta
from .         import _parsers
from .         import _util
from .gnupg    import GPG
from ._version import get_versions

__version__  = get_versions()['version']
__authors__  = copyleft.authors
__license__  = copyleft.full_text
__copyleft__ = copyleft.copyright

## do not set __package__ = "gnupg", else we will end up with
## gnupg.<*allofthethings*>
__all__ = ["GPG", "_util", "_parsers", "_meta", "_logger"]

## avoid the "from gnupg import gnupg" idiom
del gnupg
del absolute_import
del copyleft
del get_versions
del _version
