#!/usr/bin/python

import os
import sys
import xml.sax
import urllib2
import logging
import traceback
import re
import json
from grayson.common.util import GraysonUtil

''' A graph node '''
class Node:
	def __init__(self, anid, nodeLabel, nodeType):
		self.id = anid
		self.type = nodeType
		self.label = nodeLabel
		self.context = {}
	def getId (self):
		return self.id
	def getType (self):
		return self.type
	def setType (self, type):
		self.type = type
	def getLabel (self):
		return self.label
	def setLabel (self, label):
		self.label = label
	def setContext (self, context):
		self.context = context
	def getContext (self):
		return self.context

''' A gaph edge '''
class Edge:
	def __init__(self, anid, source, target, type):
		self.id = anid
		self.type = type
		self.source = source
		self.target = target
	def getId (self):
		return self.id
	def setType (self, type):
		self.type = type
	def getType (self):
		return self.type
	def setSource (self, source):
		self.source = source
	def getSource (self):
		return self.source
	def setTarget (self, target):
		self.target = target
	def getTarget (self):
		return self.target
	def getLabel (self):
		return self.id

''' A graph '''
class Graph:
	def __init__(self):
		self.nodes = []
		self.edges = []
		self.nodeMap = {}
		self.nodeLabelMap = {}
		self.properties = None
		self.propertyList = []
		self.fileNames = []
		self.edgeMap = {}
	def addFileName (self, fileName):
		if not fileName in self.fileNames:
			self.fileNames.append (fileName)
	def addProperties (self, properties):
		self.propertyList.append (properties)
	def getPropertyList (self):
		return self.propertyList
	def setProperties (self, properties):
		self.properties = properties
	def getProperties (self):
		return self.properties
	def getNodes (self):
		return self.nodes
	def getNode (self, id):
		return self.nodeMap[id] if id in self.nodeMap else None
	def getNodeByLabel (self, label):
		return self.nodeLabelMap [label] if label in self.nodeLabelMap else None
	def getNodeIdByLabel (self, label):
		node = self.getNodeByLabel (label)
		return node.getId () if node else None
	def addNode (self, id, label, type="{}"):
		node = Node (id, label, type)
		self.addExistingNode (node)
		return node
	def addExistingNode (self, node):
		self.nodes.append (node)
		self.nodeMap[node.getId()] = node
		self.nodeLabelMap[node.getLabel()] = node
		return node
	def removeNode (self, id):
		for node in self.nodes:
			if node.getId () == id:
				self.nodes.remove (node)
		if node.getId () in self.nodeMap:
			del self.nodeMap [node.getId ()]
		if node.getLabel () in self.nodeLabelMap:
			del self.nodeLabelMap [node.getLabel ()]
	def getEdges (self):
		return self.edges

	def addEdge (self, id, source, target, type="{}"):
		edge = Edge (id, source, target, type)
		self.edges.append (edge)
		key = self.getEdgeKey(edge.getSource (), edge.getTarget ())
		self.edgeMap [key] = edge
		return edge

	def getEdgeKey (self, source, target):
		return "%s->%s" % (ed, source, target)

	def getEdge (self, source, target):
		key = self.getEdgeKey (source, target)
		return self.edgeMap [key] if key in self.edgeMap else None
			
	def removeEdge (self, edge):
		self.edges.remove (edge)
	def dump (self):
		for node in self.nodes:
			typeText = None
			type = node.getType ()
			if type:
				typeText = type.replace ("\n", "")
			logging.debug ("--node (%s(%s)(%s)) ", node.getId (), node.getLabel (), typeText)
		for edge in self.edges:
			logging.debug ("edge: src: %s trg: %s", edge.getSource (), edge.getTarget ())
			try:
				source = self.nodeMap [edge.getSource ()]
				target = self.nodeMap [edge.getTarget ()]
				if not source:
					targetText = target.getLabel () if target else " unknown target"
					logging.debug ( "unable to find node for source id %s with target %s", edge.getSource (), targetText)
				elif not target:
					sourceText = source.getLabel () if source else " unknown source"
					logging.debug ("unable to find node for target id %s with source %s", edge.getTarget (), sourceText)
				else:
					logging.debug ("--edge(id=%s)(src=(id=%s):%s, dst=(id=%s):%s), type(%s)",
					       edge.getId(), 
						       source.getId (),
						       source.getLabel (), 
						       target.getId (), 
						       target.getLabel (),
						       edge.getType ())
			except Exception as ex:
				pass


""" GraphML parser """
class JSONHandler (object):
        def __init__(self, graph=None):
                self.elements = []
		self.idPrefix = 1
		if graph:
			self.graph = graph
			for node in graph.nodes:
				id = node.getId ()
				if id:
					match = re.match ("([0-9]+).*", id)
					if match:
						prefix = int (match.group (1))
						if prefix > self.idPrefix:
							logging.debug ( "setting prefix: %s", prefix)
							self.idPrefix = prefix + 1
		else:
			self.graph = Graph ()

		self.source = None
		self.target = None
		self.type = None
		self.edgeId = None
		self.label = None
		self.nodeId = 0
		self.nodeType = None
		self.isDescription = False

	def parse (self, stream):
		#data = GraysonUtil.readFile (file)
		data = stream.read ()
		stream.close ()

		print "--------> \n%s" % data
		model = json.loads (data)

		self.deleteComment (model)
		# Read nodes		
		syntax = {
			"file"     : True,
			"job"      : False,
			"abstract" : False,
			"context"  : True,
			"workflow" : True
			}
		for (key, value) in syntax.items ():
			self.parseElement (elementKey       = key,
					   model            = model,
					   allowListVariant = value)
		# Make edges
		nodes = self.graph.getNodes ()
		for node in nodes:
			obj = node.getType ()
			if hasattr (obj, 'in'):
				src = obj ['in']
				del obj ['in']
				if isinstance (src, basestring):
					fro = self.getNode (src)
					self.mapEdge (fro = fro, to = node)
				elif isinstance (src, list):
					for item in src:
						fro = self.getNode (item)
						self.mapEdge (fro = fro, to = node)
						
			if hasattr (obj, 'out'):
				output = obj ['out']
				del obj ['out']
				if isinstance (output, basestring):					
					to = self.getNode (output)
					self.mapEdge (fro = node, to = to)
				elif isinstance (output, list):
					for item in output:
						to = self.getNode (item)
						self.mapEdge (fro = node, to = to)
					
		# Flatten type objects
		for node in nodes:
			text = unicode (json.dumps (node.getType (),
						    sort_keys=True,
						    indent=2,
						    separators=(',',':')))
			print text
			node.setType (text)


	def mapEdge (self, fro, to):
		edge = None
		if fro:
			edge = self.getEdge (fro.getId (), to.getId ())
		else:
			raise ValueError ("Unable to find %s in relationship: %s->%s" % (fro.getLabel (), fro.getLabel (), to.getLabel ()))
		return edge

	def parseElement (self, elementKey, model, allowListVariant = False):
		if elementKey in model:
			element = model [elementKey]
			if allowListVariant:
				if isinstance (element, basestring):
					logging.info ("--element(%s) %s", elementKey, element)
					node = self.getNode (element,
							     { "type" : elementKey })
				elif isinstance (element, list):
					for key in element:
						logging.info ("--element(%s) %s", elementKey, key)
						node = self.getNode (key,
								     { "type" : elementKey })						
				else:
					raise ValueError ("%s list items must be strings in this syntax variant." % elementKey)
			elif isinstance (element, dict):
				for (key, item) in element.items ():
					if not 'type' in item:
						item ["type"] = elementKey
					self.deleteComment (item)
					node = self.getNode (key, item)
			else:
				raise ValueError ("Invalid syntax for %s list element" % elementKey)
	def deleteComment (self, obj):
		if 'comment' in obj:
			del obj ['comment']
			
	def nextFile (self):
		self.idPrefix += 1

	def getNode (self, name, obj = None):
		node = self.graph.getNodeByLabel (name)
		if not node and obj:
			id = "%s%s%s" % (self.idPrefix, "n", self.nodeId)
			self.nodeId = self.nodeId + 1
			node = self.graph.addNode (id, name, obj)
			#obj ["id"] = id
			node.setType (obj)
		return node
	def getEdge (self, source, target):
		return self.graph.getEdge (source, target)
        def endElement (self, element):
                self.elements = self.elements[1:]
                if element == "node":

			node = self.graph.addNode (self.nodeId, self.label, self.nodeType)
			label = node.getLabel ()
			if label == "properties" or label == "Properties":
				self.graph.addProperties (node)
				logging.debug ("graphml:parse:properties: %s", node.getType ())
			self.nodeId = None
			self.nodeType = None
			self.label = None
		elif element == "edge":
			self.graph.addEdge (self.edgeId, self.source, self.target, self.nodeType)
			self.nodeType = None
			self.source = None
			self.target = None
			self.edgeId = None
		self.isDescription = False			
	def endDocument (self):
		x = 0
		
class JSONParser (object):
	def __init__(self): pass	

	def parseStream (self, stream, url, handler):
		logging.debug ("parser-stream-url: %s" % url)
		handler.parse (stream)
		handler.graph.addFileName (os.path.realpath (url))

	def parseURL (self, url, handler, path=[]):
		stream = None
		HTTP = "http://"
		if not "" in path:
			path.append ("")
		if url.startswith (HTTP):
			stream = urllib2.urlopen (url)
		elif os.path.exists (url):
			stream = open (url)
			self.parseStream (stream, url, handler)
		else:
			parts = url.rsplit (".")
			if len(parts) >= 3: # <package>.<package>.<model>.graphml
				numParts = len (parts)
				packagePath = ""
				for element in parts [ 0 : numParts - 2 ]:
					packagePath = os.path.join (packagePath, element)
				modelName = "%s.%s" % (parts [ numParts - 2 ],
						       parts [ numParts - 1 ])
				url = os.path.join (packagePath, "model", modelName)
			for prefix in path:
				if prefix == "":
					newUrl = url
				else:
					newUrl = "%s/%s" % (prefix, url)
				logging.debug ("parser-detect-url:%s" % newUrl)
				if newUrl.startswith (HTTP):
					stream = urllib2.urlopen (newUrl)
				elif os.path.isfile (newUrl):
					stream = open (newUrl)
				if stream:
					self.parseStream (stream, newUrl, handler)
					break
		if not stream:
			raise ValueError ("unable to find model: %s" % url)
	def parse (self, fname):
		handler = JSONHandler ()
		self.parseURL (fname, handle)
		return handler.graph
	def parseMultiple (self, fileNames, path=[], graph=None):
		handler = JSONHandler (graph)
		for fileName in fileNames:
			self.parseURL (fileName, handler, path)
			handler.nextFile ()
		return handler.graph
	'''
	def parseString (self, string):
		handler = JSONHandler ()
		xml.sax.parseString (string, handler)
		return handler.graph
		'''

__version__ = '0.1'
__all__ = [ "Node", "Edge", "JSONParser", "Graph" ]
__author__ = 'Steve Cox <scox@renci.org>'

