# -*- encoding: UTF-8 -*-
# 
# This a project generated by Pyjama with default layout
# 
# Copyright (C) 2012  maemo
# 
# This program is free software: you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation, either version 3 of the License,
# or (at your option) any later version.
# 
# This program is distributed in the hope that it will
# be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
# 
# You should have received a copy of the GNU General
# Public License along with this program. If not, see
# <http://www.gnu.org/licenses/>
# 


'''
Created on 01 March 2012 04:19:29

@author: maemo
'''

import logging
import pickle
import os
import os.path

from model import *
from persistence import dao

from ..common import version 

version.getInstance().submitRevision("$Revision: 47 $")


'''
Facade functions
'''

def get_mougeon_storage_dir():
    '''
    Compute the application storage dir.
    This is an utility function to retrieve the directory where mougeon can
    store any file like settings or cached data.
    '''
    storage = os.path.expanduser("~")    
    storage = os.path.join(storage, ".mougeon")
    return storage



class mougeon(object):
    '''
    Main class of the Program. The GUI use this class like a Facade to any core functions.
    '''
    
    def __init__(self):        
        self._ensure_mougeon_conf_store() 
        self._ensure_mougeon_data_store()       
        self.settings = None        
        self.load_settings()        
        self.apply_settings()

    def get_mougeon_settings_file(self):
        storage = get_mougeon_storage_dir()
        storage = os.path.join(storage, "settings.pickle")
        return storage

    def load_settings(self):
        '''
        load the saved settings
        '''
        self._ensure_mougeon_conf_store()
        storage = self.get_mougeon_settings_file()
        try:           
            file = open(storage,'rb')
            self.settings = pickle.load(file)
            file.close()
        except IOError, EOFError:
            logging.warning("failed to load the settings")
            self.settings  = Settings()
            
    
    def save_settings(self):
        '''
        save the current settings
        '''
        self._ensure_mougeon_conf_store()
        storage = self.get_mougeon_settings_file()
        try:           
            file = open(storage,'wb')
            pickle.dump(self.settings,file)
            file.close()
        except IOError:
            logging.warning("failed to save the settings")

    
    def apply_settings(self):        
       pass
                               
    
    def _ensure_mougeon_conf_store(self):
        storage = get_mougeon_storage_dir()
        if os.path.exists(storage):
            pass
        else:
            os.makedirs(storage)

    def _ensure_mougeon_data_store(self):
        storage = get_mougeon_storage_dir()
        storage = os.path.join(storage, "mougeon.db")
        dao.DATABASE_URL = storage
        dao.checkStorage()
        
    '''
    Facade method
    '''
        
    
    def get_settings(self):
        return self.settings
    
    def start_tracker_record(self):
        TRACKER_INSTANCE.record(True)
  
    def stop_tracker_record(self):
        TRACKER_INSTANCE.stop_record()
        
    def register_tracker_listener(self, aListener):
        TRACKER_INSTANCE.add_listener(aListener)
        
    def unregister_tracker_listener(self, aListener):
        TRACKER_INSTANCE.remove_listener(aListener)
        
    def reset_data(self):
        TRACKER_INSTANCE.reset_data()
        
    def get_mougeon_storage_dir(self):
        '''
        Storage location of pyajama
        '''
        return get_mougeon_storage_dir()
            
    
    def is_using_freemobile(self):
        return get_current_op() == FREE_OPERATOR
    
    def freemobile_percent(self):        
        op = TRACKER_INSTANCE.free_mobile_record()
        tot = TRACKER_INSTANCE.number_of_record()
        # TODO complute percent
        if tot > 0:
            return 100.0 * op / tot
        else:
            return 0
        
    
    def orange_percent(self):        
        op = TRACKER_INSTANCE.orange_record()
        tot = TRACKER_INSTANCE.number_of_record()
        # TODO complute percent
        if tot > 0:
            return 100.0 * op / tot
        else:
            return 0 
    
    def get_mainly_used_operator(self):
        if self.freemobile_percent() >= 50:
            return FREE_OPERATOR
        else:
            return ORANGE_OPERATOR