#!/usr/bin/python

"""Definitions for physical constants
"""

R_d = 287.0 # J K^-1 kg^-1; gas constant for 1 mol dry air Wallace and Hobbs Eq. 3.11
R_v = 461.51 # J K^-1 kg^-1 gas constant for water vapour; Wallace and Hobbs Eq. 3.13
R = 8.3143 # J K^-1 mol^-1; Wallace and Hobbs page 467
h = 6.62617e-34  # J s Planck
k = 1.380662e-23 # J/K Boltzmann
c = 2.99792458e8  # m/s speed of light
ppm = 1e-6  # parts per million
ppb = 1e-9  # parts per billion
ppt = 1e-12 # parts per trillion
hecto = 1e2
M_d = 28.97 # kg kmol^-1; effective molecular weight of dry air; Wallace and Hobbs
M_w = 18.016 # kg kmol^-1; molecular weight of H2O (Wallace and Hobbs)
KiB = 2**10
KB = 10**3
MiB = 2**20
MB = 10**6
