# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import json
import requests
from avisosms.base import MountPoint

from avisosms.plugins import SendSMSPlugin, BalancePlugin, MobileCommercePlugin, TelephoneBookPlugin, RARPlugin


class BaseAvisoSMSClient(object):
    BASE_URL = 'http://api.avisosms.ru'
    __metaclass__ = MountPoint

    def __init__(self, username, password):
        super(BaseAvisoSMSClient, self).__init__()
        self.username = username
        self.password = password

    def post_json(self, data, url):
        headers = {'Content-type': 'application/json', 'Accept': 'text/plain', 'charset': 'utf8'}
        r = requests.post(url=self.BASE_URL + url, data=json.dumps(data), headers=headers)
        return r.json()


class AvisoSMSClient(BaseAvisoSMSClient):
    plugins = (SendSMSPlugin, BalancePlugin, MobileCommercePlugin, TelephoneBookPlugin, RARPlugin)

    def __init__(self, username, password, service_id=None, secure_hash=None):
        super(AvisoSMSClient, self).__init__(username, password)
        self.service_id = service_id
        self.secure_hash = secure_hash