
# Root class for all exceptions generated by the Parameters module
class ParametersException(Exception):
	pass

# Parameter Errors
class ParameterValueError(ParametersException):
	pass

class ParameterOverSpecifiedError(ParametersException):
	pass

class ParameterNotInvertableError(ParametersException):
	pass

class ParameterInvalidError(ParametersException):
	pass

class ParameterRecursionError(ParametersException):
	pass

class ParameterNameWarning(UserWarning):
	pass

class ParameterInconsistentWarning(UserWarning):
	pass

# Bound Errors
class ParameterOutsideBoundsWarning(UserWarning):
	pass

class ParameterOutsideBoundsError(ParametersException):
	pass



# Symbolic evaluation errors
class SymbolicEvaluationError(ParametersException):
	pass

class ExpressionOptimisationError(ParametersException):
	pass

# Quantity Errors
class QuantityValueError(ParametersException):
	pass

class QuantityCoercionError(ParametersException):
	pass

# Unit Errors
class UnitInvalidError(ParametersException):
	pass

class UnitConversionError(ParametersException):
	pass

# Scaling Errors
class ScalingValueError(ParametersException):
	pass

class ScalingUnitInvalidError(ParametersException):
	pass

class ScalingDimensionInvalidError(ParametersException):
	pass
