#!/usr/bin/env python
# -*- coding: utf-8 -*-

from scp.scp import SCPClient
import colors

def puts(msg, m_type='heading'):
    messages_by_type = {
        'heading': colors.blue,
        'info': lambda msg: msg,
        'success': colors.green,
        'warn': colors.yellow,
        'error': colors.red
    }
    print messages_by_type[m_type](msg)

def execute(ssh, script, targetdir, duration, arguments):
    '''execute the counter script'''
    ssh.exec_command('cd %s; nohup ./%s %s %s' % (targetdir, script, duration, ' '.join(arguments)))

def run(ssh, command):
    puts('executing: %s' % command, 'info')
    stdin, stdout, stderr = ssh.exec_command(command)
    if stdout.channel.recv_exit_status():
        puts(stdout.read() + stderr.read(), 'error')
    else:
        puts(stdout.read(), 'info')

def create_directories(path, user, permission, group=None):
    group = group or user

    sudo("mkdir -p %s" % path)
    sudo("chown %s:%s %s" % (user, group, path))
    sudo("chmod %s %s" % (permission, path))

def upload(ssh, localpath, remotepath):
    '''upload to remote'''
    scp = SCPClient(ssh.get_transport())
    scp.put(localpath, remotepath, recursive=True)


"""
def install_packages(packages):
    with settings(warn_only=True):
        sudo("apt-get install %s -qy " % (' '.join(packages),))

def server_upgrade():
    puts('updating server')
    with settings(warn_only=True):
        sudo("apt-get update -qy")
        # sudo("aptitude -y upgrade")

def restart_service(service):
    sudo("service %s stop" % (service,))
    sudo("service %s start" % (service,))

def http_status(host, port="80", name="", run_local=False):
    if run_local:
        url = "{0}:{1}".format(host, port)
        status = local("curl -o /dev/null --silent --head --write-out '%{http_code}' " + url, capture=True)
    else:
        url = "127.0.0.1:{0}".format(port)
        status = run("curl -o /dev/null --silent --head --write-out '%{http_code}' " + url)
    if status == '200':
        print(name + " " + green('OK'))
    else:
        print(name + " " + red('FAIL'))
"""