#!/usr/bin/env python
import os
from math import pi
from datetime import datetime
import ephem
import ephem.stars

def read_db(lines):
    catalog = {}
    for line in lines:
        if not line:
            continue
        m = ephem.readdb(line)
        catalog[m.name] = m
    return catalog

obs = ephem.city('San Francisco')
obs.date = datetime.utcnow()

def get_star_names():
    for star in ephem.stars.db.split("\n"):
        name = star.split(",")[0]
    yield name

for name, messier in MESSIER.items():
    messier.compute(obs)
    if messier.alt < 0:
        continue
    print "%s\naz: %s\nalt: %s" % (name, str(messier.az), str(messier.alt))
    print messier.mag
