#!/usr/bin/env python2
# -*- coding: utf-8 -*-
# Copyright 2013 Francisco Jesús Macía Espín <fjmaciaespin@gmail.com>

'''
Subtle is an automatic subtitle downloader for videos
Copyright (C) 2013 Francisco Jesús Macía Espín (fmacia)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import sys 
import os
sys.path.insert(0, os.path.abspath('..'))
from subtle import Video

def main():
    """
    Función principal del script
    """

    args = sys.argv
    if len(args) > 1:
        ret = 0
        for arg in args[1:]:
            #TODO: comprobar si arg es una carpeta y hacer un for sobre todos los videos
            capi = Video(arg)
            if capi.cargar_datos() == 0:
                #probar a descargar de subtitulos.es primero. si no, de addic7ed
                subs_es = capi.descargar_sub_subtitulos_es()
                add = 0
                if subs_es == 1:
                    add = capi.descargar_sub_addic7ed()
                    if add == 1:
                        print('No se han encontrado subtítulos')
                if subs_es == 2 or add == 2:
                    ret = 2
                ret = 0
            else:
                ret = 3
        return ret
    else:
        print('Uso: subtle [nombre del vídeo]')
        #parser.print_help()
        return 0


if __name__ == '__main__':
    sys.exit(main())