# coding: utf-8

from . import base
from ..common import render


class DictModel(base.BaseModel, dict):
    """
    dict structure that is repeatedly drawn.
    """
    def __init__(self, params):
        """
        define dict-structure model.
        :param params: dict elements(type: dict).
        :return: DictModel instance.
        """
        self.update(params)

        self.type = type(params)
        self.length = len(self)
        self.order = self.keys()

    def ordering(self, *order):
        """
        order in which list-index to generate the elements.
        :param order:
        :return: self(model).
        """
        self.order = list(order)
        for subscript in self.keys():
            if subscript not in self.order:
                self.order.append(subscript)
        return self

    def render(self, index, key):
        """
        rendering a dict-structure record.
        :param index: index of iterable-object to render container object.
        :param key: element of iterable-object to render container object.
        :return: rendered record.
        """
        record = self.type()
        for subscript in self.order:
            blueprint = self[subscript]
            args = [record, index, key]
            record[subscript] = render.apply(blueprint, args)

        return record
