# coding: utf-8

from unittest import TestCase


def gen_value(element, seq_num, seq_key):
    return str(element['b']) + ' + ' + (str(seq_key) * seq_num)


class TestDictModel(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..dict import DictModel
        return DictModel(*args, **kwargs)

    def test_order(self):
        dm = self._getClass({
            'a': 1, 'b': 2, 'c': 3, 'd': 4,
        })
        dm.ordering('d', 'b', 'c')
        self.assertEqual(dm.order, ['d', 'b', 'c', 'a'])

    def test_render(self):
        try:
            from ...pattern.increment import IncrementPattern
        except ValueError:
            try:
                from pattern.increment import IncrementPattern
            except ImportError:
                return

        dm = self._getClass({
            'a': gen_value,
            'b': IncrementPattern(),
            'c': 3
        }).ordering('b')

        self.assertEqual(
            [
                dm.render(i, key)
                for i, key in enumerate(['a', 'b', 'c'])
            ],
            [
                {'a': '1 + ', 'b': 1, 'c': 3},
                {'a': '2 + b', 'b': 2, 'c': 3},
                {'a': '3 + cc', 'b': 3, 'c': 3},
            ],
        )

    def test_render_nesting(self):
        dm = self._getClass({
            'a': 1,
            'b': self._getClass({'c': 1})
        })

        self.assertEqual(
            [
                dm.render(i, key)
                for i, key in enumerate(range(3))
            ],
            [{'a': 1, 'b': {'c': 1}}] * 3
        )

    def test_custom_render(self):
        try:
            from ...pattern.increment import IncrementPattern
        except ValueError:
            try:
                from pattern.increment import IncrementPattern
            except ImportError:
                return

        lm = self._getClass({
            'a': (lambda record: str(record['b'])),
            'b': IncrementPattern()
        }).ordering('b', 'a')

        self.assertEqual(
            [
                lm.render(i, key)
                for i, key in enumerate(range(3))
            ],
            [
                {'a': '1', 'b': 1},
                {'a': '2', 'b': 2},
                {'a': '3', 'b': 3},
            ]
        )
