# coding: utf-8

from unittest import TestCase


class TestIncrementPattern(TestCase):
    def _getClass(self, *args, **kwargs):
        from ..increment import IncrementPattern as Pattern
        return Pattern(*args, **kwargs)

    def test_normal_increment_pattern(self):
        pattern = self._getClass(3, 5)
        self.assertEqual(
            [pattern.render() for i in range(10)],
            range(3, 50, 5)
        )

    def test_datetime_increment_pattern(self):
        from datetime import datetime, timedelta

        def strptime(dt):
            return dt.strftime('%Y-%m-%dT%H:%M:%S')

        pattern = self._getClass(
            datetime(2000, 1, 1),
            timedelta(days=2, hours=8),
            strptime
        )

        self.assertEqual(
            [pattern.render() for i in range(5)],
            [
                '2000-01-01T00:00:00',
                '2000-01-03T08:00:00',
                '2000-01-05T16:00:00',
                '2000-01-08T00:00:00',
                '2000-01-10T08:00:00',
            ]
        )



