# coding: utf-8

from unittest import TestCase


class TestIterize(TestCase):
    def _callFUT(self, *args, **kwargs):
        from ..base import iterize
        return iterize(*args, **kwargs)

    def test_none(self):
        self.assertIsNone(
            self._callFUT(None)
        )

    def test_int(self):
        i = 3
        try:
            iterable = xrange(i)
        except NameError:
            iterable = range(i)
        self.assertEqual(
            [j for j in self._callFUT(i)],
            [j for j in iterable]
        )


class TestBaseContainer(TestCase):
    def test_repeat(self):
        from ..base import BaseContainer
        iterable = ['a', 'b', 'c']
        bc = BaseContainer(None).repeat(iterable)
        self.assertEqual(bc.iterable, iterable)
