# coding: utf-8

from . import base
from ..common import render


class ListModel(base.BaseModel, list):
    """
    list-structure that is repeatedly drawn.
    """
    def __init__(self, params):
        """
        define list-structure model.
        :param params: list elements(type: list).
        :return: ListModel instance.
        """
        self += params

        self.length = len(self)
        self.order = range(self.length)

    def ordering(self, *order):
        """
        order in which list-index to generate the elements.
        :param order:
        :return: self(model).
        """
        self.order = list(order)
        for subscript in range(self.length):
            if subscript not in self.order:
                self.order.append(subscript)
        return self

    def render(self, index, key):
        """
        rendering a list-structure record.
        :param index: index of iterable-object to render container object.
        :param key: element of iterable-object to render container object.
        :return: rendered record.
        """
        record = [None] * self.length
        for subscript in self.order:
            blueprint = self[subscript]
            args = [record, index, key]
            record[subscript] = render.apply(blueprint, args)
        return record
