# coding: utf-8

from .base import BasePattern


class CyclePattern(BasePattern):
    """
    select an element regularly from the choices.
    """
    def __init__(self, choice, increment=1, callback=None):
        """
        :param choice: list-elements of choices
        :param increment: list-index increase.
        :param callback: function to be called at the end of rendering.
        :return: Cycle Pattern instance.
        """
        self.choice = choice
        self.size = len(choice)
        self.index = 0
        self.increment = increment
        self.add_callback(callback)

    def render(self, *args):
        """
        render a element by regularly selection
        :param args: any.
        :return: rendered element.
        """
        element = self.choice[self.index % self.size]
        self.index += self.increment
        for callback in self.callbacks:
            element = callback(element)
        return element
