# coding: utf-8

from .base import BasePattern
import hashlib


class HashPattern(BasePattern):
    """
    generate hash value.
    """
    def __init__(self, subscript, method='md5', stringify=str, callback=None):
        """
        :param subscript: record subscript.
        :param method: hash method type. md5 / sha1 / sha224 / sha256 / sha384 / sha512
        :param stringify: stringify function to give hash method.
        :param callback: function to be called at the end of rendering.
        :return: Hash Pattern instance.
        """
        self.subscript = subscript
        self.hash = hashlib.__dict__[method]
        self.stringify = stringify
        self.add_callback(callback)

    def render(self, record, *args):
        """
        render a element by hash method.
        :param record: record to be written by pattern.render().
        :param args: any
        :return: rendered element.
        """
        seed = record[self.subscript]

        element = self.hash(self.stringify(seed)).hexdigest()
        for callback in self.callbacks:
            element = callback(element)
        return element
