# coding

from .base import BasePattern


class IncrementPattern(BasePattern):
    """
    generate element by addition of value that regular.
    """
    def __init__(self, start=1, step=1, callback=None):
        """
        :param start: initial value.
        :param step: increase.
        :param callback: function to be called at the end of rendering.
        :return: Increment Pattern instance
        """
        self.element = start
        self.step = step
        self.add_callback(callback)

    def render(self, *args):
        """
        render a element by regularly addition.
        :param args: any.
        :return: rendered element.
        """
        element = self.element
        self.element += self.step
        for callback in self.callbacks:
            element = callback(element)
        return element

